/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.grails.profiler;

import com.linkedin.grails.profiler.ProfilerLog;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class ProfilerHandlerInterceptor
extends HandlerInterceptorAdapter {
    public static final String REQUEST_STATUS_ATTR = "com.linkedin.grails.profiler.STATUS";
    private ProfilerLog profiler;

    public void setProfiler(ProfilerLog profiler) {
        this.profiler = profiler;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object o) throws Exception {
        this.profiler.logEntry(this.getClass(), "Controller");
        request.setAttribute(REQUEST_STATUS_ATTR, (Object)"Controller");
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object o, ModelAndView modelAndView) {
        this.profiler.logExit(this.getClass(), "Controller");
        this.profiler.logEntry(this.getClass(), "View");
        request.setAttribute(REQUEST_STATUS_ATTR, (Object)"View");
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object o, Exception e) {
        String status = (String)request.getAttribute(REQUEST_STATUS_ATTR);
        if (status != null) {
            this.profiler.logExit(this.getClass(), status);
        }
    }
}

