/*
 * Decompiled with CFR 0.152.
 */
package rundeck.services;

import com.codahale.metrics.Counter;
import com.dtolabs.rundeck.app.internal.logging.FSStreamingLogReader;
import com.dtolabs.rundeck.app.internal.logging.FSStreamingLogWriter;
import com.dtolabs.rundeck.app.internal.logging.RundeckLogFormat;
import com.dtolabs.rundeck.core.logging.ExecutionFileStorage;
import com.dtolabs.rundeck.core.logging.ExecutionFileStorageOptions;
import com.dtolabs.rundeck.core.logging.ExecutionMultiFileStorage;
import com.dtolabs.rundeck.core.logging.LogFileState;
import com.dtolabs.rundeck.core.logging.StreamingLogReader;
import com.dtolabs.rundeck.core.logging.StreamingLogWriter;
import com.dtolabs.rundeck.core.plugins.configuration.PropertyResolver;
import com.dtolabs.rundeck.core.plugins.configuration.PropertyScope;
import com.dtolabs.rundeck.plugins.logging.ExecutionFileStoragePlugin;
import com.dtolabs.rundeck.server.plugins.services.ExecutionFileStoragePluginProviderService;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import java.io.File;
import java.io.FileOutputStream;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ArrayUtil;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.task.AsyncTaskExecutor;
import rundeck.Execution;
import rundeck.LogFileStorageRequest;
import rundeck.services.ExecutionService;
import rundeck.services.LoggingService;
import rundeck.services.PluginService;
import rundeck.services.TaskRunner;
import rundeck.services.execution.ValueHolder;
import rundeck.services.execution.ValueWatcher;
import rundeck.services.logging.ExecutionFile;
import rundeck.services.logging.ExecutionFileProducer;
import rundeck.services.logging.ExecutionFileUtil;
import rundeck.services.logging.ExecutionLogReader;
import rundeck.services.logging.ExecutionLogState;
import rundeck.services.logging.LogFileLoader;
import rundeck.services.logging.MultiFileStorageRequestImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class LogFileStorageService
implements InitializingBean,
ApplicationContextAware,
GroovyObject {
    private static Object transactional;
    private static final RundeckLogFormat rundeckLogFormat;
    private ExecutionFileStoragePluginProviderService executionFileStoragePluginProviderService;
    private PluginService pluginService;
    private Object frameworkService;
    private AsyncTaskExecutor logFileTaskExecutor;
    private Object executorService;
    private Object grailsApplication;
    private Object grailsLinkGenerator;
    private ApplicationContext applicationContext;
    private Object metricService;
    private Object configurationService;
    private ScheduledExecutorService scheduledExecutor;
    private BlockingQueue<Long> retryIncompleteRequests;
    private Set<Long> failedRequests;
    private Map<Long, List<String>> failures;
    private BlockingQueue<Map> storageRequests;
    private BlockingQueue<Map> retrievalRequests;
    private Queue<Map> running;
    private ConcurrentHashMap<String, Map> logFileRetrievalRequests;
    private ConcurrentHashMap<String, Map> logFileRetrievalResults;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static Log log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;
    public static /* synthetic */ long __timeStamp;
    public static /* synthetic */ long __timeStamp__239_neverHappen1461970102463;
    private static /* synthetic */ SoftReference $callSiteArray;

    public LogFileStorageService() {
        MetaClass metaClass;
        CallSite[] callSiteArray = LogFileStorageService.$getCallSiteArray();
        Object object = callSiteArray[0].call(Executors.class, (Object)1);
        this.scheduledExecutor = (ScheduledExecutorService)ScriptBytecodeAdapter.castToType((Object)object, ScheduledExecutorService.class);
        Object object2 = callSiteArray[1].callConstructor(LinkedBlockingQueue.class);
        this.retryIncompleteRequests = (BlockingQueue)ScriptBytecodeAdapter.castToType((Object)object2, BlockingQueue.class);
        Object object3 = callSiteArray[2].callConstructor(HashSet.class);
        this.failedRequests = (Set)ScriptBytecodeAdapter.castToType((Object)object3, Set.class);
        Object object4 = callSiteArray[3].callConstructor(HashMap.class);
        this.failures = (Map)ScriptBytecodeAdapter.castToType((Object)object4, Map.class);
        Object object5 = callSiteArray[4].callConstructor(LinkedBlockingQueue.class);
        this.storageRequests = (BlockingQueue)ScriptBytecodeAdapter.castToType((Object)object5, BlockingQueue.class);
        Object object6 = callSiteArray[5].callConstructor(LinkedBlockingQueue.class);
        this.retrievalRequests = (BlockingQueue)ScriptBytecodeAdapter.castToType((Object)object6, BlockingQueue.class);
        Object object7 = callSiteArray[6].callConstructor(ConcurrentLinkedQueue.class);
        this.running = (Queue)ScriptBytecodeAdapter.castToType((Object)object7, Queue.class);
        Object object8 = callSiteArray[7].callConstructor(ConcurrentHashMap.class);
        this.logFileRetrievalRequests = (ConcurrentHashMap)ScriptBytecodeAdapter.castToType((Object)object8, ConcurrentHashMap.class);
        Object object9 = callSiteArray[8].callConstructor(ConcurrentHashMap.class);
        this.logFileRetrievalResults = (ConcurrentHashMap)ScriptBytecodeAdapter.castToType((Object)object9, ConcurrentHashMap.class);
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public void afterPropertiesSet() throws Exception {
        CallSite[] callSiteArray = LogFileStorageService.$getCallSiteArray();
        Object pluginName = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            pluginName = object = callSiteArray[9].callCurrent((GroovyObject)this);
        } else {
            String string = this.getConfiguredPluginName();
            pluginName = string;
        }
        if (!DefaultTypeTransformation.booleanUnbox((Object)pluginName)) {
            return;
        }
        callSiteArray[10].callSafe((Object)this.logFileTaskExecutor, callSiteArray[11].callConstructor(TaskRunner.class, (Object)this.storageRequests, (Object)new /* Unavailable Anonymous Inner Class!! */));
        callSiteArray[12].callSafe((Object)this.logFileTaskExecutor, callSiteArray[13].callConstructor(TaskRunner.class, (Object)this.retrievalRequests, (Object)new /* Unavailable Anonymous Inner Class!! */));
        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[14].callCurrent((GroovyObject)this), (Object)"periodic")) {
                long delay = DefaultTypeTransformation.longUnbox((Object)callSiteArray[15].callCurrent((GroovyObject)this));
                callSiteArray[16].call((Object)this.scheduledExecutor, (Object)ScriptBytecodeAdapter.getMethodPointer((Object)this, (String)"dequeueIncompleteLogStorage"), (Object)delay, (Object)delay, callSiteArray[17].callGetProperty(TimeUnit.class));
            }
        } else if (ScriptBytecodeAdapter.compareEqual((Object)this.getConfiguredResumeStrategy(), (Object)"periodic")) {
            long delay = this.getConfiguredStorageRetryDelay();
            callSiteArray[18].call((Object)this.scheduledExecutor, (Object)ScriptBytecodeAdapter.getMethodPointer((Object)this, (String)"dequeueIncompleteLogStorage"), (Object)delay, (Object)delay, callSiteArray[19].callGetProperty(TimeUnit.class));
        }
    }

    private String getConfiguredResumeStrategy() {
        CallSite[] callSiteArray = LogFileStorageService.$getCallSiteArray();
        Object object = callSiteArray[20].callSafe(this.configurationService, (Object)"logFileStorageService.resumeIncomplete.strategy", (Object)"periodic");
        return ShortTypeHandling.castToString((Object)(DefaultTypeTransformation.booleanUnbox((Object)object) ? object : "periodic"));
    }

    public Counter getStorageQueueCounter() {
        CallSite[] callSiteArray = LogFileStorageService.$getCallSiteArray();
        return (Counter)ScriptBytecodeAdapter.castToType((Object)callSiteArray[21].callSafe(this.metricService, callSiteArray[22].call(callSiteArray[23].callGetProperty(callSiteArray[24].callGroovyObjectGetProperty((Object)this)), (Object)".storageRequests"), (Object)"queued"), Counter.class);
    }

    public Counter getStorageTotalCounter() {
        CallSite[] callSiteArray = LogFileStorageService.$getCallSiteArray();
        return (Counter)ScriptBytecodeAdapter.castToType((Object)callSiteArray[25].callSafe(this.metricService, callSiteArray[26].call(callSiteArray[27].callGetProperty(callSiteArray[28].callGroovyObjectGetProperty((Object)this)), (Object)".storageRequests"), (Object)"total"), Counter.class);
    }

    public Counter getStorageSuccessCounter() {
        CallSite[] callSiteArray = LogFileStorageService.$getCallSiteArray();
        return (Counter)ScriptBytecodeAdapter.castToType((Object)callSiteArray[29].callSafe(this.metricService, callSiteArray[30].call(callSiteArray[31].callGetProperty(callSiteArray[32].callGroovyObjectGetProperty((Object)this)), (Object)".storageRequests"), (Object)"succeeded"), Counter.class);
    }

    public Counter getStorageFailedCounter() {
        CallSite[] callSiteArray = LogFileStorageService.$getCallSiteArray();
        return (Counter)ScriptBytecodeAdapter.castToType((Object)callSiteArray[33].callSafe(this.metricService, callSiteArray[34].call(callSiteArray[35].callGetProperty(callSiteArray[36].callGroovyObjectGetProperty((Object)this)), (Object)".storageRequests"), (Object)"failed"), Counter.class);
    }

    public List getCurrentRetrievalRequests() {
        CallSite[] callSiteArray = LogFileStorageService.$getCallSiteArray();
        return (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[37].callConstructor(ArrayList.class, (Object)this.retrievalRequests), List.class);
    }

    public List getCurrentStorageRequests() {
        CallSite[] callSiteArray = LogFileStorageService.$getCallSiteArray();
        return (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[38].callConstructor(ArrayList.class, (Object)this.storageRequests), List.class);
    }

    public List getCurrentRequests() {
        CallSite[] callSiteArray = LogFileStorageService.$getCallSiteArray();
        return (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[39].callConstructor(ArrayList.class, (Object)this.running), List.class);
    }

    public Map getCurrentRetrievalResults() {
        CallSite[] callSiteArray = LogFileStorageService.$getCallSiteArray();
        return (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[40].callConstructor(HashMap.class, (Object)this.logFileRetrievalResults), Map.class);
    }

    public Map listLogFileStoragePlugins() {
        CallSite[] callSiteArray = LogFileStorageService.$getCallSiteArray();
        return (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[41].call((Object)this.pluginService, ExecutionFileStoragePlugin.class, (Object)this.executionFileStoragePluginProviderService), Map.class);
    }

    public void runStorageRequest(Map task) {
        Reference task2 = new Reference((Object)task);
        CallSite[] callSiteArray = LogFileStorageService.$getCallSiteArray();
        int retry = 0;
        if (!BytecodeInterface8.isOrigInt() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[42].callCurrent((GroovyObject)this);
            retry = DefaultTypeTransformation.intUnbox((Object)object);
        } else {
            int n;
            retry = n = this.getConfiguredStorageRetryCount();
        }
        int delay = 0;
        if (!BytecodeInterface8.isOrigInt() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[43].callCurrent((GroovyObject)this);
            delay = DefaultTypeTransformation.intUnbox((Object)object);
        } else {
            int n;
            delay = n = this.getConfiguredStorageRetryDelay();
        }
        callSiteArray[44].call((Object)this.running, (Object)((Map)task2.get()));
        Object object = callSiteArray[45].callGetProperty((Object)((Map)task2.get()));
        int count = DefaultTypeTransformation.intUnbox((Object)(DefaultTypeTransformation.booleanUnbox((Object)object) ? object : Integer.valueOf(0)));
        if (!BytecodeInterface8.isOrigInt() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object2 = callSiteArray[46].call((Object)count);
            count = DefaultTypeTransformation.intUnbox((Object)object2);
            Object object3 = object2;
            ScriptBytecodeAdapter.setProperty((Object)object3, null, (Object)((Map)task2.get()), (String)"count");
        } else {
            int n = ++count;
            ScriptBytecodeAdapter.setProperty((Object)n, null, (Object)((Map)task2.get()), (String)"count");
        }
        callSiteArray[47].call((Object)log, (Object)new GStringImpl(new Object[]{callSiteArray[48].callGetProperty((Object)((Map)task2.get())), count, retry}, new String[]{"Storage request [ID#", "] (attempt ", " of ", ")..."}));
        Reference success = new Reference((Object)false);
        Reference filetype = new Reference(callSiteArray[49].callGetProperty((Object)((Map)task2.get())));
        Reference typelist = new Reference(null);
        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            List list = ScriptBytecodeAdapter.compareNotEqual((Object)filetype.get(), (Object)"*") ? (List)ScriptBytecodeAdapter.asType((Object)callSiteArray[50].call(filetype.get(), (Object)","), List.class) : ScriptBytecodeAdapter.createList((Object[])new Object[0]);
            typelist.set((Object)list);
        } else {
            List list = ScriptBytecodeAdapter.compareNotEqual((Object)filetype.get(), (Object)"*") ? (List)ScriptBytecodeAdapter.asType((Object)callSiteArray[51].call(filetype.get(), (Object)","), List.class) : ScriptBytecodeAdapter.createList((Object[])new Object[0]);
            typelist.set((Object)list);
        }
        callSiteArray[52].call(LogFileStorageRequest.class, (Object)new /* Unavailable Anonymous Inner Class!! */);
        if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (!DefaultTypeTransformation.booleanUnbox((Object)success.get()) && count < retry) {
                callSiteArray[53].call((Object)log, (Object)new GStringImpl(new Object[]{callSiteArray[54].callGetProperty((Object)((Map)task2.get())), delay}, new String[]{"Storage request [ID#", "] was not successful, retrying in ", " seconds..."}));
                callSiteArray[55].call((Object)this.running, (Object)((Map)task2.get()));
                callSiteArray[56].callCurrent((GroovyObject)this, (Object)((Map)task2.get()), (Object)delay);
            } else if (!DefaultTypeTransformation.booleanUnbox((Object)success.get())) {
                callSiteArray[57].callSafe(callSiteArray[58].callCurrent((GroovyObject)this));
                if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[59].callCurrent((GroovyObject)this))) {
                    callSiteArray[60].call((Object)log, (Object)new GStringImpl(new Object[]{callSiteArray[61].callGetProperty((Object)((Map)task2.get())), retry}, new String[]{"Storage request [ID#", "] FAILED ", " attempts, cancelling"}));
                    callSiteArray[62].call(this.executorService, (Object)new /* Unavailable Anonymous Inner Class!! */);
                } else {
                    callSiteArray[63].call((Object)log, (Object)new GStringImpl(new Object[]{callSiteArray[64].callGetProperty((Object)((Map)task2.get())), retry}, new String[]{"Storage request [ID#", "] FAILED ", " attempts, giving up"}));
                    callSiteArray[65].call((Object)this.running, (Object)((Map)task2.get()));
                    callSiteArray[66].call((Object)this.failedRequests, callSiteArray[67].callGetProperty((Object)((Map)task2.get())));
                }
            } else {
                callSiteArray[68].call((Object)this.failedRequests, callSiteArray[69].callGetProperty((Object)((Map)task2.get())));
                callSiteArray[70].call((Object)this.failures, callSiteArray[71].callGetProperty((Object)((Map)task2.get())));
                callSiteArray[72].call(this.executorService, (Object)new /* Unavailable Anonymous Inner Class!! */);
            }
        } else if (!DefaultTypeTransformation.booleanUnbox((Object)success.get()) && count < retry) {
            callSiteArray[73].call((Object)log, (Object)new GStringImpl(new Object[]{callSiteArray[74].callGetProperty((Object)((Map)task2.get())), delay}, new String[]{"Storage request [ID#", "] was not successful, retrying in ", " seconds..."}));
            callSiteArray[75].call((Object)this.running, (Object)((Map)task2.get()));
            callSiteArray[76].callCurrent((GroovyObject)this, (Object)((Map)task2.get()), (Object)delay);
        } else if (!DefaultTypeTransformation.booleanUnbox((Object)success.get())) {
            callSiteArray[77].callSafe((Object)this.getStorageFailedCounter());
            if (this.getConfiguredStorageFailureCancel()) {
                callSiteArray[78].call((Object)log, (Object)new GStringImpl(new Object[]{callSiteArray[79].callGetProperty((Object)((Map)task2.get())), retry}, new String[]{"Storage request [ID#", "] FAILED ", " attempts, cancelling"}));
                callSiteArray[80].call(this.executorService, (Object)new /* Unavailable Anonymous Inner Class!! */);
            } else {
                callSiteArray[81].call((Object)log, (Object)new GStringImpl(new Object[]{callSiteArray[82].callGetProperty((Object)((Map)task2.get())), retry}, new String[]{"Storage request [ID#", "] FAILED ", " attempts, giving up"}));
                callSiteArray[83].call((Object)this.running, (Object)((Map)task2.get()));
                callSiteArray[84].call((Object)this.failedRequests, callSiteArray[85].callGetProperty((Object)((Map)task2.get())));
            }
        } else {
            callSiteArray[86].call((Object)this.failedRequests, callSiteArray[87].callGetProperty((Object)((Map)task2.get())));
            callSiteArray[88].call((Object)this.failures, callSiteArray[89].callGetProperty((Object)((Map)task2.get())));
            callSiteArray[90].call(this.executorService, (Object)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    private void runRetrievalRequest(Map task) {
        Reference task2 = new Reference((Object)task);
        CallSite[] callSiteArray = LogFileStorageService.$getCallSiteArray();
        callSiteArray[91].call((Object)this.logFileTaskExecutor, (Object)new /* Unavailable Anonymous Inner Class!! */);
    }

    public int getConfiguredStorageRetryCount() {
        CallSite[] callSiteArray = LogFileStorageService.$getCallSiteArray();
        Object object = callSiteArray[92].callGetPropertySafe(callSiteArray[93].callGetPropertySafe(callSiteArray[94].callGetPropertySafe(callSiteArray[95].callGetPropertySafe(callSiteArray[96].callGetPropertySafe(callSiteArray[97].callGetProperty(this.grailsApplication))))));
        Object count = DefaultTypeTransformation.booleanUnbox((Object)object) ? object : Integer.valueOf(0);
        if (count instanceof String) {
            Object object2;
            count = object2 = callSiteArray[98].call(count);
        }
        if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return DefaultTypeTransformation.intUnbox((Object)(ScriptBytecodeAdapter.compareGreaterThan((Object)count, (Object)0) ? count : Integer.valueOf(1)));
        }
        return DefaultTypeTransformation.intUnbox((Object)(ScriptBytecodeAdapter.compareGreaterThan((Object)count, (Object)0) ? count : Integer.valueOf(1)));
    }

    public int getConfiguredStorageRetryDelay() {
        CallSite[] callSiteArray = LogFileStorageService.$getCallSiteArray();
        Object object = callSiteArray[99].callGetPropertySafe(callSiteArray[100].callGetPropertySafe(callSiteArray[101].callGetPropertySafe(callSiteArray[102].callGetPropertySafe(callSiteArray[103].callGetPropertySafe(callSiteArray[104].callGetProperty(this.grailsApplication))))));
        Object delay = DefaultTypeTransformation.booleanUnbox((Object)object) ? object : Integer.valueOf(0);
        if (delay instanceof String) {
            Object object2;
            delay = object2 = callSiteArray[105].call(delay);
        }
        if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return DefaultTypeTransformation.intUnbox((Object)(ScriptBytecodeAdapter.compareGreaterThan((Object)delay, (Object)0) ? delay : Integer.valueOf(60)));
        }
        return DefaultTypeTransformation.intUnbox((Object)(ScriptBytecodeAdapter.compareGreaterThan((Object)delay, (Object)0) ? delay : Integer.valueOf(60)));
    }

    public boolean getConfiguredStorageFailureCancel() {
        CallSite[] callSiteArray = LogFileStorageService.$getCallSiteArray();
        return DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[106].call(this.configurationService, (Object)"execution.logs.fileStorage.cancelOnStorageFailure", (Object)true));
    }

    public int getConfiguredRetrievalRetryCount() {
        CallSite[] callSiteArray = LogFileStorageService.$getCallSiteArray();
        Object object = callSiteArray[107].callGetPropertySafe(callSiteArray[108].callGetPropertySafe(callSiteArray[109].callGetPropertySafe(callSiteArray[110].callGetPropertySafe(callSiteArray[111].callGetProperty(callSiteArray[112].callGetProperty(this.grailsApplication))))));
        Object count = DefaultTypeTransformation.booleanUnbox((Object)object) ? object : Integer.valueOf(0);
        if (count instanceof String) {
            Object object2;
            count = object2 = callSiteArray[113].call(count);
        }
        if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return DefaultTypeTransformation.intUnbox((Object)(ScriptBytecodeAdapter.compareGreaterThan((Object)count, (Object)0) ? count : Integer.valueOf(3)));
        }
        return DefaultTypeTransformation.intUnbox((Object)(ScriptBytecodeAdapter.compareGreaterThan((Object)count, (Object)0) ? count : Integer.valueOf(3)));
    }

    public int getConfiguredRetrievalRetryDelay() {
        CallSite[] callSiteArray = LogFileStorageService.$getCallSiteArray();
        Object object = callSiteArray[114].callGetPropertySafe(callSiteArray[115].callGetPropertySafe(callSiteArray[116].callGetPropertySafe(callSiteArray[117].callGetPropertySafe(callSiteArray[118].callGetProperty(callSiteArray[119].callGetProperty(this.grailsApplication))))));
        Object delay = DefaultTypeTransformation.booleanUnbox((Object)object) ? object : Integer.valueOf(0);
        if (delay instanceof String) {
            Object object2;
            delay = object2 = callSiteArray[120].call(delay);
        }
        if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return DefaultTypeTransformation.intUnbox((Object)(ScriptBytecodeAdapter.compareGreaterThan((Object)delay, (Object)0) ? delay : Integer.valueOf(60)));
        }
        return DefaultTypeTransformation.intUnbox((Object)(ScriptBytecodeAdapter.compareGreaterThan((Object)delay, (Object)0) ? delay : Integer.valueOf(60)));
    }

    public int getConfiguredRemotePendingDelay() {
        CallSite[] callSiteArray = LogFileStorageService.$getCallSiteArray();
        Object object = callSiteArray[121].callGetPropertySafe(callSiteArray[122].callGetPropertySafe(callSiteArray[123].callGetPropertySafe(callSiteArray[124].callGetPropertySafe(callSiteArray[125].callGetProperty(callSiteArray[126].callGetProperty(this.grailsApplication))))));
        Object delay = DefaultTypeTransformation.booleanUnbox((Object)object) ? object : Integer.valueOf(0);
        if (delay instanceof String) {
            Object object2;
            delay = object2 = callSiteArray[127].call(delay);
        }
        if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return DefaultTypeTransformation.intUnbox((Object)(ScriptBytecodeAdapter.compareGreaterThan((Object)delay, (Object)0) ? delay : Integer.valueOf(120)));
        }
        return DefaultTypeTransformation.intUnbox((Object)(ScriptBytecodeAdapter.compareGreaterThan((Object)delay, (Object)0) ? delay : Integer.valueOf(120)));
    }

    public String getConfiguredPluginName() {
        CallSite[] callSiteArray = LogFileStorageService.$getCallSiteArray();
        return ShortTypeHandling.castToString((Object)callSiteArray[128].callSafe(this.configurationService, (Object)"execution.logs.fileStoragePlugin", null));
    }

    public StreamingLogWriter getLogFileWriterForExecution(Execution e, Map<String, String> defaultMeta, ValueWatcher<Long> filesizeWatcher) {
        CallSite[] callSiteArray = LogFileStorageService.$getCallSiteArray();
        Object filetype = callSiteArray[129].callGetProperty(LoggingService.class);
        File file = (File)ScriptBytecodeAdapter.castToType((Object)callSiteArray[130].callCurrent((GroovyObject)this, (Object)e, filetype, (Object)false), File.class);
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[131].call(callSiteArray[132].call((Object)file))) && !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[133].call(callSiteArray[134].call((Object)file)))) {
            throw (Throwable)callSiteArray[135].callConstructor(IllegalStateException.class, callSiteArray[136].call((Object)"Unable to create directories for storage: ", (Object)file));
        }
        Reference writer = new Reference(callSiteArray[137].callConstructor(FSStreamingLogWriter.class, callSiteArray[138].callConstructor(FileOutputStream.class, (Object)file), defaultMeta, (Object)rundeckLogFormat));
        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (ScriptBytecodeAdapter.compareNotEqual(filesizeWatcher, null)) {
                ValueHolder value = (ValueHolder)ScriptBytecodeAdapter.asType((Object)new /* Unavailable Anonymous Inner Class!! */, ValueHolder.class);
                callSiteArray[139].call(filesizeWatcher, (Object)value);
            }
        } else if (ScriptBytecodeAdapter.compareNotEqual(filesizeWatcher, null)) {
            ValueHolder value = (ValueHolder)ScriptBytecodeAdapter.asType((Object)new /* Unavailable Anonymous Inner Class!! */, ValueHolder.class);
            callSiteArray[140].call(filesizeWatcher, (Object)value);
        }
        return (StreamingLogWriter)ScriptBytecodeAdapter.castToType((Object)writer.get(), StreamingLogWriter.class);
    }

    public void submitForStorage(Execution e) {
        CallSite[] callSiteArray = LogFileStorageService.$getCallSiteArray();
        Object plugin = callSiteArray[141].callCurrent((GroovyObject)this, (Object)e, callSiteArray[142].call(this.frameworkService, callSiteArray[143].callGroovyObjectGetProperty((Object)e)));
        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass() ? ScriptBytecodeAdapter.compareEqual(null, (Object)plugin) || !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[144].callCurrent((GroovyObject)this, plugin)) : ScriptBytecodeAdapter.compareEqual(null, (Object)plugin) || !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[145].callCurrent((GroovyObject)this, plugin))) {
            return;
        }
        LogFileStorageRequest request = (LogFileStorageRequest)ScriptBytecodeAdapter.castToType((Object)callSiteArray[146].callCurrent((GroovyObject)this, (Object)e, (Object)"*"), LogFileStorageRequest.class);
        callSiteArray[147].call((Object)request);
        Object reqid = callSiteArray[148].call(callSiteArray[149].call(callSiteArray[150].call(callSiteArray[151].callGetProperty(callSiteArray[152].callGroovyObjectGetProperty((Object)request))), (Object)":"), callSiteArray[153].callGroovyObjectGetProperty((Object)request));
        callSiteArray[154].callCurrent((GroovyObject)this, reqid, plugin, (Object)request);
    }

    private LogFileStorageRequest createStorageRequest(Execution e, String filetype) {
        CallSite[] callSiteArray = LogFileStorageService.$getCallSiteArray();
        LogFileStorageRequest request = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[155].callConstructor(LogFileStorageRequest.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"execution", e, "pluginName", callSiteArray[156].callCurrent((GroovyObject)this), "completed", false, "filetype", filetype}));
            request = (LogFileStorageRequest)ScriptBytecodeAdapter.castToType((Object)object, LogFileStorageRequest.class);
        } else {
            Object object = callSiteArray[157].callConstructor(LogFileStorageRequest.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"execution", e, "pluginName", this.getConfiguredPluginName(), "completed", false, "filetype", filetype}));
            request = (LogFileStorageRequest)ScriptBytecodeAdapter.castToType((Object)object, LogFileStorageRequest.class);
        }
        callSiteArray[158].call((Object)request, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"flush", true}));
        return request;
    }

    public Map getStorageStats() {
        Map map;
        Map map2;
        CallSite[] callSiteArray = LogFileStorageService.$getCallSiteArray();
        Object missing = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            missing = object = callSiteArray[159].callCurrent((GroovyObject)this);
        } else {
            int n = this.countMissingLogStorageExecutions();
            missing = n;
        }
        Object incompleteRequests = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            incompleteRequests = object = callSiteArray[160].callCurrent((GroovyObject)this);
        } else {
            int n = this.countIncompleteLogStorageRequests();
            incompleteRequests = n;
        }
        Object queued = callSiteArray[161].callGetProperty(callSiteArray[162].callGroovyObjectGetProperty((Object)this));
        Object failed = callSiteArray[163].callGetProperty(callSiteArray[164].callGroovyObjectGetProperty((Object)this));
        Object succeeded = callSiteArray[165].callGetProperty(callSiteArray[166].callGroovyObjectGetProperty((Object)this));
        Object total = callSiteArray[167].callGetProperty(callSiteArray[168].callGroovyObjectGetProperty((Object)this));
        Object incomplete = callSiteArray[169].call(incompleteRequests, queued);
        Map data = null;
        data = __$stMC || BytecodeInterface8.disabledStandardMetaClass() ? (map2 = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"pluginName", callSiteArray[170].callCurrent((GroovyObject)this), "succeededCount", succeeded, "failedCount", failed, "queuedCount", queued, "totalCount", total, "incompleteCount", incomplete, "missingCount", missing})) : (map = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"pluginName", this.getConfiguredPluginName(), "succeededCount", succeeded, "failedCount", failed, "queuedCount", queued, "totalCount", total, "incompleteCount", incomplete, "missingCount", missing}));
        return (Map)ScriptBytecodeAdapter.castToType((Object)data, Map.class);
    }

    public int countMissingLogStorageExecutions() {
        CallSite[] callSiteArray = LogFileStorageService.$getCallSiteArray();
        return DefaultTypeTransformation.intUnbox((Object)callSiteArray[171].callCurrent((GroovyObject)this, callSiteArray[172].callGetProperty(this.frameworkService)));
    }

    /*
     * WARNING - void declaration
     */
    public void resumeIncompleteLogStorageAsync(String serverUUID, Long id) {
        void var2_2;
        Reference serverUUID2 = new Reference((Object)serverUUID);
        Reference id2 = new Reference((Object)var2_2);
        CallSite[] callSiteArray = LogFileStorageService.$getCallSiteArray();
        callSiteArray[173].call(this.executorService, (Object)new /* Unavailable Anonymous Inner Class!! */);
    }

    public Object dequeueIncompleteLogStorage() {
        CallSite[] callSiteArray = LogFileStorageService.$getCallSiteArray();
        Reference taskId = new Reference(callSiteArray[174].call((Object)this.retryIncompleteRequests, (Object)30, callSiteArray[175].callGetProperty(TimeUnit.class)));
        if (!DefaultTypeTransformation.booleanUnbox((Object)taskId.get())) {
            return null;
        }
        callSiteArray[176].call((Object)log, (Object)new GStringImpl(new Object[]{taskId.get()}, new String[]{"dequeueIncompleteLogStorage, processing ", ""}));
        return callSiteArray[177].call(LogFileStorageRequest.class, (Object)new /* Unavailable Anonymous Inner Class!! */);
    }

    public Set<Long> getQueuedIncompleteRequestIds() {
        CallSite[] callSiteArray = LogFileStorageService.$getCallSiteArray();
        return (Set)ScriptBytecodeAdapter.castToType((Object)callSiteArray[178].call(Collections.class, callSiteArray[179].callConstructor(HashSet.class, (Object)this.retryIncompleteRequests)), Set.class);
    }

    public Set<Long> getFailedRequestIds() {
        CallSite[] callSiteArray = LogFileStorageService.$getCallSiteArray();
        return (Set)ScriptBytecodeAdapter.castToType((Object)callSiteArray[180].call(Collections.class, (Object)this.failedRequests), Set.class);
    }

    public List<String> getFailures(Long id) {
        CallSite[] callSiteArray = LogFileStorageService.$getCallSiteArray();
        return (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[181].call(Collections.class, callSiteArray[182].call((Object)this.failures, (Object)id)), List.class);
    }

    public void resumeIncompleteLogStoragePeriodic(String serverUUID, Long id) {
        CallSite[] callSiteArray = LogFileStorageService.$getCallSiteArray();
        List incomplete = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (!DefaultTypeTransformation.booleanUnbox((Object)id)) {
                Object object = callSiteArray[183].callCurrent((GroovyObject)this, (Object)serverUUID);
                incomplete = (List)ScriptBytecodeAdapter.castToType((Object)object, List.class);
            } else {
                Object found = callSiteArray[184].call(LogFileStorageRequest.class, (Object)id);
                if (DefaultTypeTransformation.booleanUnbox((Object)found) && ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[185].callGetProperty(callSiteArray[186].callGetProperty(found)), (Object)serverUUID)) {
                    List list;
                    incomplete = list = ScriptBytecodeAdapter.createList((Object[])new Object[]{found});
                }
            }
        } else if (!DefaultTypeTransformation.booleanUnbox((Object)id)) {
            List list;
            incomplete = list = this.listIncompleteRequests(serverUUID);
        } else {
            Object found = callSiteArray[187].call(LogFileStorageRequest.class, (Object)id);
            if (DefaultTypeTransformation.booleanUnbox((Object)found) && ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[188].callGetProperty(callSiteArray[189].callGetProperty(found)), (Object)serverUUID)) {
                List list;
                incomplete = list = ScriptBytecodeAdapter.createList((Object[])new Object[]{found});
            }
        }
        callSiteArray[190].call((Object)incomplete, (Object)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void resumeIncompleteLogStorage(String serverUUID, Long id) {
        CallSite[] callSiteArray = LogFileStorageService.$getCallSiteArray();
        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object strategy = callSiteArray[191].callCurrent((GroovyObject)this);
            if (ScriptBytecodeAdapter.compareEqual((Object)"delayed", (Object)strategy)) {
                callSiteArray[192].callCurrent((GroovyObject)this, (Object)serverUUID, (Object)id);
            } else {
                callSiteArray[193].callCurrent((GroovyObject)this, (Object)serverUUID, (Object)id);
            }
        } else {
            String strategy = this.getConfiguredResumeStrategy();
            if (ScriptBytecodeAdapter.compareEqual((Object)"delayed", (Object)strategy)) {
                this.resumeIncompleteLogStorageDelayed(serverUUID, id);
            } else {
                this.resumeIncompleteLogStoragePeriodic(serverUUID, id);
            }
        }
    }

    public void haltIncompleteLogStorage(String serverUUID) {
        CallSite[] callSiteArray = LogFileStorageService.$getCallSiteArray();
        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object strategy = callSiteArray[194].callCurrent((GroovyObject)this);
            if (ScriptBytecodeAdapter.compareEqual((Object)"delayed", (Object)strategy)) {
                throw (Throwable)callSiteArray[195].callConstructor(IllegalStateException.class, (Object)"Cannot halt storage task when strategy is: delayed");
            }
            int size = DefaultTypeTransformation.intUnbox((Object)callSiteArray[196].call((Object)this.retryIncompleteRequests));
            callSiteArray[197].call((Object)this.retryIncompleteRequests);
            callSiteArray[198].call(callSiteArray[199].callGroovyObjectGetProperty((Object)this), (Object)size);
        } else {
            String strategy = this.getConfiguredResumeStrategy();
            if (ScriptBytecodeAdapter.compareEqual((Object)"delayed", (Object)strategy)) {
                throw (Throwable)callSiteArray[200].callConstructor(IllegalStateException.class, (Object)"Cannot halt storage task when strategy is: delayed");
            }
            int size = DefaultTypeTransformation.intUnbox((Object)callSiteArray[201].call((Object)this.retryIncompleteRequests));
            callSiteArray[202].call((Object)this.retryIncompleteRequests);
            callSiteArray[203].call(callSiteArray[204].callGroovyObjectGetProperty((Object)this), (Object)size);
        }
    }

    public int cleanupIncompleteLogStorage(String serverUUID, Long id) {
        CallSite[] callSiteArray = LogFileStorageService.$getCallSiteArray();
        List incomplete = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (!DefaultTypeTransformation.booleanUnbox((Object)id)) {
                Object object = callSiteArray[205].callCurrent((GroovyObject)this, (Object)serverUUID);
                incomplete = (List)ScriptBytecodeAdapter.castToType((Object)object, List.class);
            } else {
                Object found = callSiteArray[206].call(LogFileStorageRequest.class, (Object)id);
                if (DefaultTypeTransformation.booleanUnbox((Object)found) && ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[207].callGetProperty(callSiteArray[208].callGetProperty(found)), (Object)serverUUID)) {
                    List list;
                    incomplete = list = ScriptBytecodeAdapter.createList((Object[])new Object[]{found});
                }
            }
        } else if (!DefaultTypeTransformation.booleanUnbox((Object)id)) {
            List list;
            incomplete = list = this.listIncompleteRequests(serverUUID);
        } else {
            Object found = callSiteArray[209].call(LogFileStorageRequest.class, (Object)id);
            if (DefaultTypeTransformation.booleanUnbox((Object)found) && ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[210].callGetProperty(callSiteArray[211].callGetProperty(found)), (Object)serverUUID)) {
                List list;
                incomplete = list = ScriptBytecodeAdapter.createList((Object[])new Object[]{found});
            }
        }
        Object object = callSiteArray[212].call((Object)incomplete, (Object)new /* Unavailable Anonymous Inner Class!! */);
        incomplete = (List)ScriptBytecodeAdapter.castToType((Object)object, List.class);
        callSiteArray[213].call((Object)incomplete, (Object)new /* Unavailable Anonymous Inner Class!! */);
        return DefaultTypeTransformation.intUnbox((Object)callSiteArray[214].call((Object)incomplete));
    }

    public int resumeIncompleteLogStorageDelayed(String serverUUID, Long id) {
        CallSite[] callSiteArray = LogFileStorageService.$getCallSiteArray();
        List incomplete = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (!DefaultTypeTransformation.booleanUnbox((Object)id)) {
                Object object = callSiteArray[215].callCurrent((GroovyObject)this, (Object)serverUUID);
                incomplete = (List)ScriptBytecodeAdapter.castToType((Object)object, List.class);
            } else {
                Object found = callSiteArray[216].call(LogFileStorageRequest.class, (Object)id);
                if (DefaultTypeTransformation.booleanUnbox((Object)found) && ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[217].callGetProperty(callSiteArray[218].callGetProperty(found)), (Object)serverUUID)) {
                    List list;
                    incomplete = list = ScriptBytecodeAdapter.createList((Object[])new Object[]{found});
                }
            }
        } else if (!DefaultTypeTransformation.booleanUnbox((Object)id)) {
            List list;
            incomplete = list = this.listIncompleteRequests(serverUUID);
        } else {
            Object found = callSiteArray[219].call(LogFileStorageRequest.class, (Object)id);
            if (DefaultTypeTransformation.booleanUnbox((Object)found) && ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[220].callGetProperty(callSiteArray[221].callGetProperty(found)), (Object)serverUUID)) {
                List list;
                incomplete = list = ScriptBytecodeAdapter.createList((Object[])new Object[]{found});
            }
        }
        callSiteArray[222].call((Object)log, (Object)new GStringImpl(new Object[]{callSiteArray[223].call((Object)incomplete), serverUUID}, new String[]{"resumeIncompleteLogStorage: found: ", " incomplete requests for serverUUID: ", ""}));
        if (!DefaultTypeTransformation.booleanUnbox((Object)incomplete)) {
            return 0;
        }
        Reference delayInc = new Reference(null);
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[224].callCurrent((GroovyObject)this);
            delayInc.set(object);
        } else {
            int n = this.getConfiguredStorageRetryDelay();
            delayInc.set((Object)n);
        }
        Reference delay = new Reference(delayInc.get());
        Reference count = new Reference((Object)0);
        callSiteArray[225].call((Object)incomplete, (Object)new /* Unavailable Anonymous Inner Class!! */);
        callSiteArray[226].call((Object)log, (Object)new GStringImpl(new Object[]{count.get(), serverUUID}, new String[]{"resumeIncompleteLogStorage: ", " incomplete requests requeued for serverUUID: ", ""}));
        return DefaultTypeTransformation.intUnbox((Object)count.get());
    }

    public int countIncompleteLogStorageRequests() {
        CallSite[] callSiteArray = LogFileStorageService.$getCallSiteArray();
        Reference serverUUID = new Reference(callSiteArray[227].callGetProperty(this.frameworkService));
        Object found2 = callSiteArray[228].call(callSiteArray[229].call(LogFileStorageRequest.class), (Object)new /* Unavailable Anonymous Inner Class!! */);
        return DefaultTypeTransformation.intUnbox((Object)found2);
    }

    /*
     * WARNING - void declaration
     */
    public List<LogFileStorageRequest> listIncompleteRequests(String serverUUID, Map paging) {
        void var2_2;
        Reference serverUUID2 = new Reference((Object)serverUUID);
        Reference paging2 = new Reference((Object)var2_2);
        CallSite[] callSiteArray = LogFileStorageService.$getCallSiteArray();
        Object found2 = callSiteArray[230].call(LogFileStorageRequest.class, (Object)new /* Unavailable Anonymous Inner Class!! */);
        return (List)ScriptBytecodeAdapter.castToType((Object)found2, List.class);
    }

    public int countExecutionsWithoutStorageRequests(String serverUUID) {
        Reference serverUUID2 = new Reference((Object)serverUUID);
        CallSite[] callSiteArray = LogFileStorageService.$getCallSiteArray();
        Object found2 = callSiteArray[231].call(callSiteArray[232].call(Execution.class), (Object)new /* Unavailable Anonymous Inner Class!! */);
        return DefaultTypeTransformation.intUnbox((Object)found2);
    }

    /*
     * WARNING - void declaration
     */
    public List<Execution> listExecutionsWithoutStorageRequests(String serverUUID, Map paging) {
        void var2_2;
        Reference serverUUID2 = new Reference((Object)serverUUID);
        Reference paging2 = new Reference((Object)var2_2);
        CallSite[] callSiteArray = LogFileStorageService.$getCallSiteArray();
        return (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[233].call(callSiteArray[234].call(Execution.class), (Object)new /* Unavailable Anonymous Inner Class!! */), List.class);
    }

    public boolean isStorageRequestInProgress(Object reqid) {
        Reference reqid2 = new Reference(reqid);
        CallSite[] callSiteArray = LogFileStorageService.$getCallSiteArray();
        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[235].call(callSiteArray[236].callCurrent((GroovyObject)this), (Object)new /* Unavailable Anonymous Inner Class!! */)) || DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[237].call(callSiteArray[238].callCurrent((GroovyObject)this), (Object)new /* Unavailable Anonymous Inner Class!! */));
        }
        return DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[239].call((Object)this.getCurrentStorageRequests(), (Object)new /* Unavailable Anonymous Inner Class!! */)) || DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[240].call((Object)this.getCurrentRequests(), (Object)new /* Unavailable Anonymous Inner Class!! */));
    }

    public File getFileForExecutionFiletype(Execution execution, String filetype, boolean useStoredPath) {
        CallSite[] callSiteArray = LogFileStorageService.$getCallSiteArray();
        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (useStoredPath && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[241].callGroovyObjectGetProperty((Object)execution))) {
                String path = ShortTypeHandling.castToString((Object)callSiteArray[242].call(callSiteArray[243].callGroovyObjectGetProperty((Object)execution), (Object)"\\.([^\\.]+)$", (Object)""));
                return (File)ScriptBytecodeAdapter.castToType((Object)callSiteArray[244].callConstructor(File.class, callSiteArray[245].call(callSiteArray[246].call((Object)path, (Object)"."), (Object)filetype)), File.class);
            }
            return (File)ScriptBytecodeAdapter.castToType((Object)callSiteArray[247].callCurrent((GroovyObject)this, callSiteArray[248].callStatic(LogFileStorageService.class, (Object)execution, (Object)filetype)), File.class);
        }
        if (useStoredPath && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[249].callGroovyObjectGetProperty((Object)execution))) {
            String path = ShortTypeHandling.castToString((Object)callSiteArray[250].call(callSiteArray[251].callGroovyObjectGetProperty((Object)execution), (Object)"\\.([^\\.]+)$", (Object)""));
            return (File)ScriptBytecodeAdapter.castToType((Object)callSiteArray[252].callConstructor(File.class, callSiteArray[253].call(callSiteArray[254].call((Object)path, (Object)"."), (Object)filetype)), File.class);
        }
        return (File)ScriptBytecodeAdapter.castToType((Object)callSiteArray[255].callCurrent((GroovyObject)this, callSiteArray[256].callStatic(LogFileStorageService.class, (Object)execution, (Object)filetype)), File.class);
    }

    public static String generateLocalPathForExecutionFile(Execution execution, String extension) {
        CallSite[] callSiteArray = LogFileStorageService.$getCallSiteArray();
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[257].callGroovyObjectGetProperty((Object)execution))) {
            return ShortTypeHandling.castToString((Object)callSiteArray[258].call((Object)new GStringImpl(new Object[]{callSiteArray[259].callGroovyObjectGetProperty((Object)execution), callSiteArray[260].callGetProperty(callSiteArray[261].callGroovyObjectGetProperty((Object)execution)), callSiteArray[262].callGroovyObjectGetProperty((Object)execution)}, new String[]{"", "/job/", "/logs/", "."}), (Object)extension));
        }
        return ShortTypeHandling.castToString((Object)callSiteArray[263].call((Object)new GStringImpl(new Object[]{callSiteArray[264].callGroovyObjectGetProperty((Object)execution), callSiteArray[265].callGroovyObjectGetProperty((Object)execution)}, new String[]{"", "/run/logs/", "."}), (Object)extension));
    }

    public File getFileForLocalPath(String path) {
        CallSite[] callSiteArray = LogFileStorageService.$getCallSiteArray();
        Object props = callSiteArray[266].call(this.frameworkService);
        Object dir = callSiteArray[267].call(props, (Object)"framework.logs.dir");
        if (!DefaultTypeTransformation.booleanUnbox((Object)dir)) {
            throw (Throwable)callSiteArray[268].callConstructor(IllegalStateException.class, (Object)"framework.logs.dir is not set in framework.properties");
        }
        return (File)ScriptBytecodeAdapter.castToType((Object)callSiteArray[269].callConstructor(File.class, callSiteArray[270].callConstructor(File.class, dir, (Object)"rundeck"), (Object)path), File.class);
    }

    private static StreamingLogReader getLogReaderForFile(File file) {
        CallSite[] callSiteArray = LogFileStorageService.$getCallSiteArray();
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[271].call((Object)file))) {
            throw (Throwable)callSiteArray[272].callConstructor(IllegalArgumentException.class, callSiteArray[273].call((Object)"File does not exist: ", (Object)file));
        }
        return (StreamingLogReader)ScriptBytecodeAdapter.castToType((Object)callSiteArray[274].callConstructor(FSStreamingLogReader.class, (Object)file, (Object)"UTF-8", (Object)rundeckLogFormat), StreamingLogReader.class);
    }

    private Map getLogFileState(Execution execution, String filetype, ExecutionFileStoragePlugin plugin) {
        CallSite[] callSiteArray = LogFileStorageService.$getCallSiteArray();
        File file = (File)ScriptBytecodeAdapter.castToType((Object)callSiteArray[275].callCurrent((GroovyObject)this, (Object)execution, (Object)filetype, (Object)true), File.class);
        Object key = callSiteArray[276].callStatic(LogFileStorageService.class, (Object)execution, (Object)filetype);
        LogFileState local = null;
        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = ScriptBytecodeAdapter.compareNotEqual((Object)file, null) && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[277].call((Object)file)) ? callSiteArray[278].callGetProperty(LogFileState.class) : callSiteArray[279].callGetProperty(LogFileState.class);
            local = (LogFileState)ShortTypeHandling.castToEnum((Object)object, LogFileState.class);
        } else {
            Object object = ScriptBytecodeAdapter.compareNotEqual((Object)file, null) && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[280].call((Object)file)) ? callSiteArray[281].callGetProperty(LogFileState.class) : callSiteArray[282].callGetProperty(LogFileState.class);
            local = (LogFileState)ShortTypeHandling.castToEnum((Object)object, LogFileState.class);
        }
        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (ScriptBytecodeAdapter.compareEqual((Object)local, (Object)callSiteArray[283].callGetProperty(LogFileState.class))) {
                return ScriptBytecodeAdapter.createMap((Object[])new Object[]{"state", callSiteArray[284].callGetProperty(ExecutionLogState.class)});
            }
        } else if (ScriptBytecodeAdapter.compareEqual((Object)local, (Object)callSiteArray[285].callGetProperty(LogFileState.class))) {
            return ScriptBytecodeAdapter.createMap((Object[])new Object[]{"state", callSiteArray[286].callGetProperty(ExecutionLogState.class)});
        }
        LogFileState remote = null;
        ExecutionLogState remoteNotFound = (ExecutionLogState)ShortTypeHandling.castToEnum((Object)callSiteArray[287].callGetProperty(ExecutionLogState.class), ExecutionLogState.class);
        long pendingDelay = 0L;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[288].call(callSiteArray[289].callGetProperty(TimeUnit.class), callSiteArray[290].callCurrent((GroovyObject)this), callSiteArray[291].callGetProperty(TimeUnit.class));
            pendingDelay = DefaultTypeTransformation.longUnbox((Object)object);
        } else {
            Object object = callSiteArray[292].call(callSiteArray[293].callGetProperty(TimeUnit.class), (Object)this.getConfiguredRemotePendingDelay(), callSiteArray[294].callGetProperty(TimeUnit.class));
            pendingDelay = DefaultTypeTransformation.longUnbox((Object)object);
        }
        if (!BytecodeInterface8.isOrigL() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[295].callGroovyObjectGetProperty((Object)execution), null) && ScriptBytecodeAdapter.compareGreaterThan((Object)callSiteArray[296].call(callSiteArray[297].call(System.class), callSiteArray[298].callGetProperty(callSiteArray[299].callGroovyObjectGetProperty((Object)execution))), (Object)pendingDelay)) {
                Object object = callSiteArray[300].callGetProperty(ExecutionLogState.class);
                remoteNotFound = (ExecutionLogState)ShortTypeHandling.castToEnum((Object)object, ExecutionLogState.class);
            }
        } else if (ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[301].callGroovyObjectGetProperty((Object)execution), null) && ScriptBytecodeAdapter.compareGreaterThan((Object)callSiteArray[302].call(callSiteArray[303].call(System.class), callSiteArray[304].callGetProperty(callSiteArray[305].callGroovyObjectGetProperty((Object)execution))), (Object)pendingDelay)) {
            Object object = callSiteArray[306].callGetProperty(ExecutionLogState.class);
            remoteNotFound = (ExecutionLogState)ShortTypeHandling.castToEnum((Object)object, ExecutionLogState.class);
        }
        String errorCode = null;
        List errorData = null;
        Object previous = callSiteArray[307].callCurrent((GroovyObject)this, key);
        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (ScriptBytecodeAdapter.compareNotEqual((Object)previous, null)) {
                Object object = callSiteArray[308].callGetProperty(previous);
                remote = (LogFileState)ShortTypeHandling.castToEnum((Object)object, LogFileState.class);
                Object object2 = callSiteArray[309].callGetProperty(previous);
                errorCode = ShortTypeHandling.castToString((Object)object2);
                Object object3 = callSiteArray[310].callGetProperty(previous);
                errorData = (List)ScriptBytecodeAdapter.castToType((Object)object3, List.class);
                Object state = callSiteArray[311].call(ExecutionLogState.class, (Object)local, (Object)remote, (Object)remoteNotFound);
                callSiteArray[312].call((Object)log, (Object)new GStringImpl(new Object[]{callSiteArray[313].callGroovyObjectGetProperty((Object)execution), plugin, state, local, remote}, new String[]{"getLogFileState(", ",", ") (CACHE): ", " forFileStates: ", ", ", ""}));
                return ScriptBytecodeAdapter.createMap((Object[])new Object[]{"state", state, "errorCode", errorCode, "errorData", errorData});
            }
        } else if (ScriptBytecodeAdapter.compareNotEqual((Object)previous, null)) {
            Object object = callSiteArray[314].callGetProperty(previous);
            remote = (LogFileState)ShortTypeHandling.castToEnum((Object)object, LogFileState.class);
            Object object4 = callSiteArray[315].callGetProperty(previous);
            errorCode = ShortTypeHandling.castToString((Object)object4);
            Object object5 = callSiteArray[316].callGetProperty(previous);
            errorData = (List)ScriptBytecodeAdapter.castToType((Object)object5, List.class);
            Object state = callSiteArray[317].call(ExecutionLogState.class, (Object)local, (Object)remote, (Object)remoteNotFound);
            callSiteArray[318].call((Object)log, (Object)new GStringImpl(new Object[]{callSiteArray[319].callGroovyObjectGetProperty((Object)execution), plugin, state, local, remote}, new String[]{"getLogFileState(", ",", ") (CACHE): ", " forFileStates: ", ", ", ""}));
            return ScriptBytecodeAdapter.createMap((Object[])new Object[]{"state", state, "errorCode", errorCode, "errorData", errorData});
        }
        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (ScriptBytecodeAdapter.compareEqual(null, remote)) {
                Object requeststate = callSiteArray[320].callCurrent((GroovyObject)this, (Object)execution, (Object)filetype);
                if (ScriptBytecodeAdapter.compareNotEqual(null, (Object)requeststate)) {
                    callSiteArray[321].call((Object)log, (Object)new GStringImpl(new Object[]{callSiteArray[322].callGroovyObjectGetProperty((Object)execution), plugin, requeststate}, new String[]{"getLogFileState(", ",", ") (RUNNING): ", ""}));
                    return ScriptBytecodeAdapter.createMap((Object[])new Object[]{"state", requeststate});
                }
            }
        } else if (ScriptBytecodeAdapter.compareEqual(null, remote)) {
            Object requeststate = callSiteArray[323].callCurrent((GroovyObject)this, (Object)execution, (Object)filetype);
            if (ScriptBytecodeAdapter.compareNotEqual(null, (Object)requeststate)) {
                callSiteArray[324].call((Object)log, (Object)new GStringImpl(new Object[]{callSiteArray[325].callGroovyObjectGetProperty((Object)execution), plugin, requeststate}, new String[]{"getLogFileState(", ",", ") (RUNNING): ", ""}));
                return ScriptBytecodeAdapter.createMap((Object[])new Object[]{"state", requeststate});
            }
        }
        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (ScriptBytecodeAdapter.compareEqual(null, (Object)remote) && ScriptBytecodeAdapter.compareNotEqual(null, (Object)plugin) && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[326].callCurrent((GroovyObject)this, (Object)plugin))) {
                Object errorMessage = null;
                try {
                    Object newremote = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[327].call((Object)plugin, (Object)filetype)) ? callSiteArray[328].callGetProperty(LogFileState.class) : callSiteArray[329].callGetProperty(LogFileState.class);
                    Object object = newremote;
                    remote = (LogFileState)ShortTypeHandling.castToEnum((Object)object, LogFileState.class);
                }
                catch (Throwable e) {
                    List list;
                    Object object;
                    String string;
                    Object pluginName = callSiteArray[330].callCurrent((GroovyObject)this);
                    callSiteArray[331].call((Object)log, callSiteArray[332].call((Object)new GStringImpl(new Object[]{pluginName}, new String[]{"Log file availability could not be determined ", ": "}), callSiteArray[333].callGetProperty((Object)e)));
                    callSiteArray[334].call((Object)log, callSiteArray[335].call((Object)new GStringImpl(new Object[]{pluginName}, new String[]{"Log file availability could not be determined ", ": "}), callSiteArray[336].callGetProperty((Object)e)), (Object)e);
                    errorCode = string = "execution.log.storage.state.ERROR";
                    errorMessage = object = callSiteArray[337].callGetProperty((Object)e);
                    errorData = list = ScriptBytecodeAdapter.createList((Object[])new Object[]{pluginName, errorMessage});
                    Object object6 = callSiteArray[338].callGetProperty(LogFileState.class);
                    remote = (LogFileState)ShortTypeHandling.castToEnum((Object)object6, LogFileState.class);
                }
                if (ScriptBytecodeAdapter.compareNotEqual((Object)remote, (Object)callSiteArray[339].callGetProperty(LogFileState.class))) {
                    callSiteArray[340].callCurrent((GroovyObject)this, ArrayUtil.createArray((Object)key, (Object)remote, (Object)0, errorMessage, (Object)errorCode, (Object)errorData));
                }
            }
        } else if (ScriptBytecodeAdapter.compareEqual(null, (Object)remote) && ScriptBytecodeAdapter.compareNotEqual(null, (Object)plugin) && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[341].callCurrent((GroovyObject)this, (Object)plugin))) {
            Object errorMessage = null;
            try {
                Object newremote = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[342].call((Object)plugin, (Object)filetype)) ? callSiteArray[343].callGetProperty(LogFileState.class) : callSiteArray[344].callGetProperty(LogFileState.class);
                Object object = newremote;
                remote = (LogFileState)ShortTypeHandling.castToEnum((Object)object, LogFileState.class);
            }
            catch (Throwable e) {
                List list;
                Object object;
                String string;
                String pluginName = this.getConfiguredPluginName();
                callSiteArray[345].call((Object)log, callSiteArray[346].call((Object)new GStringImpl(new Object[]{pluginName}, new String[]{"Log file availability could not be determined ", ": "}), callSiteArray[347].callGetProperty((Object)e)));
                callSiteArray[348].call((Object)log, callSiteArray[349].call((Object)new GStringImpl(new Object[]{pluginName}, new String[]{"Log file availability could not be determined ", ": "}), callSiteArray[350].callGetProperty((Object)e)), (Object)e);
                errorCode = string = "execution.log.storage.state.ERROR";
                errorMessage = object = callSiteArray[351].callGetProperty((Object)e);
                errorData = list = ScriptBytecodeAdapter.createList((Object[])new Object[]{pluginName, errorMessage});
                Object object7 = callSiteArray[352].callGetProperty(LogFileState.class);
                remote = (LogFileState)ShortTypeHandling.castToEnum((Object)object7, LogFileState.class);
            }
            if (ScriptBytecodeAdapter.compareNotEqual((Object)remote, (Object)callSiteArray[353].callGetProperty(LogFileState.class))) {
                callSiteArray[354].callCurrent((GroovyObject)this, ArrayUtil.createArray((Object)key, (Object)remote, (Object)0, errorMessage, (Object)errorCode, (Object)errorData));
            }
        }
        Object state = callSiteArray[355].call(ExecutionLogState.class, (Object)local, (Object)remote, (Object)remoteNotFound);
        callSiteArray[356].call((Object)log, (Object)new GStringImpl(new Object[]{callSiteArray[357].callGroovyObjectGetProperty((Object)execution), plugin, state, local, remote}, new String[]{"getLogFileState(", ",", "): ", " forFileStates: ", ", ", ""}));
        return ScriptBytecodeAdapter.createMap((Object[])new Object[]{"state", state, "errorCode", errorCode, "errorData", errorData});
    }

    public Object pluginSupportsRetrieve(Object plugin) {
        CallSite[] callSiteArray = LogFileStorageService.$getCallSiteArray();
        if (plugin instanceof ExecutionFileStorageOptions) {
            return callSiteArray[358].callGetProperty((Object)((ExecutionFileStorageOptions)ScriptBytecodeAdapter.castToType((Object)plugin, ExecutionFileStorageOptions.class)));
        }
        return true;
    }

    public Object pluginSupportsStorage(Object plugin) {
        CallSite[] callSiteArray = LogFileStorageService.$getCallSiteArray();
        if (plugin instanceof ExecutionFileStorageOptions) {
            return callSiteArray[359].callGetProperty((Object)((ExecutionFileStorageOptions)ScriptBytecodeAdapter.castToType((Object)plugin, ExecutionFileStorageOptions.class)));
        }
        return true;
    }

    public Map getRetrievalCacheResult(String key) {
        CallSite[] callSiteArray = LogFileStorageService.$getCallSiteArray();
        Object previous = callSiteArray[360].call((Object)this.logFileRetrievalResults, (Object)key);
        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (ScriptBytecodeAdapter.compareNotEqual((Object)previous, null) && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[361].callCurrent((GroovyObject)this, previous))) {
                callSiteArray[362].call((Object)log, (Object)new GStringImpl(new Object[]{previous}, new String[]{"getRetrievalCacheResult, previous result still cached: ", ""}));
                return (Map)ScriptBytecodeAdapter.castToType((Object)previous, Map.class);
            }
            if (ScriptBytecodeAdapter.compareNotEqual((Object)previous, null) && !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[363].callCurrent((GroovyObject)this, previous))) {
                callSiteArray[364].call((Object)log, (Object)new GStringImpl(new Object[]{callSiteArray[365].callGetProperty(previous), key}, new String[]{"getRetrievalCacheResult, reached max retry count of ", " for ", ", not retrying"}));
                return (Map)ScriptBytecodeAdapter.castToType((Object)previous, Map.class);
            }
            if (ScriptBytecodeAdapter.compareNotEqual((Object)previous, null)) {
                callSiteArray[366].call((Object)log, (Object)new GStringImpl(new Object[]{previous}, new String[]{"getRetrievalCacheResult, expired cache result: ", ""}));
            }
        } else {
            if (ScriptBytecodeAdapter.compareNotEqual((Object)previous, null) && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[367].callCurrent((GroovyObject)this, previous))) {
                callSiteArray[368].call((Object)log, (Object)new GStringImpl(new Object[]{previous}, new String[]{"getRetrievalCacheResult, previous result still cached: ", ""}));
                return (Map)ScriptBytecodeAdapter.castToType((Object)previous, Map.class);
            }
            if (ScriptBytecodeAdapter.compareNotEqual((Object)previous, null) && !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[369].callCurrent((GroovyObject)this, previous))) {
                callSiteArray[370].call((Object)log, (Object)new GStringImpl(new Object[]{callSiteArray[371].callGetProperty(previous), key}, new String[]{"getRetrievalCacheResult, reached max retry count of ", " for ", ", not retrying"}));
                return (Map)ScriptBytecodeAdapter.castToType((Object)previous, Map.class);
            }
            if (ScriptBytecodeAdapter.compareNotEqual((Object)previous, null)) {
                callSiteArray[372].call((Object)log, (Object)new GStringImpl(new Object[]{previous}, new String[]{"getRetrievalCacheResult, expired cache result: ", ""}));
            }
        }
        return (Map)ScriptBytecodeAdapter.castToType(null, Map.class);
    }

    public Map cacheRetrievalState(String key, LogFileState state, int count, String error, String errorCode, List errorData) {
        CallSite[] callSiteArray = LogFileStorageService.$getCallSiteArray();
        Object name = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            name = object = callSiteArray[373].callCurrent((GroovyObject)this);
        } else {
            String string = this.getConfiguredPluginName();
            name = string;
        }
        Map cache = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"id", key, "name", name, "state", state, "time", callSiteArray[374].callConstructor(Date.class), "count", count});
        if (DefaultTypeTransformation.booleanUnbox((Object)error)) {
            String string = errorCode;
            String string2 = DefaultTypeTransformation.booleanUnbox((Object)string) ? string : "execution.log.storage.retrieval.ERROR";
            ScriptBytecodeAdapter.setProperty((Object)string2, null, (Object)cache, (String)"errorCode");
            List list = errorData;
            List list2 = DefaultTypeTransformation.booleanUnbox((Object)list) ? list : ScriptBytecodeAdapter.createList((Object[])new Object[]{name, error});
            ScriptBytecodeAdapter.setProperty((Object)list2, null, (Object)cache, (String)"errorData");
            String string3 = error;
            ScriptBytecodeAdapter.setProperty((Object)string3, null, (Object)cache, (String)"error");
        }
        Object previous = callSiteArray[375].call((Object)this.logFileRetrievalResults, (Object)key, (Object)cache);
        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (ScriptBytecodeAdapter.compareNotEqual(null, (Object)previous)) {
                callSiteArray[376].call((Object)log, (Object)new GStringImpl(new Object[]{key, previous}, new String[]{"cacheRetrievalState: replacing cached state for ", ": ", ""}));
                Object object = callSiteArray[377].callGetProperty(previous);
                ScriptBytecodeAdapter.setProperty((Object)object, null, (Object)cache, (String)"count");
            } else {
                callSiteArray[378].call((Object)log, (Object)new GStringImpl(new Object[]{key, cache}, new String[]{"cacheRetrievalState: cached state for ", ": ", ""}));
            }
        } else if (ScriptBytecodeAdapter.compareNotEqual(null, (Object)previous)) {
            callSiteArray[379].call((Object)log, (Object)new GStringImpl(new Object[]{key, previous}, new String[]{"cacheRetrievalState: replacing cached state for ", ": ", ""}));
            Object object = callSiteArray[380].callGetProperty(previous);
            ScriptBytecodeAdapter.setProperty((Object)object, null, (Object)cache, (String)"count");
        } else {
            callSiteArray[381].call((Object)log, (Object)new GStringImpl(new Object[]{key, cache}, new String[]{"cacheRetrievalState: cached state for ", ": ", ""}));
        }
        return (Map)ScriptBytecodeAdapter.castToType((Object)cache, Map.class);
    }

    private ExecutionFileStoragePlugin getConfiguredPluginForExecution(Execution execution, PropertyResolver resolver) {
        CallSite[] callSiteArray = LogFileStorageService.$getCallSiteArray();
        Object jobcontext = callSiteArray[382].call(ExecutionService.class, (Object)execution, this.grailsLinkGenerator);
        Object plugin = callSiteArray[383].callCurrent((GroovyObject)this, jobcontext, (Object)resolver);
        return (ExecutionFileStoragePlugin)ScriptBytecodeAdapter.castToType((Object)plugin, ExecutionFileStoragePlugin.class);
    }

    private ExecutionFileStoragePlugin getConfiguredPlugin(Map context, PropertyResolver resolver) {
        CallSite[] callSiteArray = LogFileStorageService.$getCallSiteArray();
        Object pluginName = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            pluginName = object = callSiteArray[384].callCurrent((GroovyObject)this);
        } else {
            String string = this.getConfiguredPluginName();
            pluginName = string;
        }
        if (!DefaultTypeTransformation.booleanUnbox((Object)pluginName)) {
            return (ExecutionFileStoragePlugin)ScriptBytecodeAdapter.castToType(null, ExecutionFileStoragePlugin.class);
        }
        Object result = null;
        try {
            Object object;
            result = object = callSiteArray[385].call((Object)this.pluginService, pluginName, (Object)this.executionFileStoragePluginProviderService, (Object)resolver, callSiteArray[386].callGetProperty(PropertyScope.class));
        }
        catch (Throwable e) {
            callSiteArray[387].call((Object)log, callSiteArray[388].call((Object)new GStringImpl(new Object[]{pluginName, callSiteArray[389].callGetProperty(callSiteArray[390].callGetProperty((Object)e))}, new String[]{"Failed to create LogFileStoragePlugin '", "': ", ":"}), callSiteArray[391].callGetProperty((Object)e)), (Object)e);
            callSiteArray[392].call((Object)log, callSiteArray[393].call((Object)new GStringImpl(new Object[]{pluginName, callSiteArray[394].callGetProperty(callSiteArray[395].callGetProperty((Object)e))}, new String[]{"Failed to create LogFileStoragePlugin '", "': ", ":"}), callSiteArray[396].callGetProperty((Object)e)), (Object)e);
        }
        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (ScriptBytecodeAdapter.compareNotEqual((Object)result, null) && ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[397].callGetProperty(result), null)) {
                Object plugin = callSiteArray[398].callGetProperty(result);
                callSiteArray[399].call(plugin, (Object)context);
                ExecutionFileStoragePlugin executionFileStoragePlugin = (ExecutionFileStoragePlugin)ScriptBytecodeAdapter.castToType((Object)plugin, ExecutionFileStoragePlugin.class);
                try {
                    return executionFileStoragePlugin;
                }
                catch (Throwable e) {
                    callSiteArray[400].call((Object)log, callSiteArray[401].call((Object)new GStringImpl(new Object[]{pluginName, callSiteArray[402].callGetProperty(callSiteArray[403].callGetProperty((Object)e))}, new String[]{"Failed to initialize LogFileStoragePlugin '", "': ", ": "}), callSiteArray[404].callGetProperty((Object)e)), (Object)e);
                    callSiteArray[405].call((Object)log, callSiteArray[406].call((Object)new GStringImpl(new Object[]{pluginName, callSiteArray[407].callGetProperty(callSiteArray[408].callGetProperty((Object)e))}, new String[]{"Failed to initialize LogFileStoragePlugin '", "': ", ": "}), callSiteArray[409].callGetProperty((Object)e)), (Object)e);
                }
            }
        } else if (ScriptBytecodeAdapter.compareNotEqual((Object)result, null) && ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[410].callGetProperty(result), null)) {
            Object plugin = callSiteArray[411].callGetProperty(result);
            callSiteArray[412].call(plugin, (Object)context);
            ExecutionFileStoragePlugin executionFileStoragePlugin = (ExecutionFileStoragePlugin)ScriptBytecodeAdapter.castToType((Object)plugin, ExecutionFileStoragePlugin.class);
            try {
                return executionFileStoragePlugin;
            }
            catch (Throwable e) {
                callSiteArray[413].call((Object)log, callSiteArray[414].call((Object)new GStringImpl(new Object[]{pluginName, callSiteArray[415].callGetProperty(callSiteArray[416].callGetProperty((Object)e))}, new String[]{"Failed to initialize LogFileStoragePlugin '", "': ", ": "}), callSiteArray[417].callGetProperty((Object)e)), (Object)e);
                callSiteArray[418].call((Object)log, callSiteArray[419].call((Object)new GStringImpl(new Object[]{pluginName, callSiteArray[420].callGetProperty(callSiteArray[421].callGetProperty((Object)e))}, new String[]{"Failed to initialize LogFileStoragePlugin '", "': ", ": "}), callSiteArray[422].callGetProperty((Object)e)), (Object)e);
            }
        }
        return (ExecutionFileStoragePlugin)ScriptBytecodeAdapter.castToType(null, ExecutionFileStoragePlugin.class);
    }

    public ExecutionLogReader requestLogFileReader(Execution e, String filetype, boolean performLoad) {
        CallSite[] callSiteArray = LogFileStorageService.$getCallSiteArray();
        Object loader = callSiteArray[423].callCurrent((GroovyObject)this, (Object)e, (Object)filetype, (Object)performLoad);
        Object reader = null;
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[424].callGetProperty(loader))) {
            Object object;
            reader = object = callSiteArray[425].callStatic(LogFileStorageService.class, callSiteArray[426].callGetProperty(loader));
        }
        return (ExecutionLogReader)ScriptBytecodeAdapter.castToType((Object)callSiteArray[427].callConstructor(ExecutionLogReader.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"state", callSiteArray[428].callGetProperty(loader), "reader", reader, "errorCode", callSiteArray[429].callGetProperty(loader), "errorData", callSiteArray[430].callGetProperty(loader)})), ExecutionLogReader.class);
    }

    public LogFileLoader requestLogFileLoad(Execution e, String filetype, boolean performLoad) {
        CallSite[] callSiteArray = LogFileStorageService.$getCallSiteArray();
        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[431].callGroovyObjectGetProperty((Object)e), null) && ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[432].callGroovyObjectGetProperty((Object)e), null)) {
                if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[433].call(this.frameworkService)) && ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[434].callGroovyObjectGetProperty((Object)e), (Object)callSiteArray[435].call(this.frameworkService))) {
                    return (LogFileLoader)ScriptBytecodeAdapter.castToType((Object)callSiteArray[436].callConstructor(LogFileLoader.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"state", callSiteArray[437].callGetProperty(ExecutionLogState.class)})), LogFileLoader.class);
                }
                if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[438].callGroovyObjectGetProperty((Object)e))) {
                    return (LogFileLoader)ScriptBytecodeAdapter.castToType((Object)callSiteArray[439].callConstructor(LogFileLoader.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"state", callSiteArray[440].callGetProperty(ExecutionLogState.class)})), LogFileLoader.class);
                }
            }
        } else if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[441].callGroovyObjectGetProperty((Object)e), null) && ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[442].callGroovyObjectGetProperty((Object)e), null)) {
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[443].call(this.frameworkService)) && ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[444].callGroovyObjectGetProperty((Object)e), (Object)callSiteArray[445].call(this.frameworkService))) {
                return (LogFileLoader)ScriptBytecodeAdapter.castToType((Object)callSiteArray[446].callConstructor(LogFileLoader.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"state", callSiteArray[447].callGetProperty(ExecutionLogState.class)})), LogFileLoader.class);
            }
            if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[448].callGroovyObjectGetProperty((Object)e))) {
                return (LogFileLoader)ScriptBytecodeAdapter.castToType((Object)callSiteArray[449].callConstructor(LogFileLoader.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"state", callSiteArray[450].callGetProperty(ExecutionLogState.class)})), LogFileLoader.class);
            }
        }
        Object plugin = callSiteArray[451].callCurrent((GroovyObject)this, (Object)e, callSiteArray[452].call(this.frameworkService, callSiteArray[453].callGroovyObjectGetProperty((Object)e)));
        Object result = callSiteArray[454].callCurrent((GroovyObject)this, (Object)e, (Object)filetype, plugin);
        Object state = callSiteArray[455].callGetProperty(result);
        Object file = null;
        Object object = state;
        if (ScriptBytecodeAdapter.isCase((Object)object, (Object)callSiteArray[456].callGetProperty(ExecutionLogState.class))) {
            Object object2;
            file = object2 = callSiteArray[457].callCurrent((GroovyObject)this, (Object)e, (Object)filetype, (Object)true);
        } else if (ScriptBytecodeAdapter.isCase((Object)object, (Object)callSiteArray[458].callGetProperty(ExecutionLogState.class)) && performLoad) {
            Object object3;
            state = object3 = callSiteArray[459].callCurrent((GroovyObject)this, (Object)e, (Object)filetype, plugin);
        }
        callSiteArray[460].call((Object)log, (Object)new GStringImpl(new Object[]{callSiteArray[461].callGroovyObjectGetProperty((Object)e), performLoad, state}, new String[]{"requestLogFileRetrieval(", ",", "): ", ""}));
        return (LogFileLoader)ScriptBytecodeAdapter.castToType((Object)callSiteArray[462].callConstructor(LogFileLoader.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"state", state, "file", file, "errorCode", callSiteArray[463].callGetProperty(result), "errorData", callSiteArray[464].callGetProperty(result)})), LogFileLoader.class);
    }

    private static String logFileRetrievalKey(Execution execution, String filetype) {
        CallSite[] callSiteArray = LogFileStorageService.$getCallSiteArray();
        return ShortTypeHandling.castToString((Object)callSiteArray[465].call(callSiteArray[466].call(callSiteArray[467].call(callSiteArray[468].callGroovyObjectGetProperty((Object)execution)), (Object)":"), (Object)filetype));
    }

    private ExecutionLogState logFileRetrievalRequestState(Execution execution, String filetype) {
        CallSite[] callSiteArray = LogFileStorageService.$getCallSiteArray();
        Object key = callSiteArray[469].callStatic(LogFileStorageService.class, (Object)execution, (Object)filetype);
        Object pending = callSiteArray[470].call((Object)this.logFileRetrievalRequests, key);
        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (ScriptBytecodeAdapter.compareNotEqual((Object)pending, null)) {
                callSiteArray[471].call((Object)log, (Object)new GStringImpl(new Object[]{callSiteArray[472].callGetProperty(pending)}, new String[]{"logFileRetrievalRequestState, already pending: ", ""}));
                return (ExecutionLogState)ShortTypeHandling.castToEnum((Object)callSiteArray[473].callGetProperty(pending), ExecutionLogState.class);
            }
        } else if (ScriptBytecodeAdapter.compareNotEqual((Object)pending, null)) {
            callSiteArray[474].call((Object)log, (Object)new GStringImpl(new Object[]{callSiteArray[475].callGetProperty(pending)}, new String[]{"logFileRetrievalRequestState, already pending: ", ""}));
            return (ExecutionLogState)ShortTypeHandling.castToEnum((Object)callSiteArray[476].callGetProperty(pending), ExecutionLogState.class);
        }
        return (ExecutionLogState)ShortTypeHandling.castToEnum(null, ExecutionLogState.class);
    }

    private ExecutionLogState requestLogFileRetrieval(Execution execution, String filetype, ExecutionFileStorage plugin) {
        Map map;
        Map map2;
        CallSite[] callSiteArray = LogFileStorageService.$getCallSiteArray();
        Object key = callSiteArray[477].callStatic(LogFileStorageService.class, (Object)execution, (Object)filetype);
        Object file = callSiteArray[478].callCurrent((GroovyObject)this, (Object)execution, (Object)filetype, (Object)false);
        Map newstate = null;
        newstate = __$stMC || BytecodeInterface8.disabledStandardMetaClass() ? (map2 = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"state", callSiteArray[479].callGetProperty(ExecutionLogState.class), "file", file, "filetype", filetype, "storage", plugin, "id", key, "name", callSiteArray[480].callCurrent((GroovyObject)this), "count", 0})) : (map = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"state", callSiteArray[481].callGetProperty(ExecutionLogState.class), "file", file, "filetype", filetype, "storage", plugin, "id", key, "name", this.getConfiguredPluginName(), "count", 0}));
        Object previous = callSiteArray[482].call((Object)this.logFileRetrievalResults, key);
        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (ScriptBytecodeAdapter.compareNotEqual((Object)previous, null)) {
                Object object = callSiteArray[483].callGetProperty(previous);
                ScriptBytecodeAdapter.setProperty((Object)object, null, (Object)newstate, (String)"count");
            }
        } else if (ScriptBytecodeAdapter.compareNotEqual((Object)previous, null)) {
            Object object = callSiteArray[484].callGetProperty(previous);
            ScriptBytecodeAdapter.setProperty((Object)object, null, (Object)newstate, (String)"count");
        }
        Object pending = callSiteArray[485].call((Object)this.logFileRetrievalRequests, key, (Object)newstate);
        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (ScriptBytecodeAdapter.compareNotEqual((Object)pending, null)) {
                callSiteArray[486].call((Object)log, (Object)new GStringImpl(new Object[]{key, callSiteArray[487].callGetProperty(pending)}, new String[]{"requestLogFileRetrieval, already pending for ", ": ", ""}));
                return (ExecutionLogState)ShortTypeHandling.castToEnum((Object)callSiteArray[488].callGetProperty(pending), ExecutionLogState.class);
            }
        } else if (ScriptBytecodeAdapter.compareNotEqual((Object)pending, null)) {
            callSiteArray[489].call((Object)log, (Object)new GStringImpl(new Object[]{key, callSiteArray[490].callGetProperty(pending)}, new String[]{"requestLogFileRetrieval, already pending for ", ": ", ""}));
            return (ExecutionLogState)ShortTypeHandling.castToEnum((Object)callSiteArray[491].callGetProperty(pending), ExecutionLogState.class);
        }
        callSiteArray[492].call((Object)this.logFileRetrievalResults, key);
        callSiteArray[493].call((Object)log, (Object)new GStringImpl(new Object[]{callSiteArray[494].call(callSiteArray[495].callGetProperty((Object)newstate), (Object)1), key}, new String[]{"requestLogFileRetrieval, queueing a new request (attempt ", ") for ", "..."}));
        callSiteArray[496].call((Object)this.retrievalRequests, (Object)newstate);
        return (ExecutionLogState)ShortTypeHandling.castToEnum((Object)callSiteArray[497].callGetProperty(ExecutionLogState.class), ExecutionLogState.class);
    }

    public boolean isResultCacheItemFresh(Map previous) {
        CallSite[] callSiteArray = LogFileStorageService.$getCallSiteArray();
        int retryDelay = 0;
        if (!BytecodeInterface8.isOrigInt() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[498].callCurrent((GroovyObject)this);
            retryDelay = DefaultTypeTransformation.intUnbox((Object)object);
        } else {
            int n;
            retryDelay = n = this.getConfiguredRetrievalRetryDelay();
        }
        long ms = DefaultTypeTransformation.longUnbox((Object)callSiteArray[499].call(callSiteArray[500].call(callSiteArray[501].callGetProperty(TimeUnit.class), (Object)retryDelay, callSiteArray[502].callGetProperty(TimeUnit.class))));
        Date cacheTime = (Date)ScriptBytecodeAdapter.castToType((Object)callSiteArray[503].callGetProperty((Object)previous), Date.class);
        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return ScriptBytecodeAdapter.compareLessThan((Object)callSiteArray[504].call(System.class), (Object)callSiteArray[505].call(callSiteArray[506].callGetProperty((Object)cacheTime), (Object)ms));
        }
        return ScriptBytecodeAdapter.compareLessThan((Object)callSiteArray[507].call(System.class), (Object)callSiteArray[508].call(callSiteArray[509].callGetProperty((Object)cacheTime), (Object)ms));
    }

    public boolean isResultCacheItemAllowedRetry(Map previous) {
        CallSite[] callSiteArray = LogFileStorageService.$getCallSiteArray();
        if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            int retryCount = DefaultTypeTransformation.intUnbox((Object)callSiteArray[510].callCurrent((GroovyObject)this));
            return ScriptBytecodeAdapter.compareLessThan((Object)callSiteArray[511].callGetProperty((Object)previous), (Object)retryCount);
        }
        int retryCount = this.getConfiguredRetrievalRetryCount();
        return ScriptBytecodeAdapter.compareLessThan((Object)callSiteArray[512].callGetProperty((Object)previous), (Object)retryCount);
    }

    private void storeLogFileAsync(String id, ExecutionFileStorage storage, LogFileStorageRequest executionLogStorage, int delay) {
        CallSite[] callSiteArray = LogFileStorageService.$getCallSiteArray();
        callSiteArray[513].callCurrent((GroovyObject)this, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"id", id, "storage", storage, "filetype", callSiteArray[514].callGroovyObjectGetProperty((Object)executionLogStorage), "request", executionLogStorage, "requestId", callSiteArray[515].callGroovyObjectGetProperty((Object)executionLogStorage)}), (Object)delay);
    }

    private void queueLogStorageRequest(Map task, int delay) {
        Reference task2 = new Reference((Object)task);
        CallSite[] callSiteArray = LogFileStorageService.$getCallSiteArray();
        if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (delay >= 0) {
                callSiteArray[516].callSafe(callSiteArray[517].callGroovyObjectGetProperty((Object)this));
                callSiteArray[518].callSafe(callSiteArray[519].callGroovyObjectGetProperty((Object)this));
            }
            if (delay > 0) {
                callSiteArray[520].call((Object)this.scheduledExecutor, (Object)new /* Unavailable Anonymous Inner Class!! */, (Object)delay, callSiteArray[521].callGetProperty(TimeUnit.class));
            } else {
                callSiteArray[522].call((Object)this.storageRequests, (Object)((Map)task2.get()));
            }
        } else {
            if (delay >= 0) {
                callSiteArray[523].callSafe(callSiteArray[524].callGroovyObjectGetProperty((Object)this));
                callSiteArray[525].callSafe(callSiteArray[526].callGroovyObjectGetProperty((Object)this));
            }
            if (delay > 0) {
                callSiteArray[527].call((Object)this.scheduledExecutor, (Object)new /* Unavailable Anonymous Inner Class!! */, (Object)delay, callSiteArray[528].callGetProperty(TimeUnit.class));
            } else {
                callSiteArray[529].call((Object)this.storageRequests, (Object)((Map)task2.get()));
            }
        }
    }

    public boolean areAllExecutionFilesPresent(Execution execution) {
        CallSite[] callSiteArray = LogFileStorageService.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object bean = null;
            Iterator iterator = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[530].call(callSiteArray[531].callCurrent((GroovyObject)this)), Iterator.class);
            while (iterator.hasNext()) {
                bean = iterator.next();
                if (!(!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[532].call(bean))) || !(!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[533].call(callSiteArray[534].callGetProperty(callSiteArray[535].call(bean, (Object)execution)))))) continue;
                return false;
            }
        } else {
            Object bean = null;
            Iterator iterator = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[536].call((Object)this.listExecutionFileProducers()), Iterator.class);
            while (iterator.hasNext()) {
                bean = iterator.next();
                if (!(!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[537].call(bean))) || !(!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[538].call(callSiteArray[539].callGetProperty(callSiteArray[540].call(bean, (Object)execution)))))) continue;
                return false;
            }
        }
        return true;
    }

    public Map<String, ExecutionFile> getExecutionFiles(Execution execution, List<String> filters) {
        Reference execution2 = new Reference((Object)execution);
        CallSite[] callSiteArray = LogFileStorageService.$getCallSiteArray();
        Collection beans = (Collection)ScriptBytecodeAdapter.castToType((Object)callSiteArray[541].callCurrent((GroovyObject)this, filters), Collection.class);
        Reference result = new Reference((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[0]));
        callSiteArray[542].callSafe((Object)beans, (Object)new /* Unavailable Anonymous Inner Class!! */);
        callSiteArray[543].call((Object)log, (Object)new GStringImpl(new Object[]{result.get()}, new String[]{"found beans of ExecutionFileProducer result: ", ""}));
        Object object = result.get();
        return (Map)ScriptBytecodeAdapter.castToType((Object)(DefaultTypeTransformation.booleanUnbox((Object)object) ? object : ScriptBytecodeAdapter.createMap((Object[])new Object[0])), Map.class);
    }

    private Collection<ExecutionFileProducer> listExecutionFileProducers(List<String> filters) {
        Reference filters2 = new Reference(filters);
        CallSite[] callSiteArray = LogFileStorageService.$getCallSiteArray();
        Object type = callSiteArray[544].call((Object)this.applicationContext, ExecutionFileProducer.class);
        Object all = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[545].callSafe(type, (Object)new /* Unavailable Anonymous Inner Class!! */)) ? callSiteArray[546].callSafe(type, (Object)new /* Unavailable Anonymous Inner Class!! */) : type;
        Object beans = callSiteArray[547].callSafe(all);
        if (DefaultTypeTransformation.booleanUnbox((Object)((List)filters2.get()))) {
            Object object;
            beans = object = callSiteArray[548].call(beans, (Object)new /* Unavailable Anonymous Inner Class!! */);
        }
        return (Collection)ScriptBytecodeAdapter.castToType((Object)beans, Collection.class);
    }

    private Object deleteExecutionFilePerPolicy(ExecutionFile file, boolean canRetrieve) {
        CallSite[] callSiteArray = LogFileStorageService.$getCallSiteArray();
        return callSiteArray[549].call(ExecutionFileUtil.class, (Object)file, (Object)canRetrieve);
    }

    /*
     * WARNING - void declaration
     */
    private List storeLogFiles(List<String> filter, ExecutionFileStorage storage, String ident, Map<String, ExecutionFile> files) {
        void var3_3;
        Reference storage2 = new Reference((Object)storage);
        Reference ident2 = new Reference((Object)var3_3);
        Reference files2 = new Reference(files);
        CallSite[] callSiteArray = LogFileStorageService.$getCallSiteArray();
        callSiteArray[550].call((Object)log, (Object)new GStringImpl(new Object[]{(String)ident2.get(), filter}, new String[]{"Storage request [ID#", "], start, type ", ""}));
        Boolean success = false;
        if (DefaultTypeTransformation.booleanUnbox(filter)) {
            Object object = callSiteArray[551].call((Object)((Map)files2.get()), callSiteArray[552].call(filter, (Object)new /* Unavailable Anonymous Inner Class!! */));
            files2.set((Object)((Map)ScriptBytecodeAdapter.castToType((Object)object, Map.class)));
        }
        Reference list = new Reference((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[0]));
        Reference deletions = new Reference((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]));
        if ((ExecutionFileStorage)storage2.get() instanceof ExecutionMultiFileStorage) {
            Object object = callSiteArray[553].callCurrent((GroovyObject)this, (Object)((Map)files2.get()), (Object)((ExecutionFileStorage)storage2.get()), (Object)((String)ident2.get()));
            list.set(object);
        } else {
            callSiteArray[554].call((Object)((Map)files2.get()), (Object)new /* Unavailable Anonymous Inner Class!! */);
        }
        if (!DefaultTypeTransformation.booleanUnbox((Object)list.get())) {
            boolean bl = true;
            success = bl;
        }
        callSiteArray[555].call(callSiteArray[556].call((Object)((Map)files2.get())), (Object)new /* Unavailable Anonymous Inner Class!! */);
        Reference canRetrieve = new Reference((Object)((Boolean)ScriptBytecodeAdapter.castToType((Object)callSiteArray[557].callCurrent((GroovyObject)this, (Object)((ExecutionFileStorage)storage2.get())), Boolean.class)));
        callSiteArray[558].call((Object)((List)deletions.get()), (Object)new /* Unavailable Anonymous Inner Class!! */);
        callSiteArray[559].call((Object)log, (Object)new GStringImpl(new Object[]{(String)ident2.get(), success}, new String[]{"Storage request [ID#", "], finish: ", ""}));
        return ScriptBytecodeAdapter.createList((Object[])new Object[]{success, list.get()});
    }

    private Map<String, String> storeMultiLogFiles(Map<String, ExecutionFile> files, ExecutionMultiFileStorage storage, String ident) {
        CallSite[] callSiteArray = LogFileStorageService.$getCallSiteArray();
        callSiteArray[560].call((Object)log, (Object)new GStringImpl(new Object[]{ident}, new String[]{"Storage request storeMultiLogFiles [ID#", "], start"}));
        Reference failures = new Reference((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[0]));
        Map localfiles = (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[561].call(files, (Object)new /* Unavailable Anonymous Inner Class!! */), Map.class);
        Reference request = new Reference(callSiteArray[562].callConstructor(MultiFileStorageRequestImpl.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"files", localfiles})));
        callSiteArray[563].call((Object)storage, request.get());
        callSiteArray[564].call(callSiteArray[565].call(files), (Object)new /* Unavailable Anonymous Inner Class!! */);
        return (Map)failures.get();
    }

    /*
     * WARNING - void declaration
     */
    private Object storeSingleLogFile(File file, String filetype, ExecutionFileStorage storage, String ident) {
        void var3_3;
        Reference filetype2 = new Reference((Object)filetype);
        Reference storage2 = new Reference((Object)var3_3);
        CallSite[] callSiteArray = LogFileStorageService.$getCallSiteArray();
        callSiteArray[566].call((Object)log, (Object)new GStringImpl(new Object[]{ident}, new String[]{"Storage request [ID#", "], start"}));
        Reference success = new Reference((Object)false);
        Reference message = new Reference(null);
        Reference lastModified = new Reference((Object)((Date)ScriptBytecodeAdapter.castToType((Object)callSiteArray[567].callConstructor(Date.class, callSiteArray[568].call((Object)file)), Date.class)));
        Reference length = new Reference((Object)((Long)ScriptBytecodeAdapter.castToType((Object)callSiteArray[569].call((Object)file), Long.class)));
        try {
            callSiteArray[570].call((Object)file, (Object)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (Throwable e) {
            callSiteArray[571].call((Object)log, (Object)new GStringImpl(new Object[]{ident, callSiteArray[572].callGetProperty((Object)e)}, new String[]{"Storage request [ID#", "] error: ", ""}));
            callSiteArray[573].call((Object)log, (Object)new GStringImpl(new Object[]{ident, callSiteArray[574].callGetProperty((Object)e)}, new String[]{"Storage request [ID#", "] error: ", ""}), (Object)e);
            Object object = callSiteArray[575].callGetProperty((Object)e);
            message.set((Object)ShortTypeHandling.castToString((Object)object));
        }
        callSiteArray[576].call((Object)log, (Object)new GStringImpl(new Object[]{ident, success.get()}, new String[]{"Storage request [ID#", "], finish: ", ""}));
        return ScriptBytecodeAdapter.createList((Object[])new Object[]{success.get(), (String)message.get()});
    }

    /*
     * WARNING - void declaration
     */
    private Map retrieveLogFile(File file, String filetype, ExecutionFileStorage storage, String ident) {
        void var3_3;
        Reference filetype2 = new Reference((Object)filetype);
        Reference storage2 = new Reference((Object)var3_3);
        CallSite[] callSiteArray = LogFileStorageService.$getCallSiteArray();
        Object tempfile = callSiteArray[577].call(File.class, (Object)"temp-storage", (Object)"logfile");
        callSiteArray[578].call(tempfile);
        Boolean success = false;
        Reference psuccess = new Reference((Object)false);
        Reference errorMessage = new Reference(null);
        try {
            callSiteArray[579].call(tempfile, (Object)new /* Unavailable Anonymous Inner Class!! */);
            if (DefaultTypeTransformation.booleanUnbox((Object)psuccess.get())) {
                if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[580].call(callSiteArray[581].call((Object)file))) && !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[582].call(callSiteArray[583].call((Object)file)))) {
                    GStringImpl gStringImpl = new GStringImpl(new Object[]{file}, new String[]{"Failed to create directories for file: ", ""});
                    errorMessage.set((Object)gStringImpl);
                }
                if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[584].call(tempfile, (Object)file))) {
                    GStringImpl gStringImpl = new GStringImpl(new Object[]{file}, new String[]{"Failed to move temp file to location: ", ""});
                    errorMessage.set((Object)gStringImpl);
                } else {
                    boolean bl = true;
                    success = bl;
                }
            }
            callSiteArray[585].call((Object)log, (Object)new GStringImpl(new Object[]{ident, success, errorMessage.get()}, new String[]{"Retrieval request [ID#", "], result: ", ", error? ", ""}));
        }
        catch (Throwable t) {
            GStringImpl gStringImpl = new GStringImpl(new Object[]{callSiteArray[586].callGetProperty((Object)t)}, new String[]{"Failed retrieve log file: ", ""});
            errorMessage.set((Object)gStringImpl);
            callSiteArray[587].call((Object)log, (Object)new GStringImpl(new Object[]{ident, callSiteArray[588].callGetProperty((Object)t)}, new String[]{"Retrieval request [ID#", "]: Failed retrieve log file: ", ""}), (Object)t);
        }
        if (!DefaultTypeTransformation.booleanUnbox((Object)success)) {
            callSiteArray[589].call((Object)log, (Object)new GStringImpl(new Object[]{ident, errorMessage.get()}, new String[]{"Retrieval request [ID#", "] error: ", ""}));
            callSiteArray[590].call(tempfile);
        }
        return ScriptBytecodeAdapter.createMap((Object[])new Object[]{"success", success, "error", errorMessage.get()});
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != LogFileStorageService.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
        CallSite[] callSiteArray = LogFileStorageService.$getCallSiteArray();
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(LogFileStorageService.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$1(String name, Object value) {
        CallSite[] callSiteArray = LogFileStorageService.$getCallSiteArray();
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, LogFileStorageService.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$1(String name) {
        CallSite[] callSiteArray = LogFileStorageService.$getCallSiteArray();
        return ScriptBytecodeAdapter.getGroovyObjectProperty(LogFileStorageService.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public StreamingLogWriter getLogFileWriterForExecution(Execution e, Map<String, String> defaultMeta) {
        CallSite[] callSiteArray = LogFileStorageService.$getCallSiteArray();
        return this.getLogFileWriterForExecution(e, defaultMeta, null);
    }

    public void resumeIncompleteLogStorageAsync(String serverUUID) {
        Reference serverUUID2 = new Reference((Object)serverUUID);
        CallSite[] callSiteArray = LogFileStorageService.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            this.resumeIncompleteLogStorageAsync((String)serverUUID2.get(), null);
        } else {
            this.resumeIncompleteLogStorageAsync((String)serverUUID2.get(), null);
        }
    }

    public void resumeIncompleteLogStoragePeriodic(String serverUUID) {
        CallSite[] callSiteArray = LogFileStorageService.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            this.resumeIncompleteLogStoragePeriodic(serverUUID, null);
        } else {
            this.resumeIncompleteLogStoragePeriodic(serverUUID, null);
        }
    }

    public void resumeIncompleteLogStorage(String serverUUID) {
        CallSite[] callSiteArray = LogFileStorageService.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            this.resumeIncompleteLogStorage(serverUUID, null);
        } else {
            this.resumeIncompleteLogStorage(serverUUID, null);
        }
    }

    public int cleanupIncompleteLogStorage(String serverUUID) {
        CallSite[] callSiteArray = LogFileStorageService.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return this.cleanupIncompleteLogStorage(serverUUID, null);
        }
        return this.cleanupIncompleteLogStorage(serverUUID, null);
    }

    public int resumeIncompleteLogStorageDelayed(String serverUUID) {
        CallSite[] callSiteArray = LogFileStorageService.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return this.resumeIncompleteLogStorageDelayed(serverUUID, null);
        }
        return this.resumeIncompleteLogStorageDelayed(serverUUID, null);
    }

    public List<LogFileStorageRequest> listIncompleteRequests(String serverUUID) {
        Reference serverUUID2 = new Reference((Object)serverUUID);
        CallSite[] callSiteArray = LogFileStorageService.$getCallSiteArray();
        return this.listIncompleteRequests((String)serverUUID2.get(), ScriptBytecodeAdapter.createMap((Object[])new Object[0]));
    }

    public List<Execution> listExecutionsWithoutStorageRequests(String serverUUID) {
        Reference serverUUID2 = new Reference((Object)serverUUID);
        CallSite[] callSiteArray = LogFileStorageService.$getCallSiteArray();
        return this.listExecutionsWithoutStorageRequests((String)serverUUID2.get(), ScriptBytecodeAdapter.createMap((Object[])new Object[0]));
    }

    public Map cacheRetrievalState(String key, LogFileState state, int count, String error, String errorCode) {
        CallSite[] callSiteArray = LogFileStorageService.$getCallSiteArray();
        return this.cacheRetrievalState(key, state, count, error, errorCode, null);
    }

    public Map cacheRetrievalState(String key, LogFileState state, int count, String error) {
        CallSite[] callSiteArray = LogFileStorageService.$getCallSiteArray();
        return this.cacheRetrievalState(key, state, count, error, null, null);
    }

    public Map cacheRetrievalState(String key, LogFileState state, int count) {
        CallSite[] callSiteArray = LogFileStorageService.$getCallSiteArray();
        return this.cacheRetrievalState(key, state, count, null, null, null);
    }

    public ExecutionLogReader requestLogFileReader(Execution e, String filetype) {
        CallSite[] callSiteArray = LogFileStorageService.$getCallSiteArray();
        return this.requestLogFileReader(e, filetype, true);
    }

    private void storeLogFileAsync(String id, ExecutionFileStorage storage, LogFileStorageRequest executionLogStorage) {
        CallSite[] callSiteArray = LogFileStorageService.$getCallSiteArray();
        this.storeLogFileAsync(id, storage, executionLogStorage, 0);
    }

    private void queueLogStorageRequest(Map task) {
        Reference task2 = new Reference((Object)task);
        CallSite[] callSiteArray = LogFileStorageService.$getCallSiteArray();
        this.queueLogStorageRequest((Map)task2.get(), 0);
    }

    private Collection<ExecutionFileProducer> listExecutionFileProducers() {
        CallSite[] callSiteArray = LogFileStorageService.$getCallSiteArray();
        return this.listExecutionFileProducers(null);
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    public static /* synthetic */ void __$swapInit() {
        CallSite[] callSiteArray = LogFileStorageService.$getCallSiteArray();
        $callSiteArray = null;
    }

    static {
        LogFileStorageService.__$swapInit();
        Long l = 0L;
        __timeStamp__239_neverHappen1461970102463 = l;
        Long l2 = 1461970102463L;
        __timeStamp = l2;
        boolean bl = false;
        transactional = bl;
        Object object = LogFileStorageService.$getCallSiteArray()[591].callConstructor(RundeckLogFormat.class);
        rundeckLogFormat = (RundeckLogFormat)ScriptBytecodeAdapter.castToType((Object)object, RundeckLogFormat.class);
        Object object2 = LogFileStorageService.$getCallSiteArray()[592].call(LogFactory.class, (Object)"grails.app.services.rundeck.services.LogFileStorageService");
        log = (Log)ScriptBytecodeAdapter.castToType((Object)object2, Log.class);
    }

    public static Object getTransactional() {
        return transactional;
    }

    public static void setTransactional(Object object) {
        transactional = object;
    }

    public static final RundeckLogFormat getRundeckLogFormat() {
        return rundeckLogFormat;
    }

    public ExecutionFileStoragePluginProviderService getExecutionFileStoragePluginProviderService() {
        return this.executionFileStoragePluginProviderService;
    }

    public void setExecutionFileStoragePluginProviderService(ExecutionFileStoragePluginProviderService executionFileStoragePluginProviderService) {
        this.executionFileStoragePluginProviderService = executionFileStoragePluginProviderService;
    }

    public PluginService getPluginService() {
        return this.pluginService;
    }

    public void setPluginService(PluginService pluginService) {
        this.pluginService = pluginService;
    }

    public Object getFrameworkService() {
        return this.frameworkService;
    }

    public void setFrameworkService(Object object) {
        this.frameworkService = object;
    }

    public AsyncTaskExecutor getLogFileTaskExecutor() {
        return this.logFileTaskExecutor;
    }

    public void setLogFileTaskExecutor(AsyncTaskExecutor asyncTaskExecutor) {
        this.logFileTaskExecutor = asyncTaskExecutor;
    }

    public Object getExecutorService() {
        return this.executorService;
    }

    public void setExecutorService(Object object) {
        this.executorService = object;
    }

    public Object getGrailsApplication() {
        return this.grailsApplication;
    }

    public void setGrailsApplication(Object object) {
        this.grailsApplication = object;
    }

    public Object getGrailsLinkGenerator() {
        return this.grailsLinkGenerator;
    }

    public void setGrailsLinkGenerator(Object object) {
        this.grailsLinkGenerator = object;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public Object getMetricService() {
        return this.metricService;
    }

    public void setMetricService(Object object) {
        this.metricService = object;
    }

    public Object getConfigurationService() {
        return this.configurationService;
    }

    public void setConfigurationService(Object object) {
        this.configurationService = object;
    }

    public ScheduledExecutorService getScheduledExecutor() {
        return this.scheduledExecutor;
    }

    public void setScheduledExecutor(ScheduledExecutorService scheduledExecutorService) {
        this.scheduledExecutor = scheduledExecutorService;
    }

    public /* synthetic */ String this$2$getConfiguredResumeStrategy() {
        return this.getConfiguredResumeStrategy();
    }

    public /* synthetic */ void this$2$runRetrievalRequest(Map map) {
        this.runRetrievalRequest(map);
    }

    public /* synthetic */ LogFileStorageRequest this$2$createStorageRequest(Execution execution, String string) {
        return this.createStorageRequest(execution, string);
    }

    public /* synthetic */ Map this$2$getLogFileState(Execution execution, String string, ExecutionFileStoragePlugin executionFileStoragePlugin) {
        return this.getLogFileState(execution, string, executionFileStoragePlugin);
    }

    public /* synthetic */ ExecutionFileStoragePlugin this$2$getConfiguredPluginForExecution(Execution execution, PropertyResolver propertyResolver) {
        return this.getConfiguredPluginForExecution(execution, propertyResolver);
    }

    public /* synthetic */ ExecutionFileStoragePlugin this$2$getConfiguredPlugin(Map map, PropertyResolver propertyResolver) {
        return this.getConfiguredPlugin(map, propertyResolver);
    }

    public /* synthetic */ ExecutionLogState this$2$logFileRetrievalRequestState(Execution execution, String string) {
        return this.logFileRetrievalRequestState(execution, string);
    }

    public /* synthetic */ ExecutionLogState this$2$requestLogFileRetrieval(Execution execution, String string, ExecutionFileStorage executionFileStorage) {
        return this.requestLogFileRetrieval(execution, string, executionFileStorage);
    }

    public /* synthetic */ void this$2$storeLogFileAsync(String string, ExecutionFileStorage executionFileStorage, LogFileStorageRequest logFileStorageRequest, int n) {
        this.storeLogFileAsync(string, executionFileStorage, logFileStorageRequest, n);
    }

    public /* synthetic */ void this$2$queueLogStorageRequest(Map map, int n) {
        this.queueLogStorageRequest(map, n);
    }

    public /* synthetic */ Collection this$2$listExecutionFileProducers(List list) {
        return this.listExecutionFileProducers(list);
    }

    public /* synthetic */ Object this$2$deleteExecutionFilePerPolicy(ExecutionFile executionFile, boolean bl) {
        return this.deleteExecutionFilePerPolicy(executionFile, bl);
    }

    public /* synthetic */ List this$2$storeLogFiles(List list, ExecutionFileStorage executionFileStorage, String string, Map map) {
        return this.storeLogFiles(list, executionFileStorage, string, map);
    }

    public /* synthetic */ Map this$2$storeMultiLogFiles(Map map, ExecutionMultiFileStorage executionMultiFileStorage, String string) {
        return this.storeMultiLogFiles(map, executionMultiFileStorage, string);
    }

    public /* synthetic */ Object this$2$storeSingleLogFile(File file, String string, ExecutionFileStorage executionFileStorage, String string2) {
        return this.storeSingleLogFile(file, string, executionFileStorage, string2);
    }

    public /* synthetic */ Map this$2$retrieveLogFile(File file, String string, ExecutionFileStorage executionFileStorage, String string2) {
        return this.retrieveLogFile(file, string, executionFileStorage, string2);
    }

    public /* synthetic */ void this$2$storeLogFileAsync(String string, ExecutionFileStorage executionFileStorage, LogFileStorageRequest logFileStorageRequest) {
        this.storeLogFileAsync(string, executionFileStorage, logFileStorageRequest);
    }

    public /* synthetic */ void this$2$queueLogStorageRequest(Map map) {
        this.queueLogStorageRequest(map);
    }

    public /* synthetic */ Collection this$2$listExecutionFileProducers() {
        return this.listExecutionFileProducers();
    }

    public /* synthetic */ void super$1$wait() {
        super.wait();
    }

    public /* synthetic */ String super$1$toString() {
        return super.toString();
    }

    public /* synthetic */ void super$1$wait(long l) {
        super.wait(l);
    }

    public /* synthetic */ void super$1$wait(long l, int n) {
        super.wait(l, n);
    }

    public /* synthetic */ void super$1$notify() {
        super.notify();
    }

    public /* synthetic */ void super$1$notifyAll() {
        super.notifyAll();
    }

    public /* synthetic */ Class super$1$getClass() {
        return super.getClass();
    }

    public /* synthetic */ Object super$1$clone() {
        return super.clone();
    }

    public /* synthetic */ boolean super$1$equals(Object object) {
        return super.equals(object);
    }

    public /* synthetic */ int super$1$hashCode() {
        return super.hashCode();
    }

    public /* synthetic */ void super$1$finalize() {
        super.finalize();
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "newScheduledThreadPool";
        stringArray[1] = "<$constructor$>";
        stringArray[2] = "<$constructor$>";
        stringArray[3] = "<$constructor$>";
        stringArray[4] = "<$constructor$>";
        stringArray[5] = "<$constructor$>";
        stringArray[6] = "<$constructor$>";
        stringArray[7] = "<$constructor$>";
        stringArray[8] = "<$constructor$>";
        stringArray[9] = "getConfiguredPluginName";
        stringArray[10] = "execute";
        stringArray[11] = "<$constructor$>";
        stringArray[12] = "execute";
        stringArray[13] = "<$constructor$>";
        stringArray[14] = "getConfiguredResumeStrategy";
        stringArray[15] = "getConfiguredStorageRetryDelay";
        stringArray[16] = "scheduleAtFixedRate";
        stringArray[17] = "SECONDS";
        stringArray[18] = "scheduleAtFixedRate";
        stringArray[19] = "SECONDS";
        stringArray[20] = "getString";
        stringArray[21] = "counter";
        stringArray[22] = "plus";
        stringArray[23] = "name";
        stringArray[24] = "class";
        stringArray[25] = "counter";
        stringArray[26] = "plus";
        stringArray[27] = "name";
        stringArray[28] = "class";
        stringArray[29] = "counter";
        stringArray[30] = "plus";
        stringArray[31] = "name";
        stringArray[32] = "class";
        stringArray[33] = "counter";
        stringArray[34] = "plus";
        stringArray[35] = "name";
        stringArray[36] = "class";
        stringArray[37] = "<$constructor$>";
        stringArray[38] = "<$constructor$>";
        stringArray[39] = "<$constructor$>";
        stringArray[40] = "<$constructor$>";
        stringArray[41] = "listPlugins";
        stringArray[42] = "getConfiguredStorageRetryCount";
        stringArray[43] = "getConfiguredStorageRetryDelay";
        stringArray[44] = "leftShift";
        stringArray[45] = "count";
        stringArray[46] = "next";
        stringArray[47] = "debug";
        stringArray[48] = "id";
        stringArray[49] = "filetype";
        stringArray[50] = "split";
        stringArray[51] = "split";
        stringArray[52] = "withNewSession";
        stringArray[53] = "debug";
        stringArray[54] = "id";
        stringArray[55] = "remove";
        stringArray[56] = "queueLogStorageRequest";
        stringArray[57] = "inc";
        stringArray[58] = "getStorageFailedCounter";
        stringArray[59] = "getConfiguredStorageFailureCancel";
        stringArray[60] = "error";
        stringArray[61] = "id";
        stringArray[62] = "execute";
        stringArray[63] = "error";
        stringArray[64] = "id";
        stringArray[65] = "remove";
        stringArray[66] = "add";
        stringArray[67] = "requestId";
        stringArray[68] = "remove";
        stringArray[69] = "requestId";
        stringArray[70] = "remove";
        stringArray[71] = "requestId";
        stringArray[72] = "execute";
        stringArray[73] = "debug";
        stringArray[74] = "id";
        stringArray[75] = "remove";
        stringArray[76] = "queueLogStorageRequest";
        stringArray[77] = "inc";
        stringArray[78] = "error";
        stringArray[79] = "id";
        stringArray[80] = "execute";
        stringArray[81] = "error";
        stringArray[82] = "id";
        stringArray[83] = "remove";
        stringArray[84] = "add";
        stringArray[85] = "requestId";
        stringArray[86] = "remove";
        stringArray[87] = "requestId";
        stringArray[88] = "remove";
        stringArray[89] = "requestId";
        stringArray[90] = "execute";
        stringArray[91] = "execute";
        stringArray[92] = "storageRetryCount";
        stringArray[93] = "fileStorage";
        stringArray[94] = "logs";
        stringArray[95] = "execution";
        stringArray[96] = "rundeck";
        stringArray[97] = "config";
        stringArray[98] = "toInteger";
        stringArray[99] = "storageRetryDelay";
        stringArray[100] = "fileStorage";
        stringArray[101] = "logs";
        stringArray[102] = "execution";
        stringArray[103] = "rundeck";
        stringArray[104] = "config";
        stringArray[105] = "toInteger";
        stringArray[106] = "getBoolean";
        stringArray[107] = "retrievalRetryCount";
        stringArray[108] = "fileStorage";
        stringArray[109] = "logs";
        stringArray[110] = "execution";
        stringArray[111] = "rundeck";
        stringArray[112] = "config";
        stringArray[113] = "toInteger";
        stringArray[114] = "retrievalRetryDelay";
        stringArray[115] = "fileStorage";
        stringArray[116] = "logs";
        stringArray[117] = "execution";
        stringArray[118] = "rundeck";
        stringArray[119] = "config";
        stringArray[120] = "toInteger";
        stringArray[121] = "remotePendingDelay";
        stringArray[122] = "fileStorage";
        stringArray[123] = "logs";
        stringArray[124] = "execution";
        stringArray[125] = "rundeck";
        stringArray[126] = "config";
        stringArray[127] = "toInteger";
        stringArray[128] = "getString";
        stringArray[129] = "LOG_FILE_FILETYPE";
        stringArray[130] = "getFileForExecutionFiletype";
        stringArray[131] = "isDirectory";
        stringArray[132] = "getParentFile";
        stringArray[133] = "mkdirs";
        stringArray[134] = "getParentFile";
        stringArray[135] = "<$constructor$>";
        stringArray[136] = "plus";
        stringArray[137] = "<$constructor$>";
        stringArray[138] = "<$constructor$>";
        stringArray[139] = "watch";
        stringArray[140] = "watch";
        stringArray[141] = "getConfiguredPluginForExecution";
        stringArray[142] = "getFrameworkPropertyResolver";
        stringArray[143] = "project";
        stringArray[144] = "pluginSupportsStorage";
        stringArray[145] = "pluginSupportsStorage";
        stringArray[146] = "createStorageRequest";
        stringArray[147] = "discard";
        stringArray[148] = "plus";
        stringArray[149] = "plus";
        stringArray[150] = "toString";
        stringArray[151] = "id";
        stringArray[152] = "execution";
        stringArray[153] = "filetype";
        stringArray[154] = "storeLogFileAsync";
        stringArray[155] = "<$constructor$>";
        stringArray[156] = "getConfiguredPluginName";
        stringArray[157] = "<$constructor$>";
        stringArray[158] = "save";
        stringArray[159] = "countMissingLogStorageExecutions";
        stringArray[160] = "countIncompleteLogStorageRequests";
        stringArray[161] = "count";
        stringArray[162] = "storageQueueCounter";
        stringArray[163] = "count";
        stringArray[164] = "storageFailedCounter";
        stringArray[165] = "count";
        stringArray[166] = "storageSuccessCounter";
        stringArray[167] = "count";
        stringArray[168] = "storageTotalCounter";
        stringArray[169] = "minus";
        stringArray[170] = "getConfiguredPluginName";
        stringArray[171] = "countExecutionsWithoutStorageRequests";
        stringArray[172] = "serverUUID";
        stringArray[173] = "execute";
        stringArray[174] = "poll";
        stringArray[175] = "SECONDS";
        stringArray[176] = "debug";
        stringArray[177] = "withNewSession";
        stringArray[178] = "unmodifiableSet";
        stringArray[179] = "<$constructor$>";
        stringArray[180] = "unmodifiableSet";
        stringArray[181] = "unmodifiableList";
        stringArray[182] = "getAt";
        stringArray[183] = "listIncompleteRequests";
        stringArray[184] = "get";
        stringArray[185] = "serverNodeUUID";
        stringArray[186] = "execution";
        stringArray[187] = "get";
        stringArray[188] = "serverNodeUUID";
        stringArray[189] = "execution";
        stringArray[190] = "each";
        stringArray[191] = "getConfiguredResumeStrategy";
        stringArray[192] = "resumeIncompleteLogStorageDelayed";
        stringArray[193] = "resumeIncompleteLogStoragePeriodic";
        stringArray[194] = "getConfiguredResumeStrategy";
        stringArray[195] = "<$constructor$>";
        stringArray[196] = "size";
        stringArray[197] = "clear";
        stringArray[198] = "dec";
        stringArray[199] = "storageQueueCounter";
        stringArray[200] = "<$constructor$>";
        stringArray[201] = "size";
        stringArray[202] = "clear";
        stringArray[203] = "dec";
        stringArray[204] = "storageQueueCounter";
        stringArray[205] = "listIncompleteRequests";
        stringArray[206] = "get";
        stringArray[207] = "serverNodeUUID";
        stringArray[208] = "execution";
        stringArray[209] = "get";
        stringArray[210] = "serverNodeUUID";
        stringArray[211] = "execution";
        stringArray[212] = "findAll";
        stringArray[213] = "each";
        stringArray[214] = "size";
        stringArray[215] = "listIncompleteRequests";
        stringArray[216] = "get";
        stringArray[217] = "serverNodeUUID";
        stringArray[218] = "execution";
        stringArray[219] = "get";
        stringArray[220] = "serverNodeUUID";
        stringArray[221] = "execution";
        stringArray[222] = "info";
        stringArray[223] = "size";
        stringArray[224] = "getConfiguredStorageRetryDelay";
        stringArray[225] = "each";
        stringArray[226] = "info";
        stringArray[227] = "serverUUID";
        stringArray[228] = "get";
        stringArray[229] = "createCriteria";
        stringArray[230] = "withCriteria";
        stringArray[231] = "get";
        stringArray[232] = "createCriteria";
        stringArray[233] = "list";
        stringArray[234] = "createCriteria";
        stringArray[235] = "find";
        stringArray[236] = "getCurrentStorageRequests";
        stringArray[237] = "find";
        stringArray[238] = "getCurrentRequests";
        stringArray[239] = "find";
        stringArray[240] = "find";
        stringArray[241] = "outputfilepath";
        stringArray[242] = "replaceAll";
        stringArray[243] = "outputfilepath";
        stringArray[244] = "<$constructor$>";
        stringArray[245] = "plus";
        stringArray[246] = "plus";
        stringArray[247] = "getFileForLocalPath";
        stringArray[248] = "generateLocalPathForExecutionFile";
        stringArray[249] = "outputfilepath";
        stringArray[250] = "replaceAll";
        stringArray[251] = "outputfilepath";
        stringArray[252] = "<$constructor$>";
        stringArray[253] = "plus";
        stringArray[254] = "plus";
        stringArray[255] = "getFileForLocalPath";
        stringArray[256] = "generateLocalPathForExecutionFile";
        stringArray[257] = "scheduledExecution";
        stringArray[258] = "plus";
        stringArray[259] = "project";
        stringArray[260] = "extid";
        stringArray[261] = "scheduledExecution";
        stringArray[262] = "id";
        stringArray[263] = "plus";
        stringArray[264] = "project";
        stringArray[265] = "id";
        stringArray[266] = "getFrameworkProperties";
        stringArray[267] = "getProperty";
        stringArray[268] = "<$constructor$>";
        stringArray[269] = "<$constructor$>";
        stringArray[270] = "<$constructor$>";
        stringArray[271] = "exists";
        stringArray[272] = "<$constructor$>";
        stringArray[273] = "plus";
        stringArray[274] = "<$constructor$>";
        stringArray[275] = "getFileForExecutionFiletype";
        stringArray[276] = "logFileRetrievalKey";
        stringArray[277] = "exists";
        stringArray[278] = "AVAILABLE";
        stringArray[279] = "NOT_FOUND";
        stringArray[280] = "exists";
        stringArray[281] = "AVAILABLE";
        stringArray[282] = "NOT_FOUND";
        stringArray[283] = "AVAILABLE";
        stringArray[284] = "AVAILABLE";
        stringArray[285] = "AVAILABLE";
        stringArray[286] = "AVAILABLE";
        stringArray[287] = "PENDING_REMOTE";
        stringArray[288] = "convert";
        stringArray[289] = "MILLISECONDS";
        stringArray[290] = "getConfiguredRemotePendingDelay";
        stringArray[291] = "SECONDS";
        stringArray[292] = "convert";
        stringArray[293] = "MILLISECONDS";
        stringArray[294] = "SECONDS";
        stringArray[295] = "dateCompleted";
        stringArray[296] = "minus";
        stringArray[297] = "currentTimeMillis";
        stringArray[298] = "time";
        stringArray[299] = "dateCompleted";
        stringArray[300] = "NOT_FOUND";
        stringArray[301] = "dateCompleted";
        stringArray[302] = "minus";
        stringArray[303] = "currentTimeMillis";
        stringArray[304] = "time";
        stringArray[305] = "dateCompleted";
        stringArray[306] = "NOT_FOUND";
        stringArray[307] = "getRetrievalCacheResult";
        stringArray[308] = "state";
        stringArray[309] = "errorCode";
        stringArray[310] = "errorData";
        stringArray[311] = "forFileStates";
        stringArray[312] = "debug";
        stringArray[313] = "id";
        stringArray[314] = "state";
        stringArray[315] = "errorCode";
        stringArray[316] = "errorData";
        stringArray[317] = "forFileStates";
        stringArray[318] = "debug";
        stringArray[319] = "id";
        stringArray[320] = "logFileRetrievalRequestState";
        stringArray[321] = "debug";
        stringArray[322] = "id";
        stringArray[323] = "logFileRetrievalRequestState";
        stringArray[324] = "debug";
        stringArray[325] = "id";
        stringArray[326] = "pluginSupportsRetrieve";
        stringArray[327] = "isAvailable";
        stringArray[328] = "AVAILABLE";
        stringArray[329] = "NOT_FOUND";
        stringArray[330] = "getConfiguredPluginName";
        stringArray[331] = "error";
        stringArray[332] = "plus";
        stringArray[333] = "message";
        stringArray[334] = "debug";
        stringArray[335] = "plus";
        stringArray[336] = "message";
        stringArray[337] = "message";
        stringArray[338] = "ERROR";
        stringArray[339] = "AVAILABLE";
        stringArray[340] = "cacheRetrievalState";
        stringArray[341] = "pluginSupportsRetrieve";
        stringArray[342] = "isAvailable";
        stringArray[343] = "AVAILABLE";
        stringArray[344] = "NOT_FOUND";
        stringArray[345] = "error";
        stringArray[346] = "plus";
        stringArray[347] = "message";
        stringArray[348] = "debug";
        stringArray[349] = "plus";
        stringArray[350] = "message";
        stringArray[351] = "message";
        stringArray[352] = "ERROR";
        stringArray[353] = "AVAILABLE";
        stringArray[354] = "cacheRetrievalState";
        stringArray[355] = "forFileStates";
        stringArray[356] = "debug";
        stringArray[357] = "id";
        stringArray[358] = "retrieveSupported";
        stringArray[359] = "storeSupported";
        stringArray[360] = "get";
        stringArray[361] = "isResultCacheItemFresh";
        stringArray[362] = "debug";
        stringArray[363] = "isResultCacheItemAllowedRetry";
        stringArray[364] = "warn";
        stringArray[365] = "count";
        stringArray[366] = "warn";
        stringArray[367] = "isResultCacheItemFresh";
        stringArray[368] = "debug";
        stringArray[369] = "isResultCacheItemAllowedRetry";
        stringArray[370] = "warn";
        stringArray[371] = "count";
        stringArray[372] = "warn";
        stringArray[373] = "getConfiguredPluginName";
        stringArray[374] = "<$constructor$>";
        stringArray[375] = "put";
        stringArray[376] = "warn";
        stringArray[377] = "count";
        stringArray[378] = "debug";
        stringArray[379] = "warn";
        stringArray[380] = "count";
        stringArray[381] = "debug";
        stringArray[382] = "exportContextForExecution";
        stringArray[383] = "getConfiguredPlugin";
        stringArray[384] = "getConfiguredPluginName";
        stringArray[385] = "configurePlugin";
        stringArray[386] = "Instance";
        stringArray[387] = "error";
        stringArray[388] = "plus";
        stringArray[389] = "name";
        stringArray[390] = "class";
        stringArray[391] = "message";
        stringArray[392] = "debug";
        stringArray[393] = "plus";
        stringArray[394] = "name";
        stringArray[395] = "class";
        stringArray[396] = "message";
        stringArray[397] = "instance";
        stringArray[398] = "instance";
        stringArray[399] = "initialize";
        stringArray[400] = "error";
        stringArray[401] = "plus";
        stringArray[402] = "name";
        stringArray[403] = "class";
        stringArray[404] = "message";
        stringArray[405] = "debug";
        stringArray[406] = "plus";
        stringArray[407] = "name";
        stringArray[408] = "class";
        stringArray[409] = "message";
        stringArray[410] = "instance";
        stringArray[411] = "instance";
        stringArray[412] = "initialize";
        stringArray[413] = "error";
        stringArray[414] = "plus";
        stringArray[415] = "name";
        stringArray[416] = "class";
        stringArray[417] = "message";
        stringArray[418] = "debug";
        stringArray[419] = "plus";
        stringArray[420] = "name";
        stringArray[421] = "class";
        stringArray[422] = "message";
        stringArray[423] = "requestLogFileLoad";
        stringArray[424] = "file";
        stringArray[425] = "getLogReaderForFile";
        stringArray[426] = "file";
        stringArray[427] = "<$constructor$>";
        stringArray[428] = "state";
        stringArray[429] = "errorCode";
        stringArray[430] = "errorData";
        stringArray[431] = "dateCompleted";
        stringArray[432] = "dateStarted";
        stringArray[433] = "isClusterModeEnabled";
        stringArray[434] = "serverNodeUUID";
        stringArray[435] = "getServerUUID";
        stringArray[436] = "<$constructor$>";
        stringArray[437] = "PENDING_REMOTE";
        stringArray[438] = "outputfilepath";
        stringArray[439] = "<$constructor$>";
        stringArray[440] = "WAITING";
        stringArray[441] = "dateCompleted";
        stringArray[442] = "dateStarted";
        stringArray[443] = "isClusterModeEnabled";
        stringArray[444] = "serverNodeUUID";
        stringArray[445] = "getServerUUID";
        stringArray[446] = "<$constructor$>";
        stringArray[447] = "PENDING_REMOTE";
        stringArray[448] = "outputfilepath";
        stringArray[449] = "<$constructor$>";
        stringArray[450] = "WAITING";
        stringArray[451] = "getConfiguredPluginForExecution";
        stringArray[452] = "getFrameworkPropertyResolver";
        stringArray[453] = "project";
        stringArray[454] = "getLogFileState";
        stringArray[455] = "state";
        stringArray[456] = "AVAILABLE";
        stringArray[457] = "getFileForExecutionFiletype";
        stringArray[458] = "AVAILABLE_REMOTE";
        stringArray[459] = "requestLogFileRetrieval";
        stringArray[460] = "debug";
        stringArray[461] = "id";
        stringArray[462] = "<$constructor$>";
        stringArray[463] = "errorCode";
        stringArray[464] = "errorData";
        stringArray[465] = "plus";
        stringArray[466] = "plus";
        stringArray[467] = "toString";
        stringArray[468] = "id";
        stringArray[469] = "logFileRetrievalKey";
        stringArray[470] = "get";
        stringArray[471] = "debug";
        stringArray[472] = "state";
        stringArray[473] = "state";
        stringArray[474] = "debug";
        stringArray[475] = "state";
        stringArray[476] = "state";
        stringArray[477] = "logFileRetrievalKey";
        stringArray[478] = "getFileForExecutionFiletype";
        stringArray[479] = "PENDING_LOCAL";
        stringArray[480] = "getConfiguredPluginName";
        stringArray[481] = "PENDING_LOCAL";
        stringArray[482] = "get";
        stringArray[483] = "count";
        stringArray[484] = "count";
        stringArray[485] = "putIfAbsent";
        stringArray[486] = "debug";
        stringArray[487] = "state";
        stringArray[488] = "state";
        stringArray[489] = "debug";
        stringArray[490] = "state";
        stringArray[491] = "state";
        stringArray[492] = "remove";
        stringArray[493] = "debug";
        stringArray[494] = "plus";
        stringArray[495] = "count";
        stringArray[496] = "leftShift";
        stringArray[497] = "PENDING_LOCAL";
        stringArray[498] = "getConfiguredRetrievalRetryDelay";
        stringArray[499] = "longValue";
        stringArray[500] = "convert";
        stringArray[501] = "MILLISECONDS";
        stringArray[502] = "SECONDS";
        stringArray[503] = "time";
        stringArray[504] = "currentTimeMillis";
        stringArray[505] = "plus";
        stringArray[506] = "time";
        stringArray[507] = "currentTimeMillis";
        stringArray[508] = "plus";
        stringArray[509] = "time";
        stringArray[510] = "getConfiguredRetrievalRetryCount";
        stringArray[511] = "count";
        stringArray[512] = "count";
        stringArray[513] = "queueLogStorageRequest";
        stringArray[514] = "filetype";
        stringArray[515] = "id";
        stringArray[516] = "inc";
        stringArray[517] = "storageQueueCounter";
        stringArray[518] = "inc";
        stringArray[519] = "storageTotalCounter";
        stringArray[520] = "schedule";
        stringArray[521] = "SECONDS";
        stringArray[522] = "leftShift";
        stringArray[523] = "inc";
        stringArray[524] = "storageQueueCounter";
        stringArray[525] = "inc";
        stringArray[526] = "storageTotalCounter";
        stringArray[527] = "schedule";
        stringArray[528] = "SECONDS";
        stringArray[529] = "leftShift";
        stringArray[530] = "iterator";
        stringArray[531] = "listExecutionFileProducers";
        stringArray[532] = "isExecutionFileGenerated";
        stringArray[533] = "exists";
        stringArray[534] = "localFile";
        stringArray[535] = "produceStorageFileForExecution";
        stringArray[536] = "iterator";
        stringArray[537] = "isExecutionFileGenerated";
        stringArray[538] = "exists";
        stringArray[539] = "localFile";
        stringArray[540] = "produceStorageFileForExecution";
        stringArray[541] = "listExecutionFileProducers";
        stringArray[542] = "each";
        stringArray[543] = "debug";
        stringArray[544] = "getBeansOfType";
        stringArray[545] = "find";
        stringArray[546] = "findAll";
        stringArray[547] = "values";
        stringArray[548] = "findAll";
        stringArray[549] = "deleteExecutionFilePerPolicy";
        stringArray[550] = "debug";
        stringArray[551] = "subMap";
        stringArray[552] = "findAll";
        stringArray[553] = "storeMultiLogFiles";
        stringArray[554] = "each";
        stringArray[555] = "each";
        stringArray[556] = "keySet";
        stringArray[557] = "pluginSupportsRetrieve";
        stringArray[558] = "each";
        stringArray[559] = "debug";
        stringArray[560] = "debug";
        stringArray[561] = "collectEntries";
        stringArray[562] = "<$constructor$>";
        stringArray[563] = "storeMultiple";
        stringArray[564] = "each";
        stringArray[565] = "keySet";
        stringArray[566] = "debug";
        stringArray[567] = "<$constructor$>";
        stringArray[568] = "lastModified";
        stringArray[569] = "length";
        stringArray[570] = "withInputStream";
        stringArray[571] = "error";
        stringArray[572] = "message";
        stringArray[573] = "debug";
        stringArray[574] = "message";
        stringArray[575] = "message";
        stringArray[576] = "debug";
        stringArray[577] = "createTempFile";
        stringArray[578] = "deleteOnExit";
        stringArray[579] = "withOutputStream";
        stringArray[580] = "isDirectory";
        stringArray[581] = "getParentFile";
        stringArray[582] = "mkdirs";
        stringArray[583] = "getParentFile";
        stringArray[584] = "renameTo";
        stringArray[585] = "debug";
        stringArray[586] = "message";
        stringArray[587] = "debug";
        stringArray[588] = "message";
        stringArray[589] = "error";
        stringArray[590] = "delete";
        stringArray[591] = "<$constructor$>";
        stringArray[592] = "getLog";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[593];
        LogFileStorageService.$createCallSiteArray_1((String[])stringArray);
        return new CallSiteArray(LogFileStorageService.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = LogFileStorageService.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

