/*
 * Decompiled with CFR 0.152.
 */
package grails.plugin.cache;

import grails.plugin.cache.CustomCacheKeyGenerator;
import grails.plugin.cache.SimpleKeyGenerator;
import java.lang.reflect.Method;
import org.codehaus.groovy.grails.plugins.GrailsVersionUtils;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.cache.interceptor.KeyGenerator;
import org.springframework.core.SpringVersion;

public class CustomCacheKeyGenerator
implements KeyGenerator {
    private final KeyGenerator innerKeyGenerator;

    public CustomCacheKeyGenerator(KeyGenerator innerKeyGenerator) {
        this.innerKeyGenerator = innerKeyGenerator;
    }

    public CustomCacheKeyGenerator() {
        if (SpringVersion.getVersion() == null || GrailsVersionUtils.isVersionGreaterThan((String)SpringVersion.getVersion(), (String)"4.0.3")) {
            this.innerKeyGenerator = new SimpleKeyGenerator();
        } else {
            try {
                this.innerKeyGenerator = (KeyGenerator)Class.forName("org.springframework.cache.interceptor.SimpleKeyGenerator").newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public Object generate(Object target, Method method, Object ... params) {
        Class objClass = AopProxyUtils.ultimateTargetClass((Object)target);
        return new CacheKey(objClass.getName().intern(), method.toString().intern(), target.hashCode(), this.innerKeyGenerator.generate(target, method, params));
    }
}

