/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.ssl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.SocketChannel;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import org.apache.commons.ssl.Java14;

public class SSLSocketWrapper
extends SSLSocket {
    protected Socket s;

    public SSLSocketWrapper(Socket s) {
        this.s = s;
    }

    public void addHandshakeCompletedListener(HandshakeCompletedListener hcl) {
        if (this.s instanceof SSLSocket) {
            ((SSLSocket)this.s).addHandshakeCompletedListener(hcl);
        }
    }

    public void removeHandshakeCompletedListener(HandshakeCompletedListener hcl) {
        if (this.s instanceof SSLSocket) {
            ((SSLSocket)this.s).removeHandshakeCompletedListener(hcl);
        }
    }

    public String[] getSupportedCipherSuites() {
        if (this.s instanceof SSLSocket) {
            return ((SSLSocket)this.s).getSupportedCipherSuites();
        }
        return null;
    }

    public boolean getEnableSessionCreation() {
        return this.s instanceof SSLSocket && ((SSLSocket)this.s).getEnableSessionCreation();
    }

    public String[] getEnabledCipherSuites() {
        if (this.s instanceof SSLSocket) {
            return ((SSLSocket)this.s).getEnabledCipherSuites();
        }
        return null;
    }

    public String[] getSupportedProtocols() {
        if (this.s instanceof SSLSocket) {
            return ((SSLSocket)this.s).getSupportedProtocols();
        }
        return null;
    }

    public String[] getEnabledProtocols() {
        if (this.s instanceof SSLSocket) {
            return ((SSLSocket)this.s).getEnabledProtocols();
        }
        return null;
    }

    public SSLSession getSession() {
        if (this.s instanceof SSLSocket) {
            return ((SSLSocket)this.s).getSession();
        }
        return null;
    }

    public boolean getUseClientMode() {
        return this.s instanceof SSLSocket && ((SSLSocket)this.s).getUseClientMode();
    }

    public boolean getNeedClientAuth() {
        return this.s instanceof SSLSocket && ((SSLSocket)this.s).getNeedClientAuth();
    }

    public boolean getWantClientAuth() {
        return this.s instanceof SSLSocket && ((SSLSocket)this.s).getWantClientAuth();
    }

    public void setEnabledCipherSuites(String[] cs) {
        if (this.s instanceof SSLSocket) {
            ((SSLSocket)this.s).setEnabledCipherSuites(cs);
        }
    }

    public void setEnabledProtocols(String[] ep) {
        if (this.s instanceof SSLSocket) {
            ((SSLSocket)this.s).setEnabledProtocols(ep);
        }
    }

    public void startHandshake() throws IOException {
        if (this.s instanceof SSLSocket) {
            ((SSLSocket)this.s).startHandshake();
        }
    }

    public void setUseClientMode(boolean b) {
        if (this.s instanceof SSLSocket) {
            ((SSLSocket)this.s).setUseClientMode(b);
        }
    }

    public void setNeedClientAuth(boolean b) {
        if (this.s instanceof SSLSocket) {
            ((SSLSocket)this.s).setNeedClientAuth(b);
        }
    }

    public void setWantClientAuth(boolean b) {
        if (this.s instanceof SSLSocket) {
            ((SSLSocket)this.s).setWantClientAuth(b);
        }
    }

    public void setEnableSessionCreation(boolean b) {
        if (this.s instanceof SSLSocket) {
            ((SSLSocket)this.s).setEnableSessionCreation(b);
        }
    }

    public SocketChannel getChannel() {
        return this.s.getChannel();
    }

    public InetAddress getInetAddress() {
        return this.s.getInetAddress();
    }

    public boolean getKeepAlive() throws SocketException {
        return this.s.getKeepAlive();
    }

    public InetAddress getLocalAddress() {
        return this.s.getLocalAddress();
    }

    public int getLocalPort() {
        return this.s.getLocalPort();
    }

    public SocketAddress getLocalSocketAddress() {
        return this.s.getLocalSocketAddress();
    }

    public boolean getOOBInline() throws SocketException {
        return this.s.getOOBInline();
    }

    public int getPort() {
        return this.s.getPort();
    }

    public int getReceiveBufferSize() throws SocketException {
        return this.s.getReceiveBufferSize();
    }

    public SocketAddress getRemoteSocketAddress() {
        return this.s.getRemoteSocketAddress();
    }

    public boolean getReuseAddress() throws SocketException {
        return this.s.getReuseAddress();
    }

    public int getSendBufferSize() throws SocketException {
        return this.s.getSendBufferSize();
    }

    public int getSoLinger() throws SocketException {
        return this.s.getSoLinger();
    }

    public int getSoTimeout() throws SocketException {
        return this.s.getSoTimeout();
    }

    public boolean getTcpNoDelay() throws SocketException {
        return this.s.getTcpNoDelay();
    }

    public int getTrafficClass() throws SocketException {
        return this.s.getTrafficClass();
    }

    public boolean isBound() {
        return this.s.isBound();
    }

    public boolean isClosed() {
        return this.s.isClosed();
    }

    public boolean isConnected() {
        return this.s.isConnected();
    }

    public boolean isInputShutdown() {
        return this.s.isInputShutdown();
    }

    public boolean isOutputShutdown() {
        return this.s.isOutputShutdown();
    }

    public void sendUrgentData(int data) throws IOException {
        this.s.sendUrgentData(data);
    }

    public void setKeepAlive(boolean on) throws SocketException {
        this.s.setKeepAlive(on);
    }

    public void setOOBInline(boolean on) throws SocketException {
        this.s.setOOBInline(on);
    }

    public void setReceiveBufferSize(int size) throws SocketException {
        this.s.setReceiveBufferSize(size);
    }

    public void setReuseAddress(boolean on) throws SocketException {
        this.s.setReuseAddress(on);
    }

    public void setSendBufferSize(int size) throws SocketException {
        this.s.setSendBufferSize(size);
    }

    public void setSoLinger(boolean on, int l) throws SocketException {
        this.s.setSoLinger(on, l);
    }

    public void setSoTimeout(int timeout) throws SocketException {
        this.s.setSoTimeout(timeout);
    }

    public void setTcpNoDelay(boolean on) throws SocketException {
        this.s.setTcpNoDelay(on);
    }

    public void setTrafficClass(int tc) throws SocketException {
        this.s.setTrafficClass(tc);
    }

    public void shutdownInput() throws IOException {
        this.s.shutdownInput();
    }

    public void shutdownOutput() throws IOException {
        this.s.shutdownOutput();
    }

    public String toString() {
        return this.s.toString();
    }

    public void setPerformancePreferences(int connectionTime, int latency, int bandwidth) {
        this.s.setPerformancePreferences(connectionTime, latency, bandwidth);
    }

    public void bind(SocketAddress bindpoint) throws IOException {
        this.s.bind(bindpoint);
    }

    public void close() throws IOException {
        this.s.close();
    }

    public void connect(SocketAddress endpoint) throws IOException {
        this.s.connect(endpoint);
    }

    public void connect(SocketAddress endpoint, int timeout) throws IOException {
        this.s.connect(endpoint, timeout);
    }

    public InputStream getInputStream() throws IOException {
        return this.s.getInputStream();
    }

    public OutputStream getOutputStream() throws IOException {
        return this.s.getOutputStream();
    }

    public void setHost(String host) throws IOException {
        if (this.s instanceof SSLSocket) {
            Java14.setHostForSNI((SSLSocket)this.s, host);
        }
    }
}

