/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.jetty.jaas;

import com.dtolabs.rundeck.jetty.jaas.HostnameVerifyingSSLSocketFactory;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.ssl.HostnameVerifier;

public class HostnameVerifyingTrustManager
implements X509TrustManager {
    protected X509TrustManager realTrustManager;
    protected HostnameVerifier verifier;

    public HostnameVerifyingTrustManager(TrustManager trustManager) {
        if (!(trustManager instanceof X509TrustManager)) {
            throw new IllegalArgumentException(String.format("Expected trustManager to be of type X509TrustManager but was [%s]", trustManager.getClass()));
        }
        this.verifier = HostnameVerifier.STRICT;
        this.realTrustManager = (X509TrustManager)trustManager;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.realTrustManager.checkClientTrusted(chain, authType);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        if (chain.length > 0) {
            X509Certificate serverCert = chain[0];
            String host = HostnameVerifyingSSLSocketFactory.getTargetHost();
            try {
                this.verifier.check(host, serverCert);
            }
            catch (SSLException e) {
                throw new CertificateException(e);
            }
        }
        this.realTrustManager.checkServerTrusted(chain, authType);
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.realTrustManager.getAcceptedIssuers();
    }
}

