/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.util.concurrent.Executor;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.ForkInvoker;

public abstract class ExecutorCallback
implements Callback {
    private final ForkInvoker<Void> _invoker;
    private final Executor _executor;
    private final Runnable _onComplete = new Runnable(){

        @Override
        public void run() {
            ExecutorCallback.this.onCompleted();
        }
    };

    public ExecutorCallback(Executor executor) {
        this(executor, 4);
    }

    public ExecutorCallback(Executor executor, int maxRecursion) {
        this._executor = executor;
        ExecutorCallbackInvoker executorCallbackInvoker = this._invoker = maxRecursion > 0 ? new ExecutorCallbackInvoker(maxRecursion) : null;
        if (this._executor == null) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public void succeeded() {
        if (this._invoker == null) {
            this._executor.execute(this._onComplete);
        } else if (this.alwaysDispatchCompletion()) {
            this._invoker.fork(null);
        } else {
            this._invoker.invoke(null);
        }
    }

    protected abstract void onCompleted();

    @Override
    public void failed(final Throwable x) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                ExecutorCallback.this.onFailed(x);
            }

            public String toString() {
                return String.format("ExecutorCallback@%x{%s}", this.hashCode(), x);
            }
        };
        if (this._executor == null) {
            new Thread(runnable).start();
        } else {
            this._executor.execute(runnable);
        }
    }

    protected void onFailed(Throwable x) {
    }

    protected boolean alwaysDispatchCompletion() {
        return this._executor != null;
    }

    public String toString() {
        return String.format("%s@%x", this.getClass(), this.hashCode());
    }

    private class ExecutorCallbackInvoker
    extends ForkInvoker<Void>
    implements Runnable {
        private ExecutorCallbackInvoker(int maxInvocations) {
            super(maxInvocations);
        }

        @Override
        public void fork(Void arg) {
            ExecutorCallback.this._executor.execute(this);
        }

        @Override
        public void call(Void arg) {
            ExecutorCallback.this.onCompleted();
        }

        @Override
        public void run() {
            ExecutorCallback.this.onCompleted();
        }
    }
}

