/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.plus.security;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Locale;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.eclipse.jetty.plus.jndi.NamingEntryUtil;
import org.eclipse.jetty.security.IdentityService;
import org.eclipse.jetty.security.MappedLoginService;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.UserIdentity;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.security.Password;

public class DataSourceLoginService
extends MappedLoginService {
    private static final Logger LOG = Log.getLogger(DataSourceLoginService.class);
    private String _jndiName = "javax.sql.DataSource/default";
    private DataSource _datasource;
    private Server _server;
    private String _userTableName = "users";
    private String _userTableKey = "id";
    private String _userTableUserField = "username";
    private String _userTablePasswordField = "pwd";
    private String _roleTableName = "roles";
    private String _roleTableKey = "id";
    private String _roleTableRoleField = "role";
    private String _userRoleTableName = "user_roles";
    private String _userRoleTableUserKey = "user_id";
    private String _userRoleTableRoleKey = "role_id";
    private int _cacheMs = 30000;
    private String _userSql;
    private String _roleSql;
    private boolean _createTables = false;

    public DataSourceLoginService() {
    }

    public DataSourceLoginService(String name) {
        this.setName(name);
    }

    public DataSourceLoginService(String name, IdentityService identityService) {
        this.setName(name);
        this.setIdentityService(identityService);
    }

    public void setJndiName(String jndi) {
        this._jndiName = jndi;
    }

    public String getJndiName() {
        return this._jndiName;
    }

    public void setServer(Server server) {
        this._server = server;
    }

    public Server getServer() {
        return this._server;
    }

    public void setCreateTables(boolean createTables) {
        this._createTables = createTables;
    }

    public boolean getCreateTables() {
        return this._createTables;
    }

    public void setUserTableName(String name) {
        this._userTableName = name;
    }

    public String getUserTableName() {
        return this._userTableName;
    }

    public String getUserTableKey() {
        return this._userTableKey;
    }

    public void setUserTableKey(String tableKey) {
        this._userTableKey = tableKey;
    }

    public String getUserTableUserField() {
        return this._userTableUserField;
    }

    public void setUserTableUserField(String tableUserField) {
        this._userTableUserField = tableUserField;
    }

    public String getUserTablePasswordField() {
        return this._userTablePasswordField;
    }

    public void setUserTablePasswordField(String tablePasswordField) {
        this._userTablePasswordField = tablePasswordField;
    }

    public String getRoleTableName() {
        return this._roleTableName;
    }

    public void setRoleTableName(String tableName) {
        this._roleTableName = tableName;
    }

    public String getRoleTableKey() {
        return this._roleTableKey;
    }

    public void setRoleTableKey(String tableKey) {
        this._roleTableKey = tableKey;
    }

    public String getRoleTableRoleField() {
        return this._roleTableRoleField;
    }

    public void setRoleTableRoleField(String tableRoleField) {
        this._roleTableRoleField = tableRoleField;
    }

    public String getUserRoleTableName() {
        return this._userRoleTableName;
    }

    public void setUserRoleTableName(String roleTableName) {
        this._userRoleTableName = roleTableName;
    }

    public String getUserRoleTableUserKey() {
        return this._userRoleTableUserKey;
    }

    public void setUserRoleTableUserKey(String roleTableUserKey) {
        this._userRoleTableUserKey = roleTableUserKey;
    }

    public String getUserRoleTableRoleKey() {
        return this._userRoleTableRoleKey;
    }

    public void setUserRoleTableRoleKey(String roleTableRoleKey) {
        this._userRoleTableRoleKey = roleTableRoleKey;
    }

    public void setCacheMs(int ms) {
        this._cacheMs = ms;
    }

    public int getCacheMs() {
        return this._cacheMs;
    }

    @Override
    protected void loadUsers() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected UserIdentity loadUser(String userName) {
        try {
            this.initDb();
            try (Connection connection = this.getConnection();
                 PreparedStatement statement1 = connection.prepareStatement(this._userSql);){
                statement1.setObject(1, userName);
                try (ResultSet rs1 = statement1.executeQuery();){
                    if (!rs1.next()) return null;
                    int key = rs1.getInt(this._userTableKey);
                    String credentials = rs1.getString(this._userTablePasswordField);
                    ArrayList<String> roles = new ArrayList<String>();
                    try (PreparedStatement statement2 = connection.prepareStatement(this._roleSql);){
                        statement2.setInt(1, key);
                        try (ResultSet rs2 = statement2.executeQuery();){
                            while (rs2.next()) {
                                roles.add(rs2.getString(this._roleTableRoleField));
                            }
                        }
                    }
                    UserIdentity userIdentity = this.putUser(userName, new Password(credentials), roles.toArray(new String[roles.size()]));
                    return userIdentity;
                }
            }
        }
        catch (NamingException e) {
            LOG.warn("No datasource for " + this._jndiName, e);
            return null;
        }
        catch (SQLException e) {
            LOG.warn("Problem loading user info for " + userName, e);
        }
        return null;
    }

    public void initDb() throws NamingException, SQLException {
        if (this._datasource != null) {
            return;
        }
        InitialContext ic = new InitialContext();
        assert (ic != null);
        if (this._server != null) {
            try {
                this._datasource = (DataSource)NamingEntryUtil.lookup(this._server, this._jndiName);
            }
            catch (NameNotFoundException nameNotFoundException) {
                // empty catch block
            }
        }
        if (this._datasource == null) {
            this._datasource = (DataSource)NamingEntryUtil.lookup(null, this._jndiName);
        }
        this._userSql = "select " + this._userTableKey + "," + this._userTablePasswordField + " from " + this._userTableName + " where " + this._userTableUserField + " = ?";
        this._roleSql = "select r." + this._roleTableRoleField + " from " + this._roleTableName + " r, " + this._userRoleTableName + " u where u." + this._userRoleTableUserKey + " = ?" + " and r." + this._roleTableKey + " = u." + this._userRoleTableRoleKey;
        this.prepareTables();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void prepareTables() throws NamingException, SQLException {
        if (!this._createTables) {
            if (!LOG.isDebugEnabled()) return;
            LOG.debug("createTables false", new Object[0]);
            return;
        }
        boolean autocommit = true;
        Connection connection = this.getConnection();
        try (Statement stmt = connection.createStatement();){
            block79: {
                Throwable throwable;
                ResultSet result;
                String tableName;
                DatabaseMetaData metaData;
                block78: {
                    block77: {
                        autocommit = connection.getAutoCommit();
                        connection.setAutoCommit(false);
                        metaData = connection.getMetaData();
                        tableName = metaData.storesLowerCaseIdentifiers() ? this._userTableName.toLowerCase(Locale.ENGLISH) : (metaData.storesUpperCaseIdentifiers() ? this._userTableName.toUpperCase(Locale.ENGLISH) : this._userTableName);
                        result = metaData.getTables(null, null, tableName, null);
                        throwable = null;
                        try {
                            if (result.next()) break block77;
                            stmt.executeUpdate("create table " + this._userTableName + "(" + this._userTableKey + " integer," + this._userTableUserField + " varchar(100) not null unique," + this._userTablePasswordField + " varchar(20) not null, primary key(" + this._userTableKey + "))");
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("Created table " + this._userTableName, new Object[0]);
                            }
                        }
                        catch (Throwable x2) {
                            throwable = x2;
                            throw x2;
                        }
                        finally {
                            if (result != null) {
                                if (throwable != null) {
                                    try {
                                        result.close();
                                    }
                                    catch (Throwable x2) {
                                        throwable.addSuppressed(x2);
                                    }
                                } else {
                                    result.close();
                                }
                            }
                        }
                    }
                    tableName = metaData.storesLowerCaseIdentifiers() ? this._roleTableName.toLowerCase(Locale.ENGLISH) : (metaData.storesUpperCaseIdentifiers() ? this._roleTableName.toUpperCase(Locale.ENGLISH) : this._roleTableName);
                    result = metaData.getTables(null, null, tableName, null);
                    throwable = null;
                    try {
                        if (result.next()) break block78;
                        String str = "create table " + this._roleTableName + " (" + this._roleTableKey + " integer, " + this._roleTableRoleField + " varchar(100) not null unique, primary key(" + this._roleTableKey + "))";
                        stmt.executeUpdate(str);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Created table " + this._roleTableName, new Object[0]);
                        }
                    }
                    catch (Throwable x2) {
                        throwable = x2;
                        throw x2;
                    }
                    finally {
                        if (result != null) {
                            if (throwable != null) {
                                try {
                                    result.close();
                                }
                                catch (Throwable x2) {
                                    throwable.addSuppressed(x2);
                                }
                            } else {
                                result.close();
                            }
                        }
                    }
                }
                tableName = metaData.storesLowerCaseIdentifiers() ? this._userRoleTableName.toLowerCase(Locale.ENGLISH) : (metaData.storesUpperCaseIdentifiers() ? this._userRoleTableName.toUpperCase(Locale.ENGLISH) : this._userRoleTableName);
                result = metaData.getTables(null, null, tableName, null);
                throwable = null;
                try {
                    if (result.next()) break block79;
                    stmt.executeUpdate("create table " + this._userRoleTableName + " (" + this._userRoleTableUserKey + " integer, " + this._userRoleTableRoleKey + " integer, " + "primary key (" + this._userRoleTableUserKey + ", " + this._userRoleTableRoleKey + "))");
                    stmt.executeUpdate("create index indx_user_role on " + this._userRoleTableName + "(" + this._userRoleTableUserKey + ")");
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Created table " + this._userRoleTableName + " and index", new Object[0]);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (result != null) {
                        if (throwable != null) {
                            try {
                                result.close();
                            }
                            catch (Throwable x2) {
                                throwable.addSuppressed(x2);
                            }
                        } else {
                            result.close();
                        }
                    }
                }
            }
            connection.commit();
            return;
        }
        finally {
            try {
                connection.setAutoCommit(autocommit);
            }
            catch (SQLException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Prepare tables", e);
                }
            }
            finally {
                block81: {
                    try {
                        connection.close();
                    }
                    catch (SQLException e) {
                        if (!LOG.isDebugEnabled()) break block81;
                        LOG.debug("Prepare tables", e);
                    }
                }
            }
        }
    }

    private Connection getConnection() throws NamingException, SQLException {
        this.initDb();
        return this._datasource.getConnection();
    }
}

