/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.jetty.jaas;

import com.dtolabs.rundeck.jetty.jaas.HostnameVerifyingSSLSocketFactory;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import org.eclipse.jetty.jaas.callback.ObjectCallback;
import org.eclipse.jetty.jaas.spi.AbstractLoginModule;
import org.eclipse.jetty.jaas.spi.UserInfo;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.security.Credential;

public class JettyCachingLdapLoginModule
extends AbstractLoginModule {
    private static final Logger LOG = Log.getLogger(JettyCachingLdapLoginModule.class);
    private static final Pattern rolePattern = Pattern.compile("^cn=([^,]+)", 2);
    protected final String _roleMemberFilter = "member=*";
    protected String _providerUrl;
    protected String _rolePrefix = "";
    protected int _cacheDuration = 0;
    protected String _hostname;
    protected int _port = 389;
    protected String _authenticationMethod;
    protected String _contextFactory;
    protected String _bindDn;
    protected String _bindPassword;
    protected String _userObjectClass = "inetOrgPerson";
    protected String _userRdnAttribute = "uid";
    protected String _userIdAttribute = "cn";
    protected String _userPasswordAttribute = "userPassword";
    protected String _userBaseDn;
    protected String _roleBaseDn;
    protected String _roleObjectClass = "groupOfUniqueNames";
    protected String _roleMemberAttribute = "uniqueMember";
    protected String _roleUsernameMemberAttribute = null;
    protected String _roleNameAttribute = "roleName";
    protected boolean _debug;
    protected boolean _ldapsVerifyHostname = true;
    protected boolean _forceBindingLogin = false;
    protected boolean _forceBindingLoginUseRootContextForRoles = false;
    protected DirContext _rootContext;
    protected boolean _reportStatistics;
    protected List<String> _supplementalRoles;
    protected boolean _nestedGroups;
    protected long _timeoutRead = 0L;
    protected long _timeoutConnect = 0L;
    protected static final ConcurrentHashMap<String, CachedUserInfo> USERINFOCACHE = new ConcurrentHashMap();
    protected static long userInfoCacheHits;
    protected static long loginAttempts;
    private static ConcurrentHashMap<String, List<String>> roleMemberOfMap;
    private static long roleMemberOfMapExpires;

    public UserInfo getUserInfo(String username) throws Exception {
        String pwdCredential = this.getUserCredentials(username);
        if (pwdCredential == null) {
            return null;
        }
        pwdCredential = JettyCachingLdapLoginModule.convertCredentialLdapToJetty(pwdCredential);
        Credential credential = Credential.getCredential((String)pwdCredential);
        List roles = this.getUserRoles(this._rootContext, username);
        return new UserInfo(username, credential, roles);
    }

    protected String doRFC2254Encoding(String inputString) {
        StringBuffer buf = new StringBuffer(inputString.length());
        block7: for (int i = 0; i < inputString.length(); ++i) {
            char c = inputString.charAt(i);
            switch (c) {
                case '\\': {
                    buf.append("\\5c");
                    continue block7;
                }
                case '*': {
                    buf.append("\\2a");
                    continue block7;
                }
                case '(': {
                    buf.append("\\28");
                    continue block7;
                }
                case ')': {
                    buf.append("\\29");
                    continue block7;
                }
                case '\u0000': {
                    buf.append("\\00");
                    continue block7;
                }
                default: {
                    buf.append(c);
                }
            }
        }
        return buf.toString();
    }

    private String getUserCredentials(String username) throws LoginException {
        String ldapCredential = null;
        SearchControls ctls = new SearchControls();
        ctls.setCountLimit(1L);
        ctls.setDerefLinkFlag(true);
        ctls.setSearchScope(2);
        String filter = "(&(objectClass={0})({1}={2}))";
        try {
            Object[] filterArguments = new Object[]{this._userObjectClass, this._userIdAttribute, username};
            NamingEnumeration<SearchResult> results = this._rootContext.search(this._userBaseDn, filter, filterArguments, ctls);
            LOG.debug("Found user?: " + results.hasMoreElements(), new Object[0]);
            if (!results.hasMoreElements()) {
                throw new LoginException("User not found.");
            }
            SearchResult result = this.findUser(username);
            Attributes attributes = result.getAttributes();
            Attribute attribute = attributes.get(this._userPasswordAttribute);
            if (attribute != null) {
                try {
                    byte[] value = (byte[])attribute.get();
                    ldapCredential = new String(value);
                }
                catch (NamingException e) {
                    LOG.debug("no password available under attribute: " + this._userPasswordAttribute, new Object[0]);
                }
            }
        }
        catch (NamingException e) {
            throw new LoginException("Root context binding failure.");
        }
        LOG.debug("user cred is: " + ldapCredential, new Object[0]);
        return ldapCredential;
    }

    protected List getUserRoles(DirContext dirContext, String username) throws LoginException, NamingException {
        String userDn = this._userRdnAttribute + "=" + username + "," + this._userBaseDn;
        return this.getUserRolesByDn(dirContext, userDn, username);
    }

    private List getUserRolesByDn(DirContext dirContext, String userDn, String username) throws LoginException, NamingException {
        NamingEnumeration<SearchResult> results;
        Object[] filterArguments;
        List<String> roleList = new ArrayList<String>();
        if (dirContext == null || this._roleBaseDn == null || this._roleMemberAttribute == null && this._roleUsernameMemberAttribute == null || this._roleObjectClass == null) {
            LOG.warn("JettyCachingLdapLoginModule: No user roles found: roleBaseDn, roleObjectClass and roleMemberAttribute or roleUsernameMemberAttribute must be specified.", new Object[0]);
            return roleList;
        }
        SearchControls ctls = new SearchControls();
        ctls.setDerefLinkFlag(true);
        ctls.setSearchScope(2);
        String filter = "(&(objectClass={0})({1}={2}))";
        if (null != this._roleUsernameMemberAttribute) {
            filterArguments = new Object[]{this._roleObjectClass, this._roleUsernameMemberAttribute, username};
            results = dirContext.search(this._roleBaseDn, filter, filterArguments, ctls);
        } else {
            filterArguments = new Object[]{this._roleObjectClass, this._roleMemberAttribute, userDn};
            results = dirContext.search(this._roleBaseDn, filter, filterArguments, ctls);
        }
        while (results.hasMoreElements()) {
            Attribute roleAttribute;
            SearchResult result = (SearchResult)results.nextElement();
            Attributes attributes = result.getAttributes();
            if (attributes == null || (roleAttribute = attributes.get(this._roleNameAttribute)) == null) continue;
            NamingEnumeration<?> roles = roleAttribute.getAll();
            while (roles.hasMore()) {
                if (this._rolePrefix != null && !"".equalsIgnoreCase(this._rolePrefix)) {
                    String role = (String)roles.next();
                    roleList.add(role.replace(this._rolePrefix, ""));
                    continue;
                }
                roleList.add((String)roles.next());
            }
        }
        this.addSupplementalRoles(roleList);
        if (this._nestedGroups) {
            roleList = this.getNestedRoles(dirContext, roleList);
        }
        if (roleList.size() < 1) {
            LOG.warn("JettyCachingLdapLoginModule: User '" + username + "' has no role membership; role query configuration may be incorrect", new Object[0]);
        } else {
            LOG.debug("JettyCachingLdapLoginModule: User '" + username + "' has roles: " + roleList, new Object[0]);
        }
        return roleList;
    }

    protected void addSupplementalRoles(List<String> roleList) {
        if (null != this._supplementalRoles) {
            for (String supplementalRole : this._supplementalRoles) {
                if (null == supplementalRole || "".equals(supplementalRole.trim())) continue;
                roleList.add(supplementalRole.trim());
            }
        }
    }

    private List<String> getNestedRoles(DirContext dirContext, List<String> roleList) {
        HashMap<String, List<String>> roleMemberOfMap = new HashMap<String, List<String>>();
        roleMemberOfMap.putAll(this.getRoleMemberOfMap(dirContext));
        List<String> mergedList = this.mergeRoles(roleList, roleMemberOfMap);
        return mergedList;
    }

    private List<String> mergeRoles(List<String> roles, HashMap<String, List<String>> roleMemberOfMap) {
        ArrayList<String> newRoles = new ArrayList<String>();
        ArrayList<String> mergedRoles = new ArrayList<String>();
        mergedRoles.addAll(roles);
        for (String role : roles) {
            if (!roleMemberOfMap.containsKey(role)) continue;
            for (String newRole : roleMemberOfMap.get(role)) {
                if (roles.contains(newRole)) continue;
                newRoles.add(newRole);
            }
            roleMemberOfMap.remove(role);
        }
        if (!newRoles.isEmpty()) {
            mergedRoles.addAll(this.mergeRoles(newRoles, roleMemberOfMap));
        }
        return mergedRoles;
    }

    private ConcurrentHashMap<String, List<String>> getRoleMemberOfMap(DirContext dirContext) {
        if (this._cacheDuration == 0 || System.currentTimeMillis() > roleMemberOfMapExpires) {
            roleMemberOfMap = this.buildRoleMemberOfMap(dirContext);
            roleMemberOfMapExpires = System.currentTimeMillis() + (long)this._cacheDuration;
        }
        return roleMemberOfMap;
    }

    private ConcurrentHashMap<String, List<String>> buildRoleMemberOfMap(DirContext dirContext) {
        Object[] filterArguments = new Object[]{this._roleObjectClass};
        SearchControls ctls = new SearchControls();
        ctls.setDerefLinkFlag(true);
        ctls.setSearchScope(2);
        ConcurrentHashMap<String, List<String>> roleMemberOfMap = new ConcurrentHashMap<String, List<String>>();
        try {
            NamingEnumeration<SearchResult> results = dirContext.search(this._roleBaseDn, "member=*", ctls);
            while (results.hasMoreElements()) {
                SearchResult result = (SearchResult)results.nextElement();
                Attributes attributes = result.getAttributes();
                if (attributes == null) continue;
                Attribute roleAttribute = attributes.get(this._roleNameAttribute);
                Attribute memberAttribute = attributes.get(this._roleMemberAttribute);
                if (roleAttribute == null || memberAttribute == null) continue;
                NamingEnumeration<?> role = roleAttribute.getAll();
                NamingEnumeration<?> members = memberAttribute.getAll();
                if (!role.hasMore() || !members.hasMore()) continue;
                String roleName = (String)role.next();
                if (this._rolePrefix != null && !"".equalsIgnoreCase(this._rolePrefix)) {
                    roleName = roleName.replace(this._rolePrefix, "");
                }
                while (members.hasMore()) {
                    String member = (String)members.next();
                    Matcher roleMatcher = rolePattern.matcher(member);
                    if (!roleMatcher.find()) continue;
                    String roleMember = roleMatcher.group(1);
                    List<Object> memberOf = roleMemberOfMap.containsKey(roleMember) ? roleMemberOfMap.get(roleMember) : new ArrayList();
                    memberOf.add(roleName);
                    roleMemberOfMap.put(roleMember, memberOf);
                }
            }
        }
        catch (NamingException e) {
            e.printStackTrace();
        }
        return roleMemberOfMap;
    }

    protected boolean isDebug() {
        return this._debug;
    }

    protected void debug(String message) {
        if (this.isDebug()) {
            LOG.debug(message, new Object[0]);
        }
    }

    public boolean login() throws LoginException {
        try {
            Object[] userPass = this.getCallBackAuth();
            if (null == userPass || userPass.length < 2) {
                this.setAuthenticated(false);
            } else {
                String name = (String)userPass[0];
                Object pass = userPass[1];
                this.setAuthenticated(this.authenticate(name, pass));
            }
            return this.isAuthenticated();
        }
        catch (UnsupportedCallbackException e) {
            throw new LoginException("Error obtaining callback information.");
        }
        catch (IOException e) {
            if (this._debug) {
                e.printStackTrace();
            }
            throw new LoginException("IO Error performing login.");
        }
    }

    protected Object[] getCallBackAuth() throws IOException, UnsupportedCallbackException, LoginException {
        if (this.getCallbackHandler() == null) {
            throw new LoginException("No callback handler");
        }
        Callback[] callbacks = this.configureCallbacks();
        this.getCallbackHandler().handle(callbacks);
        String webUserName = ((NameCallback)callbacks[0]).getName();
        Object webCredential = ((ObjectCallback)callbacks[1]).getObject();
        return new Object[]{webUserName, webCredential};
    }

    protected boolean authenticate(String webUserName, Object webCredential) throws LoginException {
        try {
            if (this.isEmptyOrNull(webUserName) || this.isEmptyOrNull(webCredential)) {
                this.setAuthenticated(false);
                return this.isAuthenticated();
            }
            ++loginAttempts;
            if (this._reportStatistics) {
                DecimalFormat percentHit = new DecimalFormat("#.##");
                LOG.info("Login attempts: " + loginAttempts + ", Hits: " + userInfoCacheHits + ", Ratio: " + percentHit.format((double)userInfoCacheHits / (double)loginAttempts * 100.0) + "%.", new Object[0]);
            }
            if (this._forceBindingLogin) {
                return this.bindingLogin(webUserName, webCredential);
            }
            UserInfo userInfo = this.getUserInfo(webUserName);
            if (userInfo == null) {
                this.setAuthenticated(false);
                return false;
            }
            this.setCurrentUser(new AbstractLoginModule.JAASUserInfo((AbstractLoginModule)this, userInfo));
            if (webCredential instanceof String) {
                return this.credentialLogin(Credential.getCredential((String)((String)webCredential)));
            }
            return this.credentialLogin(webCredential);
        }
        catch (UnsupportedCallbackException e) {
            throw new LoginException("Error obtaining callback information.");
        }
        catch (IOException e) {
            if (this._debug) {
                e.printStackTrace();
            }
            throw new LoginException("IO Error performing login.");
        }
        catch (Exception e) {
            if (this._debug) {
                e.printStackTrace();
            }
            throw new LoginException("Error obtaining user info.");
        }
    }

    private boolean isEmptyOrNull(Object value) {
        return null == value || "".equals(value);
    }

    protected boolean credentialLogin(Object webCredential) throws LoginException {
        this.setAuthenticated(this.getCurrentUser().checkCredential(webCredential));
        return this.isAuthenticated();
    }

    protected boolean bindingLogin(String username, Object password) throws LoginException, NamingException {
        String cacheToken = Credential.MD5.digest((String)(username + ":" + password.toString()));
        if (this._cacheDuration > 0) {
            CachedUserInfo cached = USERINFOCACHE.get(cacheToken);
            if (cached != null) {
                if (System.currentTimeMillis() < cached.expires) {
                    LOG.debug("Cache Hit for " + username + ".", new Object[0]);
                    ++userInfoCacheHits;
                    this.setCurrentUser(new AbstractLoginModule.JAASUserInfo((AbstractLoginModule)this, cached.userInfo));
                    this.setAuthenticated(true);
                    return true;
                }
                LOG.info("Cache Eviction for " + username + ".", new Object[0]);
                USERINFOCACHE.remove(cacheToken);
            } else {
                LOG.debug("Cache Miss for " + username + ".", new Object[0]);
            }
        }
        SearchResult searchResult = this.findUser(username);
        String userDn = searchResult.getNameInNamespace();
        LOG.info("Attempting authentication: " + userDn, new Object[0]);
        Hashtable environment = this.getEnvironment();
        environment.put("java.naming.security.principal", userDn);
        environment.put("java.naming.security.credentials", password);
        DirContext dirContext = new InitialDirContext(environment);
        if (this._forceBindingLoginUseRootContextForRoles) {
            dirContext = this._rootContext;
            LOG.debug("Using _rootContext for role lookup.", new Object[0]);
        }
        List roles = this.getUserRolesByDn(dirContext, userDn, username);
        UserInfo userInfo = new UserInfo(username, null, roles);
        if (this._cacheDuration > 0) {
            USERINFOCACHE.put(cacheToken, new CachedUserInfo(userInfo, System.currentTimeMillis() + (long)this._cacheDuration));
            LOG.debug("Adding " + username + " set to expire: " + System.currentTimeMillis() + this._cacheDuration, new Object[0]);
        }
        this.setCurrentUser(new AbstractLoginModule.JAASUserInfo((AbstractLoginModule)this, userInfo));
        this.setAuthenticated(true);
        return true;
    }

    private SearchResult findUser(String username) throws NamingException, LoginException {
        SearchControls ctls = new SearchControls();
        ctls.setCountLimit(1L);
        ctls.setDerefLinkFlag(true);
        ctls.setSearchScope(2);
        String filter = "(&(objectClass={0})({1}={2}))";
        LOG.debug("Searching for users with filter: '" + filter + "'" + " from base dn: " + this._userBaseDn, new Object[0]);
        Object[] filterArguments = new Object[]{this._userObjectClass, this._userIdAttribute, username};
        NamingEnumeration<SearchResult> results = this._rootContext.search(this._userBaseDn, filter, filterArguments, ctls);
        LOG.debug("Found user?: " + results.hasMoreElements(), new Object[0]);
        if (!results.hasMoreElements()) {
            throw new LoginException("User not found.");
        }
        return (SearchResult)results.nextElement();
    }

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        super.initialize(subject, callbackHandler, sharedState, options);
        this.initializeOptions(options);
        try {
            this._rootContext = new InitialDirContext(this.getEnvironment());
        }
        catch (NamingException ex) {
            LOG.warn((Throwable)ex);
            throw new IllegalStateException("Unable to establish root context: " + ex.getMessage());
        }
    }

    public void initializeOptions(Map options) {
        String cacheDurationSetting;
        this._hostname = (String)options.get("hostname");
        if (options.containsKey("port")) {
            this._port = Integer.parseInt((String)options.get("port"));
        }
        this._providerUrl = (String)options.get("providerUrl");
        this._contextFactory = (String)options.get("contextFactory");
        this._bindDn = (String)options.get("bindDn");
        this._bindPassword = (String)options.get("bindPassword");
        this._authenticationMethod = (String)options.get("authenticationMethod");
        this._userBaseDn = (String)options.get("userBaseDn");
        this._roleBaseDn = (String)options.get("roleBaseDn");
        if (options.containsKey("forceBindingLogin")) {
            this._forceBindingLogin = Boolean.parseBoolean((String)options.get("forceBindingLogin"));
        }
        if (options.containsKey("nestedGroups")) {
            this._nestedGroups = Boolean.parseBoolean((String)options.get("nestedGroups"));
        }
        if (options.containsKey("forceBindingLoginUseRootContextForRoles")) {
            this._forceBindingLoginUseRootContextForRoles = Boolean.parseBoolean((String)options.get("forceBindingLoginUseRootContextForRoles"));
        }
        this._userObjectClass = this.getOption(options, "userObjectClass", this._userObjectClass);
        this._userRdnAttribute = this.getOption(options, "userRdnAttribute", this._userRdnAttribute);
        this._userIdAttribute = this.getOption(options, "userIdAttribute", this._userIdAttribute);
        this._userPasswordAttribute = this.getOption(options, "userPasswordAttribute", this._userPasswordAttribute);
        this._roleObjectClass = this.getOption(options, "roleObjectClass", this._roleObjectClass);
        this._roleMemberAttribute = this.getOption(options, "roleMemberAttribute", this._roleMemberAttribute);
        this._roleUsernameMemberAttribute = this.getOption(options, "roleUsernameMemberAttribute", this._roleUsernameMemberAttribute);
        this._roleNameAttribute = this.getOption(options, "roleNameAttribute", this._roleNameAttribute);
        this._debug = Boolean.parseBoolean(String.valueOf(this.getOption(options, "debug", Boolean.toString(this._debug))));
        this._ldapsVerifyHostname = Boolean.parseBoolean(String.valueOf(this.getOption(options, "ldapsVerifyHostname", Boolean.toString(this._ldapsVerifyHostname))));
        this._rolePrefix = (String)options.get("rolePrefix");
        this._reportStatistics = Boolean.parseBoolean(String.valueOf(this.getOption(options, "reportStatistics", Boolean.toString(this._reportStatistics))));
        Object supplementalRoles = options.get("supplementalRoles");
        if (null != supplementalRoles) {
            this._supplementalRoles = new ArrayList<String>();
            this._supplementalRoles.addAll(Arrays.asList(supplementalRoles.toString().split(", *")));
        }
        if ((cacheDurationSetting = (String)options.get("cacheDurationMillis")) != null) {
            try {
                this._cacheDuration = Integer.parseInt(cacheDurationSetting);
            }
            catch (NumberFormatException e) {
                LOG.warn("Unable to parse cacheDurationMillis to a number: " + cacheDurationSetting, new Object[]{". Using default: " + this._cacheDuration, e});
            }
        }
        if (options.containsKey("timeoutRead")) {
            this._timeoutRead = Long.parseLong((String)options.get("timeoutRead"));
        }
        if (options.containsKey("timeoutConnect")) {
            this._timeoutConnect = Long.parseLong((String)options.get("timeoutConnect"));
        }
    }

    public boolean commit() throws LoginException {
        try {
            this._rootContext.close();
        }
        catch (NamingException e) {
            throw new LoginException("error closing root context: " + e.getMessage());
        }
        return super.commit();
    }

    public boolean abort() throws LoginException {
        try {
            this._rootContext.close();
        }
        catch (NamingException e) {
            throw new LoginException("error closing root context: " + e.getMessage());
        }
        return super.abort();
    }

    protected String getOption(Map options, String key, String defaultValue) {
        Object value = options.get(key);
        if (value == null) {
            return defaultValue;
        }
        return (String)value;
    }

    public Hashtable getEnvironment() {
        Properties env = new Properties();
        env.put("java.naming.factory.initial", this._contextFactory);
        String url = null;
        if (this._providerUrl != null) {
            url = this._providerUrl;
        } else if (this._hostname != null) {
            url = "ldap://" + this._hostname + "/";
            if (this._port != 0) {
                url = url + ":" + this._port + "/";
            }
            LOG.warn("Using hostname and port.  Use providerUrl instead: " + url, new Object[0]);
        }
        env.put("java.naming.provider.url", url);
        if (this._authenticationMethod != null) {
            env.put("java.naming.security.authentication", this._authenticationMethod);
        }
        if (this._bindDn != null) {
            env.put("java.naming.security.principal", this._bindDn);
        }
        if (this._bindPassword != null) {
            env.put("java.naming.security.credentials", this._bindPassword);
        }
        env.put("com.sun.jndi.ldap.read.timeout", Long.toString(this._timeoutRead));
        env.put("com.sun.jndi.ldap.connect.timeout", Long.toString(this._timeoutConnect));
        if (url != null && url.startsWith("ldaps") && this._ldapsVerifyHostname) {
            try {
                URI uri = new URI(url);
                HostnameVerifyingSSLSocketFactory.setTargetHost(uri.getHost());
                env.put("java.naming.ldap.factory.socket", "com.dtolabs.rundeck.jetty.jaas.HostnameVerifyingSSLSocketFactory");
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        return env;
    }

    private static String convertCredentialLdapToJetty(String encryptedPassword) {
        if (encryptedPassword == null) {
            return encryptedPassword;
        }
        if (encryptedPassword.toUpperCase().startsWith("{MD5}")) {
            return "MD5:" + encryptedPassword.substring("{MD5}".length(), encryptedPassword.length());
        }
        if (encryptedPassword.toUpperCase().startsWith("{CRYPT}")) {
            return "CRYPT:" + encryptedPassword.substring("{CRYPT}".length(), encryptedPassword.length());
        }
        return encryptedPassword;
    }

    static {
        roleMemberOfMapExpires = 0L;
    }

    private static final class CachedUserInfo {
        public final long expires;
        public final UserInfo userInfo;

        public CachedUserInfo(UserInfo userInfo, long expires) {
            this.userInfo = userInfo;
            this.expires = expires;
        }
    }
}

