/*
 * Decompiled with CFR 0.152.
 */
package org.rundeck.storage.conf;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.rundeck.storage.api.ContentMeta;
import org.rundeck.storage.api.Path;
import org.rundeck.storage.api.PathUtil;
import org.rundeck.storage.api.Resource;
import org.rundeck.storage.api.Tree;
import org.rundeck.storage.conf.SelectiveTree;
import org.rundeck.storage.impl.DelegateResource;
import org.rundeck.storage.impl.DelegateTree;
import org.rundeck.storage.impl.ResourceBase;

public class SubPathTree<T extends ContentMeta>
extends DelegateTree<T>
implements SelectiveTree<T> {
    Path rootPath;
    private boolean fullPath;

    public SubPathTree(Tree<T> delegate, String rootPath, boolean fullPath) {
        this(delegate, PathUtil.asPath((String)rootPath), fullPath);
    }

    public SubPathTree(Tree<T> delegate, Path rootPath, boolean fullPath) {
        super(delegate);
        this.rootPath = rootPath;
        this.fullPath = fullPath;
    }

    @Override
    public Path getSubPath() {
        return this.rootPath;
    }

    private Path translatePathInternal(Path extpath) {
        return PathUtil.asPath((String)this.translatePathInternal(extpath.getPath()));
    }

    protected String translatePathInternal(String extpath) {
        if (this.fullPath) {
            return extpath;
        }
        return PathUtil.removePrefix((String)this.rootPath.getPath(), (String)extpath);
    }

    private Path translatePathExternal(Path intpath) {
        return PathUtil.asPath((String)this.translatePathExternal(intpath.getPath()));
    }

    protected String translatePathExternal(String intpath) {
        if (this.fullPath) {
            return intpath;
        }
        return PathUtil.appendPath((String)this.rootPath.getPath(), (String)intpath);
    }

    public boolean hasPath(Path path) {
        return this.isLocalRoot(path) || super.hasPath(this.translatePathInternal(path));
    }

    public boolean hasResource(Path path) {
        return !this.isLocalRoot(path) && super.hasResource(this.translatePathInternal(path));
    }

    public boolean hasDirectory(Path path) {
        return this.isLocalRoot(path) || super.hasDirectory(this.translatePathInternal(path));
    }

    protected boolean isLocalRoot(Path path) {
        return PathUtil.isRoot((String)PathUtil.removePrefix((String)this.rootPath.getPath(), (String)path.getPath()));
    }

    public Resource<T> getResource(Path path) {
        if (this.isLocalRoot(path)) {
            throw new IllegalArgumentException("No resource for path: " + path);
        }
        return this.translateResourceExternal(super.getResource(this.translatePathInternal(path)));
    }

    public Resource<T> getPath(Path path) {
        if (this.isLocalRoot(path) && !super.hasDirectory(this.translatePathInternal(path))) {
            return this.translateResourceExternal((Resource<T>)new ResourceBase(path, null, true));
        }
        return this.translateResourceExternal(super.getPath(this.translatePathInternal(path)));
    }

    public Set<Resource<T>> listDirectory(Path path) {
        if (this.isLocalRoot(path) && !super.hasDirectory(this.translatePathInternal(path))) {
            return Collections.emptySet();
        }
        return this.translateAllExternal(super.listDirectory(this.translatePathInternal(path)));
    }

    public Set<Resource<T>> listDirectorySubdirs(Path path) {
        if (this.isLocalRoot(path) && !super.hasDirectory(this.translatePathInternal(path))) {
            return Collections.emptySet();
        }
        return this.translateAllExternal(super.listDirectorySubdirs(this.translatePathInternal(path)));
    }

    public Set<Resource<T>> listDirectoryResources(Path path) {
        if (this.isLocalRoot(path) && !super.hasDirectory(this.translatePathInternal(path))) {
            return Collections.emptySet();
        }
        return this.translateAllExternal(super.listDirectoryResources(this.translatePathInternal(path)));
    }

    private Set<Resource<T>> translateAllExternal(Set<Resource<T>> internal) {
        HashSet<Resource<T>> resources = new HashSet<Resource<T>>();
        for (Resource<T> resource : internal) {
            resources.add(this.translateResourceExternal(resource));
        }
        return resources;
    }

    public boolean deleteResource(Path path) {
        return super.deleteResource(this.translatePathInternal(path));
    }

    private Resource<T> translateResourceExternal(Resource<T> resource) {
        if (this.fullPath) {
            return resource;
        }
        return new translatedResource<T>(resource, this.translatePathExternal(resource.getPath()));
    }

    public Resource<T> createResource(Path path, T data) {
        return this.translateResourceExternal(super.createResource(this.translatePathInternal(path), data));
    }

    public Resource<T> updateResource(Path path, T data) {
        return this.translateResourceExternal(super.updateResource(this.translatePathInternal(path), data));
    }

    static class translatedResource<T extends ContentMeta>
    extends DelegateResource<T> {
        Path newpath;

        translatedResource(Resource<T> delegate, Path newpath) {
            super(delegate);
            this.newpath = newpath;
        }

        public Path getPath() {
            return this.newpath;
        }
    }
}

