/*
 * Decompiled with CFR 0.152.
 */
package org.rundeck.storage.conf;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.rundeck.storage.api.ContentMeta;
import org.rundeck.storage.api.Path;
import org.rundeck.storage.api.PathUtil;
import org.rundeck.storage.api.Resource;
import org.rundeck.storage.api.Tree;
import org.rundeck.storage.conf.SelectiveTree;
import org.rundeck.storage.conf.SubPath;
import org.rundeck.storage.impl.DelegateTree;
import org.rundeck.storage.impl.ResourceBase;

public class TreeStack<T extends ContentMeta>
extends DelegateTree<T> {
    private List<? extends SelectiveTree<T>> treeHandlerList;

    public TreeStack(List<? extends SelectiveTree<T>> treeHandlerList, Tree<T> delegate) {
        super(delegate);
        this.validatePaths(treeHandlerList);
        this.treeHandlerList = this.sorted(treeHandlerList);
    }

    private void validatePaths(List<? extends SelectiveTree<T>> treeHandlerList) {
        HashSet<String> paths = new HashSet<String>();
        for (SelectiveTree<T> tSelectiveTree : treeHandlerList) {
            if (!paths.contains(tSelectiveTree.getSubPath().getPath())) {
                paths.add(tSelectiveTree.getSubPath().getPath());
                continue;
            }
            throw new IllegalArgumentException(String.format("Cannot create TreeStack: multiple subpaths defined for: %s", tSelectiveTree.getSubPath()));
        }
    }

    private List<? extends SelectiveTree<T>> sorted(List<? extends SelectiveTree<T>> treeHandlerList) {
        ArrayList<SelectiveTree<T>> list = new ArrayList<SelectiveTree<T>>(treeHandlerList);
        list.sort(new Comparator<SelectiveTree<T>>(){

            @Override
            public int compare(SelectiveTree<T> o1, SelectiveTree<T> o2) {
                return o2.getSubPath().getPath().length() - o1.getSubPath().getPath().length();
            }
        });
        return list;
    }

    public Resource<T> getResource(Path path) {
        return this.getContentStorage(path).getResource(path);
    }

    public Resource<T> getPath(Path path) {
        return this.getContentStorage(path).getPath(path);
    }

    public Set<Resource<T>> listDirectoryResources(Path path) {
        return this.getContentStorage(path).listDirectoryResources(path);
    }

    public Set<Resource<T>> listDirectory(Path path) {
        return this.merge(this.listDirectoryIfFound(path), this.listStackDirectory(path));
    }

    private Set<Resource<T>> listDirectoryIfFound(Path path) {
        if (this.getContentStorage(path).hasDirectory(path)) {
            return this.getContentStorage(path).listDirectory(path);
        }
        return null;
    }

    private Map<String, Resource<T>> asMap(Set<Resource<T>> matchedList) {
        HashMap<String, Resource<T>> map = new HashMap<String, Resource<T>>();
        for (Resource<T> tResource : matchedList) {
            map.put(tResource.getPath().getPath(), tResource);
        }
        return map;
    }

    private Set<Resource<T>> merge(Set<Resource<T>> ... matchedList) {
        HashMap<String, Resource<T>> merge = new HashMap<String, Resource<T>>();
        if (null != matchedList && matchedList.length > 0) {
            for (Set<Resource<T>> resources : matchedList) {
                if (resources == null || resources.size() <= 0) continue;
                merge.putAll(this.asMap(resources));
            }
        }
        return new HashSet<Resource<T>>(merge.values());
    }

    public Set<Resource<T>> listDirectorySubdirs(Path path) {
        return this.merge(this.listDirectoryIfFound(path), this.listStackDirectory(path));
    }

    public boolean deleteResource(Path path) {
        return this.getContentStorage(path).deleteResource(path);
    }

    public Resource<T> createResource(Path path, T content) {
        return this.getContentStorage(path).createResource(path, content);
    }

    public Resource<T> updateResource(Path path, T content) {
        return this.getContentStorage(path).updateResource(path, content);
    }

    public boolean hasPath(Path path) {
        return this.getContentStorage(path).hasPath(path);
    }

    public static boolean matchesPath(Path path, SelectiveTree<?> tree) {
        return path.equals(tree.getSubPath()) || PathUtil.hasRoot((Path)path, (Path)tree.getSubPath());
    }

    public static boolean hasParentPath(Path path, SubPath tree) {
        return path.equals(PathUtil.parentPath((Path)tree.getSubPath()));
    }

    private Set<Resource<T>> listStackDirectory(Path path) {
        HashSet<Resource<T>> merge = new HashSet<Resource<T>>();
        if (this.treeHandlerList.size() > 0) {
            for (SelectiveTree<T> treeHandler : this.treeHandlerList) {
                if (!PathUtil.hasRoot((Path)treeHandler.getSubPath(), (Path)path) || PathUtil.equals((Path)treeHandler.getSubPath(), (Path)path)) continue;
                String relativePath = PathUtil.removePrefix((String)path.getPath(), (String)treeHandler.getSubPath().getPath());
                String[] components = PathUtil.componentsFromPathString((String)relativePath);
                Path subpath = PathUtil.appendPath((Path)path, (String)components[0]);
                merge.add((Resource<T>)new ResourceBase(subpath, null, true));
            }
        }
        return merge;
    }

    private Tree<T> getContentStorage(Path path) {
        if (this.treeHandlerList.size() > 0) {
            for (SelectiveTree<T> treeHandler : this.treeHandlerList) {
                if (!TreeStack.matchesPath(path, treeHandler)) continue;
                return treeHandler;
            }
        }
        return this.getDelegate();
    }

    public boolean hasResource(Path path) {
        return this.getContentStorage(path).hasResource(path);
    }

    public boolean hasDirectory(Path path) {
        return this.getContentStorage(path).hasDirectory(path);
    }
}

