/*
 * Decompiled with CFR 0.152.
 */
package org.rundeck.storage.data.file;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;
import org.rundeck.storage.api.ContentFactory;
import org.rundeck.storage.api.ContentMeta;
import org.rundeck.storage.api.Path;
import org.rundeck.storage.api.Resource;
import org.rundeck.storage.api.StorageException;
import org.rundeck.storage.api.Tree;
import org.rundeck.storage.data.DataUtil;
import org.rundeck.storage.data.file.ContentMetaResource;
import org.rundeck.storage.data.file.FilepathMapper;
import org.rundeck.storage.data.file.LockingTree;
import org.rundeck.storage.data.file.MetadataMapper;

public class FileTree<T extends ContentMeta>
extends LockingTree<T>
implements Tree<T> {
    private ContentFactory<T> contentFactory;
    private FilepathMapper filepathMapper;
    private MetadataMapper metadataMapper;
    static Predicate<Resource> IsDirResourcePredicate = new Predicate<Resource>(){

        @Override
        public boolean apply(Resource resource) {
            return resource.isDirectory();
        }
    };
    static Predicate<Resource> IsResourcePredicate = FileTree.invert(IsDirResourcePredicate);

    public FileTree(ContentFactory<T> contentFactory, FilepathMapper filepathMapper, MetadataMapper metadataMapper) {
        this.contentFactory = contentFactory;
        this.filepathMapper = filepathMapper;
        this.metadataMapper = metadataMapper;
    }

    public boolean hasPath(Path path) {
        return this.filepathMapper.contentFileForPath(path).isFile() || this.filepathMapper.directoryForPath(path).isDirectory();
    }

    public boolean hasResource(Path path) {
        return this.filepathMapper.contentFileForPath(path).isFile() && this.filepathMapper.metadataFileFor(path).exists();
    }

    public boolean hasDirectory(Path path) {
        return this.filepathMapper.directoryForPath(path).isDirectory();
    }

    public Resource<T> getResource(Path path) {
        try {
            return this.loadResource(path, true);
        }
        catch (IOException e) {
            throw StorageException.readException((Path)path, (String)("Failed to read resource: " + path + ": " + e.getMessage()), (Throwable)e);
        }
    }

    public Resource<T> getPath(Path path) {
        try {
            return this.loadResource(path, false);
        }
        catch (IOException e) {
            throw StorageException.readException((Path)path, (String)("Failed to read resource: " + path + ": " + e.getMessage()), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Resource<T> loadResource(Path path, boolean requireFile) throws IOException {
        Object object = this.pathSynch(path);
        synchronized (object) {
            File datafile = this.filepathMapper.contentFileForPath(path);
            if (!datafile.exists()) {
                throw StorageException.readException((Path)path, (String)("Path does not exist: " + path));
            }
            if (requireFile && datafile.isDirectory()) {
                throw StorageException.readException((Path)path, (String)String.format("Failed to read resource at path: %s: is a directory", path));
            }
            boolean directory = datafile.isDirectory();
            if (!directory) {
                return new ContentMetaResource<T>(path, this.loader(path, datafile, this.filepathMapper.metadataFileFor(path)), directory);
            }
            return new ContentMetaResource<Object>(path, null, directory);
        }
    }

    private T loader(Path path, File datafile, File metafile) throws IOException {
        return (T)this.contentFactory.create(this.synchStream(path, DataUtil.lazyFileStream((File)datafile)), this.metadataMapper.readMetadata(metafile));
    }

    private Resource<T> storeResource(Path path, ContentMeta data) throws IOException {
        File datafile = this.filepathMapper.contentFileForPath(path);
        File metafile = this.filepathMapper.metadataFileFor(path);
        long len = this.writeContent(path, datafile, metafile, data);
        return new ContentMetaResource<T>(path, this.loader(path, datafile, metafile), false);
    }

    public Set<Resource<T>> listDirectoryResources(Path path) {
        return this.filterResources(path, IsResourcePredicate);
    }

    public Set<Resource<T>> listDirectory(Path path) {
        return this.filterResources(path, null);
    }

    public Set<Resource<T>> listDirectorySubdirs(Path path) {
        return this.filterResources(path, IsDirResourcePredicate);
    }

    static <T> Predicate<T> invert(final Predicate<T> pred) {
        return new Predicate<T>(){

            @Override
            public boolean apply(T resource) {
                return !pred.apply(resource);
            }
        };
    }

    private Set<Resource<T>> filterResources(Path path, Predicate<Resource> test) {
        if (!this.hasDirectory(path)) {
            throw StorageException.listException((Path)path, (String)("not a directory path: " + path));
        }
        File file = this.filepathMapper.directoryForPath(path);
        HashSet<Resource<T>> files = new HashSet<Resource<T>>();
        try {
            for (File file1 : file.listFiles()) {
                Resource<T> res = this.loadResource(this.filepathMapper.pathForContentFile(file1), false);
                if (null != test && !test.apply(res)) continue;
                files.add(res);
            }
        }
        catch (IOException e) {
            throw StorageException.listException((Path)path, (String)("Failed to list directory: " + path + ": " + e.getMessage()), (Throwable)e);
        }
        return files;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteResource(Path path) {
        boolean content = false;
        boolean meta = false;
        Object object = this.pathSynch(path);
        synchronized (object) {
            if (!this.hasResource(path)) {
                throw StorageException.deleteException((Path)path, (String)("Resource not found: " + path));
            }
            if (this.filepathMapper.contentFileForPath(path).exists()) {
                content = this.filepathMapper.contentFileForPath(path).delete();
            }
            if (this.filepathMapper.metadataFileFor(path).exists()) {
                meta = this.filepathMapper.metadataFileFor(path).delete();
            }
        }
        return content && meta;
    }

    public Resource<T> createResource(Path path, ContentMeta content) {
        Object object = this.pathSynch(path);
        synchronized (object) {
            if (this.hasResource(path)) {
                throw StorageException.createException((Path)path, (String)("Resource already exists: " + path));
            }
            try {
                return this.storeResource(path, content);
            }
            catch (IOException e) {
                throw StorageException.createException((Path)path, (String)("Failed to create resource: " + path + ": " + e.getMessage()), (Throwable)e);
            }
        }
    }

    public Resource<T> updateResource(Path path, ContentMeta content) {
        Object object = this.pathSynch(path);
        synchronized (object) {
            if (!this.hasResource(path)) {
                throw StorageException.updateException((Path)path, (String)("Resource does not exist: " + path));
            }
            try {
                return this.storeResource(path, content);
            }
            catch (IOException e) {
                e.printStackTrace();
                throw StorageException.updateException((Path)path, (String)("Failed to update resource: " + path + ": " + e.getMessage()), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long writeContent(Path path, File datafile, File metafile, ContentMeta input) throws IOException {
        Object object = this.pathSynch(path);
        synchronized (object) {
            long l;
            this.metadataMapper.writeMetadata(input.getMeta(), metafile);
            if (!datafile.getParentFile().exists()) {
                datafile.getParentFile().mkdirs();
            }
            FileOutputStream out = new FileOutputStream(datafile);
            try {
                l = input.writeContent((OutputStream)out);
            }
            catch (Throwable throwable) {
                out.close();
                throw throwable;
            }
            out.close();
            return l;
        }
    }

    static interface Predicate<T> {
        public boolean apply(T var1);
    }
}

