/*
 * Decompiled with CFR 0.152.
 */
package org.rundeck.storage.data.file;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.rundeck.storage.data.file.MetadataMapper;

public class JsonMetadataMapper
implements MetadataMapper {
    private ObjectMapper objectMapper;

    public JsonMetadataMapper() {
        this.objectMapper = new ObjectMapper();
    }

    public JsonMetadataMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    @Override
    public void writeMetadata(Map<String, String> meta, File destination) throws IOException {
        if (!destination.getParentFile().exists()) {
            destination.getParentFile().mkdirs();
        }
        HashMap<String, String> stringStringHashMap = new HashMap<String, String>();
        Map<String, String> map = meta;
        for (String o : map.keySet()) {
            if (null == o || null == map.get(o)) continue;
            stringStringHashMap.put(o.toString(), map.get(o).toString());
        }
        this.objectMapper.writeValue(destination, stringStringHashMap);
    }

    @Override
    public Map<String, String> readMetadata(File metadata) throws IOException {
        if (metadata.isFile()) {
            return (Map)this.objectMapper.readValue(metadata, Map.class);
        }
        return Collections.emptyMap();
    }
}

