/*
 * Decompiled with CFR 0.152.
 */
package org.rundeck.storage.data.file;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import org.rundeck.storage.api.ContentMeta;
import org.rundeck.storage.api.HasInputStream;
import org.rundeck.storage.api.Path;
import org.rundeck.storage.api.Tree;
import org.rundeck.storage.impl.StringToPathTree;

public abstract class LockingTree<T extends ContentMeta>
extends StringToPathTree<T>
implements Tree<T> {
    private ConcurrentHashMap<String, Object> locks = new ConcurrentHashMap(new WeakHashMap());

    protected Object pathSynch(Path path) {
        Object newref = new Object();
        Object oldref = this.locks.putIfAbsent(path.getPath(), newref);
        return null != oldref ? oldref : newref;
    }

    protected HasInputStream synchStream(final Path path, final HasInputStream stream) {
        return new HasInputStream(){

            public InputStream getInputStream() throws IOException {
                ByteArrayOutputStream bytes = new ByteArrayOutputStream();
                this.writeContent(bytes);
                return new ByteArrayInputStream(bytes.toByteArray());
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public long writeContent(OutputStream outputStream) throws IOException {
                Object object = LockingTree.this.pathSynch(path);
                synchronized (object) {
                    return stream.writeContent(outputStream);
                }
            }
        };
    }
}

