/*
 * Decompiled with CFR 0.152.
 */
package org.rundeck.storage.data.file;

import java.io.File;
import org.rundeck.storage.api.Path;
import org.rundeck.storage.data.file.FileTreeUtil;
import org.rundeck.storage.data.file.FilepathMapper;

public class DirectFilepathMapper
implements FilepathMapper {
    private File rootDir;
    private File contentDir;
    private File metaDir;

    public DirectFilepathMapper(File rootDir) {
        this.rootDir = rootDir;
        this.contentDir = new File(rootDir, "content");
        this.metaDir = new File(rootDir, "meta");
        if (!this.contentDir.exists() && !this.contentDir.mkdirs()) {
            throw new IllegalArgumentException("Unable to create root dir: " + rootDir);
        }
        if (!this.metaDir.exists() && !this.metaDir.mkdirs()) {
            throw new IllegalArgumentException("Unable to create meta dir: " + this.metaDir);
        }
    }

    private File withPath(Path path, File dir) {
        return new File(dir, path.getPath());
    }

    @Override
    public File contentFileForPath(Path path) {
        return this.withPath(path, this.contentDir);
    }

    @Override
    public File metadataFileFor(Path path) {
        return this.withPath(path, this.metaDir);
    }

    @Override
    public File directoryForPath(Path path) {
        return this.withPath(path, this.contentDir);
    }

    @Override
    public Path pathForContentFile(File datafile) {
        return FileTreeUtil.pathForFileInRoot(this.contentDir, datafile);
    }

    @Override
    public Path pathForMetadataFile(File metafile) {
        return FileTreeUtil.pathForFileInRoot(this.metaDir, metafile);
    }

    @Override
    public Path pathForDirectory(File directory) {
        return FileTreeUtil.pathForFileInRoot(this.contentDir, directory);
    }
}

