/*
 * Decompiled with CFR 0.152.
 */
package org.rundeck.storage.data.file;

import java.io.File;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Set;
import java.util.regex.Pattern;
import org.rundeck.storage.api.ContentFactory;
import org.rundeck.storage.api.ContentMeta;
import org.rundeck.storage.api.Path;
import org.rundeck.storage.api.PathUtil;
import org.rundeck.storage.data.file.DirectFilepathMapper;
import org.rundeck.storage.data.file.FileTree;
import org.rundeck.storage.data.file.JsonMetadataMapper;

public class FileTreeUtil {
    public static <T extends ContentMeta> FileTree<T> forRoot(File root, ContentFactory<T> factory) {
        return new FileTree<T>(factory, new DirectFilepathMapper(root), new JsonMetadataMapper());
    }

    public static <T extends ContentMeta> FileTree<T> forRoot(File root, ContentFactory<T> factory, Set<PosixFilePermission> filePermissions) {
        return new FileTree<T>(factory, new DirectFilepathMapper(root), new JsonMetadataMapper(), filePermissions);
    }

    public static Path pathForFileInRoot(File rootDir, File file) {
        String rootPath;
        String filePath = file.getAbsolutePath();
        if (!filePath.startsWith(rootPath = rootDir.getAbsolutePath())) {
            throw new IllegalArgumentException("not a file in the root directory: " + file);
        }
        return FileTreeUtil.pathForRelativeFilepath(filePath.substring(rootPath.length()));
    }

    public static Path pathForRelativeFilepath(String filepath) {
        return FileTreeUtil.pathForRelativeFilepath(filepath, File.separator);
    }

    public static Path pathForRelativeFilepath(String filepath, String separator) {
        String[] comps = filepath.split(Pattern.quote(separator));
        return PathUtil.pathFromComponents((String[])comps);
    }
}

