/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.utils;

import java.util.Map;
import org.apache.log4j.Logger;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.JobListener;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.listeners.JobListenerSupport;

public class GrailsServiceInjectorJobListener
extends JobListenerSupport {
    private static final transient Logger LOG = Logger.getLogger(GrailsServiceInjectorJobListener.class);
    private String name;
    private Map services;
    private Scheduler quartzScheduler;

    public GrailsServiceInjectorJobListener() {
    }

    public GrailsServiceInjectorJobListener(String name, Map services, Scheduler quartzScheduler) throws SchedulerException {
        this.name = name;
        this.services = services;
        this.setQuartzScheduler(quartzScheduler);
        LOG.info((Object)"GrailsServiceInjectorJobListener initialized, added to quartzScheduler");
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void jobToBeExecuted(JobExecutionContext context) {
        context.getJobDetail().getJobDataMap().putAll(this.services);
        LOG.info((Object)"services injected for job");
    }

    public void jobWasExecuted(JobExecutionContext context, JobExecutionException exception) {
    }

    public Map getServices() {
        return this.services;
    }

    public void setServices(Map services) {
        this.services = services;
    }

    public Scheduler getQuartzScheduler() {
        return this.quartzScheduler;
    }

    public void setQuartzScheduler(Scheduler quartzScheduler) throws SchedulerException {
        this.quartzScheduler = quartzScheduler;
        quartzScheduler.addJobListener((JobListener)this);
    }
}

