/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.plugins.quartz;

import grails.util.GrailsUtil;
import groovy.lang.Closure;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.groovy.grails.commons.AbstractInjectableGrailsClass;
import org.codehaus.groovy.grails.commons.GrailsClassUtils;
import org.codehaus.groovy.grails.plugins.quartz.GrailsTaskClass;
import org.codehaus.groovy.grails.plugins.quartz.GrailsTaskClassProperty;
import org.codehaus.groovy.grails.plugins.quartz.config.TriggersConfigBuilder;
import org.quartz.JobExecutionContext;

public class DefaultGrailsTaskClass
extends AbstractInjectableGrailsClass
implements GrailsTaskClass,
GrailsTaskClassProperty {
    public static final String JOB = "Job";
    private Map triggers = new HashMap();

    public DefaultGrailsTaskClass(Class clazz) {
        super(clazz, JOB);
        this.evaluateTriggers();
    }

    private void evaluateTriggers() {
        Closure triggersClosure = (Closure)GrailsClassUtils.getStaticPropertyValue((Class)this.getClazz(), (String)"triggers");
        TriggersConfigBuilder builder = new TriggersConfigBuilder(this.getFullName());
        if (triggersClosure != null) {
            builder.build((Object)triggersClosure);
            this.triggers = (Map)builder.getTriggers();
        } else if (this.isCronExpressionConfigured()) {
            GrailsUtil.deprecated((String)("You're using deprecated 'def cronExpression = ...' parameter in the " + this.getFullName() + ", use 'static triggers = { cron cronExpression: ...} instead."));
            this.triggers = builder.createEmbeddedCronTrigger(this.getStartDelay(), this.getCronExpression());
        } else {
            GrailsUtil.deprecated((String)("You're using deprecated 'def startDelay = ...; def timeout = ...' parameters in the" + this.getFullName() + ", use 'static triggers = { simple startDelay: ..., repeatInterval: ...} instead."));
            this.triggers = builder.createEmbeddedSimpleTrigger(this.getStartDelay(), this.getTimeout(), this.getRepeatCount());
        }
    }

    public void execute() {
        this.getMetaClass().invokeMethod(this.getReferenceInstance(), "execute", new Object[0]);
    }

    public void execute(JobExecutionContext context) {
        this.getMetaClass().invokeMethod(this.getReferenceInstance(), "execute", new Object[]{context});
    }

    public long getTimeout() {
        Object obj = this.getPropertyValue("timeout");
        if (obj == null) {
            return 60000L;
        }
        return ((Number)obj).longValue();
    }

    public long getStartDelay() {
        Object obj = this.getPropertyValue("startDelay");
        if (obj == null) {
            return 0L;
        }
        return ((Number)obj).longValue();
    }

    public int getRepeatCount() {
        Object obj = this.getPropertyValue("repeatCount");
        if (obj == null) {
            return -1;
        }
        return ((Number)obj).intValue();
    }

    public String getCronExpression() {
        String cronExpression = (String)this.getPropertyOrStaticPropertyOrFieldValue("cronExpression", String.class);
        if (cronExpression == null || "".equals(cronExpression)) {
            return "0 0 6 * * ?";
        }
        return cronExpression;
    }

    public String getGroup() {
        String group = (String)this.getPropertyOrStaticPropertyOrFieldValue("group", String.class);
        if (group == null || "".equals(group)) {
            return "GRAILS_JOBS";
        }
        return group;
    }

    public boolean isCronExpressionConfigured() {
        String cronExpression = (String)this.getPropertyOrStaticPropertyOrFieldValue("cronExpression", String.class);
        return cronExpression != null;
    }

    public boolean isConcurrent() {
        Boolean concurrent = (Boolean)this.getPropertyValue("concurrent", Boolean.class);
        return concurrent == null ? true : concurrent;
    }

    public boolean isSessionRequired() {
        Boolean sessionRequired = (Boolean)this.getPropertyValue("sessionRequired", Boolean.class);
        return sessionRequired == null ? true : sessionRequired;
    }

    public boolean getVolatility() {
        Boolean volatility = (Boolean)this.getPropertyValue("volatility", Boolean.class);
        return volatility == null ? true : volatility;
    }

    public boolean getDurability() {
        Boolean durability = (Boolean)this.getPropertyValue("durability", Boolean.class);
        return durability == null ? true : durability;
    }

    public boolean getRequestsRecovery() {
        Boolean requestsRecovery = (Boolean)this.getPropertyValue("requestsRecovery", Boolean.class);
        return requestsRecovery == null ? false : requestsRecovery;
    }

    public Map getTriggers() {
        return this.triggers;
    }
}

