/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.plugins.quartz.listeners;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.FlushMode;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.listeners.JobListenerSupport;
import org.springframework.orm.hibernate3.SessionFactoryUtils;
import org.springframework.orm.hibernate3.SessionHolder;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class SessionBinderJobListener
extends JobListenerSupport {
    private static final transient Log LOG = LogFactory.getLog(SessionBinderJobListener.class);
    public static final String NAME = "sessionBinderListener";
    private SessionFactory sessionFactory;

    public String getName() {
        return NAME;
    }

    public void jobToBeExecuted(JobExecutionContext context) {
        Session session = SessionFactoryUtils.getSession((SessionFactory)this.sessionFactory, (boolean)true);
        session.setFlushMode(FlushMode.AUTO);
        TransactionSynchronizationManager.bindResource((Object)this.sessionFactory, (Object)new SessionHolder(session));
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Hibernate Session is bounded to Job thread");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void jobWasExecuted(JobExecutionContext context, JobExecutionException exception) {
        SessionHolder sessionHolder = (SessionHolder)TransactionSynchronizationManager.getResource((Object)this.sessionFactory);
        try {
            if (!FlushMode.MANUAL.equals(sessionHolder.getSession().getFlushMode())) {
                sessionHolder.getSession().flush();
            }
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)"Cannot flush Hibernate Sesssion, error will be ignored", (Throwable)e);
            }
        }
        finally {
            TransactionSynchronizationManager.unbindResource((Object)this.sessionFactory);
            SessionFactoryUtils.closeSession((Session)sessionHolder.getSession());
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Hibernate Session is unbounded from Job thread and closed");
            }
        }
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }
}

