/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.plugins.quartz;

import org.codehaus.groovy.grails.plugins.quartz.GrailsJobFactory;
import org.quartz.JobDetail;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Required;

public class JobDetailFactoryBean
implements FactoryBean,
InitializingBean {
    public static final transient String JOB_NAME_PARAMETER = "org.grails.plugins.quartz.grailsJobName";
    private String name;
    private String group;
    private boolean concurrent;
    private boolean volatility;
    private boolean durability;
    private boolean requestsRecovery;
    private String[] jobListenerNames;
    private JobDetail jobDetail;

    public void setName(String name) {
        this.name = name;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public void setJobListenerNames(String[] names) {
        this.jobListenerNames = names;
    }

    @Required
    public void setConcurrent(boolean concurrent) {
        this.concurrent = concurrent;
    }

    @Required
    public void setVolatility(boolean volatility) {
        this.volatility = volatility;
    }

    @Required
    public void setDurability(boolean durability) {
        this.durability = durability;
    }

    @Required
    public void setRequestsRecovery(boolean requestsRecovery) {
        this.requestsRecovery = requestsRecovery;
    }

    public void afterPropertiesSet() {
        if (this.name == null) {
            throw new IllegalStateException("name is required");
        }
        if (this.group == null) {
            throw new IllegalStateException("group is required");
        }
        Class jobClass = this.concurrent ? GrailsJobFactory.GrailsTaskClassJob.class : GrailsJobFactory.StatefulGrailsTaskClassJob.class;
        this.jobDetail = new JobDetail(this.name, this.group, jobClass);
        this.jobDetail.getJobDataMap().put(JOB_NAME_PARAMETER, this.name);
        this.jobDetail.setDurability(this.durability);
        this.jobDetail.setVolatility(this.volatility);
        this.jobDetail.setRequestsRecovery(this.requestsRecovery);
        if (this.jobListenerNames != null) {
            for (int i = 0; i < this.jobListenerNames.length; ++i) {
                this.jobDetail.addJobListener(this.jobListenerNames[i]);
            }
        }
    }

    public Object getObject() {
        return this.jobDetail;
    }

    public Class getObjectType() {
        return JobDetail.class;
    }

    public boolean isSingleton() {
        return true;
    }
}

