/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.plugins.quartz;

import java.beans.PropertyEditor;
import java.text.ParseException;
import java.util.Date;
import java.util.Map;
import org.codehaus.groovy.grails.plugins.quartz.StringEditor;
import org.quartz.JobDetail;
import org.quartz.Trigger;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;

public class CustomTriggerFactoryBean
implements FactoryBean,
InitializingBean {
    private Class<Trigger> triggerClass;
    private Trigger customTrigger;
    private JobDetail jobDetail;
    private Map triggerAttributes;

    public void afterPropertiesSet() throws ParseException {
        this.customTrigger = (Trigger)BeanUtils.instantiateClass((Class)this.triggerClass);
        if (this.triggerAttributes.containsKey("startDelay")) {
            Number startDelay = (Number)this.triggerAttributes.remove("startDelay");
            this.customTrigger.setStartTime(new Date(System.currentTimeMillis() + startDelay.longValue()));
        }
        if (this.jobDetail != null) {
            this.customTrigger.setJobName(this.jobDetail.getName());
            this.customTrigger.setJobGroup(this.jobDetail.getGroup());
        }
        BeanWrapper customTriggerWrapper = PropertyAccessorFactory.forBeanPropertyAccess((Object)this.customTrigger);
        customTriggerWrapper.registerCustomEditor(String.class, (PropertyEditor)new StringEditor());
        customTriggerWrapper.setPropertyValues(this.triggerAttributes);
    }

    public Object getObject() throws Exception {
        return this.customTrigger;
    }

    public Class getObjectType() {
        return this.triggerClass;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setJobDetail(JobDetail jobDetail) {
        this.jobDetail = jobDetail;
    }

    public void setTriggerClass(Class<Trigger> triggerClass) {
        this.triggerClass = triggerClass;
    }

    public void setTriggerAttributes(Map triggerAttributes) {
        this.triggerAttributes = triggerAttributes;
    }
}

