/*
 * Decompiled with CFR 0.152.
 */
package grails.plugin.cache.web.filter;

import grails.plugin.cache.web.filter.WebKeyGenerator;
import javax.servlet.http.HttpServletRequest;
import org.codehaus.groovy.grails.web.util.WebUtils;
import org.springframework.util.StringUtils;

public class DefaultWebKeyGenerator
implements WebKeyGenerator {
    protected boolean supportAjax = false;
    public static final String X_REQUESTED_WITH = "X-Requested-With";

    public String generate(HttpServletRequest request) {
        String requestedWith;
        String uri = WebUtils.getForwardURI((HttpServletRequest)request);
        StringBuilder key = new StringBuilder();
        key.append(request.getServerName().toLowerCase()).append(':');
        key.append(request.getMethod().toUpperCase());
        String format = WebUtils.getFormatFromURI((String)uri);
        if (StringUtils.hasLength((String)format) && !"all".equals(format)) {
            key.append(":format:").append(format);
        }
        if (this.supportAjax && StringUtils.hasLength((String)(requestedWith = request.getHeader(X_REQUESTED_WITH)))) {
            key.append(':').append(X_REQUESTED_WITH).append(':').append(requestedWith);
        }
        key.append(':').append(uri);
        if (StringUtils.hasLength((String)request.getQueryString())) {
            key.append('?').append(request.getQueryString());
        }
        return key.toString();
    }

    public void setSupportAjax(boolean support) {
        this.supportAjax = support;
    }
}

