/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.server.projects;

import com.dtolabs.rundeck.core.authorization.Authorization;
import com.dtolabs.rundeck.core.common.INodeSet;
import com.dtolabs.rundeck.core.common.IProjectNodes;
import com.dtolabs.rundeck.core.common.IRundeckProject;
import com.dtolabs.rundeck.core.common.NodeFileParserException;
import com.dtolabs.rundeck.core.common.UpdateUtils;
import com.dtolabs.rundeck.core.storage.ResourceMeta;
import com.dtolabs.rundeck.core.utils.IPropertyLookup;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import rundeck.services.ProjectManagerService;

public class RundeckProject
implements IRundeckProject {
    private String name;
    private ProjectManagerService projectService;
    private IProjectNodes projectNodes;
    private Authorization projectAuthorization;
    private Date lastModifiedTime;
    private IPropertyLookup lookup;
    private IPropertyLookup projectLookup;

    public RundeckProject(String name, IPropertyLookup lookup, IPropertyLookup projectLookup, ProjectManagerService projectService, Date lastModifiedTime) {
        this.name = name;
        this.setLookup(lookup);
        this.setProjectLookup(projectLookup);
        this.projectService = projectService;
        this.setLastModifiedTime(lastModifiedTime);
    }

    public String getName() {
        return this.name;
    }

    public String getProperty(String property) {
        return this.getLookup().getProperty(property);
    }

    public List<Map<String, Object>> listResourceModelConfigurations() {
        return this.projectNodes.listResourceModelConfigurations();
    }

    public INodeSet getNodeSet() throws NodeFileParserException {
        return this.projectNodes.getNodeSet();
    }

    public boolean hasProperty(String key) {
        return this.getProperties().containsKey(key);
    }

    public Map<String, String> getProperties() {
        HashMap<String, String> result = new HashMap<String, String>();
        if (null != this.getLookup()) {
            for (Object key : this.getLookup().getPropertiesMap().keySet()) {
                result.put(key.toString(), this.getLookup().getProperty(key.toString()));
            }
        }
        return result;
    }

    public Map<String, String> getProjectProperties() {
        HashMap<String, String> result = new HashMap<String, String>();
        if (null != this.getProjectLookup()) {
            for (Object key : this.getProjectLookup().getPropertiesMap().keySet()) {
                result.put(key.toString(), this.getProjectLookup().getProperty(key.toString()));
            }
        }
        return result;
    }

    public void mergeProjectProperties(Properties properties, Set<String> removePrefixes) {
        this.projectService.mergeProjectProperties(this, properties, removePrefixes);
    }

    public void setProjectProperties(Properties properties) {
        this.projectService.setProjectProperties(this, properties);
    }

    public boolean existsFileResource(String path) {
        return this.projectService.existsProjectFileResource(this.name, path);
    }

    public boolean existsDirResource(String path) {
        return this.projectService.existsProjectDirResource(this.name, path);
    }

    public List<String> listDirPaths(String path) {
        return this.projectService.listProjectDirPaths(this.name, path);
    }

    public boolean deleteFileResource(String path) {
        return this.projectService.deleteProjectFileResource(this.name, path);
    }

    public long storeFileResource(String path, InputStream input) throws IOException {
        return ((ResourceMeta)this.projectService.writeProjectFileResource(this.name, path, input, new HashMap()).getContents()).getContentLength();
    }

    public long loadFileResource(String path, OutputStream output) throws IOException {
        return this.projectService.readProjectFileResource(this.name, path, output);
    }

    public Date getConfigLastModifiedTime() {
        return this.getLastModifiedTime();
    }

    public boolean updateNodesResourceFile() throws UpdateUtils.UpdateException {
        return this.projectNodes.updateNodesResourceFile(this.projectService.getNodesResourceFilePath((IRundeckProject)this));
    }

    public void updateNodesResourceFileFromUrl(String providerURL, String username, String password) throws UpdateUtils.UpdateException {
        this.projectNodes.updateNodesResourceFileFromUrl(providerURL, username, password, this.projectService.getNodesResourceFilePath((IRundeckProject)this));
    }

    public void updateNodesResourceFile(INodeSet nodeset) throws UpdateUtils.UpdateException {
        this.projectNodes.updateNodesResourceFile(nodeset, this.projectService.getNodesResourceFilePath((IRundeckProject)this));
    }

    public IProjectNodes getProjectNodes() {
        return this.projectNodes;
    }

    public void setProjectNodes(IProjectNodes projectNodes) {
        this.projectNodes = projectNodes;
    }

    public String toString() {
        return "RundeckProject{name='" + this.name + '\'' + ", lastModifiedTime=" + this.getLastModifiedTime() + '}';
    }

    public IPropertyLookup getLookup() {
        return this.lookup;
    }

    public void setLookup(IPropertyLookup lookup) {
        this.lookup = lookup;
    }

    public IPropertyLookup getProjectLookup() {
        return this.projectLookup;
    }

    public void setProjectLookup(IPropertyLookup projectLookup) {
        this.projectLookup = projectLookup;
    }

    public Date getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    public void setLastModifiedTime(Date lastModifiedTime) {
        this.lastModifiedTime = lastModifiedTime;
    }

    public Authorization getProjectAuthorization() {
        return this.projectService.getProjectAuthorization(this.name);
    }
}

