/*
 * Decompiled with CFR 0.152.
 */
package grails.plugin.cache.web.filter;

import grails.plugin.cache.web.filter.CacheExpressionRootObject;
import grails.plugin.cache.web.filter.LazyParamAwareEvaluationContext;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.cache.Cache;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;

public class ExpressionEvaluator {
    protected SpelExpressionParser parser = new SpelExpressionParser();
    protected ParameterNameDiscoverer paramNameDiscoverer = new LocalVariableTableParameterNameDiscoverer();
    protected Map<String, Expression> conditionCache = new ConcurrentHashMap();
    protected Map<String, Expression> keyCache = new ConcurrentHashMap();
    protected Map<String, Method> targetMethodCache = new ConcurrentHashMap();

    public EvaluationContext createEvaluationContext(Collection<Cache> caches, Method method, Object[] args, Class<?> targetClass) {
        CacheExpressionRootObject rootObject = new CacheExpressionRootObject(caches, method, targetClass);
        return new LazyParamAwareEvaluationContext((Object)rootObject, this.paramNameDiscoverer, method, args, targetClass, this.targetMethodCache);
    }

    public boolean condition(String conditionExpression, Method method, EvaluationContext evalContext) {
        String key = this.toString(method, conditionExpression);
        Expression condExp = (Expression)this.conditionCache.get(key);
        if (condExp == null) {
            condExp = this.parser.parseExpression(conditionExpression);
            this.conditionCache.put(key, condExp);
        }
        return (Boolean)condExp.getValue(evalContext, Boolean.TYPE);
    }

    public Object key(String keyExpression, Method method, EvaluationContext evalContext) {
        String key = this.toString(method, keyExpression);
        Expression keyExp = (Expression)this.keyCache.get(key);
        if (keyExp == null) {
            keyExp = this.parser.parseExpression(keyExpression);
            this.keyCache.put(key, keyExp);
        }
        return keyExp.getValue(evalContext);
    }

    protected String toString(Method method, String expression) {
        return method.getDeclaringClass().getName() + '#' + method + '#' + expression;
    }
}

