/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.grails.profiler;

import com.linkedin.grails.profiler.ProfilerAppender;
import com.linkedin.grails.profiler.ProfilerLog;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.util.Assert;

public class DefaultProfilerLog
implements ProfilerLog,
ApplicationContextAware {
    private ApplicationContext applicationContext;
    private List<String> appenderNames;
    private ThreadLocal<String> profilingLabel = new ThreadLocal();
    private ThreadLocal<List<ProfilerAppender>> appenders = new ThreadLocal();

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setAppenderNames(List<String> appenderNames) {
        this.appenderNames = appenderNames;
    }

    public void startProfiling(String label) {
        Assert.notNull((Object)label, (String)"Label cannot be null");
        if (this.appenders.get() == null) {
            ArrayList<ProfilerAppender> localAppenders = new ArrayList<ProfilerAppender>(this.appenderNames.size());
            for (String appenderName : this.appenderNames) {
                ProfilerAppender appender = (ProfilerAppender)this.applicationContext.getBean(appenderName);
                localAppenders.add(appender);
            }
            this.appenders.set(localAppenders);
        }
        this.profilingLabel.set(label);
    }

    public void stopProfiling() {
        this.appenders.set(null);
        this.profilingLabel.set(null);
    }

    public boolean isProfiling() {
        return this.profilingLabel.get() != null;
    }

    public void logEntry(Class<?> clazz, String name) {
        if (!this.isProfiling()) {
            return;
        }
        long entryTime = System.currentTimeMillis();
        for (ProfilerAppender appender : (List)this.appenders.get()) {
            appender.logEntry((String)this.profilingLabel.get(), clazz, name, entryTime);
        }
    }

    public void logExit(Class<?> clazz, String name) {
        if (!this.isProfiling()) {
            return;
        }
        long exitTime = System.currentTimeMillis();
        for (ProfilerAppender appender : (List)this.appenders.get()) {
            appender.logExit((String)this.profilingLabel.get(), clazz, name, exitTime);
        }
    }
}

