/*
 * Decompiled with CFR 0.152.
 */
package grails.plugin.cache.web;

import java.lang.reflect.Method;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import org.codehaus.groovy.grails.commons.GrailsControllerClass;
import org.codehaus.groovy.grails.web.servlet.mvc.GrailsParameterMap;
import org.codehaus.groovy.grails.web.servlet.mvc.GrailsWebRequest;
import org.springframework.util.StringUtils;

public class ContentCacheParameters {
    protected final GrailsWebRequest grailsWebRequest;
    protected GrailsControllerClass controllerClass;
    protected Method method;
    protected String actionName;

    public ContentCacheParameters(GrailsWebRequest request) {
        this.grailsWebRequest = request;
        this.initController();
        this.initAction();
    }

    public String getControllerName() {
        return this.grailsWebRequest.getControllerName();
    }

    public String getActionName() {
        if (this.actionName == null) {
            this.actionName = this.grailsWebRequest.getActionName();
            if (!StringUtils.hasLength((String)this.actionName) && this.controllerClass != null) {
                this.actionName = this.controllerClass.getDefaultAction();
            }
        }
        return this.actionName;
    }

    public Method getMethod() {
        return this.method;
    }

    public GrailsParameterMap getParams() {
        return this.grailsWebRequest.getParams();
    }

    public HttpServletRequest getRequest() {
        return this.grailsWebRequest.getCurrentRequest();
    }

    public Class<?> getControllerClass() {
        return this.controllerClass == null ? null : this.controllerClass.getClazz();
    }

    protected void initController() {
        this.controllerClass = (GrailsControllerClass)GrailsWebRequest.lookupApplication().getArtefactForFeature("Controller", (Object)('/' + this.getControllerName()));
    }

    protected void initAction() {
        if (this.controllerClass == null) {
            return;
        }
        this.getActionName();
        ArrayList<Method> matches = new ArrayList<Method>();
        for (Method m : this.controllerClass.getClazz().getMethods()) {
            if (!m.getName().equals(this.actionName)) continue;
            matches.add(m);
        }
        if (matches.size() == 1) {
            this.method = (Method)matches.get(0);
        } else if (matches.size() > 1) {
            this.method = ((Method)matches.get(0)).getParameterTypes().length > 0 ? (Method)matches.get(0) : (Method)matches.get(1);
        }
        if (this.method == null) {
            // empty if block
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder("[");
        buffer.append("controller=").append(this.getControllerName());
        if (this.controllerClass == null) {
            buffer.append("?");
        }
        buffer.append(", action=").append(this.getActionName());
        if (this.method == null) {
            buffer.append("?");
        }
        buffer.append("]");
        return buffer.toString();
    }
}

