/*
 * Decompiled with CFR 0.152.
 */
package grails.plugins.quartz.listeners;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.grails.support.PersistenceContextInterceptor;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.listeners.JobListenerSupport;

public class SessionBinderJobListener
extends JobListenerSupport {
    private static final transient Log LOG = LogFactory.getLog(SessionBinderJobListener.class);
    public static final String NAME = "sessionBinderListener";
    private PersistenceContextInterceptor persistenceInterceptor;

    public String getName() {
        return NAME;
    }

    public PersistenceContextInterceptor getPersistenceInterceptor() {
        return this.persistenceInterceptor;
    }

    public void setPersistenceInterceptor(PersistenceContextInterceptor persistenceInterceptor) {
        this.persistenceInterceptor = persistenceInterceptor;
    }

    public void jobToBeExecuted(JobExecutionContext context) {
        if (this.persistenceInterceptor != null) {
            this.persistenceInterceptor.init();
            LOG.debug((Object)"Persistence session is opened.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void jobWasExecuted(JobExecutionContext context, JobExecutionException exception) {
        if (this.persistenceInterceptor != null) {
            try {
                this.persistenceInterceptor.flush();
                this.persistenceInterceptor.clear();
                LOG.debug((Object)"Persistence session is flushed.");
            }
            catch (Exception e) {
                LOG.error((Object)("Failed to flush session after job: " + context.getJobDetail().getDescription()), (Throwable)e);
            }
            finally {
                try {
                    this.persistenceInterceptor.destroy();
                }
                catch (Exception e) {
                    LOG.error((Object)("Failed to finalize session after job: " + context.getJobDetail().getDescription()), (Throwable)e);
                }
            }
        }
    }
}

