/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.grails.profiler;

import com.linkedin.grails.profiler.ProfilerLog;
import groovy.lang.Closure;

public class ProfilingClosureWrapper
extends Closure {
    private static final long serialVersionUID = 1L;
    private Closure target;
    private ProfilerLog profiler;
    private String name;
    private Class<?> targetClass;

    public ProfilingClosureWrapper(Class<?> targetClass, Closure closure, ProfilerLog profiler, String name) {
        super(closure.getDelegate(), closure.getDelegate());
        this.target = closure;
        this.profiler = profiler;
        this.name = name;
        this.targetClass = targetClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object call(Object ... objects) {
        this.profiler.logEntry(this.targetClass, this.name);
        try {
            Object object = this.target.call(objects);
            return object;
        }
        finally {
            this.profiler.logExit(this.targetClass, this.name);
        }
    }

    public boolean equals(Object obj) {
        return this == obj || this.target == obj;
    }

    public int hashCode() {
        return this.target.hashCode();
    }

    public Closure curry(Object ... objects) {
        return new ProfilingClosureWrapper(this.targetClass, this.target.curry(objects), this.profiler, this.name);
    }

    public boolean isCase(Object o) {
        return this.target.isCase(o);
    }

    public Closure asWritable() {
        return this.target.asWritable();
    }

    public Object getProperty(String property) {
        return this.target.getProperty(property);
    }

    public void setProperty(String s, Object o) {
        this.target.setProperty(s, o);
    }

    public int getMaximumNumberOfParameters() {
        return this.target.getMaximumNumberOfParameters();
    }

    public Class<?>[] getParameterTypes() {
        return this.target.getParameterTypes();
    }

    public Object getDelegate() {
        return this.target.getDelegate();
    }

    public void setDelegate(Object o) {
        this.target.setDelegate(o);
    }

    public int getDirective() {
        return this.target.getDirective();
    }

    public void setDirective(int i) {
        this.target.setDirective(i);
    }

    public int getResolveStrategy() {
        return this.target.getResolveStrategy();
    }

    public void setResolveStrategy(int i) {
        this.target.setResolveStrategy(i);
    }
}

