/*
 * Decompiled with CFR 0.152.
 */
package rundeck.services;

import com.codahale.metrics.MetricRegistry;
import com.dtolabs.rundeck.core.authorization.AclsUtil;
import com.dtolabs.rundeck.core.authorization.Authorization;
import com.dtolabs.rundeck.core.authorization.AuthorizationUtil;
import com.dtolabs.rundeck.core.authorization.providers.CacheableYamlSource;
import com.dtolabs.rundeck.core.authorization.providers.Policies;
import com.dtolabs.rundeck.core.authorization.providers.PoliciesCache;
import com.dtolabs.rundeck.core.authorization.providers.YamlProvider;
import com.dtolabs.rundeck.core.common.IRundeckProject;
import com.dtolabs.rundeck.core.common.IRundeckProjectConfig;
import com.dtolabs.rundeck.core.common.ProjectManager;
import com.dtolabs.rundeck.core.common.ProjectNodeSupport;
import com.dtolabs.rundeck.core.storage.ResourceMeta;
import com.dtolabs.rundeck.core.storage.StorageTree;
import com.dtolabs.rundeck.core.storage.StorageUtil;
import com.dtolabs.rundeck.core.utils.IPropertyLookup;
import com.dtolabs.rundeck.core.utils.PropertyLookup;
import com.dtolabs.rundeck.server.projects.ProjectFile;
import com.dtolabs.rundeck.server.projects.ProjectInfo;
import com.dtolabs.rundeck.server.projects.RundeckProject;
import com.dtolabs.rundeck.server.projects.RundeckProjectConfig;
import com.google.common.base.Optional;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.LoadingCache;
import grails.transaction.Transactional;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.SoftReference;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.commons.fileupload.util.Streams;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.grails.orm.support.GrailsTransactionTemplate;
import org.codehaus.groovy.grails.orm.support.TransactionManagerAware;
import org.codehaus.groovy.grails.transaction.GrailsTransactionAttribute;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.rundeck.storage.api.PathUtil;
import org.rundeck.storage.api.Resource;
import org.rundeck.storage.data.DataUtil;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import rundeck.Project;
import rundeck.Storage;
import rundeck.services.ConfigurationService;
import rundeck.services.FrameworkService;
import rundeck.services.ProjectManagerService;
import rundeck.services.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
@Transactional
public class ProjectManagerService
implements ProjectManager,
ApplicationContextAware,
InitializingBean,
GroovyObject,
TransactionManagerAware {
    public static final String ETC_PROJECT_PROPERTIES_PATH = "/etc/project.properties";
    public static final String MIME_TYPE_PROJECT_PROPERTIES = "text/x-java-properties";
    public static final String DEFAULT_PROJECT_CACHE_SPEC = "expireAfterAccess=10m,refreshAfterWrite=1m";
    public static final String DEFAULT_ACL_CACHE_SPEC = "refreshAfterWrite=2m";
    public static final String DEFAULT_FILE_CACHE_SPEC = "refreshAfterWrite=10m";
    private FrameworkService frameworkService;
    private StorageTree rundeckConfigStorageTree;
    private ApplicationContext applicationContext;
    private ConfigurationService configurationService;
    private Object grailsApplication;
    private Object metricService;
    private Object nodeService;
    private ExecutorService executor;
    private LoadingCache<String, IRundeckProject> projectCache;
    private LoadingCache<ProjectFile, CacheableYamlSource> sourceCache;
    private LoadingCache<ProjectFile, Optional<String>> fileCache;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    PlatformTransactionManager transactionManager;
    private static Log log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;
    public static /* synthetic */ long __timeStamp;
    public static /* synthetic */ long __timeStamp__239_neverHappen1460763730918;
    private static /* synthetic */ SoftReference $callSiteArray;

    public ProjectManagerService() {
        MetaClass metaClass;
        CallSite[] callSiteArray = ProjectManagerService.$getCallSiteArray();
        Object object = callSiteArray[0].call(Executors.class, (Object)2);
        this.executor = (ExecutorService)ScriptBytecodeAdapter.castToType((Object)object, ExecutorService.class);
        Object object2 = callSiteArray[1].call(callSiteArray[2].call(callSiteArray[3].call(callSiteArray[4].call(CacheBuilder.class), (Object)10, callSiteArray[5].callGetProperty(TimeUnit.class)), (Object)1, callSiteArray[6].callGetProperty(TimeUnit.class)), (Object)new 1(this));
        this.projectCache = (LoadingCache)ScriptBytecodeAdapter.castToType((Object)object2, LoadingCache.class);
        Object object3 = callSiteArray[7].call(callSiteArray[8].call(callSiteArray[9].call(CacheBuilder.class), (Object)2, callSiteArray[10].callGetProperty(TimeUnit.class)), (Object)new 7(this));
        this.sourceCache = (LoadingCache)ScriptBytecodeAdapter.castToType((Object)object3, LoadingCache.class);
        Object object4 = callSiteArray[11].call(callSiteArray[12].call(callSiteArray[13].call(CacheBuilder.class), (Object)5, callSiteArray[14].callGetProperty(TimeUnit.class)), (Object)new 8(this));
        this.fileCache = (LoadingCache)ScriptBytecodeAdapter.castToType((Object)object4, LoadingCache.class);
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    private StorageTree getStorage() {
        CallSite[] callSiteArray = ProjectManagerService.$getCallSiteArray();
        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (ScriptBytecodeAdapter.compareEqual(null, (Object)this.rundeckConfigStorageTree)) {
                Object object = callSiteArray[15].call((Object)this.applicationContext, (Object)"rundeckConfigStorageTree", StorageTree.class);
                this.rundeckConfigStorageTree = (StorageTree)ScriptBytecodeAdapter.castToType((Object)object, StorageTree.class);
            }
        } else if (ScriptBytecodeAdapter.compareEqual(null, (Object)this.rundeckConfigStorageTree)) {
            Object object = callSiteArray[16].call((Object)this.applicationContext, (Object)"rundeckConfigStorageTree", StorageTree.class);
            this.rundeckConfigStorageTree = (StorageTree)ScriptBytecodeAdapter.castToType((Object)object, StorageTree.class);
        }
        return this.rundeckConfigStorageTree;
    }

    public void setStorage(StorageTree tree) {
        StorageTree storageTree;
        CallSite[] callSiteArray = ProjectManagerService.$getCallSiteArray();
        this.rundeckConfigStorageTree = storageTree = tree;
    }

    public Collection<IRundeckProject> listFrameworkProjects() {
        CallSite[] callSiteArray = ProjectManagerService.$getCallSiteArray();
        GrailsTransactionAttribute $transactionAttribute = (GrailsTransactionAttribute)ScriptBytecodeAdapter.castToType((Object)callSiteArray[17].callConstructor(GrailsTransactionAttribute.class), GrailsTransactionAttribute.class);
        GrailsTransactionTemplate $transactionTemplate = (GrailsTransactionTemplate)ScriptBytecodeAdapter.castToType((Object)callSiteArray[18].callConstructor(GrailsTransactionTemplate.class, (Object)this.transactionManager, (Object)$transactionAttribute), GrailsTransactionTemplate.class);
        return (Collection)ScriptBytecodeAdapter.castToType((Object)$transactionTemplate.execute((Closure)new /* Unavailable Anonymous Inner Class!! */), Collection.class);
    }

    public Collection<String> listFrameworkProjectNames() {
        CallSite[] callSiteArray = ProjectManagerService.$getCallSiteArray();
        GrailsTransactionAttribute $transactionAttribute = (GrailsTransactionAttribute)ScriptBytecodeAdapter.castToType((Object)callSiteArray[19].callConstructor(GrailsTransactionAttribute.class), GrailsTransactionAttribute.class);
        GrailsTransactionTemplate $transactionTemplate = (GrailsTransactionTemplate)ScriptBytecodeAdapter.castToType((Object)callSiteArray[20].callConstructor(GrailsTransactionTemplate.class, (Object)this.transactionManager, (Object)$transactionAttribute), GrailsTransactionTemplate.class);
        return (Collection)ScriptBytecodeAdapter.castToType((Object)$transactionTemplate.execute((Closure)new /* Unavailable Anonymous Inner Class!! */), Collection.class);
    }

    public IRundeckProject getFrameworkProject(String name) {
        Reference name2 = new Reference((Object)name);
        CallSite[] callSiteArray = ProjectManagerService.$getCallSiteArray();
        GrailsTransactionAttribute $transactionAttribute = (GrailsTransactionAttribute)ScriptBytecodeAdapter.castToType((Object)callSiteArray[21].callConstructor(GrailsTransactionAttribute.class), GrailsTransactionAttribute.class);
        GrailsTransactionTemplate $transactionTemplate = (GrailsTransactionTemplate)ScriptBytecodeAdapter.castToType((Object)callSiteArray[22].callConstructor(GrailsTransactionTemplate.class, (Object)this.transactionManager, (Object)$transactionAttribute), GrailsTransactionTemplate.class);
        return (IRundeckProject)ScriptBytecodeAdapter.castToType((Object)$transactionTemplate.execute((Closure)new /* Unavailable Anonymous Inner Class!! */), IRundeckProject.class);
    }

    public boolean existsFrameworkProject(String project) {
        Reference project2 = new Reference((Object)project);
        CallSite[] callSiteArray = ProjectManagerService.$getCallSiteArray();
        GrailsTransactionAttribute $transactionAttribute = (GrailsTransactionAttribute)ScriptBytecodeAdapter.castToType((Object)callSiteArray[23].callConstructor(GrailsTransactionAttribute.class), GrailsTransactionAttribute.class);
        GrailsTransactionTemplate $transactionTemplate = (GrailsTransactionTemplate)ScriptBytecodeAdapter.castToType((Object)callSiteArray[24].callConstructor(GrailsTransactionTemplate.class, (Object)this.transactionManager, (Object)$transactionAttribute), GrailsTransactionTemplate.class);
        return DefaultTypeTransformation.booleanUnbox((Object)$transactionTemplate.execute((Closure)new /* Unavailable Anonymous Inner Class!! */));
    }

    public IRundeckProject createFrameworkProject(String projectName) {
        Reference projectName2 = new Reference((Object)projectName);
        CallSite[] callSiteArray = ProjectManagerService.$getCallSiteArray();
        GrailsTransactionAttribute $transactionAttribute = (GrailsTransactionAttribute)ScriptBytecodeAdapter.castToType((Object)callSiteArray[25].callConstructor(GrailsTransactionAttribute.class), GrailsTransactionAttribute.class);
        GrailsTransactionTemplate $transactionTemplate = (GrailsTransactionTemplate)ScriptBytecodeAdapter.castToType((Object)callSiteArray[26].callConstructor(GrailsTransactionTemplate.class, (Object)this.transactionManager, (Object)$transactionAttribute), GrailsTransactionTemplate.class);
        return (IRundeckProject)ScriptBytecodeAdapter.castToType((Object)$transactionTemplate.execute((Closure)new /* Unavailable Anonymous Inner Class!! */), IRundeckProject.class);
    }

    public void afterPropertiesSet() throws Exception {
        CallSite[] callSiteArray = ProjectManagerService.$getCallSiteArray();
        Object object = callSiteArray[27].callSafe((Object)this.configurationService, (Object)"projectManagerService", (Object)"projectCache", (Object)DEFAULT_PROJECT_CACHE_SPEC);
        Object spec = DefaultTypeTransformation.booleanUnbox((Object)object) ? object : DEFAULT_PROJECT_CACHE_SPEC;
        callSiteArray[28].call((Object)log, (Object)new GStringImpl(new Object[]{spec}, new String[]{"projectCache: creating from spec: ", ""}));
        Object object2 = callSiteArray[29].call(callSiteArray[30].call(callSiteArray[31].call(CacheBuilder.class, spec)), (Object)new /* Unavailable Anonymous Inner Class!! */);
        this.projectCache = (LoadingCache)ScriptBytecodeAdapter.castToType((Object)object2, LoadingCache.class);
        Object object3 = callSiteArray[32].callSafe((Object)this.configurationService, (Object)"projectManagerService", (Object)"aclSourceCache", (Object)DEFAULT_ACL_CACHE_SPEC);
        Object spec2 = DefaultTypeTransformation.booleanUnbox((Object)object3) ? object3 : DEFAULT_ACL_CACHE_SPEC;
        callSiteArray[33].call((Object)log, (Object)new GStringImpl(new Object[]{spec2}, new String[]{"sourceCache: creating from spec: ", ""}));
        Object object4 = callSiteArray[34].call(callSiteArray[35].call(callSiteArray[36].call(CacheBuilder.class, spec2)), (Object)new /* Unavailable Anonymous Inner Class!! */);
        this.sourceCache = (LoadingCache)ScriptBytecodeAdapter.castToType((Object)object4, LoadingCache.class);
        Object object5 = callSiteArray[37].callSafe((Object)this.configurationService, (Object)"projectManagerService", (Object)"fileCache", (Object)DEFAULT_FILE_CACHE_SPEC);
        Object spec3 = DefaultTypeTransformation.booleanUnbox((Object)object5) ? object5 : DEFAULT_FILE_CACHE_SPEC;
        callSiteArray[38].call((Object)log, (Object)new GStringImpl(new Object[]{spec3}, new String[]{"fileCache: creating from spec: ", ""}));
        Object object6 = callSiteArray[39].call(callSiteArray[40].call(callSiteArray[41].call(CacheBuilder.class, spec3)), (Object)new /* Unavailable Anonymous Inner Class!! */);
        this.fileCache = (LoadingCache)ScriptBytecodeAdapter.castToType((Object)object6, LoadingCache.class);
        MetricRegistry registry = (MetricRegistry)ScriptBytecodeAdapter.castToType((Object)callSiteArray[42].callSafe(this.metricService), MetricRegistry.class);
        callSiteArray[43].call(Util.class, callSiteArray[44].call(callSiteArray[45].callGetProperty(callSiteArray[46].callGroovyObjectGetProperty((Object)this)), (Object)".projectCache"), (Object)registry, (Object)this.projectCache);
        callSiteArray[47].call(Util.class, callSiteArray[48].call(callSiteArray[49].callGetProperty(callSiteArray[50].callGroovyObjectGetProperty((Object)this)), (Object)".sourceCache"), (Object)registry, (Object)this.sourceCache);
        callSiteArray[51].call(Util.class, callSiteArray[52].call(callSiteArray[53].callGetProperty(callSiteArray[54].callGroovyObjectGetProperty((Object)this)), (Object)".fileCache"), (Object)registry, (Object)this.fileCache);
    }

    /*
     * WARNING - void declaration
     */
    public boolean existsProjectFileResource(String projectName, String path) {
        void var2_2;
        Reference projectName2 = new Reference((Object)projectName);
        Reference path2 = new Reference((Object)var2_2);
        CallSite[] callSiteArray = ProjectManagerService.$getCallSiteArray();
        GrailsTransactionAttribute $transactionAttribute = (GrailsTransactionAttribute)ScriptBytecodeAdapter.castToType((Object)callSiteArray[55].callConstructor(GrailsTransactionAttribute.class), GrailsTransactionAttribute.class);
        GrailsTransactionTemplate $transactionTemplate = (GrailsTransactionTemplate)ScriptBytecodeAdapter.castToType((Object)callSiteArray[56].callConstructor(GrailsTransactionTemplate.class, (Object)this.transactionManager, (Object)$transactionAttribute), GrailsTransactionTemplate.class);
        return DefaultTypeTransformation.booleanUnbox((Object)$transactionTemplate.execute((Closure)new /* Unavailable Anonymous Inner Class!! */));
    }

    /*
     * WARNING - void declaration
     */
    public boolean existsProjectDirResource(String projectName, String path) {
        void var2_2;
        Reference projectName2 = new Reference((Object)projectName);
        Reference path2 = new Reference((Object)var2_2);
        CallSite[] callSiteArray = ProjectManagerService.$getCallSiteArray();
        GrailsTransactionAttribute $transactionAttribute = (GrailsTransactionAttribute)ScriptBytecodeAdapter.castToType((Object)callSiteArray[57].callConstructor(GrailsTransactionAttribute.class), GrailsTransactionAttribute.class);
        GrailsTransactionTemplate $transactionTemplate = (GrailsTransactionTemplate)ScriptBytecodeAdapter.castToType((Object)callSiteArray[58].callConstructor(GrailsTransactionTemplate.class, (Object)this.transactionManager, (Object)$transactionAttribute), GrailsTransactionTemplate.class);
        return DefaultTypeTransformation.booleanUnbox((Object)$transactionTemplate.execute((Closure)new /* Unavailable Anonymous Inner Class!! */));
    }

    /*
     * WARNING - void declaration
     */
    public Resource<ResourceMeta> getProjectFileResource(String projectName, String path) {
        void var2_2;
        Reference projectName2 = new Reference((Object)projectName);
        Reference path2 = new Reference((Object)var2_2);
        CallSite[] callSiteArray = ProjectManagerService.$getCallSiteArray();
        GrailsTransactionAttribute $transactionAttribute = (GrailsTransactionAttribute)ScriptBytecodeAdapter.castToType((Object)callSiteArray[59].callConstructor(GrailsTransactionAttribute.class), GrailsTransactionAttribute.class);
        GrailsTransactionTemplate $transactionTemplate = (GrailsTransactionTemplate)ScriptBytecodeAdapter.castToType((Object)callSiteArray[60].callConstructor(GrailsTransactionTemplate.class, (Object)this.transactionManager, (Object)$transactionAttribute), GrailsTransactionTemplate.class);
        return (Resource)ScriptBytecodeAdapter.castToType((Object)$transactionTemplate.execute((Closure)new /* Unavailable Anonymous Inner Class!! */), Resource.class);
    }

    /*
     * WARNING - void declaration
     */
    public long readProjectFileResource(String projectName, String path, OutputStream output) {
        void var3_3;
        void var2_2;
        Reference projectName2 = new Reference((Object)projectName);
        Reference path2 = new Reference((Object)var2_2);
        Reference output2 = new Reference((Object)var3_3);
        CallSite[] callSiteArray = ProjectManagerService.$getCallSiteArray();
        GrailsTransactionAttribute $transactionAttribute = (GrailsTransactionAttribute)ScriptBytecodeAdapter.castToType((Object)callSiteArray[61].callConstructor(GrailsTransactionAttribute.class), GrailsTransactionAttribute.class);
        GrailsTransactionTemplate $transactionTemplate = (GrailsTransactionTemplate)ScriptBytecodeAdapter.castToType((Object)callSiteArray[62].callConstructor(GrailsTransactionTemplate.class, (Object)this.transactionManager, (Object)$transactionAttribute), GrailsTransactionTemplate.class);
        return DefaultTypeTransformation.longUnbox((Object)$transactionTemplate.execute((Closure)new /* Unavailable Anonymous Inner Class!! */));
    }

    /*
     * WARNING - void declaration
     */
    public String readCachedProjectFileAsAstring(String projectName, String path) {
        void var2_2;
        Reference projectName2 = new Reference((Object)projectName);
        Reference path2 = new Reference((Object)var2_2);
        CallSite[] callSiteArray = ProjectManagerService.$getCallSiteArray();
        GrailsTransactionAttribute $transactionAttribute = (GrailsTransactionAttribute)ScriptBytecodeAdapter.castToType((Object)callSiteArray[63].callConstructor(GrailsTransactionAttribute.class), GrailsTransactionAttribute.class);
        GrailsTransactionTemplate $transactionTemplate = (GrailsTransactionTemplate)ScriptBytecodeAdapter.castToType((Object)callSiteArray[64].callConstructor(GrailsTransactionTemplate.class, (Object)this.transactionManager, (Object)$transactionAttribute), GrailsTransactionTemplate.class);
        return ShortTypeHandling.castToString((Object)$transactionTemplate.execute((Closure)new /* Unavailable Anonymous Inner Class!! */));
    }

    /*
     * WARNING - void declaration
     */
    public String readProjectFileResourceAsString(String projectName, String path) {
        void var2_2;
        Reference projectName2 = new Reference((Object)projectName);
        Reference path2 = new Reference((Object)var2_2);
        CallSite[] callSiteArray = ProjectManagerService.$getCallSiteArray();
        GrailsTransactionAttribute $transactionAttribute = (GrailsTransactionAttribute)ScriptBytecodeAdapter.castToType((Object)callSiteArray[65].callConstructor(GrailsTransactionAttribute.class), GrailsTransactionAttribute.class);
        GrailsTransactionTemplate $transactionTemplate = (GrailsTransactionTemplate)ScriptBytecodeAdapter.castToType((Object)callSiteArray[66].callConstructor(GrailsTransactionTemplate.class, (Object)this.transactionManager, (Object)$transactionAttribute), GrailsTransactionTemplate.class);
        return ShortTypeHandling.castToString((Object)$transactionTemplate.execute((Closure)new /* Unavailable Anonymous Inner Class!! */));
    }

    /*
     * WARNING - void declaration
     */
    public List<String> listProjectDirPaths(String projectName, String path, String pattern) {
        void var3_3;
        void var2_2;
        Reference projectName2 = new Reference((Object)projectName);
        Reference path2 = new Reference((Object)var2_2);
        Reference pattern2 = new Reference((Object)var3_3);
        CallSite[] callSiteArray = ProjectManagerService.$getCallSiteArray();
        GrailsTransactionAttribute $transactionAttribute = (GrailsTransactionAttribute)ScriptBytecodeAdapter.castToType((Object)callSiteArray[67].callConstructor(GrailsTransactionAttribute.class), GrailsTransactionAttribute.class);
        GrailsTransactionTemplate $transactionTemplate = (GrailsTransactionTemplate)ScriptBytecodeAdapter.castToType((Object)callSiteArray[68].callConstructor(GrailsTransactionTemplate.class, (Object)this.transactionManager, (Object)$transactionAttribute), GrailsTransactionTemplate.class);
        return (List)ScriptBytecodeAdapter.castToType((Object)$transactionTemplate.execute((Closure)new /* Unavailable Anonymous Inner Class!! */), List.class);
    }

    /*
     * WARNING - void declaration
     */
    public Resource<ResourceMeta> updateProjectFileResource(String projectName, String path, InputStream input, Map<String, String> meta) {
        void var3_3;
        void var2_2;
        Reference projectName2 = new Reference((Object)projectName);
        Reference path2 = new Reference((Object)var2_2);
        Reference input2 = new Reference((Object)var3_3);
        Reference meta2 = new Reference(meta);
        CallSite[] callSiteArray = ProjectManagerService.$getCallSiteArray();
        GrailsTransactionAttribute $transactionAttribute = (GrailsTransactionAttribute)ScriptBytecodeAdapter.castToType((Object)callSiteArray[69].callConstructor(GrailsTransactionAttribute.class), GrailsTransactionAttribute.class);
        GrailsTransactionTemplate $transactionTemplate = (GrailsTransactionTemplate)ScriptBytecodeAdapter.castToType((Object)callSiteArray[70].callConstructor(GrailsTransactionTemplate.class, (Object)this.transactionManager, (Object)$transactionAttribute), GrailsTransactionTemplate.class);
        return (Resource)ScriptBytecodeAdapter.castToType((Object)$transactionTemplate.execute((Closure)new /* Unavailable Anonymous Inner Class!! */), Resource.class);
    }

    /*
     * WARNING - void declaration
     */
    public Resource<ResourceMeta> createProjectFileResource(String projectName, String path, InputStream input, Map<String, String> meta) {
        void var3_3;
        void var2_2;
        Reference projectName2 = new Reference((Object)projectName);
        Reference path2 = new Reference((Object)var2_2);
        Reference input2 = new Reference((Object)var3_3);
        Reference meta2 = new Reference(meta);
        CallSite[] callSiteArray = ProjectManagerService.$getCallSiteArray();
        GrailsTransactionAttribute $transactionAttribute = (GrailsTransactionAttribute)ScriptBytecodeAdapter.castToType((Object)callSiteArray[71].callConstructor(GrailsTransactionAttribute.class), GrailsTransactionAttribute.class);
        GrailsTransactionTemplate $transactionTemplate = (GrailsTransactionTemplate)ScriptBytecodeAdapter.castToType((Object)callSiteArray[72].callConstructor(GrailsTransactionTemplate.class, (Object)this.transactionManager, (Object)$transactionAttribute), GrailsTransactionTemplate.class);
        return (Resource)ScriptBytecodeAdapter.castToType((Object)$transactionTemplate.execute((Closure)new /* Unavailable Anonymous Inner Class!! */), Resource.class);
    }

    /*
     * WARNING - void declaration
     */
    public Resource<ResourceMeta> writeProjectFileResource(String projectName, String path, InputStream input, Map<String, String> meta) {
        void var3_3;
        void var2_2;
        Reference projectName2 = new Reference((Object)projectName);
        Reference path2 = new Reference((Object)var2_2);
        Reference input2 = new Reference((Object)var3_3);
        Reference meta2 = new Reference(meta);
        CallSite[] callSiteArray = ProjectManagerService.$getCallSiteArray();
        GrailsTransactionAttribute $transactionAttribute = (GrailsTransactionAttribute)ScriptBytecodeAdapter.castToType((Object)callSiteArray[73].callConstructor(GrailsTransactionAttribute.class), GrailsTransactionAttribute.class);
        GrailsTransactionTemplate $transactionTemplate = (GrailsTransactionTemplate)ScriptBytecodeAdapter.castToType((Object)callSiteArray[74].callConstructor(GrailsTransactionTemplate.class, (Object)this.transactionManager, (Object)$transactionAttribute), GrailsTransactionTemplate.class);
        return (Resource)ScriptBytecodeAdapter.castToType((Object)$transactionTemplate.execute((Closure)new /* Unavailable Anonymous Inner Class!! */), Resource.class);
    }

    /*
     * WARNING - void declaration
     */
    public boolean deleteProjectFileResource(String projectName, String path) {
        void var2_2;
        Reference projectName2 = new Reference((Object)projectName);
        Reference path2 = new Reference((Object)var2_2);
        CallSite[] callSiteArray = ProjectManagerService.$getCallSiteArray();
        GrailsTransactionAttribute $transactionAttribute = (GrailsTransactionAttribute)ScriptBytecodeAdapter.castToType((Object)callSiteArray[75].callConstructor(GrailsTransactionAttribute.class), GrailsTransactionAttribute.class);
        GrailsTransactionTemplate $transactionTemplate = (GrailsTransactionTemplate)ScriptBytecodeAdapter.castToType((Object)callSiteArray[76].callConstructor(GrailsTransactionTemplate.class, (Object)this.transactionManager, (Object)$transactionAttribute), GrailsTransactionTemplate.class);
        return DefaultTypeTransformation.booleanUnbox((Object)$transactionTemplate.execute((Closure)new /* Unavailable Anonymous Inner Class!! */));
    }

    public boolean deleteAllProjectFileResources(String projectName) {
        Reference projectName2 = new Reference((Object)projectName);
        CallSite[] callSiteArray = ProjectManagerService.$getCallSiteArray();
        GrailsTransactionAttribute $transactionAttribute = (GrailsTransactionAttribute)ScriptBytecodeAdapter.castToType((Object)callSiteArray[77].callConstructor(GrailsTransactionAttribute.class), GrailsTransactionAttribute.class);
        GrailsTransactionTemplate $transactionTemplate = (GrailsTransactionTemplate)ScriptBytecodeAdapter.castToType((Object)callSiteArray[78].callConstructor(GrailsTransactionTemplate.class, (Object)this.transactionManager, (Object)$transactionAttribute), GrailsTransactionTemplate.class);
        return DefaultTypeTransformation.booleanUnbox((Object)$transactionTemplate.execute((Closure)new /* Unavailable Anonymous Inner Class!! */));
    }

    public Date getProjectConfigLastModified(String projectName) {
        Reference projectName2 = new Reference((Object)projectName);
        CallSite[] callSiteArray = ProjectManagerService.$getCallSiteArray();
        GrailsTransactionAttribute $transactionAttribute = (GrailsTransactionAttribute)ScriptBytecodeAdapter.castToType((Object)callSiteArray[79].callConstructor(GrailsTransactionAttribute.class), GrailsTransactionAttribute.class);
        GrailsTransactionTemplate $transactionTemplate = (GrailsTransactionTemplate)ScriptBytecodeAdapter.castToType((Object)callSiteArray[80].callConstructor(GrailsTransactionTemplate.class, (Object)this.transactionManager, (Object)$transactionAttribute), GrailsTransactionTemplate.class);
        return (Date)ScriptBytecodeAdapter.castToType((Object)$transactionTemplate.execute((Closure)new /* Unavailable Anonymous Inner Class!! */), Date.class);
    }

    public boolean isValidConfigFile(byte ... bytes) {
        Reference bytes2 = new Reference((Object)bytes);
        CallSite[] callSiteArray = ProjectManagerService.$getCallSiteArray();
        GrailsTransactionAttribute $transactionAttribute = (GrailsTransactionAttribute)ScriptBytecodeAdapter.castToType((Object)callSiteArray[81].callConstructor(GrailsTransactionAttribute.class), GrailsTransactionAttribute.class);
        GrailsTransactionTemplate $transactionTemplate = (GrailsTransactionTemplate)ScriptBytecodeAdapter.castToType((Object)callSiteArray[82].callConstructor(GrailsTransactionTemplate.class, (Object)this.transactionManager, (Object)$transactionAttribute), GrailsTransactionTemplate.class);
        return DefaultTypeTransformation.booleanUnbox((Object)$transactionTemplate.execute((Closure)new /* Unavailable Anonymous Inner Class!! */));
    }

    private Map loadProjectConfigResource(String projectName) {
        CallSite[] callSiteArray = ProjectManagerService.$getCallSiteArray();
        Object resource = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[83].callCurrent((GroovyObject)this, (Object)projectName, (Object)ETC_PROJECT_PROPERTIES_PATH);
            resource = object;
        } else {
            Resource resource2;
            resource = resource2 = this.getProjectFileResource(projectName, ETC_PROJECT_PROPERTIES_PATH);
        }
        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass() ? ScriptBytecodeAdapter.compareEqual(null, (Object)resource) : ScriptBytecodeAdapter.compareEqual(null, (Object)resource)) {
            return ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        }
        Object properties = callSiteArray[84].callConstructor(Properties.class);
        Object bytestream = callSiteArray[85].callConstructor(ByteArrayOutputStream.class);
        callSiteArray[86].call(Streams.class, callSiteArray[87].callGetProperty(callSiteArray[88].callGetProperty(resource)), bytestream, (Object)true);
        Object bytes = callSiteArray[89].call(bytestream);
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[90].callCurrent((GroovyObject)this, bytes))) {
            try {
                callSiteArray[91].call(properties, callSiteArray[92].callConstructor(ByteArrayInputStream.class, bytes));
            }
            catch (IOException e) {
                callSiteArray[93].call((Object)log, callSiteArray[94].call((Object)new GStringImpl(new Object[]{callSiteArray[95].callGetProperty(resource)}, new String[]{"Failed loading project properties from storage: ", ": "}), callSiteArray[96].callGetProperty((Object)e)), (Object)e);
            }
        } else {
            callSiteArray[97].call((Object)log, (Object)new GStringImpl(new Object[]{callSiteArray[98].callGetProperty(resource)}, new String[]{"Failed loading project properties from storage: ", ": could not validate contents"}));
        }
        return ScriptBytecodeAdapter.createMap((Object[])new Object[]{"config", properties, "lastModified", callSiteArray[99].callGetProperty(callSiteArray[100].callGetProperty(resource)), "creationTime", callSiteArray[101].callGetProperty(callSiteArray[102].callGetProperty(resource))});
    }

    private Map storeProjectConfig(String projectName, Properties properties) {
        CallSite[] callSiteArray = ProjectManagerService.$getCallSiteArray();
        String storagePath = ETC_PROJECT_PROPERTIES_PATH;
        Object baos = callSiteArray[103].callConstructor(ByteArrayOutputStream.class);
        String string = projectName;
        callSiteArray[104].call((Object)properties, (Object)"project.name", (Object)string);
        callSiteArray[105].call((Object)properties, baos, callSiteArray[106].call(callSiteArray[107].call((Object)MIME_TYPE_PROJECT_PROPERTIES, (Object)";name="), (Object)projectName));
        Object bais = callSiteArray[108].callConstructor(ByteArrayInputStream.class, callSiteArray[109].call(baos));
        Map metadata = ScriptBytecodeAdapter.createMap((Object[])new Object[]{callSiteArray[110].callGetProperty(StorageUtil.class), MIME_TYPE_PROJECT_PROPERTIES});
        Object resource = callSiteArray[111].callCurrent((GroovyObject)this, (Object)projectName, (Object)storagePath, bais, (Object)metadata);
        callSiteArray[112].call((Object)this.projectCache, (Object)projectName);
        callSiteArray[113].call(this.nodeService, (Object)projectName);
        return ScriptBytecodeAdapter.createMap((Object[])new Object[]{"config", properties, "lastModified", callSiteArray[114].callGetProperty(callSiteArray[115].callGetProperty(resource)), "creationTime", callSiteArray[116].callGetProperty(callSiteArray[117].callGetProperty(resource))});
    }

    private void deleteProjectResources(String projectName) {
        CallSite[] callSiteArray = ProjectManagerService.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[118].callCurrent((GroovyObject)this, (Object)projectName))) {
                callSiteArray[119].call((Object)log, (Object)new GStringImpl(new Object[]{projectName}, new String[]{"Failed to delete all associated resources for project ", ""}));
            }
        } else if (!this.deleteAllProjectFileResources(projectName)) {
            callSiteArray[120].call((Object)log, (Object)new GStringImpl(new Object[]{projectName}, new String[]{"Failed to delete all associated resources for project ", ""}));
        }
        callSiteArray[121].call((Object)this.projectCache, (Object)projectName);
        callSiteArray[122].call(this.nodeService, (Object)projectName);
    }

    private IPropertyLookup createProjectPropertyLookup(String projectName, Properties config) {
        CallSite[] callSiteArray = ProjectManagerService.$getCallSiteArray();
        Properties ownProps = (Properties)ScriptBytecodeAdapter.castToType((Object)callSiteArray[123].callConstructor(Properties.class), Properties.class);
        callSiteArray[124].call((Object)ownProps, (Object)"project.name", (Object)projectName);
        Object create = callSiteArray[125].call(PropertyLookup.class, callSiteArray[126].callCurrent((GroovyObject)this, (Object)projectName, (Object)config), callSiteArray[127].callGetProperty(callSiteArray[128].call((Object)this.frameworkService)));
        callSiteArray[129].call(create);
        return (IPropertyLookup)ScriptBytecodeAdapter.castToType((Object)create, IPropertyLookup.class);
    }

    private IPropertyLookup createDirectProjectPropertyLookup(String projectName, Properties config) {
        CallSite[] callSiteArray = ProjectManagerService.$getCallSiteArray();
        Properties ownProps = (Properties)ScriptBytecodeAdapter.castToType((Object)callSiteArray[130].callConstructor(Properties.class), Properties.class);
        callSiteArray[131].call((Object)ownProps, (Object)"project.name", (Object)projectName);
        callSiteArray[132].call((Object)ownProps, (Object)config);
        Object create = callSiteArray[133].call(PropertyLookup.class, (Object)ownProps);
        callSiteArray[134].call(create);
        return (IPropertyLookup)ScriptBytecodeAdapter.castToType((Object)create, IPropertyLookup.class);
    }

    /*
     * WARNING - void declaration
     */
    public IRundeckProject createFrameworkProject(String projectName, Properties properties) {
        void var2_2;
        Reference projectName2 = new Reference((Object)projectName);
        Reference properties2 = new Reference((Object)var2_2);
        CallSite[] callSiteArray = ProjectManagerService.$getCallSiteArray();
        GrailsTransactionAttribute $transactionAttribute = (GrailsTransactionAttribute)ScriptBytecodeAdapter.castToType((Object)callSiteArray[135].callConstructor(GrailsTransactionAttribute.class), GrailsTransactionAttribute.class);
        GrailsTransactionTemplate $transactionTemplate = (GrailsTransactionTemplate)ScriptBytecodeAdapter.castToType((Object)callSiteArray[136].callConstructor(GrailsTransactionTemplate.class, (Object)this.transactionManager, (Object)$transactionAttribute), GrailsTransactionTemplate.class);
        return (IRundeckProject)ScriptBytecodeAdapter.castToType((Object)$transactionTemplate.execute((Closure)new /* Unavailable Anonymous Inner Class!! */), IRundeckProject.class);
    }

    public void removeFrameworkProject(String projectName) {
        Reference projectName2 = new Reference((Object)projectName);
        CallSite[] callSiteArray = ProjectManagerService.$getCallSiteArray();
        GrailsTransactionAttribute $transactionAttribute = (GrailsTransactionAttribute)ScriptBytecodeAdapter.castToType((Object)callSiteArray[137].callConstructor(GrailsTransactionAttribute.class), GrailsTransactionAttribute.class);
        GrailsTransactionTemplate $transactionTemplate = (GrailsTransactionTemplate)ScriptBytecodeAdapter.castToType((Object)callSiteArray[138].callConstructor(GrailsTransactionTemplate.class, (Object)this.transactionManager, (Object)$transactionAttribute), GrailsTransactionTemplate.class);
        $transactionTemplate.execute((Closure)new /* Unavailable Anonymous Inner Class!! */);
    }

    /*
     * WARNING - void declaration
     */
    public IRundeckProject createFrameworkProjectStrict(String projectName, Properties properties) {
        void var2_2;
        Reference projectName2 = new Reference((Object)projectName);
        Reference properties2 = new Reference((Object)var2_2);
        CallSite[] callSiteArray = ProjectManagerService.$getCallSiteArray();
        GrailsTransactionAttribute $transactionAttribute = (GrailsTransactionAttribute)ScriptBytecodeAdapter.castToType((Object)callSiteArray[139].callConstructor(GrailsTransactionAttribute.class), GrailsTransactionAttribute.class);
        GrailsTransactionTemplate $transactionTemplate = (GrailsTransactionTemplate)ScriptBytecodeAdapter.castToType((Object)callSiteArray[140].callConstructor(GrailsTransactionTemplate.class, (Object)this.transactionManager, (Object)$transactionAttribute), GrailsTransactionTemplate.class);
        return (IRundeckProject)ScriptBytecodeAdapter.castToType((Object)$transactionTemplate.execute((Closure)new /* Unavailable Anonymous Inner Class!! */), IRundeckProject.class);
    }

    /*
     * WARNING - void declaration
     */
    public void mergeProjectProperties(RundeckProject project, Properties properties, Set<String> removePrefixes) {
        void var3_3;
        void var2_2;
        Reference project2 = new Reference((Object)project);
        Reference properties2 = new Reference((Object)var2_2);
        Reference removePrefixes2 = new Reference((Object)var3_3);
        CallSite[] callSiteArray = ProjectManagerService.$getCallSiteArray();
        GrailsTransactionAttribute $transactionAttribute = (GrailsTransactionAttribute)ScriptBytecodeAdapter.castToType((Object)callSiteArray[141].callConstructor(GrailsTransactionAttribute.class), GrailsTransactionAttribute.class);
        GrailsTransactionTemplate $transactionTemplate = (GrailsTransactionTemplate)ScriptBytecodeAdapter.castToType((Object)callSiteArray[142].callConstructor(GrailsTransactionTemplate.class, (Object)this.transactionManager, (Object)$transactionAttribute), GrailsTransactionTemplate.class);
        $transactionTemplate.execute((Closure)new /* Unavailable Anonymous Inner Class!! */);
    }

    /*
     * WARNING - void declaration
     */
    public Map mergeProjectProperties(String projectName, Properties properties, Set<String> removePrefixes) {
        void var3_3;
        void var2_2;
        Reference projectName2 = new Reference((Object)projectName);
        Reference properties2 = new Reference((Object)var2_2);
        Reference removePrefixes2 = new Reference((Object)var3_3);
        CallSite[] callSiteArray = ProjectManagerService.$getCallSiteArray();
        GrailsTransactionAttribute $transactionAttribute = (GrailsTransactionAttribute)ScriptBytecodeAdapter.castToType((Object)callSiteArray[143].callConstructor(GrailsTransactionAttribute.class), GrailsTransactionAttribute.class);
        GrailsTransactionTemplate $transactionTemplate = (GrailsTransactionTemplate)ScriptBytecodeAdapter.castToType((Object)callSiteArray[144].callConstructor(GrailsTransactionTemplate.class, (Object)this.transactionManager, (Object)$transactionAttribute), GrailsTransactionTemplate.class);
        return (Map)ScriptBytecodeAdapter.castToType((Object)$transactionTemplate.execute((Closure)new /* Unavailable Anonymous Inner Class!! */), Map.class);
    }

    /*
     * WARNING - void declaration
     */
    public static Properties mergeProperties(Set<String> removePrefixes, Properties oldprops, Properties inProps) {
        void var1_1;
        Reference removePrefixes2 = new Reference(removePrefixes);
        Reference oldprops2 = new Reference((Object)var1_1);
        CallSite[] callSiteArray = ProjectManagerService.$getCallSiteArray();
        Reference newprops = new Reference(callSiteArray[145].callConstructor(Properties.class));
        if (DefaultTypeTransformation.booleanUnbox((Object)((Set)removePrefixes2.get()))) {
            callSiteArray[146].call(callSiteArray[147].call((Object)((Properties)oldprops2.get())), (Object)new /* Unavailable Anonymous Inner Class!! */);
        } else {
            callSiteArray[148].call(newprops.get(), (Object)((Properties)oldprops2.get()));
        }
        callSiteArray[149].call(newprops.get(), (Object)inProps);
        return (Properties)ScriptBytecodeAdapter.castToType((Object)newprops.get(), Properties.class);
    }

    /*
     * WARNING - void declaration
     */
    public void setProjectProperties(RundeckProject project, Properties properties) {
        void var2_2;
        Reference project2 = new Reference((Object)project);
        Reference properties2 = new Reference((Object)var2_2);
        CallSite[] callSiteArray = ProjectManagerService.$getCallSiteArray();
        GrailsTransactionAttribute $transactionAttribute = (GrailsTransactionAttribute)ScriptBytecodeAdapter.castToType((Object)callSiteArray[150].callConstructor(GrailsTransactionAttribute.class), GrailsTransactionAttribute.class);
        GrailsTransactionTemplate $transactionTemplate = (GrailsTransactionTemplate)ScriptBytecodeAdapter.castToType((Object)callSiteArray[151].callConstructor(GrailsTransactionTemplate.class, (Object)this.transactionManager, (Object)$transactionAttribute), GrailsTransactionTemplate.class);
        $transactionTemplate.execute((Closure)new /* Unavailable Anonymous Inner Class!! */);
    }

    /*
     * WARNING - void declaration
     */
    public Map setProjectProperties(String projectName, Properties properties) {
        void var2_2;
        Reference projectName2 = new Reference((Object)projectName);
        Reference properties2 = new Reference((Object)var2_2);
        CallSite[] callSiteArray = ProjectManagerService.$getCallSiteArray();
        GrailsTransactionAttribute $transactionAttribute = (GrailsTransactionAttribute)ScriptBytecodeAdapter.castToType((Object)callSiteArray[152].callConstructor(GrailsTransactionAttribute.class), GrailsTransactionAttribute.class);
        GrailsTransactionTemplate $transactionTemplate = (GrailsTransactionTemplate)ScriptBytecodeAdapter.castToType((Object)callSiteArray[153].callConstructor(GrailsTransactionTemplate.class, (Object)this.transactionManager, (Object)$transactionAttribute), GrailsTransactionTemplate.class);
        return (Map)ScriptBytecodeAdapter.castToType((Object)$transactionTemplate.execute((Closure)new /* Unavailable Anonymous Inner Class!! */), Map.class);
    }

    private CacheableYamlSource loadYamlSource(ProjectFile key) {
        CallSite[] callSiteArray = ProjectManagerService.$getCallSiteArray();
        Object exists = callSiteArray[154].callCurrent((GroovyObject)this, callSiteArray[155].callGetProperty((Object)key), callSiteArray[156].callGetProperty((Object)key));
        callSiteArray[157].call((Object)log, (Object)new GStringImpl(new Object[]{callSiteArray[158].callGetProperty((Object)key), exists}, new String[]{"ProjectManagerService.loadYamlSource. path: ", ", exists: ", ""}));
        if (!DefaultTypeTransformation.booleanUnbox((Object)exists)) {
            return (CacheableYamlSource)ScriptBytecodeAdapter.castToType(null, CacheableYamlSource.class);
        }
        Object resource = callSiteArray[159].callCurrent((GroovyObject)this, callSiteArray[160].callGetProperty((Object)key), callSiteArray[161].callGetProperty((Object)key));
        Object file = callSiteArray[162].callGetProperty(resource);
        Object text = callSiteArray[163].call(callSiteArray[164].callGetProperty(file));
        return (CacheableYamlSource)ScriptBytecodeAdapter.castToType((Object)callSiteArray[165].call(YamlProvider.class, (Object)new GStringImpl(new Object[]{callSiteArray[166].callGetProperty((Object)key), callSiteArray[167].callGetProperty((Object)key)}, new String[]{"[project:", "]", ""}), text, callSiteArray[168].callGetProperty(file)), CacheableYamlSource.class);
    }

    public Authorization getProjectAuthorization(String projectName) {
        Reference projectName2 = new Reference((Object)projectName);
        CallSite[] callSiteArray = ProjectManagerService.$getCallSiteArray();
        GrailsTransactionAttribute $transactionAttribute = (GrailsTransactionAttribute)ScriptBytecodeAdapter.castToType((Object)callSiteArray[169].callConstructor(GrailsTransactionAttribute.class), GrailsTransactionAttribute.class);
        GrailsTransactionTemplate $transactionTemplate = (GrailsTransactionTemplate)ScriptBytecodeAdapter.castToType((Object)callSiteArray[170].callConstructor(GrailsTransactionTemplate.class, (Object)this.transactionManager, (Object)$transactionAttribute), GrailsTransactionTemplate.class);
        return (Authorization)ScriptBytecodeAdapter.castToType((Object)$transactionTemplate.execute((Closure)new /* Unavailable Anonymous Inner Class!! */), Authorization.class);
    }

    /*
     * WARNING - void declaration
     */
    public boolean needsReloadAcl(ProjectFile key, CacheableYamlSource source) {
        void var2_2;
        Reference key2 = new Reference((Object)key);
        Reference source2 = new Reference((Object)var2_2);
        CallSite[] callSiteArray = ProjectManagerService.$getCallSiteArray();
        GrailsTransactionAttribute $transactionAttribute = (GrailsTransactionAttribute)ScriptBytecodeAdapter.castToType((Object)callSiteArray[171].callConstructor(GrailsTransactionAttribute.class), GrailsTransactionAttribute.class);
        GrailsTransactionTemplate $transactionTemplate = (GrailsTransactionTemplate)ScriptBytecodeAdapter.castToType((Object)callSiteArray[172].callConstructor(GrailsTransactionTemplate.class, (Object)this.transactionManager, (Object)$transactionAttribute), GrailsTransactionTemplate.class);
        return DefaultTypeTransformation.booleanUnbox((Object)$transactionTemplate.execute((Closure)new /* Unavailable Anonymous Inner Class!! */));
    }

    public IRundeckProjectConfig loadProjectConfig(String project) {
        Reference project2 = new Reference((Object)project);
        CallSite[] callSiteArray = ProjectManagerService.$getCallSiteArray();
        GrailsTransactionAttribute $transactionAttribute = (GrailsTransactionAttribute)ScriptBytecodeAdapter.castToType((Object)callSiteArray[173].callConstructor(GrailsTransactionAttribute.class), GrailsTransactionAttribute.class);
        GrailsTransactionTemplate $transactionTemplate = (GrailsTransactionTemplate)ScriptBytecodeAdapter.castToType((Object)callSiteArray[174].callConstructor(GrailsTransactionTemplate.class, (Object)this.transactionManager, (Object)$transactionAttribute), GrailsTransactionTemplate.class);
        return (IRundeckProjectConfig)ScriptBytecodeAdapter.castToType((Object)$transactionTemplate.execute((Closure)new /* Unavailable Anonymous Inner Class!! */), IRundeckProjectConfig.class);
    }

    public IRundeckProject loadProject(String project) {
        Reference project2 = new Reference((Object)project);
        CallSite[] callSiteArray = ProjectManagerService.$getCallSiteArray();
        GrailsTransactionAttribute $transactionAttribute = (GrailsTransactionAttribute)ScriptBytecodeAdapter.castToType((Object)callSiteArray[175].callConstructor(GrailsTransactionAttribute.class), GrailsTransactionAttribute.class);
        GrailsTransactionTemplate $transactionTemplate = (GrailsTransactionTemplate)ScriptBytecodeAdapter.castToType((Object)callSiteArray[176].callConstructor(GrailsTransactionTemplate.class, (Object)this.transactionManager, (Object)$transactionAttribute), GrailsTransactionTemplate.class);
        return (IRundeckProject)ScriptBytecodeAdapter.castToType((Object)$transactionTemplate.execute((Closure)new /* Unavailable Anonymous Inner Class!! */), IRundeckProject.class);
    }

    public boolean needsReload(IRundeckProject project) {
        Reference project2 = new Reference((Object)project);
        CallSite[] callSiteArray = ProjectManagerService.$getCallSiteArray();
        GrailsTransactionAttribute $transactionAttribute = (GrailsTransactionAttribute)ScriptBytecodeAdapter.castToType((Object)callSiteArray[177].callConstructor(GrailsTransactionAttribute.class), GrailsTransactionAttribute.class);
        GrailsTransactionTemplate $transactionTemplate = (GrailsTransactionTemplate)ScriptBytecodeAdapter.castToType((Object)callSiteArray[178].callConstructor(GrailsTransactionTemplate.class, (Object)this.transactionManager, (Object)$transactionAttribute), GrailsTransactionTemplate.class);
        return DefaultTypeTransformation.booleanUnbox((Object)$transactionTemplate.execute((Closure)new /* Unavailable Anonymous Inner Class!! */));
    }

    public String getNodesResourceFilePath(IRundeckProject project) {
        Reference project2 = new Reference((Object)project);
        CallSite[] callSiteArray = ProjectManagerService.$getCallSiteArray();
        GrailsTransactionAttribute $transactionAttribute = (GrailsTransactionAttribute)ScriptBytecodeAdapter.castToType((Object)callSiteArray[179].callConstructor(GrailsTransactionAttribute.class), GrailsTransactionAttribute.class);
        GrailsTransactionTemplate $transactionTemplate = (GrailsTransactionTemplate)ScriptBytecodeAdapter.castToType((Object)callSiteArray[180].callConstructor(GrailsTransactionTemplate.class, (Object)this.transactionManager, (Object)$transactionAttribute), GrailsTransactionTemplate.class);
        return ShortTypeHandling.castToString((Object)$transactionTemplate.execute((Closure)new /* Unavailable Anonymous Inner Class!! */));
    }

    /*
     * WARNING - void declaration
     */
    public boolean testProjectWasImported(ProjectManager source, String projectName) {
        void var2_2;
        Reference source2 = new Reference((Object)source);
        Reference projectName2 = new Reference((Object)var2_2);
        CallSite[] callSiteArray = ProjectManagerService.$getCallSiteArray();
        GrailsTransactionAttribute $transactionAttribute = (GrailsTransactionAttribute)ScriptBytecodeAdapter.castToType((Object)callSiteArray[181].callConstructor(GrailsTransactionAttribute.class), GrailsTransactionAttribute.class);
        GrailsTransactionTemplate $transactionTemplate = (GrailsTransactionTemplate)ScriptBytecodeAdapter.castToType((Object)callSiteArray[182].callConstructor(GrailsTransactionTemplate.class, (Object)this.transactionManager, (Object)$transactionAttribute), GrailsTransactionTemplate.class);
        return DefaultTypeTransformation.booleanUnbox((Object)$transactionTemplate.execute((Closure)new /* Unavailable Anonymous Inner Class!! */));
    }

    /*
     * WARNING - void declaration
     */
    public void markProjectAsImported(ProjectManager source, String projectName) {
        void var2_2;
        Reference source2 = new Reference((Object)source);
        Reference projectName2 = new Reference((Object)var2_2);
        CallSite[] callSiteArray = ProjectManagerService.$getCallSiteArray();
        GrailsTransactionAttribute $transactionAttribute = (GrailsTransactionAttribute)ScriptBytecodeAdapter.castToType((Object)callSiteArray[183].callConstructor(GrailsTransactionAttribute.class), GrailsTransactionAttribute.class);
        GrailsTransactionTemplate $transactionTemplate = (GrailsTransactionTemplate)ScriptBytecodeAdapter.castToType((Object)callSiteArray[184].callConstructor(GrailsTransactionTemplate.class, (Object)this.transactionManager, (Object)$transactionAttribute), GrailsTransactionTemplate.class);
        $transactionTemplate.execute((Closure)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void importProjectsFromProjectManager(ProjectManager source) {
        Reference source2 = new Reference((Object)source);
        CallSite[] callSiteArray = ProjectManagerService.$getCallSiteArray();
        GrailsTransactionAttribute $transactionAttribute = (GrailsTransactionAttribute)ScriptBytecodeAdapter.castToType((Object)callSiteArray[185].callConstructor(GrailsTransactionAttribute.class), GrailsTransactionAttribute.class);
        GrailsTransactionTemplate $transactionTemplate = (GrailsTransactionTemplate)ScriptBytecodeAdapter.castToType((Object)callSiteArray[186].callConstructor(GrailsTransactionTemplate.class, (Object)this.transactionManager, (Object)$transactionAttribute), GrailsTransactionTemplate.class);
        $transactionTemplate.execute((Closure)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != ProjectManagerService.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    protected Collection $tt__listFrameworkProjects(TransactionStatus transactionStatus) {
        CallSite[] callSiteArray = ProjectManagerService.$getCallSiteArray();
        return (Collection)ScriptBytecodeAdapter.castToType((Object)callSiteArray[187].call(callSiteArray[188].call(Project.class), (Object)new /* Unavailable Anonymous Inner Class!! */), Collection.class);
    }

    protected Collection $tt__listFrameworkProjectNames(TransactionStatus transactionStatus) {
        CallSite[] callSiteArray = ProjectManagerService.$getCallSiteArray();
        Object c = callSiteArray[189].call(Project.class);
        return (Collection)ScriptBytecodeAdapter.castToType((Object)callSiteArray[190].call(c, (Object)new /* Unavailable Anonymous Inner Class!! */), Collection.class);
    }

    protected IRundeckProject $tt__getFrameworkProject(String name, TransactionStatus transactionStatus) {
        CallSite[] callSiteArray = ProjectManagerService.$getCallSiteArray();
        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (ScriptBytecodeAdapter.compareEqual(null, (Object)callSiteArray[191].call((Object)this.projectCache, (Object)name)) && !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[192].callCurrent((GroovyObject)this, (Object)name))) {
                throw (Throwable)callSiteArray[193].callConstructor(IllegalArgumentException.class, callSiteArray[194].call((Object)"Project does not exist: ", (Object)name));
            }
        } else if (ScriptBytecodeAdapter.compareEqual(null, (Object)callSiteArray[195].call((Object)this.projectCache, (Object)name)) && !this.existsFrameworkProject(name)) {
            throw (Throwable)callSiteArray[196].callConstructor(IllegalArgumentException.class, callSiteArray[197].call((Object)"Project does not exist: ", (Object)name));
        }
        Object result = callSiteArray[198].call((Object)this.projectCache, (Object)name);
        if (!DefaultTypeTransformation.booleanUnbox((Object)result)) {
            throw (Throwable)callSiteArray[199].callConstructor(IllegalArgumentException.class, callSiteArray[200].call((Object)"Project does not exist: ", (Object)name));
        }
        return (IRundeckProject)ScriptBytecodeAdapter.castToType((Object)result, IRundeckProject.class);
    }

    protected boolean $tt__existsFrameworkProject(String project, TransactionStatus transactionStatus) {
        Reference project2 = new Reference((Object)project);
        CallSite[] callSiteArray = ProjectManagerService.$getCallSiteArray();
        return DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[201].call(Project.class, (Object)new /* Unavailable Anonymous Inner Class!! */));
    }

    protected IRundeckProject $tt__createFrameworkProject(String projectName, TransactionStatus transactionStatus) {
        CallSite[] callSiteArray = ProjectManagerService.$getCallSiteArray();
        return (IRundeckProject)ScriptBytecodeAdapter.castToType((Object)callSiteArray[202].callCurrent((GroovyObject)this, (Object)projectName, callSiteArray[203].callConstructor(Properties.class)), IRundeckProject.class);
    }

    protected boolean $tt__existsProjectFileResource(String projectName, String path, TransactionStatus transactionStatus) {
        CallSite[] callSiteArray = ProjectManagerService.$getCallSiteArray();
        Object storagePath = callSiteArray[204].call(callSiteArray[205].call((Object)"projects/", (Object)projectName), (Object)(DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[206].call((Object)path, (Object)"/")) ? path : new GStringImpl(new Object[]{path}, new String[]{"/", ""})));
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[207].call(callSiteArray[208].callCurrent((GroovyObject)this), storagePath));
        }
        return DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[209].call((Object)this.getStorage(), storagePath));
    }

    protected boolean $tt__existsProjectDirResource(String projectName, String path, TransactionStatus transactionStatus) {
        CallSite[] callSiteArray = ProjectManagerService.$getCallSiteArray();
        Object storagePath = callSiteArray[210].call(callSiteArray[211].call((Object)"projects/", (Object)projectName), (Object)(DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[212].call((Object)path, (Object)"/")) ? path : new GStringImpl(new Object[]{path}, new String[]{"/", ""})));
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[213].call(callSiteArray[214].callCurrent((GroovyObject)this), storagePath));
        }
        return DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[215].call((Object)this.getStorage(), storagePath));
    }

    protected Resource $tt__getProjectFileResource(String projectName, String path, TransactionStatus transactionStatus) {
        CallSite[] callSiteArray = ProjectManagerService.$getCallSiteArray();
        Object storagePath = callSiteArray[216].call(callSiteArray[217].call((Object)"projects/", (Object)projectName), (Object)(DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[218].call((Object)path, (Object)"/")) ? path : new GStringImpl(new Object[]{path}, new String[]{"/", ""})));
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass() ? !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[219].call(callSiteArray[220].callCurrent((GroovyObject)this), storagePath)) : !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[221].call((Object)this.getStorage(), storagePath))) {
            return (Resource)ScriptBytecodeAdapter.castToType(null, Resource.class);
        }
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return (Resource)ScriptBytecodeAdapter.castToType((Object)callSiteArray[222].call(callSiteArray[223].callCurrent((GroovyObject)this), storagePath), Resource.class);
        }
        return (Resource)ScriptBytecodeAdapter.castToType((Object)callSiteArray[224].call((Object)this.getStorage(), storagePath), Resource.class);
    }

    protected long $tt__readProjectFileResource(String projectName, String path, OutputStream output, TransactionStatus transactionStatus) {
        Object object;
        Object object2;
        CallSite[] callSiteArray = ProjectManagerService.$getCallSiteArray();
        Object storagePath = callSiteArray[225].call(callSiteArray[226].call((Object)"projects/", (Object)projectName), (Object)(DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[227].call((Object)path, (Object)"/")) ? path : new GStringImpl(new Object[]{path}, new String[]{"/", ""})));
        Object resource = null;
        resource = __$stMC || BytecodeInterface8.disabledStandardMetaClass() ? (object2 = callSiteArray[228].call(callSiteArray[229].callCurrent((GroovyObject)this), storagePath)) : (object = callSiteArray[230].call((Object)this.getStorage(), storagePath));
        return DefaultTypeTransformation.longUnbox((Object)callSiteArray[231].call(Streams.class, callSiteArray[232].callGetProperty(callSiteArray[233].callGetProperty(resource)), (Object)output, (Object)false));
    }

    protected String $tt__readCachedProjectFileAsAstring(String projectName, String path, TransactionStatus transactionStatus) {
        CallSite[] callSiteArray = ProjectManagerService.$getCallSiteArray();
        Optional cached = (Optional)ScriptBytecodeAdapter.castToType((Object)callSiteArray[234].call((Object)this.fileCache, callSiteArray[235].call(ProjectFile.class, (Object)projectName, (Object)path)), Optional.class);
        return ShortTypeHandling.castToString(DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[236].call((Object)cached)) ? callSiteArray[237].call((Object)cached) : null);
    }

    protected String $tt__readProjectFileResourceAsString(String projectName, String path, TransactionStatus transactionStatus) {
        CallSite[] callSiteArray = ProjectManagerService.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass() ? !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[238].callCurrent((GroovyObject)this, (Object)projectName, (Object)path)) : !this.existsProjectFileResource(projectName, path)) {
            return ShortTypeHandling.castToString(null);
        }
        Object baos = callSiteArray[239].callConstructor(ByteArrayOutputStream.class);
        Object len = callSiteArray[240].callCurrent((GroovyObject)this, (Object)projectName, (Object)path, baos);
        return ShortTypeHandling.castToString((Object)callSiteArray[241].call(baos));
    }

    protected List $tt__listProjectDirPaths(String projectName, String path, String pattern, TransactionStatus transactionStatus) {
        Object object;
        Object object2;
        Reference pattern2 = new Reference((Object)pattern);
        CallSite[] callSiteArray = ProjectManagerService.$getCallSiteArray();
        Object prefix = callSiteArray[242].call((Object)"projects/", (Object)projectName);
        Object storagePath = callSiteArray[243].call(prefix, (Object)(DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[244].call((Object)path, (Object)"/")) ? path : new GStringImpl(new Object[]{path}, new String[]{"/", ""})));
        Object resources2 = null;
        resources2 = __$stMC || BytecodeInterface8.disabledStandardMetaClass() ? (object2 = callSiteArray[245].call(callSiteArray[246].callCurrent((GroovyObject)this), storagePath)) : (object = callSiteArray[247].call((Object)this.getStorage(), storagePath));
        Reference outprefix = new Reference(DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[248].call((Object)path, (Object)"/")) ? callSiteArray[249].call((Object)path, (Object)0, callSiteArray[250].call(callSiteArray[251].call((Object)path), (Object)1)) : path);
        return (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[252].call(callSiteArray[253].call(resources2, (Object)new /* Unavailable Anonymous Inner Class!! */), (Object)new /* Unavailable Anonymous Inner Class!! */), List.class);
    }

    protected Resource $tt__updateProjectFileResource(String projectName, String path, InputStream input, Map<String, String> meta, TransactionStatus transactionStatus) {
        Object object;
        Object object2;
        CallSite[] callSiteArray = ProjectManagerService.$getCallSiteArray();
        Object storagePath = callSiteArray[254].call(callSiteArray[255].call((Object)"projects/", (Object)projectName), (Object)(DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[256].call((Object)path, (Object)"/")) ? path : new GStringImpl(new Object[]{path}, new String[]{"/", ""})));
        Object res = null;
        res = __$stMC || BytecodeInterface8.disabledStandardMetaClass() ? (object2 = callSiteArray[257].call(callSiteArray[258].callCurrent((GroovyObject)this), storagePath, callSiteArray[259].call(DataUtil.class, (Object)input, meta, callSiteArray[260].call(StorageUtil.class)))) : (object = callSiteArray[261].call((Object)this.getStorage(), storagePath, callSiteArray[262].call(DataUtil.class, (Object)input, meta, callSiteArray[263].call(StorageUtil.class))));
        callSiteArray[264].call((Object)this.sourceCache, callSiteArray[265].call(ProjectFile.class, (Object)projectName, (Object)path));
        return (Resource)ScriptBytecodeAdapter.castToType((Object)res, Resource.class);
    }

    protected Resource $tt__createProjectFileResource(String projectName, String path, InputStream input, Map<String, String> meta, TransactionStatus transactionStatus) {
        Object object;
        Object object2;
        CallSite[] callSiteArray = ProjectManagerService.$getCallSiteArray();
        Object storagePath = callSiteArray[266].call(callSiteArray[267].call((Object)"projects/", (Object)projectName), (Object)(DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[268].call((Object)path, (Object)"/")) ? path : new GStringImpl(new Object[]{path}, new String[]{"/", ""})));
        Object res = null;
        res = __$stMC || BytecodeInterface8.disabledStandardMetaClass() ? (object2 = callSiteArray[269].call(callSiteArray[270].callCurrent((GroovyObject)this), storagePath, callSiteArray[271].call(DataUtil.class, (Object)input, meta, callSiteArray[272].call(StorageUtil.class)))) : (object = callSiteArray[273].call((Object)this.getStorage(), storagePath, callSiteArray[274].call(DataUtil.class, (Object)input, meta, callSiteArray[275].call(StorageUtil.class))));
        callSiteArray[276].call((Object)this.sourceCache, callSiteArray[277].call(ProjectFile.class, (Object)projectName, (Object)path));
        return (Resource)ScriptBytecodeAdapter.castToType((Object)res, Resource.class);
    }

    protected Resource $tt__writeProjectFileResource(String projectName, String path, InputStream input, Map<String, String> meta, TransactionStatus transactionStatus) {
        CallSite[] callSiteArray = ProjectManagerService.$getCallSiteArray();
        Object storagePath = callSiteArray[278].call(callSiteArray[279].call((Object)"projects/", (Object)projectName), (Object)(DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[280].call((Object)path, (Object)"/")) ? path : new GStringImpl(new Object[]{path}, new String[]{"/", ""})));
        callSiteArray[281].call((Object)this.fileCache, callSiteArray[282].call(ProjectFile.class, (Object)projectName, (Object)path));
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[283].call(callSiteArray[284].callCurrent((GroovyObject)this), storagePath))) {
                return (Resource)ScriptBytecodeAdapter.castToType((Object)callSiteArray[285].callCurrent((GroovyObject)this, (Object)projectName, (Object)path, (Object)input, meta), Resource.class);
            }
            return (Resource)ScriptBytecodeAdapter.castToType((Object)callSiteArray[286].callCurrent((GroovyObject)this, (Object)projectName, (Object)path, (Object)input, meta), Resource.class);
        }
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[287].call((Object)this.getStorage(), storagePath))) {
            return (Resource)ScriptBytecodeAdapter.castToType((Object)callSiteArray[288].callCurrent((GroovyObject)this, (Object)projectName, (Object)path, (Object)input, meta), Resource.class);
        }
        return (Resource)ScriptBytecodeAdapter.castToType((Object)callSiteArray[289].callCurrent((GroovyObject)this, (Object)projectName, (Object)path, (Object)input, meta), Resource.class);
    }

    protected boolean $tt__deleteProjectFileResource(String projectName, String path, TransactionStatus transactionStatus) {
        CallSite[] callSiteArray = ProjectManagerService.$getCallSiteArray();
        Object storagePath = callSiteArray[290].call(callSiteArray[291].call((Object)"projects/", (Object)projectName), (Object)(DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[292].call((Object)path, (Object)"/")) ? path : new GStringImpl(new Object[]{path}, new String[]{"/", ""})));
        callSiteArray[293].call((Object)this.sourceCache, callSiteArray[294].call(ProjectFile.class, (Object)projectName, (Object)path));
        callSiteArray[295].call((Object)this.fileCache, callSiteArray[296].call(ProjectFile.class, (Object)projectName, (Object)path));
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[297].call(callSiteArray[298].callCurrent((GroovyObject)this), storagePath))) {
                return true;
            }
            return DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[299].call(callSiteArray[300].callCurrent((GroovyObject)this), storagePath));
        }
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[301].call((Object)this.getStorage(), storagePath))) {
            return true;
        }
        return DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[302].call((Object)this.getStorage(), storagePath));
    }

    protected boolean $tt__deleteAllProjectFileResources(String projectName, TransactionStatus transactionStatus) {
        CallSite[] callSiteArray = ProjectManagerService.$getCallSiteArray();
        Object storagePath = callSiteArray[303].call((Object)"projects/", (Object)projectName);
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[304].call(StorageUtil.class, callSiteArray[305].callCurrent((GroovyObject)this), callSiteArray[306].call(PathUtil.class, storagePath)));
        }
        return DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[307].call(StorageUtil.class, (Object)this.getStorage(), callSiteArray[308].call(PathUtil.class, storagePath)));
    }

    protected Date $tt__getProjectConfigLastModified(String projectName, TransactionStatus transactionStatus) {
        CallSite[] callSiteArray = ProjectManagerService.$getCallSiteArray();
        Object resource = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[309].callCurrent((GroovyObject)this, (Object)projectName, (Object)ETC_PROJECT_PROPERTIES_PATH);
            resource = object;
        } else {
            Resource resource2;
            resource = resource2 = this.getProjectFileResource(projectName, ETC_PROJECT_PROPERTIES_PATH);
        }
        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass() ? ScriptBytecodeAdapter.compareEqual(null, (Object)resource) : ScriptBytecodeAdapter.compareEqual(null, (Object)resource)) {
            return (Date)ScriptBytecodeAdapter.castToType(null, Date.class);
        }
        return (Date)ScriptBytecodeAdapter.castToType((Object)callSiteArray[310].callGetProperty(callSiteArray[311].call(resource)), Date.class);
    }

    protected boolean $tt__isValidConfigFile(byte[] bytes, TransactionStatus transactionStatus) {
        Object object;
        Object object2;
        CallSite[] callSiteArray = ProjectManagerService.$getCallSiteArray();
        Object test = callSiteArray[312].call((Object)"#", (Object)MIME_TYPE_PROJECT_PROPERTIES);
        Object validate = null;
        validate = !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass() ? (object2 = ScriptBytecodeAdapter.compareGreaterThanEqual((Object)callSiteArray[313].callGetProperty((Object)bytes), (Object)callSiteArray[314].call(test)) ? callSiteArray[315].callConstructor(String.class, (Object)bytes, (Object)0, callSiteArray[316].call(test), (Object)"ISO-8859-1") : null) : (object = ScriptBytecodeAdapter.compareGreaterThanEqual((Object)callSiteArray[317].callGetProperty((Object)bytes), (Object)callSiteArray[318].call(test)) ? callSiteArray[319].callConstructor(String.class, (Object)bytes, (Object)0, callSiteArray[320].call(test), (Object)"ISO-8859-1") : null);
        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return ScriptBytecodeAdapter.compareEqual((Object)test, validate);
        }
        return ScriptBytecodeAdapter.compareEqual((Object)test, (Object)validate);
    }

    protected IRundeckProject $tt__createFrameworkProject(String projectName, Properties properties, TransactionStatus transactionStatus) {
        CallSite[] callSiteArray = ProjectManagerService.$getCallSiteArray();
        Project found = (Project)ScriptBytecodeAdapter.castToType((Object)callSiteArray[321].call(Project.class, (Object)projectName), Project.class);
        if (!DefaultTypeTransformation.booleanUnbox((Object)found)) {
            Object project = callSiteArray[322].callConstructor(Project.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", projectName}));
            callSiteArray[323].call(project);
        }
        Object res = callSiteArray[324].callCurrent((GroovyObject)this, (Object)projectName, (Object)properties);
        Object object = callSiteArray[327].callGetProperty(res);
        Object object2 = callSiteArray[326].callCurrent((GroovyObject)this, (Object)projectName, DefaultTypeTransformation.booleanUnbox((Object)object) ? object : callSiteArray[328].callConstructor(Properties.class));
        Object object3 = callSiteArray[330].callGetProperty(res);
        Object rdprojectconfig = callSiteArray[325].callConstructor(RundeckProjectConfig.class, (Object)projectName, object2, callSiteArray[329].callCurrent((GroovyObject)this, (Object)projectName, DefaultTypeTransformation.booleanUnbox((Object)object3) ? object3 : callSiteArray[331].callConstructor(Properties.class)), callSiteArray[332].callGetProperty(res));
        Object newproj = callSiteArray[333].callConstructor(RundeckProject.class, rdprojectconfig, (Object)this);
        Object object4 = callSiteArray[334].callConstructor(ProjectInfo.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"projectName", projectName, "projectService", this, "description", DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[335].call(rdprojectconfig, (Object)"project.description")) ? callSiteArray[336].call(rdprojectconfig, (Object)"project.description") : null}));
        ScriptBytecodeAdapter.setProperty((Object)object4, null, (Object)newproj, (String)"info");
        Object object5 = this.nodeService;
        ScriptBytecodeAdapter.setProperty((Object)object5, null, (Object)newproj, (String)"nodesFactory");
        return (IRundeckProject)ScriptBytecodeAdapter.castToType((Object)newproj, IRundeckProject.class);
    }

    protected void $tt__removeFrameworkProject(String projectName, TransactionStatus transactionStatus) {
        CallSite[] callSiteArray = ProjectManagerService.$getCallSiteArray();
        Project found = (Project)ScriptBytecodeAdapter.castToType((Object)callSiteArray[337].call(Project.class, (Object)projectName), Project.class);
        if (!DefaultTypeTransformation.booleanUnbox((Object)found)) {
            throw (Throwable)callSiteArray[338].callConstructor(IllegalArgumentException.class, callSiteArray[339].call((Object)"project does not exist: ", (Object)projectName));
        }
        callSiteArray[340].call((Object)found, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"flush", true}));
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[341].callCurrent((GroovyObject)this, (Object)projectName);
        } else {
            this.deleteProjectResources(projectName);
        }
    }

    protected IRundeckProject $tt__createFrameworkProjectStrict(String projectName, Properties properties, TransactionStatus transactionStatus) {
        CallSite[] callSiteArray = ProjectManagerService.$getCallSiteArray();
        Project found = (Project)ScriptBytecodeAdapter.castToType((Object)callSiteArray[342].call(Project.class, (Object)projectName), Project.class);
        if (DefaultTypeTransformation.booleanUnbox((Object)found)) {
            throw (Throwable)callSiteArray[343].callConstructor(IllegalArgumentException.class, callSiteArray[344].call((Object)"project exists: ", (Object)projectName));
        }
        return (IRundeckProject)ScriptBytecodeAdapter.castToType((Object)callSiteArray[345].callCurrent((GroovyObject)this, (Object)projectName, (Object)properties), IRundeckProject.class);
    }

    protected void $tt__mergeProjectProperties(RundeckProject project, Properties properties, Set<String> removePrefixes, TransactionStatus transactionStatus) {
        Object object;
        CallSite[] callSiteArray = ProjectManagerService.$getCallSiteArray();
        Object resource = callSiteArray[346].callCurrent((GroovyObject)this, callSiteArray[347].callGetProperty((Object)project), (Object)properties, removePrefixes);
        Object object2 = callSiteArray[350].callCurrent((GroovyObject)this, callSiteArray[351].callGetProperty((Object)project), DefaultTypeTransformation.booleanUnbox((Object)(object = callSiteArray[352].callGetProperty(resource))) ? object : callSiteArray[353].callConstructor(Properties.class));
        Object object3 = callSiteArray[356].callGetProperty(resource);
        Object rdprojectconfig = callSiteArray[348].callConstructor(RundeckProjectConfig.class, callSiteArray[349].callGetProperty((Object)project), object2, callSiteArray[354].callCurrent((GroovyObject)this, callSiteArray[355].callGetProperty((Object)project), DefaultTypeTransformation.booleanUnbox((Object)object3) ? object3 : callSiteArray[357].callConstructor(Properties.class)), callSiteArray[358].callGetProperty(resource));
        Object object4 = rdprojectconfig;
        ScriptBytecodeAdapter.setProperty((Object)object4, null, (Object)project, (String)"projectConfig");
        Object object5 = this.nodeService;
        ScriptBytecodeAdapter.setProperty((Object)object5, null, (Object)project, (String)"nodesFactory");
    }

    protected Map $tt__mergeProjectProperties(String projectName, Properties properties, Set<String> removePrefixes, TransactionStatus transactionStatus) {
        CallSite[] callSiteArray = ProjectManagerService.$getCallSiteArray();
        Project found = (Project)ScriptBytecodeAdapter.castToType((Object)callSiteArray[359].call(Project.class, (Object)projectName), Project.class);
        if (!DefaultTypeTransformation.booleanUnbox((Object)found)) {
            throw (Throwable)callSiteArray[360].callConstructor(IllegalArgumentException.class, callSiteArray[361].call((Object)"project does not exist: ", (Object)projectName));
        }
        Object res = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            res = object = callSiteArray[362].callCurrent((GroovyObject)this, (Object)projectName);
        } else {
            Map map = this.loadProjectConfigResource(projectName);
            res = map;
        }
        Object oldprops = callSiteArray[363].callGetProperty(res);
        Properties newprops = (Properties)ScriptBytecodeAdapter.castToType((Object)callSiteArray[364].callStatic(ProjectManagerService.class, removePrefixes, oldprops, (Object)properties), Properties.class);
        Map newres = (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[365].callCurrent((GroovyObject)this, (Object)projectName, (Object)newprops), Map.class);
        return newres;
    }

    protected void $tt__setProjectProperties(RundeckProject project, Properties properties, TransactionStatus transactionStatus) {
        Object object;
        CallSite[] callSiteArray = ProjectManagerService.$getCallSiteArray();
        Object resource = callSiteArray[366].callCurrent((GroovyObject)this, callSiteArray[367].callGetProperty((Object)project), (Object)properties);
        Object object2 = callSiteArray[370].callCurrent((GroovyObject)this, callSiteArray[371].callGetProperty((Object)project), DefaultTypeTransformation.booleanUnbox((Object)(object = callSiteArray[372].callGetProperty(resource))) ? object : callSiteArray[373].callConstructor(Properties.class));
        Object object3 = callSiteArray[376].callGetProperty(resource);
        Object rdprojectconfig = callSiteArray[368].callConstructor(RundeckProjectConfig.class, callSiteArray[369].callGetProperty((Object)project), object2, callSiteArray[374].callCurrent((GroovyObject)this, callSiteArray[375].callGetProperty((Object)project), DefaultTypeTransformation.booleanUnbox((Object)object3) ? object3 : callSiteArray[377].callConstructor(Properties.class)), callSiteArray[378].callGetProperty(resource));
        Object object4 = rdprojectconfig;
        ScriptBytecodeAdapter.setProperty((Object)object4, null, (Object)project, (String)"projectConfig");
        Object object5 = this.nodeService;
        ScriptBytecodeAdapter.setProperty((Object)object5, null, (Object)project, (String)"nodesFactory");
    }

    protected Map $tt__setProjectProperties(String projectName, Properties properties, TransactionStatus transactionStatus) {
        CallSite[] callSiteArray = ProjectManagerService.$getCallSiteArray();
        Project found = (Project)ScriptBytecodeAdapter.castToType((Object)callSiteArray[379].call(Project.class, (Object)projectName), Project.class);
        if (!DefaultTypeTransformation.booleanUnbox((Object)found)) {
            throw (Throwable)callSiteArray[380].callConstructor(IllegalArgumentException.class, callSiteArray[381].call((Object)"project does not exist: ", (Object)projectName));
        }
        Map resource = (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[382].callCurrent((GroovyObject)this, (Object)projectName, (Object)properties), Map.class);
        return resource;
    }

    protected Authorization $tt__getProjectAuthorization(String projectName, TransactionStatus transactionStatus) {
        Reference projectName2 = new Reference((Object)projectName);
        CallSite[] callSiteArray = ProjectManagerService.$getCallSiteArray();
        callSiteArray[383].call((Object)log, (Object)new GStringImpl(new Object[]{(String)projectName2.get()}, new String[]{"ProjectManagerService.getProjectAuthorization for ", ""}));
        Object paths = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            paths = object = callSiteArray[384].callCurrent((GroovyObject)this, (Object)((String)projectName2.get()), (Object)"acls", (Object)".*\\.aclpolicy");
        } else {
            List list = this.listProjectDirPaths((String)projectName2.get(), "acls", ".*\\.aclpolicy");
            paths = list;
        }
        callSiteArray[385].call((Object)log, (Object)new GStringImpl(new Object[]{paths}, new String[]{"ProjectManagerService.getProjectAuthorization. paths= ", ""}));
        Object sources = callSiteArray[386].call(callSiteArray[387].call(paths, (Object)new /* Unavailable Anonymous Inner Class!! */), (Object)new /* Unavailable Anonymous Inner Class!! */);
        Object context = callSiteArray[388].call(AuthorizationUtil.class, (Object)((String)projectName2.get()));
        return (Authorization)ScriptBytecodeAdapter.castToType((Object)callSiteArray[389].call(AclsUtil.class, callSiteArray[390].callConstructor(Policies.class, callSiteArray[391].call(PoliciesCache.class, sources, context))), Authorization.class);
    }

    /*
     * WARNING - void declaration
     */
    protected boolean $tt__needsReloadAcl(ProjectFile key, CacheableYamlSource source, TransactionStatus transactionStatus) {
        void var2_2;
        Reference key2 = new Reference((Object)key);
        Reference source2 = new Reference((Object)var2_2);
        CallSite[] callSiteArray = ProjectManagerService.$getCallSiteArray();
        Reference needsReload = new Reference((Object)true);
        callSiteArray[392].call(Storage.class, (Object)new /* Unavailable Anonymous Inner Class!! */);
        return DefaultTypeTransformation.booleanUnbox((Object)((Boolean)needsReload.get()));
    }

    protected IRundeckProjectConfig $tt__loadProjectConfig(String project, TransactionStatus transactionStatus) {
        CallSite[] callSiteArray = ProjectManagerService.$getCallSiteArray();
        Object resource = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            resource = object = callSiteArray[393].callCurrent((GroovyObject)this, (Object)project);
        } else {
            Map map = this.loadProjectConfigResource(project);
            resource = map;
        }
        Object object = callSiteArray[396].callGetProperty(resource);
        Object object2 = callSiteArray[399].callGetProperty(resource);
        Object rdprojectconfig = callSiteArray[394].callConstructor(RundeckProjectConfig.class, (Object)project, callSiteArray[395].callCurrent((GroovyObject)this, (Object)project, DefaultTypeTransformation.booleanUnbox((Object)object) ? object : callSiteArray[397].callConstructor(Properties.class)), callSiteArray[398].callCurrent((GroovyObject)this, (Object)project, DefaultTypeTransformation.booleanUnbox((Object)object2) ? object2 : callSiteArray[400].callConstructor(Properties.class)), callSiteArray[401].callGetProperty(resource));
        return (IRundeckProjectConfig)ScriptBytecodeAdapter.castToType((Object)rdprojectconfig, IRundeckProjectConfig.class);
    }

    protected IRundeckProject $tt__loadProject(String project, TransactionStatus transactionStatus) {
        Object object;
        Object object2;
        CallSite[] callSiteArray = ProjectManagerService.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass() ? !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[402].callCurrent((GroovyObject)this, (Object)project)) : !this.existsFrameworkProject(project)) {
            return (IRundeckProject)ScriptBytecodeAdapter.castToType(null, IRundeckProject.class);
        }
        long start = DefaultTypeTransformation.longUnbox((Object)callSiteArray[403].call(System.class));
        callSiteArray[404].call((Object)log, (Object)new GStringImpl(new Object[]{project}, new String[]{"Loading project definition for ", "..."}));
        Object rdproject = null;
        rdproject = __$stMC || BytecodeInterface8.disabledStandardMetaClass() ? (object2 = callSiteArray[405].callConstructor(RundeckProject.class, callSiteArray[406].callCurrent((GroovyObject)this, (Object)project), (Object)this)) : (object = callSiteArray[407].callConstructor(RundeckProject.class, (Object)this.loadProjectConfig(project), (Object)this));
        String readme = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object3 = callSiteArray[408].callCurrent((GroovyObject)this, (Object)project, (Object)"readme.md");
            readme = ShortTypeHandling.castToString((Object)object3);
        } else {
            String string;
            readme = string = this.readCachedProjectFileAsAstring(project, "readme.md");
        }
        String motd = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object4 = callSiteArray[409].callCurrent((GroovyObject)this, (Object)project, (Object)"motd.md");
            motd = ShortTypeHandling.castToString((Object)object4);
        } else {
            String string;
            motd = string = this.readCachedProjectFileAsAstring(project, "motd.md");
        }
        Object object5 = callSiteArray[410].callConstructor(ProjectInfo.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"projectName", project, "projectService", this, "description", DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[411].call(rdproject, (Object)"project.description")) ? callSiteArray[412].call(rdproject, (Object)"project.description") : null}));
        ScriptBytecodeAdapter.setProperty((Object)object5, null, (Object)rdproject, (String)"info");
        Object object6 = this.nodeService;
        ScriptBytecodeAdapter.setProperty((Object)object6, null, (Object)rdproject, (String)"nodesFactory");
        callSiteArray[413].call((Object)log, (Object)new GStringImpl(new Object[]{project, callSiteArray[414].call(callSiteArray[415].call(System.class), (Object)start)}, new String[]{"Loaded project ", " in ", "ms"}));
        return (IRundeckProject)ScriptBytecodeAdapter.castToType((Object)rdproject, IRundeckProject.class);
    }

    protected boolean $tt__needsReload(IRundeckProject project, TransactionStatus transactionStatus) {
        Reference project2 = new Reference((Object)project);
        CallSite[] callSiteArray = ProjectManagerService.$getCallSiteArray();
        return DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[416].call(Project.class, (Object)new /* Unavailable Anonymous Inner Class!! */));
    }

    protected String $tt__getNodesResourceFilePath(IRundeckProject project, TransactionStatus transactionStatus) {
        CallSite[] callSiteArray = ProjectManagerService.$getCallSiteArray();
        return ShortTypeHandling.castToString((Object)callSiteArray[417].call(ProjectNodeSupport.class, (Object)project, callSiteArray[418].call((Object)this.frameworkService)));
    }

    protected boolean $tt__testProjectWasImported(ProjectManager source, String projectName, TransactionStatus transactionStatus) {
        CallSite[] callSiteArray = ProjectManagerService.$getCallSiteArray();
        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[419].call((Object)source, (Object)projectName)) && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[420].call(callSiteArray[421].call((Object)source, (Object)projectName), (Object)"etc/project.properties.imported"));
        }
        return DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[422].call((Object)source, (Object)projectName)) && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[423].call(callSiteArray[424].call((Object)source, (Object)projectName), (Object)"etc/project.properties.imported"));
    }

    protected void $tt__markProjectAsImported(ProjectManager source, String projectName, TransactionStatus transactionStatus) {
        CallSite[] callSiteArray = ProjectManagerService.$getCallSiteArray();
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[425].call((Object)source, (Object)projectName))) {
            IRundeckProject other = (IRundeckProject)ScriptBytecodeAdapter.castToType((Object)callSiteArray[426].call((Object)source, (Object)projectName), IRundeckProject.class);
            try {
                Object baos = callSiteArray[427].callConstructor(ByteArrayOutputStream.class);
                callSiteArray[428].call((Object)other, (Object)"etc/project.properties", baos);
                callSiteArray[429].call((Object)other, (Object)"etc/project.properties.imported", callSiteArray[430].callConstructor(ByteArrayInputStream.class, callSiteArray[431].call(baos)));
                callSiteArray[432].call((Object)other, (Object)"etc/project.properties");
                callSiteArray[433].call((Object)log, (Object)new GStringImpl(new Object[]{callSiteArray[434].callGetProperty((Object)other)}, new String[]{"Filesystem project ", ", marked as imported. Rename etc/project.properties to etc/project.properties.imported"}));
            }
            catch (IOException e) {
                callSiteArray[435].call((Object)log, (Object)new GStringImpl(new Object[]{callSiteArray[436].callGetProperty((Object)other), callSiteArray[437].callGetProperty((Object)e)}, new String[]{"Failed marking ", " as imported (rename etc/project.properties to etc/project.properties.imported): ", ""}), (Object)e);
            }
        }
    }

    protected void $tt__importProjectsFromProjectManager(ProjectManager source, TransactionStatus transactionStatus) {
        Reference source2 = new Reference((Object)source);
        CallSite[] callSiteArray = ProjectManagerService.$getCallSiteArray();
        callSiteArray[438].call(callSiteArray[439].call((Object)((ProjectManager)source2.get())), (Object)new /* Unavailable Anonymous Inner Class!! */);
    }

    public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
        CallSite[] callSiteArray = ProjectManagerService.$getCallSiteArray();
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(ProjectManagerService.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$1(String name, Object value) {
        CallSite[] callSiteArray = ProjectManagerService.$getCallSiteArray();
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, ProjectManagerService.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$1(String name) {
        CallSite[] callSiteArray = ProjectManagerService.$getCallSiteArray();
        return ScriptBytecodeAdapter.getGroovyObjectProperty(ProjectManagerService.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    /*
     * WARNING - void declaration
     */
    public List<String> listProjectDirPaths(String projectName, String path) {
        void var2_2;
        Reference projectName2 = new Reference((Object)projectName);
        Reference path2 = new Reference((Object)var2_2);
        CallSite[] callSiteArray = ProjectManagerService.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return this.listProjectDirPaths((String)projectName2.get(), (String)path2.get(), null);
        }
        return this.listProjectDirPaths((String)projectName2.get(), (String)path2.get(), null);
    }

    protected List $tt__listProjectDirPaths(String projectName, String path, TransactionStatus transactionStatus) {
        CallSite[] callSiteArray = ProjectManagerService.$getCallSiteArray();
        return this.$tt__listProjectDirPaths(projectName, path, null, transactionStatus);
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    public static /* synthetic */ void __$swapInit() {
        CallSite[] callSiteArray = ProjectManagerService.$getCallSiteArray();
        $callSiteArray = null;
    }

    static {
        ProjectManagerService.__$swapInit();
        Long l = 0L;
        __timeStamp__239_neverHappen1460763730918 = l;
        Long l2 = 1460763730918L;
        __timeStamp = l2;
        Object object = ProjectManagerService.$getCallSiteArray()[440].call(LogFactory.class, (Object)"grails.app.services.rundeck.services.ProjectManagerService");
        log = (Log)ScriptBytecodeAdapter.castToType((Object)object, Log.class);
    }

    public FrameworkService getFrameworkService() {
        return this.frameworkService;
    }

    public void setFrameworkService(FrameworkService frameworkService) {
        this.frameworkService = frameworkService;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public ConfigurationService getConfigurationService() {
        return this.configurationService;
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    public Object getGrailsApplication() {
        return this.grailsApplication;
    }

    public void setGrailsApplication(Object object) {
        this.grailsApplication = object;
    }

    public Object getMetricService() {
        return this.metricService;
    }

    public void setMetricService(Object object) {
        this.metricService = object;
    }

    public Object getNodeService() {
        return this.nodeService;
    }

    public void setNodeService(Object object) {
        this.nodeService = object;
    }

    public LoadingCache<String, IRundeckProject> getProjectCache() {
        return this.projectCache;
    }

    public void setProjectCache(LoadingCache<String, IRundeckProject> loadingCache) {
        this.projectCache = loadingCache;
    }

    public PlatformTransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public void setTransactionManager(PlatformTransactionManager platformTransactionManager) {
        this.transactionManager = platformTransactionManager;
    }

    public /* synthetic */ StorageTree this$2$getStorage() {
        return this.getStorage();
    }

    public /* synthetic */ Map this$2$loadProjectConfigResource(String string) {
        return this.loadProjectConfigResource(string);
    }

    public /* synthetic */ Map this$2$storeProjectConfig(String string, Properties properties) {
        return this.storeProjectConfig(string, properties);
    }

    public /* synthetic */ void this$2$deleteProjectResources(String string) {
        this.deleteProjectResources(string);
    }

    public /* synthetic */ IPropertyLookup this$2$createProjectPropertyLookup(String string, Properties properties) {
        return this.createProjectPropertyLookup(string, properties);
    }

    public /* synthetic */ IPropertyLookup this$2$createDirectProjectPropertyLookup(String string, Properties properties) {
        return this.createDirectProjectPropertyLookup(string, properties);
    }

    public /* synthetic */ CacheableYamlSource this$2$loadYamlSource(ProjectFile projectFile) {
        return this.loadYamlSource(projectFile);
    }

    public /* synthetic */ void super$1$wait() {
        super.wait();
    }

    public /* synthetic */ String super$1$toString() {
        return super.toString();
    }

    public /* synthetic */ void super$1$wait(long l) {
        super.wait(l);
    }

    public /* synthetic */ void super$1$wait(long l, int n) {
        super.wait(l, n);
    }

    public /* synthetic */ void super$1$notify() {
        super.notify();
    }

    public /* synthetic */ void super$1$notifyAll() {
        super.notifyAll();
    }

    public /* synthetic */ Class super$1$getClass() {
        return super.getClass();
    }

    public /* synthetic */ Object super$1$clone() {
        return super.clone();
    }

    public /* synthetic */ boolean super$1$equals(Object object) {
        return super.equals(object);
    }

    public /* synthetic */ int super$1$hashCode() {
        return super.hashCode();
    }

    public /* synthetic */ void super$1$finalize() {
        super.finalize();
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "newFixedThreadPool";
        stringArray[1] = "build";
        stringArray[2] = "refreshAfterWrite";
        stringArray[3] = "expireAfterAccess";
        stringArray[4] = "newBuilder";
        stringArray[5] = "MINUTES";
        stringArray[6] = "MINUTES";
        stringArray[7] = "build";
        stringArray[8] = "refreshAfterWrite";
        stringArray[9] = "newBuilder";
        stringArray[10] = "MINUTES";
        stringArray[11] = "build";
        stringArray[12] = "refreshAfterWrite";
        stringArray[13] = "newBuilder";
        stringArray[14] = "MINUTES";
        stringArray[15] = "getBean";
        stringArray[16] = "getBean";
        stringArray[17] = "<$constructor$>";
        stringArray[18] = "<$constructor$>";
        stringArray[19] = "<$constructor$>";
        stringArray[20] = "<$constructor$>";
        stringArray[21] = "<$constructor$>";
        stringArray[22] = "<$constructor$>";
        stringArray[23] = "<$constructor$>";
        stringArray[24] = "<$constructor$>";
        stringArray[25] = "<$constructor$>";
        stringArray[26] = "<$constructor$>";
        stringArray[27] = "getCacheSpecFor";
        stringArray[28] = "debug";
        stringArray[29] = "build";
        stringArray[30] = "recordStats";
        stringArray[31] = "from";
        stringArray[32] = "getCacheSpecFor";
        stringArray[33] = "debug";
        stringArray[34] = "build";
        stringArray[35] = "recordStats";
        stringArray[36] = "from";
        stringArray[37] = "getCacheSpecFor";
        stringArray[38] = "debug";
        stringArray[39] = "build";
        stringArray[40] = "recordStats";
        stringArray[41] = "from";
        stringArray[42] = "getMetricRegistry";
        stringArray[43] = "addCacheMetrics";
        stringArray[44] = "plus";
        stringArray[45] = "name";
        stringArray[46] = "class";
        stringArray[47] = "addCacheMetrics";
        stringArray[48] = "plus";
        stringArray[49] = "name";
        stringArray[50] = "class";
        stringArray[51] = "addCacheMetrics";
        stringArray[52] = "plus";
        stringArray[53] = "name";
        stringArray[54] = "class";
        stringArray[55] = "<$constructor$>";
        stringArray[56] = "<$constructor$>";
        stringArray[57] = "<$constructor$>";
        stringArray[58] = "<$constructor$>";
        stringArray[59] = "<$constructor$>";
        stringArray[60] = "<$constructor$>";
        stringArray[61] = "<$constructor$>";
        stringArray[62] = "<$constructor$>";
        stringArray[63] = "<$constructor$>";
        stringArray[64] = "<$constructor$>";
        stringArray[65] = "<$constructor$>";
        stringArray[66] = "<$constructor$>";
        stringArray[67] = "<$constructor$>";
        stringArray[68] = "<$constructor$>";
        stringArray[69] = "<$constructor$>";
        stringArray[70] = "<$constructor$>";
        stringArray[71] = "<$constructor$>";
        stringArray[72] = "<$constructor$>";
        stringArray[73] = "<$constructor$>";
        stringArray[74] = "<$constructor$>";
        stringArray[75] = "<$constructor$>";
        stringArray[76] = "<$constructor$>";
        stringArray[77] = "<$constructor$>";
        stringArray[78] = "<$constructor$>";
        stringArray[79] = "<$constructor$>";
        stringArray[80] = "<$constructor$>";
        stringArray[81] = "<$constructor$>";
        stringArray[82] = "<$constructor$>";
        stringArray[83] = "getProjectFileResource";
        stringArray[84] = "<$constructor$>";
        stringArray[85] = "<$constructor$>";
        stringArray[86] = "copy";
        stringArray[87] = "inputStream";
        stringArray[88] = "contents";
        stringArray[89] = "toByteArray";
        stringArray[90] = "isValidConfigFile";
        stringArray[91] = "load";
        stringArray[92] = "<$constructor$>";
        stringArray[93] = "error";
        stringArray[94] = "plus";
        stringArray[95] = "path";
        stringArray[96] = "message";
        stringArray[97] = "error";
        stringArray[98] = "path";
        stringArray[99] = "modificationTime";
        stringArray[100] = "contents";
        stringArray[101] = "creationTime";
        stringArray[102] = "contents";
        stringArray[103] = "<$constructor$>";
        stringArray[104] = "putAt";
        stringArray[105] = "store";
        stringArray[106] = "plus";
        stringArray[107] = "plus";
        stringArray[108] = "<$constructor$>";
        stringArray[109] = "toByteArray";
        stringArray[110] = "RES_META_RUNDECK_CONTENT_TYPE";
        stringArray[111] = "writeProjectFileResource";
        stringArray[112] = "invalidate";
        stringArray[113] = "expireProjectNodes";
        stringArray[114] = "modificationTime";
        stringArray[115] = "contents";
        stringArray[116] = "creationTime";
        stringArray[117] = "contents";
        stringArray[118] = "deleteAllProjectFileResources";
        stringArray[119] = "error";
        stringArray[120] = "error";
        stringArray[121] = "invalidate";
        stringArray[122] = "expireProjectNodes";
        stringArray[123] = "<$constructor$>";
        stringArray[124] = "setProperty";
        stringArray[125] = "create";
        stringArray[126] = "createDirectProjectPropertyLookup";
        stringArray[127] = "propertyLookup";
        stringArray[128] = "getRundeckFramework";
        stringArray[129] = "expand";
        stringArray[130] = "<$constructor$>";
        stringArray[131] = "setProperty";
        stringArray[132] = "putAll";
        stringArray[133] = "create";
        stringArray[134] = "expand";
        stringArray[135] = "<$constructor$>";
        stringArray[136] = "<$constructor$>";
        stringArray[137] = "<$constructor$>";
        stringArray[138] = "<$constructor$>";
        stringArray[139] = "<$constructor$>";
        stringArray[140] = "<$constructor$>";
        stringArray[141] = "<$constructor$>";
        stringArray[142] = "<$constructor$>";
        stringArray[143] = "<$constructor$>";
        stringArray[144] = "<$constructor$>";
        stringArray[145] = "<$constructor$>";
        stringArray[146] = "each";
        stringArray[147] = "propertyNames";
        stringArray[148] = "putAll";
        stringArray[149] = "putAll";
        stringArray[150] = "<$constructor$>";
        stringArray[151] = "<$constructor$>";
        stringArray[152] = "<$constructor$>";
        stringArray[153] = "<$constructor$>";
        stringArray[154] = "existsProjectFileResource";
        stringArray[155] = "project";
        stringArray[156] = "path";
        stringArray[157] = "debug";
        stringArray[158] = "project";
        stringArray[159] = "getProjectFileResource";
        stringArray[160] = "project";
        stringArray[161] = "path";
        stringArray[162] = "contents";
        stringArray[163] = "getText";
        stringArray[164] = "inputStream";
        stringArray[165] = "sourceFromString";
        stringArray[166] = "project";
        stringArray[167] = "path";
        stringArray[168] = "modificationTime";
        stringArray[169] = "<$constructor$>";
        stringArray[170] = "<$constructor$>";
        stringArray[171] = "<$constructor$>";
        stringArray[172] = "<$constructor$>";
        stringArray[173] = "<$constructor$>";
        stringArray[174] = "<$constructor$>";
        stringArray[175] = "<$constructor$>";
        stringArray[176] = "<$constructor$>";
        stringArray[177] = "<$constructor$>";
        stringArray[178] = "<$constructor$>";
        stringArray[179] = "<$constructor$>";
        stringArray[180] = "<$constructor$>";
        stringArray[181] = "<$constructor$>";
        stringArray[182] = "<$constructor$>";
        stringArray[183] = "<$constructor$>";
        stringArray[184] = "<$constructor$>";
        stringArray[185] = "<$constructor$>";
        stringArray[186] = "<$constructor$>";
        stringArray[187] = "collect";
        stringArray[188] = "findAll";
        stringArray[189] = "createCriteria";
        stringArray[190] = "list";
        stringArray[191] = "getIfPresent";
        stringArray[192] = "existsFrameworkProject";
        stringArray[193] = "<$constructor$>";
        stringArray[194] = "plus";
        stringArray[195] = "getIfPresent";
        stringArray[196] = "<$constructor$>";
        stringArray[197] = "plus";
        stringArray[198] = "get";
        stringArray[199] = "<$constructor$>";
        stringArray[200] = "plus";
        stringArray[201] = "withNewSession";
        stringArray[202] = "createFrameworkProject";
        stringArray[203] = "<$constructor$>";
        stringArray[204] = "plus";
        stringArray[205] = "plus";
        stringArray[206] = "startsWith";
        stringArray[207] = "hasResource";
        stringArray[208] = "getStorage";
        stringArray[209] = "hasResource";
        stringArray[210] = "plus";
        stringArray[211] = "plus";
        stringArray[212] = "startsWith";
        stringArray[213] = "hasDirectory";
        stringArray[214] = "getStorage";
        stringArray[215] = "hasDirectory";
        stringArray[216] = "plus";
        stringArray[217] = "plus";
        stringArray[218] = "startsWith";
        stringArray[219] = "hasResource";
        stringArray[220] = "getStorage";
        stringArray[221] = "hasResource";
        stringArray[222] = "getResource";
        stringArray[223] = "getStorage";
        stringArray[224] = "getResource";
        stringArray[225] = "plus";
        stringArray[226] = "plus";
        stringArray[227] = "startsWith";
        stringArray[228] = "getResource";
        stringArray[229] = "getStorage";
        stringArray[230] = "getResource";
        stringArray[231] = "copy";
        stringArray[232] = "inputStream";
        stringArray[233] = "contents";
        stringArray[234] = "get";
        stringArray[235] = "of";
        stringArray[236] = "isPresent";
        stringArray[237] = "get";
        stringArray[238] = "existsProjectFileResource";
        stringArray[239] = "<$constructor$>";
        stringArray[240] = "readProjectFileResource";
        stringArray[241] = "toString";
        stringArray[242] = "plus";
        stringArray[243] = "plus";
        stringArray[244] = "startsWith";
        stringArray[245] = "listDirectory";
        stringArray[246] = "getStorage";
        stringArray[247] = "listDirectory";
        stringArray[248] = "endsWith";
        stringArray[249] = "substring";
        stringArray[250] = "minus";
        stringArray[251] = "length";
        stringArray[252] = "findAll";
        stringArray[253] = "collect";
        stringArray[254] = "plus";
        stringArray[255] = "plus";
        stringArray[256] = "startsWith";
        stringArray[257] = "updateResource";
        stringArray[258] = "getStorage";
        stringArray[259] = "withStream";
        stringArray[260] = "factory";
        stringArray[261] = "updateResource";
        stringArray[262] = "withStream";
        stringArray[263] = "factory";
        stringArray[264] = "invalidate";
        stringArray[265] = "of";
        stringArray[266] = "plus";
        stringArray[267] = "plus";
        stringArray[268] = "startsWith";
        stringArray[269] = "createResource";
        stringArray[270] = "getStorage";
        stringArray[271] = "withStream";
        stringArray[272] = "factory";
        stringArray[273] = "createResource";
        stringArray[274] = "withStream";
        stringArray[275] = "factory";
        stringArray[276] = "invalidate";
        stringArray[277] = "of";
        stringArray[278] = "plus";
        stringArray[279] = "plus";
        stringArray[280] = "startsWith";
        stringArray[281] = "invalidate";
        stringArray[282] = "of";
        stringArray[283] = "hasResource";
        stringArray[284] = "getStorage";
        stringArray[285] = "createProjectFileResource";
        stringArray[286] = "updateProjectFileResource";
        stringArray[287] = "hasResource";
        stringArray[288] = "createProjectFileResource";
        stringArray[289] = "updateProjectFileResource";
        stringArray[290] = "plus";
        stringArray[291] = "plus";
        stringArray[292] = "startsWith";
        stringArray[293] = "invalidate";
        stringArray[294] = "of";
        stringArray[295] = "invalidate";
        stringArray[296] = "of";
        stringArray[297] = "hasResource";
        stringArray[298] = "getStorage";
        stringArray[299] = "deleteResource";
        stringArray[300] = "getStorage";
        stringArray[301] = "hasResource";
        stringArray[302] = "deleteResource";
        stringArray[303] = "plus";
        stringArray[304] = "deletePathRecursive";
        stringArray[305] = "getStorage";
        stringArray[306] = "asPath";
        stringArray[307] = "deletePathRecursive";
        stringArray[308] = "asPath";
        stringArray[309] = "getProjectFileResource";
        stringArray[310] = "modificationTime";
        stringArray[311] = "getContents";
        stringArray[312] = "plus";
        stringArray[313] = "length";
        stringArray[314] = "length";
        stringArray[315] = "<$constructor$>";
        stringArray[316] = "length";
        stringArray[317] = "length";
        stringArray[318] = "length";
        stringArray[319] = "<$constructor$>";
        stringArray[320] = "length";
        stringArray[321] = "findByName";
        stringArray[322] = "<$constructor$>";
        stringArray[323] = "save";
        stringArray[324] = "storeProjectConfig";
        stringArray[325] = "<$constructor$>";
        stringArray[326] = "createProjectPropertyLookup";
        stringArray[327] = "config";
        stringArray[328] = "<$constructor$>";
        stringArray[329] = "createDirectProjectPropertyLookup";
        stringArray[330] = "config";
        stringArray[331] = "<$constructor$>";
        stringArray[332] = "lastModified";
        stringArray[333] = "<$constructor$>";
        stringArray[334] = "<$constructor$>";
        stringArray[335] = "hasProperty";
        stringArray[336] = "getProperty";
        stringArray[337] = "findByName";
        stringArray[338] = "<$constructor$>";
        stringArray[339] = "plus";
        stringArray[340] = "delete";
        stringArray[341] = "deleteProjectResources";
        stringArray[342] = "findByName";
        stringArray[343] = "<$constructor$>";
        stringArray[344] = "plus";
        stringArray[345] = "createFrameworkProject";
        stringArray[346] = "mergeProjectProperties";
        stringArray[347] = "name";
        stringArray[348] = "<$constructor$>";
        stringArray[349] = "name";
        stringArray[350] = "createProjectPropertyLookup";
        stringArray[351] = "name";
        stringArray[352] = "config";
        stringArray[353] = "<$constructor$>";
        stringArray[354] = "createDirectProjectPropertyLookup";
        stringArray[355] = "name";
        stringArray[356] = "config";
        stringArray[357] = "<$constructor$>";
        stringArray[358] = "lastModified";
        stringArray[359] = "findByName";
        stringArray[360] = "<$constructor$>";
        stringArray[361] = "plus";
        stringArray[362] = "loadProjectConfigResource";
        stringArray[363] = "config";
        stringArray[364] = "mergeProperties";
        stringArray[365] = "storeProjectConfig";
        stringArray[366] = "setProjectProperties";
        stringArray[367] = "name";
        stringArray[368] = "<$constructor$>";
        stringArray[369] = "name";
        stringArray[370] = "createProjectPropertyLookup";
        stringArray[371] = "name";
        stringArray[372] = "config";
        stringArray[373] = "<$constructor$>";
        stringArray[374] = "createDirectProjectPropertyLookup";
        stringArray[375] = "name";
        stringArray[376] = "config";
        stringArray[377] = "<$constructor$>";
        stringArray[378] = "lastModified";
        stringArray[379] = "findByName";
        stringArray[380] = "<$constructor$>";
        stringArray[381] = "plus";
        stringArray[382] = "storeProjectConfig";
        stringArray[383] = "debug";
        stringArray[384] = "listProjectDirPaths";
        stringArray[385] = "debug";
        stringArray[386] = "findAll";
        stringArray[387] = "collect";
        stringArray[388] = "projectContext";
        stringArray[389] = "createAuthorization";
        stringArray[390] = "<$constructor$>";
        stringArray[391] = "fromSources";
        stringArray[392] = "withNewSession";
        stringArray[393] = "loadProjectConfigResource";
        stringArray[394] = "<$constructor$>";
        stringArray[395] = "createProjectPropertyLookup";
        stringArray[396] = "config";
        stringArray[397] = "<$constructor$>";
        stringArray[398] = "createDirectProjectPropertyLookup";
        stringArray[399] = "config";
        stringArray[400] = "<$constructor$>";
        stringArray[401] = "lastModified";
        stringArray[402] = "existsFrameworkProject";
        stringArray[403] = "currentTimeMillis";
        stringArray[404] = "info";
        stringArray[405] = "<$constructor$>";
        stringArray[406] = "loadProjectConfig";
        stringArray[407] = "<$constructor$>";
        stringArray[408] = "readCachedProjectFileAsAstring";
        stringArray[409] = "readCachedProjectFileAsAstring";
        stringArray[410] = "<$constructor$>";
        stringArray[411] = "hasProperty";
        stringArray[412] = "getProperty";
        stringArray[413] = "info";
        stringArray[414] = "minus";
        stringArray[415] = "currentTimeMillis";
        stringArray[416] = "withNewSession";
        stringArray[417] = "getNodesResourceFilePath";
        stringArray[418] = "getRundeckFramework";
        stringArray[419] = "existsFrameworkProject";
        stringArray[420] = "existsFileResource";
        stringArray[421] = "getFrameworkProject";
        stringArray[422] = "existsFrameworkProject";
        stringArray[423] = "existsFileResource";
        stringArray[424] = "getFrameworkProject";
        stringArray[425] = "existsFrameworkProject";
        stringArray[426] = "getFrameworkProject";
        stringArray[427] = "<$constructor$>";
        stringArray[428] = "loadFileResource";
        stringArray[429] = "storeFileResource";
        stringArray[430] = "<$constructor$>";
        stringArray[431] = "toByteArray";
        stringArray[432] = "deleteFileResource";
        stringArray[433] = "warn";
        stringArray[434] = "name";
        stringArray[435] = "error";
        stringArray[436] = "name";
        stringArray[437] = "message";
        stringArray[438] = "each";
        stringArray[439] = "listFrameworkProjects";
        stringArray[440] = "getLog";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[441];
        ProjectManagerService.$createCallSiteArray_1((String[])stringArray);
        return new CallSiteArray(ProjectManagerService.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = ProjectManagerService.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

