/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.grails.profiler;

import com.linkedin.grails.profiler.ClassUtil;
import com.linkedin.grails.profiler.ProfilerLog;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

public class ProfilerMethodInterceptor
implements MethodInterceptor {
    private ProfilerLog profiler;

    public void setProfiler(ProfilerLog profiler) {
        this.profiler = profiler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        String methodName = methodInvocation.getMethod().getName();
        if (methodName.equals("getMetaClass")) {
            return methodInvocation.proceed();
        }
        if (methodName.equals("invokeMethod") && methodInvocation.getMethod().getParameterTypes()[0] == String.class) {
            methodName = (String)methodInvocation.getArguments()[0];
        }
        Class clazz = ClassUtil.getRealClass(methodInvocation.getThis().getClass());
        this.profiler.logEntry(clazz, methodName);
        try {
            Object object = methodInvocation.proceed();
            return object;
        }
        finally {
            this.profiler.logExit(clazz, methodName);
        }
    }
}

