/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.grails.profiler;

import com.linkedin.grails.profiler.ProfilerAppender;
import com.linkedin.grails.profiler.RequestBufferedAppender;
import org.codehaus.groovy.grails.web.servlet.mvc.GrailsWebRequest;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

public class RequestBufferedAppender
implements ProfilerAppender {
    private static final String INFO_ATTR = "com.linkedin.grails.profile.BufferedAppenderInfo";

    public void logEntry(String label, Class<?> clazz, String name, long entryTime) {
        RequestInfo info = this.getRequestInfo();
        if (info == null) {
            return;
        }
        info.logStart(entryTime);
        info.log("Entering " + this.getIdentity(label, clazz, name));
        info.incrementIndent();
    }

    public void logExit(String label, Class<?> clazz, String name, long exitTime) {
        RequestInfo info = this.getRequestInfo();
        if (info == null) {
            return;
        }
        long totalTime = exitTime - info.getStartTime();
        info.decrementIndent();
        info.log("Exiting " + this.getIdentity(label, clazz, name) + "   (Time: " + totalTime + ")");
    }

    public void prependOutput(String text) {
        RequestInfo info = this.getRequestInfo();
        if (info != null) {
            info.prependText(text + '\n');
        }
    }

    public String getOutput() {
        GrailsWebRequest webRequest = this.getWebRequest();
        if (webRequest == null) {
            return null;
        }
        RequestInfo info = (RequestInfo)webRequest.getAttribute(INFO_ATTR, 0);
        return info == null ? null : info.getOutput();
    }

    private GrailsWebRequest getWebRequest() {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        return requestAttributes == null ? null : (GrailsWebRequest)requestAttributes;
    }

    private RequestInfo getRequestInfo() {
        RequestInfo info = null;
        GrailsWebRequest webRequest = this.getWebRequest();
        if (webRequest != null) {
            Object infoAttr = webRequest.getAttribute(INFO_ATTR, 0);
            if (infoAttr == null) {
                infoAttr = new RequestInfo(null);
                webRequest.setAttribute(INFO_ATTR, infoAttr, 0);
            }
            info = (RequestInfo)infoAttr;
        }
        return info;
    }

    private String getIdentity(String label, Class<?> clazz, String name) {
        return "[" + label + "] " + clazz.getName() + ":" + name;
    }
}

