/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.grails.profiler;

import com.linkedin.grails.profiler.ProfilerCondition;
import com.linkedin.grails.profiler.ProfilerFilterResponse;
import com.linkedin.grails.profiler.ProfilerLog;
import com.linkedin.grails.profiler.RequestBufferedAppender;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.filter.OncePerRequestFilter;

public class ProfilerFilter
extends OncePerRequestFilter {
    public static final String SAVED_OUTPUT_KEY = "com.linkedin.grails.profiler.saved_output";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        WebApplicationContext appContext = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext());
        ProfilerCondition conditionBean = (ProfilerCondition)appContext.getBean("profilerCondition");
        Object output = null;
        HttpSession session = request.getSession(false);
        if (session != null) {
            output = session.getAttribute(SAVED_OUTPUT_KEY);
            session.removeAttribute(SAVED_OUTPUT_KEY);
        }
        boolean doProfiling = output != null || conditionBean.doProfiling();
        ProfilerLog profiler = null;
        RequestBufferedAppender appender = null;
        if (doProfiling) {
            session = request.getSession(true);
            profiler = (ProfilerLog)appContext.getBean("profilerLog");
            appender = (RequestBufferedAppender)appContext.getBean("bufferedAppender");
            if (output instanceof String) {
                appender.prependOutput((String)output);
            }
            profiler.startProfiling("uri: " + request.getRequestURI());
            profiler.logEntry(this.getClass(), "Web Request");
        }
        ProfilerFilterResponse filterResponse = new ProfilerFilterResponse(response);
        try {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)filterResponse);
        }
        finally {
            if (doProfiling) {
                profiler.logExit(this.getClass(), "Web Request");
                profiler.stopProfiling();
                if (filterResponse.getSaveOutput()) {
                    session.setAttribute(SAVED_OUTPUT_KEY, (Object)appender.getOutput());
                }
            }
        }
    }
}

