/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.server.filters;

import java.io.IOException;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.log4j.Logger;
import org.codehaus.groovy.grails.commons.GrailsApplication;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class AuthFilter
implements Filter {
    private static final transient Logger LOG = Logger.getLogger(AuthFilter.class);
    boolean enabled;
    String rolesAttribute;
    String userNameHeader;
    String rolesHeader;

    public void init(FilterConfig filterConfig) throws ServletException {
        WebApplicationContext springContext = WebApplicationContextUtils.getWebApplicationContext((ServletContext)filterConfig.getServletContext());
        GrailsApplication grailsApplication = (GrailsApplication)springContext.getBean(GrailsApplication.class);
        if (grailsApplication.equals(null)) {
            throw new IllegalStateException("grailsApplication not found in context");
        }
        Map map = grailsApplication.getFlatConfig();
        Object o = map.get("rundeck.security.authorization.preauthenticated.enabled");
        this.enabled = Boolean.parseBoolean(o.toString());
        this.rolesAttribute = (String)map.get("rundeck.security.authorization.preauthenticated.attributeName");
        this.rolesHeader = (String)map.get("rundeck.security.authorization.preauthenticated.userRolesHeader");
        this.userNameHeader = (String)map.get("rundeck.security.authorization.preauthenticated.userNameHeader");
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequestWrapper requestModified;
        if (!this.enabled) {
            filterChain.doFilter(request, response);
            return;
        }
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        if (this.userNameHeader != null) {
            String forwardedUser = httpRequest.getHeader(this.userNameHeader);
            LOG.info((Object)("User header " + this.userNameHeader));
            LOG.info((Object)("User / UUID recieved " + forwardedUser));
            requestModified = new /* Unavailable Anonymous Inner Class!! */;
        } else {
            requestModified = new HttpServletRequestWrapper((HttpServletRequest)request);
        }
        if (this.rolesAttribute != null && this.rolesHeader != null) {
            String forwardedRoles = httpRequest.getHeader(this.rolesHeader);
            requestModified.setAttribute(this.rolesAttribute, (Object)forwardedRoles);
            LOG.info((Object)("Roles header " + this.rolesHeader));
            LOG.info((Object)("Roles received " + forwardedRoles));
        }
        filterChain.doFilter((ServletRequest)requestModified, response);
    }

    public void destroy() {
    }
}

