/*
 * Decompiled with CFR 0.152.
 */
package org.grails.plugin.platform.events.publisher;

import groovy.lang.Closure;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.apache.log4j.Logger;
import org.codehaus.groovy.grails.support.PersistenceContextInterceptor;
import org.grails.plugin.platform.events.EventMessage;
import org.grails.plugin.platform.events.EventReply;
import org.grails.plugin.platform.events.publisher.DefaultEventsPublisher;
import org.grails.plugin.platform.events.publisher.EventsPublisher;
import org.grails.plugin.platform.events.registry.DefaultEventsRegistry;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.task.AsyncTaskExecutor;

public class DefaultEventsPublisher
implements EventsPublisher,
ApplicationContextAware,
InitializingBean {
    private static final String EXECUTOR = "executor";
    private static final String DEFAULT_EXECUTOR = "grailsTopicExecutor";
    private static final Logger log = Logger.getLogger(DefaultEventsPublisher.class);
    private DefaultEventsRegistry grailsEventsRegistry;
    @Autowired
    protected Map<String, AsyncTaskExecutor> taskExecutors;
    private PersistenceContextInterceptor persistenceInterceptor;
    private boolean catchFlushExceptions = false;
    private ApplicationContext context;

    public void setCatchFlushExceptions(boolean catchFlushExceptions) {
        this.catchFlushExceptions = catchFlushExceptions;
    }

    public void setPersistenceInterceptor(PersistenceContextInterceptor persistenceInterceptor) {
        this.persistenceInterceptor = persistenceInterceptor;
    }

    public void setGrailsEventsRegistry(DefaultEventsRegistry grailsEventsRegistry) {
        this.grailsEventsRegistry = grailsEventsRegistry;
    }

    public EventReply event(EventMessage<?> event) {
        DefaultEventsRegistry.InvokeResult invokeResult = this.grailsEventsRegistry.invokeListeners(event);
        return new EventReply(invokeResult.getResult(), invokeResult.getInvoked());
    }

    public EventReply eventAsync(EventMessage<?> event, Map<String, Object> params) {
        AsyncTaskExecutor taskExecutor = params != null && params.containsKey(EXECUTOR) ? (AsyncTaskExecutor)this.taskExecutors.get(params.get(EXECUTOR)) : (AsyncTaskExecutor)this.taskExecutors.get(DEFAULT_EXECUTOR);
        Future invokeResult = taskExecutor.submit((Callable)new Callback(this, event));
        WrappedFuture reply = new WrappedFuture(invokeResult, -1);
        if (params != null) {
            reply.setOnError((Closure)params.get("onError"));
            if (params.get("onReply") != null) {
                taskExecutor.execute((Runnable)new /* Unavailable Anonymous Inner Class!! */);
            }
        }
        return reply;
    }

    public void afterPropertiesSet() throws BeansException {
        if (this.persistenceInterceptor == null) {
            try {
                this.persistenceInterceptor = (PersistenceContextInterceptor)this.context.getBean("persistenceInterceptor", PersistenceContextInterceptor.class);
            }
            catch (BeansException ex) {
                log.debug((Object)"No persistence context interceptor found", (Throwable)ex);
            }
        }
    }

    public void setApplicationContext(ApplicationContext context) {
        this.context = context;
    }

    static /* synthetic */ PersistenceContextInterceptor access$000(DefaultEventsPublisher x0) {
        return x0.persistenceInterceptor;
    }

    static /* synthetic */ DefaultEventsRegistry access$100(DefaultEventsPublisher x0) {
        return x0.grailsEventsRegistry;
    }

    static /* synthetic */ boolean access$200(DefaultEventsPublisher x0) {
        return x0.catchFlushExceptions;
    }
}

