/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.server.plugins.services;

import com.dtolabs.rundeck.core.common.Framework;
import com.dtolabs.rundeck.core.plugins.AbstractDescribableScriptPlugin;
import com.dtolabs.rundeck.core.plugins.PluginException;
import com.dtolabs.rundeck.core.plugins.ScriptPluginProvider;
import com.dtolabs.rundeck.core.plugins.configuration.ConfigurationException;
import com.dtolabs.rundeck.plugins.rundeck.UIPlugin;
import com.dtolabs.rundeck.plugins.util.DescriptionBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * Exception performing whole class analysis ignored.
 */
public class ScriptUIPlugin
extends AbstractDescribableScriptPlugin
implements UIPlugin {
    List<String> paths;
    Map<String, List<String>> pathResources = new LinkedHashMap();
    Map<String, List<String>> pathScripts = new LinkedHashMap();
    Map<String, List<String>> pathStyles = new LinkedHashMap();
    Map<String, List<String>> pathRequires = new LinkedHashMap();

    public ScriptUIPlugin(ScriptPluginProvider provider, Framework framework) {
        super(provider, framework);
        this.loadProviderDefs(provider);
    }

    private void loadResourcesFromMap(Map uimap) {
        ScriptUIPlugin.validateUimap((Map)uimap);
        List pages = ScriptUIPlugin.asStringList(uimap.get("pages"));
        List styles = ScriptUIPlugin.asStringList(uimap.get("styles"));
        List scripts = ScriptUIPlugin.asStringList(uimap.get("scripts"));
        List requires = ScriptUIPlugin.asStringList(uimap.get("requires"));
        for (String page : pages) {
            if (styles != null) {
                for (String resource : styles) {
                    this.addResource(page, resource, this.pathResources);
                    this.addResource(page, resource, this.pathStyles);
                }
            }
            if (scripts != null) {
                for (String resource : scripts) {
                    this.addResource(page, resource, this.pathResources);
                    this.addResource(page, resource, this.pathScripts);
                }
            }
            if (requires == null) continue;
            for (String plugin : requires) {
                this.addResource(page, plugin, this.pathResources);
                this.addResource(page, plugin, this.pathRequires);
            }
        }
    }

    private void addResource(String page, String resource, Map<String, List<String>> dataSet) {
        if (null == dataSet.get(page)) {
            dataSet.put(page, new ArrayList());
        }
        dataSet.get(page).add(resource);
    }

    private static List<String> asStringList(Object pages) {
        if (pages instanceof String) {
            return Collections.singletonList((String)pages);
        }
        if (pages instanceof Collection) {
            ArrayList<String> strings = new ArrayList<String>();
            for (Object o : (Collection)pages) {
                if (!(o instanceof String)) continue;
                strings.add((String)o);
            }
            if (strings.size() < 1) {
                return null;
            }
            return strings;
        }
        return null;
    }

    private void loadProviderDefs(ScriptPluginProvider provider) {
        Map metadata = provider.getMetadata();
        ScriptUIPlugin.validateMetadata((Map)metadata);
        Object ui = metadata.get("ui");
        if (ui instanceof Map) {
            Map uimap = (Map)ui;
            this.loadResourcesFromMap(uimap);
        } else if (ui instanceof Collection) {
            for (Object o : (Collection)ui) {
                if (!(o instanceof Map)) continue;
                this.loadResourcesFromMap((Map)o);
            }
        }
    }

    static void validateScriptPlugin(ScriptPluginProvider plugin) throws PluginException {
        try {
            ScriptUIPlugin.createDescription((ScriptPluginProvider)plugin, (boolean)true, (DescriptionBuilder)DescriptionBuilder.builder());
        }
        catch (ConfigurationException e) {
            throw new PluginException((Throwable)e);
        }
        Map metadata = plugin.getMetadata();
        ScriptUIPlugin.validateMetadata((Map)metadata);
    }

    private static void validateMetadata(Map<String, Object> metadata) {
        Object ui = metadata.get("ui");
        if (ui instanceof Map) {
            ScriptUIPlugin.validateUimap((Map)((Map)ui));
        } else if (ui instanceof Collection) {
            for (Object o : (Collection)ui) {
                if (!(o instanceof Map)) continue;
                Map uimap = (Map)o;
                ScriptUIPlugin.validateUimap((Map)((Map)o));
            }
        } else {
            throw new IllegalArgumentException("in provider metadata: 'ui:' was not a Map or a List");
        }
    }

    private static void validateUimap(Map uimap) {
        List pages = ScriptUIPlugin.asStringList(uimap.get("pages"));
        if (pages == null) {
            throw new IllegalArgumentException("in provider metadata: 'ui: pages:' not found, or not a String or String list");
        }
        List styles = ScriptUIPlugin.asStringList(uimap.get("styles"));
        List scripts = ScriptUIPlugin.asStringList(uimap.get("scripts"));
        if (null == styles && null == scripts) {
            throw new IllegalArgumentException("in provider metadata: 'ui: pages:' either 'scripts' or 'styles' was expected to be a String or String list");
        }
        Object requires = uimap.get("requires");
        List requirePlugins = ScriptUIPlugin.asStringList(requires);
        if (requires != null && requirePlugins == null) {
            throw new IllegalArgumentException("in provider metadata: 'ui: pages: requires:' is not a String or String list");
        }
    }

    private List<String> keyAppliedForPath(String path, Map<String, List<String>> map) {
        ArrayList<String> result = new ArrayList<String>();
        for (String s : map.keySet()) {
            if (!"*".equals(s) && !s.equals(path) && !path.matches(s)) continue;
            result.addAll((Collection<String>)map.get(s));
        }
        return result;
    }

    public boolean doesApply(String path) {
        return this.keyAppliedForPath(path, this.pathResources) != null;
    }

    public List<String> resourcesForPath(String path) {
        return this.keyAppliedForPath(path, this.pathResources);
    }

    public List<String> scriptResourcesForPath(String path) {
        return this.keyAppliedForPath(path, this.pathScripts);
    }

    public List<String> styleResourcesForPath(String path) {
        return this.keyAppliedForPath(path, this.pathStyles);
    }

    public List<String> requires(String path) {
        return this.keyAppliedForPath(path, this.pathRequires);
    }

    public boolean isAllowCustomProperties() {
        return false;
    }
}

