/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.server.projects;

import com.dtolabs.rundeck.core.authorization.Authorization;
import com.dtolabs.rundeck.core.common.INodeSet;
import com.dtolabs.rundeck.core.common.IProjectInfo;
import com.dtolabs.rundeck.core.common.IProjectNodes;
import com.dtolabs.rundeck.core.common.IProjectNodesFactory;
import com.dtolabs.rundeck.core.common.IRundeckProject;
import com.dtolabs.rundeck.core.common.IRundeckProjectConfig;
import com.dtolabs.rundeck.core.common.NodeFileParserException;
import com.dtolabs.rundeck.core.storage.ResourceMeta;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import rundeck.services.ProjectManagerService;

public class RundeckProject
implements IRundeckProject {
    private ProjectManagerService projectService;
    private IRundeckProjectConfig projectConfig;
    private IProjectInfo info;
    private IProjectNodesFactory nodesFactory;

    public RundeckProject(IRundeckProjectConfig projectConfig, ProjectManagerService projectService) {
        this.projectConfig = projectConfig;
        this.projectService = projectService;
    }

    public String getName() {
        return this.projectConfig.getName();
    }

    public String getProperty(String property) {
        return this.projectConfig.getProperty(property);
    }

    public List<Map<String, Object>> listResourceModelConfigurations() {
        return this.getProjectNodes().listResourceModelConfigurations();
    }

    public INodeSet getNodeSet() throws NodeFileParserException {
        return this.getProjectNodes().getNodeSet();
    }

    public boolean hasProperty(String key) {
        return this.projectConfig.hasProperty(key);
    }

    public Map<String, String> getProperties() {
        return this.projectConfig.getProperties();
    }

    public Map<String, String> getProjectProperties() {
        return this.projectConfig.getProjectProperties();
    }

    public void mergeProjectProperties(Properties properties, Set<String> removePrefixes) {
        this.projectService.mergeProjectProperties(this, properties, removePrefixes);
    }

    public void setProjectProperties(Properties properties) {
        this.projectService.setProjectProperties(this, properties);
    }

    public boolean existsFileResource(String path) {
        return this.projectService.existsProjectFileResource(this.getName(), path);
    }

    public boolean existsDirResource(String path) {
        return this.projectService.existsProjectDirResource(this.getName(), path);
    }

    public List<String> listDirPaths(String path) {
        return this.projectService.listProjectDirPaths(this.getName(), path);
    }

    public boolean deleteFileResource(String path) {
        return this.projectService.deleteProjectFileResource(this.getName(), path);
    }

    public long storeFileResource(String path, InputStream input) throws IOException {
        return ((ResourceMeta)this.projectService.writeProjectFileResource(this.getName(), path, input, new HashMap()).getContents()).getContentLength();
    }

    public long loadFileResource(String path, OutputStream output) throws IOException {
        return this.projectService.readProjectFileResource(this.getName(), path, output);
    }

    public Date getConfigLastModifiedTime() {
        return this.projectConfig.getConfigLastModifiedTime();
    }

    public Date getConfigCreatedTime() {
        return this.projectConfig.getConfigCreatedTime();
    }

    public IProjectNodes getProjectNodes() {
        return this.getNodesFactory().getNodes(this.getName());
    }

    public String toString() {
        return "RundeckProject{config='" + this.projectConfig + '\'' + '}';
    }

    public Authorization getProjectAuthorization() {
        return this.projectService.getProjectAuthorization(this.getName());
    }

    public IRundeckProjectConfig getProjectConfig() {
        return this.projectConfig;
    }

    public void setProjectConfig(IRundeckProjectConfig projectConfig) {
        this.projectConfig = projectConfig;
    }

    public IProjectInfo getInfo() {
        return this.info;
    }

    public void setInfo(IProjectInfo info) {
        this.info = info;
    }

    public IProjectNodesFactory getNodesFactory() {
        return this.nodesFactory;
    }

    public void setNodesFactory(IProjectNodesFactory nodesFactory) {
        this.nodesFactory = nodesFactory;
    }
}

