/*
 * Decompiled with CFR 0.152.
 */
package rundeck.services;

import com.dtolabs.rundeck.core.authorization.AuthContext;
import com.dtolabs.rundeck.core.authorization.UserAndRolesAuthContext;
import com.dtolabs.rundeck.core.common.INodeEntry;
import com.dtolabs.rundeck.core.common.INodeSet;
import com.dtolabs.rundeck.core.common.NodeSetImpl;
import com.dtolabs.rundeck.core.execution.ExecArgList;
import com.dtolabs.rundeck.core.execution.ExecutionContext;
import com.dtolabs.rundeck.core.execution.ExecutionException;
import com.dtolabs.rundeck.core.execution.NodeExecutionService;
import com.dtolabs.rundeck.core.execution.UnauthorizedException;
import com.dtolabs.rundeck.core.execution.service.FileCopierException;
import com.dtolabs.rundeck.core.execution.service.NodeExecutorResult;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import java.io.File;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.rundeck.core.auth.AuthConstants;
import rundeck.services.FrameworkService;

public class AuthorizingNodeExecutionService
implements NodeExecutionService,
GroovyObject {
    public static final Set<String> RUN_ACTION_SET;
    private FrameworkService frameworkService;
    private NodeExecutionService nodeExecutionService;
    private UserAndRolesAuthContext authContext;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public AuthorizingNodeExecutionService() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    private boolean authCheckNode(String project, AuthContext auth, INodeEntry node) {
        NodeSetImpl nodes = new NodeSetImpl();
        nodes.putNode(node);
        INodeSet result = this.frameworkService.filterAuthorizedNodes(project, RUN_ACTION_SET, (INodeSet)nodes, auth);
        return result.getNodeNames().contains(node.getNodename());
    }

    public NodeExecutorResult executeCommand(ExecutionContext context, ExecArgList command, INodeEntry node) throws ExecutionException {
        if (!this.authCheckNode(context.getFrameworkProject(), (AuthContext)this.authContext, node)) {
            throw (Throwable)new UnauthorizedException(StringGroovyMethods.plus((String)"Unauthorized: cannot execute on node: ", (CharSequence)node.getNodename()));
        }
        return this.nodeExecutionService.executeCommand(context, command, node);
    }

    public String fileCopyFileStream(ExecutionContext context, InputStream input, INodeEntry node, String destinationPath) throws FileCopierException, ExecutionException {
        if (!this.authCheckNode(context.getFrameworkProject(), (AuthContext)this.authContext, node)) {
            throw (Throwable)new UnauthorizedException(StringGroovyMethods.plus((String)"Unauthorized: cannot copy file to node: ", (CharSequence)node.getNodename()));
        }
        return this.nodeExecutionService.fileCopyFileStream(context, input, node, destinationPath);
    }

    public String fileCopyFile(ExecutionContext context, File file, INodeEntry node, String destinationPath) throws FileCopierException, ExecutionException {
        if (!this.authCheckNode(context.getFrameworkProject(), (AuthContext)this.authContext, node)) {
            throw (Throwable)new UnauthorizedException(StringGroovyMethods.plus((String)"Unauthorized: cannot copy file to node: ", (CharSequence)node.getNodename()));
        }
        return this.nodeExecutionService.fileCopyFile(context, file, node, destinationPath);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != AuthorizingNodeExecutionService.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        Set set;
        RUN_ACTION_SET = set = Collections.unmodifiableSet(new HashSet(ScriptBytecodeAdapter.createList((Object[])new Object[]{AuthConstants.ACTION_RUN})));
    }

    public FrameworkService getFrameworkService() {
        return this.frameworkService;
    }

    public void setFrameworkService(FrameworkService frameworkService) {
        this.frameworkService = frameworkService;
    }

    public NodeExecutionService getNodeExecutionService() {
        return this.nodeExecutionService;
    }

    public void setNodeExecutionService(NodeExecutionService nodeExecutionService) {
        this.nodeExecutionService = nodeExecutionService;
    }

    public UserAndRolesAuthContext getAuthContext() {
        return this.authContext;
    }

    public void setAuthContext(UserAndRolesAuthContext userAndRolesAuthContext) {
        this.authContext = userAndRolesAuthContext;
    }
}

