/*
 * Copyright 2016 SimplifyOps, Inc. (http://simplifyops.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var TestHarness = function (name,data) {
    var self = this;
    self.name=name;
    var failed=0;
    var total=0;
    var NDX=Math.floor((Math.random() * 1024));
    var ident='js_test_'+NDX;
    var curPrefix='';
    self.compare=function(expect,val){
        "use strict";
        if(typeof(expect)!=typeof(val)){
            return false;
        }
        if(expect==null && val!=null || expect!=null && val==null){
            return false;
        }
        //todo: array and object compare
        if(expect!=null && val!=null && jQuery.type(expect)=='array' && jQuery.type(val)=='array'){
            if(expect.length!=val.length){
                return false;
            }
            for(var i=0;i<expect.length;i++){
                if(!self.compare(expect[i],val[i])){
                    return false;
                }
            }
            return true;
        }else if (expect!=null && val!=null && typeof(expect)=='object'){
            if(Object.keys(expect).length!=Object.keys(val).length){
                return false;
            }
            for(var p in expect){
                if(!self.compare(expect[p],val[p])){

                    return false;
                }
            }
            for(var p in val){
                if(!self.compare(expect[p],val[p])){
                    return false;
                }
            }
            return true;
        }
        return expect===val;
    };
    self.error=function(message){
        "use strict";
        jQuery('#'+ident).append(jQuery('<div class="js-test-failure"></div>').append(jQuery('<span class="text-danger"></span>').text(message)));
    };
    self.ok=function(msg){
        "use strict";
        jQuery('#'+ident).append(jQuery('<div></div>').append(jQuery('<span class="text-success"></span>').text("OK: " + msg)));
    };
    self.assert = function (msg, expect, val) {
        total++;
        if(null==expect && null==val && typeof(msg)!='string'){
            expect=true;
            val=msg;
            msg='(assert)';
        }else if(null==val && typeof(expect)=='string' && typeof(msg)=='boolean'){
            val=msg;
            msg=expect;
            expect=true;
        }
        if (!self.compare(expect,val)) {
            failed++;
            var message = "FAIL: " +curPrefix+ msg + ": expected: " + JSON.stringify(expect) + ", was: " + JSON.stringify(val);
            self.error(message);
            try{
                throw new Error("assert failed: "+message);
            }catch(e){
                console.log(e,e.stack);
            }
        } else {
            self.ok(curPrefix+msg);
        }
    };
    self.log = function (msg, data) {
        jQuery('#'+ident).append(jQuery('<div></div>').append(jQuery('<span class="text-' +
            'info"></span>').text("LOG: " + msg)));
        if(data){
            jQuery('#'+ident).append(jQuery('<div></div>').append(jQuery('<span class="text-info"></span>').text(data)));
        }
    };

    self.testMatrix=function(name,dataset,tester){
        "use strict";

        dataset.forEach(function (t,x) {
            var val2 = tester(t[0]);
            self.assert(messageTemplate(name,[JSON.stringify(t[0]),JSON.stringify(t[1]),x]), t[1], val2);
        });
    };
    self.holder={};
    self.prepare=function(){
        "use strict";

        if (typeof(window.Messages) == 'object') {
            self.holder['Messages']= Messages;
            var t={};
            for(var p in Messages){
                t[p]=p;
            }
            window.Messages=t;
        }
    };
    self.restore=function(){
        "use strict";
        window.Messages=self.holder['Messages'];
        self.holder={};
    };


    self.testAll = function () {
        self.prepare();
        jQuery('body > div.wrapper > div.main-panel').append(jQuery('<div id="'+ident+'" class="collapse in"></div>'));
        var jQuery2 = jQuery('#'+ident);
        self.log("Start: "+self.name);
        for (var i in self) {
            if (i.endsWith('Test')) {
                try {
                    curPrefix= i + ': ';
                    self[i].call(self, i + ': ');
                }catch(e){
                    self.assert('caught error running test: '+e, 'ok', 'exception');
                    console.log("error",e,e.stack);
                }
            }
        }
        curPrefix='';
        if(failed>0){
            jQuery2.prepend(jQuery('<div></div>').append(jQuery('<span class="text-danger"></span>').text("FAIL: " + failed+"/"+total+" assertions failed")));
        }else{
            jQuery2.collapse('hide');
            jQuery('body > div.wrapper > div.main-panel').append('<div></div>')
                .append('<span class="btn btn-link text-success test-elem" data-toggle="collapse" data-target="#'+ident+'">OK: '+total+' Tests Passed</span>')
        }
        self.restore();
    };
    for(var val in data){
        self[val]=data[val].bind(self);
    }

    jQuery(function () {
        self.testAll();
    });
};

/*
 * Copyright 2016 SimplifyOps, Inc. (http://simplifyops.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


/**
 * Selectable value with name/value pair
 * @param data
 * @constructor
 */
function OptionVal(data) {
    "use strict";

    var self = this;
    self.label = ko.observable(data.label || null);
    self.value = ko.observable(data.value || null);
    self.selected = ko.observable(data.selected ? true : false);
    self.editable = ko.observable(data.editable ? true : false);
    self.multival = ko.observable(data.multival ? true : false);
    self.resultValue = ko.computed(function () {
        var sel = self.selected();
        var val = self.value();
        if (sel && val) {
            return val;
        }
        return sel || val ? "" : null;
    });
}
var _option_uid=0;
function Option(data) {
    "use strict";

    var self = this;
    self.remoteLoadCallback = null;
    self.name = ko.observable(data.name);
    self.label = ko.observable(data.label);
    self.uid = ko.observable(data.uid||(++_option_uid+'_opt'));
    self.description = ko.observable(data.description);
    self.descriptionHtml = ko.observable(data.descriptionHtml);
    self.loading = ko.observable(false);
    self.required = ko.observable(data.required ? true : false);
    self.hidden = ko.observable(data.hidden ? true : false);
    self.enforced = ko.observable(data.enforced ? true : false);
    self.isDate = ko.observable(data.isDate ? true : false);
    self.dateFormat = ko.observable(data.dateFormat);
    /**
     * Type: used for file upload
     */
    self.optionType = ko.observable(data.optionType);
    self.fieldName = ko.observable(data.fieldName);
    self.hasError = ko.observable(data.hasError);
    self.hasRemote = ko.observable(data.hasRemote);
    self.fieldName = ko.observable(data.fieldName);
    self.fieldId = ko.observable(data.fieldId);
    self.fieldLabelId = ko.observable(data.fieldLabelId);
    self.optionDepsMet = ko.observable(data.optionDepsMet);
    self.secureInput = ko.observable(data.secureInput);
    self.multivalued = ko.observable(data.multivalued);
    self.multivalueAllSelected = ko.observable(data.multivalueAllSelected ? true : false);
    self.delimiter = ko.observable(data.delimiter);
    self.value = ko.observable(data.value);
    self.initvalue = ko.observable(data.value);
    self.useinit = ko.observable(data.value ? true : false);
    /**
     * static list of values to choose from
     */
    self.values = ko.observableArray(data.values);
    self.valuesFromPlugin = ko.observableArray(data.valuesFromPlugin);
    self.defaultValue = ko.observable(data.defaultValue);
    /**
     * list of values already selected
     */
    self.selectedMultiValues = ko.observableArray(data.selectedMultiValues);
    /**
     * list of values chosen as default for multivalued
     */
    self.defaultMultiValues = ko.observableArray(data.defaultMultiValues);
    /**
     * list of all multivalue strings to choose from
     */
    self.multiValueList = ko.observableArray(data.multiValueList);

    function emptyValue(val) {
        return (!val || val === '');
    }

    self.setReloadCallback = function (func) {
        self.remoteLoadCallback = func;
    };

    self.reloadRemoteValues = function () {
        if (self.hasRemote() && self.remoteLoadCallback) {
            self.remoteLoadCallback(self.name());
        } else {
            return true;
        }
    };

    //set up multivaluelist if default/selected values
    self.evalMultivalueChange = function () {
        if (self.multiValueList().length > 0) {
            //construct value string from selected multivalue options
            var str = '';
            var strs = [];

            var selected = ko.utils.arrayFilter(self.multiValueList(), function (val) {
                return val.selected() && val.value();
            });
            ko.utils.arrayForEach(selected, function (val) {
                strs.push(val.value());
            });
            self.value(strs.join(self.delimiter()));
            self.selectedMultiValues(strs);
        }
    };
    self.createMultivalueEntry = function (obj) {
        var optionVal = new OptionVal(obj);
        optionVal.resultValue.subscribe(function (newval) {
            if (newval == null) {
                //remove from parent
                self.multiValueList.remove(optionVal);
            } else {
                self.evalMultivalueChange();
            }
        });
        return optionVal;
    };
    self.loadedRemoteValues = ko.observable(false);
    self.remoteValues = ko.observableArray([]);
    if (self.multivalued()) {

        var testselected = function (val) {
            if (self.selectedMultiValues() && self.selectedMultiValues().length > 0) {
                return ko.utils.arrayIndexOf(self.selectedMultiValues(), val) >= 0;
            } else if (self.defaultMultiValues() && self.defaultMultiValues().length > 0) {
                return ko.utils.arrayIndexOf(self.defaultMultiValues(), val) >= 0;
            } else if (self.value()) {
                return self.value() == val;
            } else if (self.defaultValue()) {
                return self.defaultValue() == val;
            } else if (self.multivalueAllSelected()) {
                return true;
            }
            return false;
        };
        if(self.selectedMultiValues().length<1 && self.defaultMultiValues().length>0){
            //automatically select the default values
            self.selectedMultiValues(self.defaultMultiValues());
        }
        var addedExtras = false;
        var addExtraSelected = function (selected) {
            if (!self.enforced() && selected) {
                //add any selectedMultiValues that are not in values list

                ko.utils.arrayForEach(selected, function (val) {
                    if (self.values() != null && ko.utils.arrayIndexOf(self.values(), val) >= 0) {
                        return;
                    }

                    var found = ko.utils.arrayFirst(self.multiValueList(), function (oval) {
                        return oval.value() == val;
                    });
                    if (found) {
                        return;
                    }
                    self.multiValueList.unshift(self.createMultivalueEntry({
                        label: val,
                        value: val,
                        selected: !addedExtras,
                        editable: true,
                        multival: true
                    }));
                });
                addedExtras = true;
            }
        };


        if (self.hasRemote()) {
            //when remote values are loaded, set the multivalue entries with them
            self.remoteValues.subscribe(function (newval) {
                var temp = [];
                if(!self.enforced()) {
                    //preserve the editable values
                    temp = ko.utils.arrayFilter(self.multiValueList(),function (val) {
                        return val.editable();
                    });
                }
                ko.utils.arrayForEach(newval, function (val) {
                    var selected = testselected(val.value());
                    var hasselected = self.selectedMultiValues() && self.selectedMultiValues().length > 0;
                    var found = ko.utils.arrayFirst(self.multiValueList(),function (oval) {
                        return oval.value()==val.value() && oval.editable();
                    });
                    if(found){
                        found.label(val.label());
                        found.editable(false);
                        found.selected(true);
                        temp.push(found);
                    }else {
                        temp.push(self.createMultivalueEntry({
                            label: val.label(),
                            value: val.value(),
                            selected: selected || (!hasselected && val.selected()),
                            editable: false,
                            multival: true
                        }));
                    }
                });
                var multiselected=self.selectedMultiValues();
                self.multiValueList(temp);
                addExtraSelected(multiselected);
            });
        } else {
            addExtraSelected(self.selectedMultiValues());

            if (self.values() != null) {
                ko.utils.arrayForEach(self.values(), function (val) {
                    var selected = testselected(val);
                    self.multiValueList.push(self.createMultivalueEntry({
                        label: val,
                        value: val,
                        selected: selected,
                        editable: false,
                        multival: true
                    }));
                });
            }
        }
        self.multiValueList.subscribe(self.evalMultivalueChange);
    } else if (self.enforced() && self.values().length == 1 && emptyValue(self.value())) {
        //auto-set the value to only allowed value
        self.value(self.defaultValue() || self.values()[0]);
    }else if (!self.enforced() && emptyValue(self.value()) && !emptyValue(self.defaultValue())) {
        //auto-set the value to only allowed value
        self.value(self.defaultValue());
    }
    self.remoteError = ko.observable();

    self.selectedOptionValue = ko.observable(self.value());
    self.defaultStoragePath = ko.observable(data.defaultStoragePath);
    self.dateFormatErr = ko.computed(function () {
        if (!self.isDate() || !self.value() || !self.dateFormat()) {
            return false;
        }
        try {
            var m = moment(self.value(), self.dateFormat(), true);
            return !m.isValid();
        } catch (e) {
            return true;
        }
    });
    self.truncateDefaultValue = ko.computed(function () {
        var val = self.defaultValue();
        if (!val || val.length < 50) return val;
        return val.substring(0, 50);
    });
    self.setDefault = function () {
        self.value(self.defaultValue());
    };
    self.hasSingleEnforcedValue = ko.computed(function () {
        return self.enforced()
            && self.values() != null
            && self.values().length == 1;
    });
    self.singleEnforcedValue = ko.computed(function () {
        return self.hasSingleEnforcedValue() ? self.values()[0] : null;
    });
    self.hasValue = ko.computed(function () {
        return self.value();
    });
    self.hasValues = ko.computed(function () {
        var values = self.values();
        return values != null && values.length > 0;
    });
    self.hasPluginValues = ko.computed(function () {
        var pluginvalues = self.valuesFromPlugin();
        return pluginvalues != null && pluginvalues.length > 0;
    });
    self.hasExtended = ko.computed(function () {
        return !self.secureInput()
            && (
                self.hasValues()
                || self.multivalued()
                || self.hasRemote() && self.remoteValues().length > 0
                || self.hasPluginValues()
            );
    });
    self.hasTextfield = ko.computed(function () {
        return !self.enforced()
            && (
                !self.multivalued()
                || self.hasError()
            )
            || self.secureInput();
    });
    self.showDefaultButton = ko.computed(function () {
        return !self.enforced()
            && !self.multivalued()
            && !self.secureInput()
            && self.defaultValue()
            && !(
                self.values() != null
                && self.values().indexOf(self.defaultValue()) >= 0
            )
            && self.value() != self.defaultValue();
    });

    self.isFileType=ko.computed(function () {
        return self.optionType() == 'file';
    });
    /**
     * Return the array of option objects to use for displaying the Select input for this option
     */
    self.selectOptions = ko.computed(function () {
        var arr = [];
        if (!self.enforced() && !self.multivalued()) {
            arr.push(new OptionVal({label: message('option.select.choose.text'), value: ''}));
        }
        var remotevalues = self.remoteValues();
        var localvalues = self.values();
        var pluginvalues = self.valuesFromPlugin();

        if (self.hasRemote() && remotevalues != null) {
            ko.utils.arrayForEach(remotevalues, function (val) {
                arr.push(val);
            });
        } else if (self.hasValues()) {
            ko.utils.arrayForEach(localvalues, function (val) {
                arr.push(new OptionVal({label: val, value: val}));
            });
        } else if (self.hasPluginValues()) {
            ko.utils.arrayForEach(pluginvalues, function (val) {
                arr.push(new OptionVal({label: val.name, value: val.value}));
            });
        }
        return arr;
    });
    self.newMultivalueEntry = function () {
        var arr = self.multiValueList;
        arr.unshift(self.createMultivalueEntry({
            label: '_new',
            value: '',
            selected: true,
            editable: true,
            multival: true
        }));
    };
    self.multivalueFieldKeydown = function (obj,evt) {
        var enterKey = !noenter(evt);
        if (enterKey) {
            self.newMultivalueEntry()
        }
        return !enterKey;
    };

    /**
     * When select box chooses an option value, set the value()
     */
    self.selectedOptionValue.subscribe(function (newval) {
        if (newval && typeof(newval) == 'object' && typeof(newval.value) == 'function' && newval.value()) {
            self.value(newval.value());
        } else if (typeof(newval) == 'string') {
            self.value(newval);
        }
    });

    self.loadRemoteValues = function (values, selvalue) {
        self.loadedRemoteValues(false);
        self.remoteError(null);
        var tvalues = [];
        var tmultivalues = [];
        if (self.useinit() && self.initvalue() && !self.multivalued()) {
            tvalues[1] = (self.initvalue());
            self.useinit(false);
        } else if (self.useinit() && self.multivalued() && self.selectedMultiValues().length > 0) {
            tmultivalues[1] = self.selectedMultiValues();
            self.useinit(false);
        }
        if (selvalue && tvalues.indexOf(selvalue) < 0 && !self.multivalued()) {
            tvalues[0] = selvalue;
        } else if (self.multivalued() && selvalue) {
            tmultivalues[0] = selvalue.split(self.delimiter());
        }
        var rvalues = [];
        var tselected = -1;
        var remoteselectedArr = [];
        ko.utils.arrayForEach(values, function (val) {
            var optval;
            if (typeof(val) === 'object') {
                if (val.selected) {
                    remoteselectedArr.push(val.value)
                }
                optval = new OptionVal({label: val.name, value: val.value, selected: val.selected});
            } else if (typeof(val) === 'string') {
                optval = new OptionVal({label: val, value: val});
            }
            if (optval) {
                rvalues.push(optval);
                if (tvalues.length > 0 && tvalues.indexOf(optval.value()) > tselected) {
                    tselected = tvalues.indexOf(optval.value());
                }
            }
        });

        //choose value to select, by preference:
        //1: init value(s)
        //2: remote "selected" value(s)
        //3: input "selected" value(s)

        if (!self.multivalued()) {
            var touse = tselected === 1 ?
                tvalues[tselected] :
                (
                    (remoteselectedArr.length > 0 && remoteselectedArr[0]) ||
                    (tselected >= 0 ? tvalues[tselected] : null)
                );

            if (touse) {
                //choose correct value
                self.selectedOptionValue(touse);
            }
        } else if (self.multivalued()) {
            var touse =
                tmultivalues[1] ||
                (
                    (remoteselectedArr.length > 0 && remoteselectedArr) ||
                    (tmultivalues[0])
                );

            if (touse && touse.length > 0) {
                //choose correct value
                self.selectedMultiValues(touse);
            }
        }

        //triggers refresh of "selectOptions" populating select box
        self.remoteValues(rvalues);
        self.loadedRemoteValues(true);
    };
    /**
     * Option values data loaded from remote JSON request
     * @param data
     */
    self.loadRemote = function (data) {
        if (data.err && data.err.message) {
            var err = data.err;
            if (err) {
                err.url = data.srcUrl;
            }
            self.remoteError(err);
            self.remoteValues([]);
        } else if (data.values) {
            self.loadRemoteValues(data.values, data.selectedvalue);
        }
    };
    self.animateRemove = function (div) {
        jQuery(div).show().slideUp('fast', 0, function () {
            jQuery(div).remove();
        });
    };
    self.animateAdd = function (div) {
        jQuery(div).hide().slideDown('fast',function(){
            jQuery(div).find('input[type=text]').focus();
        });
    };
}
function JobOptions(data) {
    "use strict";
    var self = this;
    self.options = ko.observableArray();
    self.remoteoptions = null;
    self.mapping = {
        options: {
            key: function (data) {
                return ko.utils.unwrapObservable(data.name);
            },
            create: function (options) {
                return new Option(options.data);
            }
        }
    };

    ko.mapping.fromJS(data, self.mapping, self);
}

/*
 * Copyright 2016 SimplifyOps, Inc. (http://simplifyops.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

//= require util/testing
//= require menu/joboptions

jQuery(function () {
    function mkopt(data) {
        var defdata = {
            name: 'test',
            description: 'x',
            required: true,
            enforced: true,
            values: ['a', 'b'],
            defaultValue: 'a',
            defaultStoragePath: null,
            multivalued: false,
            defaultMultiValues: null,
            delimiter: null,
            selectedMultiValues: null,
            fieldName: 'extra.option.test',
            fieldId: 'a_bc',
            hasError: null,
            hasRemote: false,
            optionDepsMet: true,
            secureInput: false,
            hasExtended: false,
            value: null
        };
        if (data) {
            jQuery.extend(defdata, data);
        }
        return new Option(defdata);
    }

    function mkval(v, l) {
        "use strict";
        return new OptionVal({value: v, label: l || v});
    }

    new TestHarness("jobotionsTest.js", {
        baseOptionValueTest: function (pref) {
            "use strict";
            var opt = new OptionVal({});
            this.assert(" option value", null, opt.value());
            this.assert(" option value", null, opt.label());
            this.assert(" option value", false, opt.selected());
            this.assert(" option value", false, opt.editable());
            this.assert(" option value", false, opt.multival());

            opt = new OptionVal({label: 'test', value: 'test2', selected: true, editable: true, multival: true});
            this.assert(" option value", 'test', opt.label());
            this.assert(" option value", 'test2', opt.value());
            this.assert(" option value", true, opt.selected());
            this.assert(" option value", true, opt.editable());
            this.assert(" option value", true, opt.multival());
        },
        resultValueTest: function (pref) {
            "use strict";
            var opt = new OptionVal({value: "abc", selected: true});
            this.assert(" option value", 'abc', opt.resultValue());
            opt.value('');
            this.assert(" option value", '', opt.resultValue());
            opt.value('xxx');
            opt.selected(false);
            this.assert(" option value", '', opt.resultValue());
            opt.value('');
            this.assert(" option value", null, opt.resultValue());
            opt.value(null);
            this.assert(" option value", null, opt.resultValue());
        },
        truncateDefaultValue_Test: function (pref) {
            "use strict";
            var opt = mkopt();
            opt.defaultValue('short');
            this.assert(" value", 'short', opt.truncateDefaultValue());
            opt.defaultValue('long 123456789012345678901234567890123456789012345-----');
            this.assert(" value", 'long 123456789012345678901234567890123456789012345', opt.truncateDefaultValue());
            opt.defaultValue('');
            this.assert(" value", '', opt.truncateDefaultValue());
            opt.defaultValue(null);
            this.assert(" value", null, opt.truncateDefaultValue());
        },
        hasSingleEnforcedValue_Test: function (pref) {
            "use strict";
            var opt = mkopt();
            opt.enforced(true);
            opt.values(['x']);
            this.assert(" option", true, opt.hasSingleEnforcedValue());
            this.assert(" option", 'x', opt.singleEnforcedValue());
            opt.enforced(false);
            this.assert(" option", false, opt.hasSingleEnforcedValue());
            this.assert(" option", null, opt.singleEnforcedValue());
            opt.enforced(true);
            opt.values(['x', 'z']);
            this.assert(" option", false, opt.hasSingleEnforcedValue());
            this.assert(" option", null, opt.singleEnforcedValue());
            opt.values(null);
            this.assert(" option", false, opt.hasSingleEnforcedValue());
            this.assert(" option", null, opt.singleEnforcedValue());
        },
        hasValues_Test: function (pref) {
            "use strict";
            var self = this;
            var opt = mkopt();
            self.testMatrix(
                " hasValues({0})",
                [
                    [null, false],
                    [[], false],
                    [['x'], true],
                    [['x', 'y'], true]
                ],
                function (val) {
                    opt.values(val);
                    return opt.hasValues();
                }
            );

        },
        hasExtended_Test: function (pref) {
            "use strict";
            var self = this;
            var opt = mkopt();
            self.testMatrix(
                " hasExtended({0})",
                [
                    [{secureInput: true}, false],
                    [{secureInput: false, values: ['a'], multivalued: false, hasRemote: false, remoteValues: []}, true],
                    [{secureInput: false, values: [], multivalued: true, hasRemote: false, remoteValues: []}, true],
                    [{secureInput: false, values: [], multivalued: false, hasRemote: true, remoteValues: []}, false],
                    [{secureInput: false, values: [], multivalued: false, hasRemote: true, remoteValues: ['x']}, true]
                ],
                function (val) {
                    opt.secureInput(val.secureInput);
                    opt.multivalued(val.multivalued);
                    opt.hasRemote(val.hasRemote);
                    opt.values(val.values);
                    opt.remoteValues(val.remoteValues);
                    return opt.hasExtended();
                }
            );

        },
        hasTextfield_Test: function (pref) {
            "use strict";
            var self = this;
            var opt = mkopt();
            self.testMatrix(
                " hasTextfield({0})",
                [
                    [{enforced: false, multivalued: false, secureInput: false, hasError: false}, true],
                    [{enforced: false, multivalued: true, secureInput: false, hasError: true}, true],
                    [{enforced: true, multivalued: false, secureInput: true, hasError: false}, true],

                    [{enforced: true, multivalued: true, secureInput: false, hasError: false}, false],
                    [{enforced: true, multivalued: false, secureInput: false, hasError: true}, false]
                ],
                function (val) {
                    opt.enforced(val.enforced);
                    opt.multivalued(val.multivalued);
                    opt.secureInput(val.secureInput);
                    opt.hasError(val.hasError);
                    return opt.hasTextfield();
                }
            );

        },
        showDefaultButton_Test: function (pref) {
            "use strict";
            var self = this;
            var opt = mkopt();
            self.testMatrix(
                " showDefaultButton({0})",
                [
                    [{
                        enforced: true,
                        multivalued: true,
                        secureInput: true,
                        defaultValue: null,
                        values: null,
                        value: 'x'
                    }, false],
                    [{
                        enforced: false,
                        multivalued: false,
                        secureInput: false,
                        defaultValue: 'x',
                        values: null,
                        value: 'x'
                    }, false],
                    [{
                        enforced: false,
                        multivalued: false,
                        secureInput: false,
                        defaultValue: 'x',
                        values: null,
                        value: 'Z'
                    }, true],
                    [{
                        enforced: false,
                        multivalued: false,
                        secureInput: false,
                        defaultValue: 'x',
                        values: ['x'],
                        value: 'Z'
                    }, false],
                    [{
                        enforced: false,
                        multivalued: false,
                        secureInput: false,
                        defaultValue: 'x',
                        values: ['Z'],
                        value: 'Z'
                    }, true],
                ],
                function (val) {
                    opt.enforced(val.enforced);
                    opt.multivalued(val.multivalued);
                    opt.secureInput(val.secureInput);
                    opt.defaultValue(val.defaultValue);
                    opt.values(val.values);
                    opt.value(val.value);
                    return opt.showDefaultButton();
                }
            );

        },
        selectOptions_Test: function (pref) {
            "use strict";
            var self = this;
            var opt = mkopt();
            self.testMatrix(
                " selectOptions({0})",
                [
                    [{enforced: false, multivalued: false, remoteValues: null, values: null, hasRemote: false}, ''],
                    [{enforced: false, multivalued: false, remoteValues: null, values: ['x'], hasRemote: false}, ',x'],
                    [{
                        enforced: false,
                        multivalued: false,
                        remoteValues: null,
                        values: ['x', 'y'],
                        hasRemote: false
                    }, ',x,y'],
                    [{
                        enforced: true,
                        multivalued: false,
                        remoteValues: null,
                        values: ['x', 'y'],
                        hasRemote: false
                    }, 'x,y'],
                    [{
                        enforced: false,
                        multivalued: true,
                        remoteValues: null,
                        values: ['x', 'y'],
                        hasRemote: false
                    }, 'x,y'],
                    [{
                        enforced: false,
                        multivalued: false,
                        remoteValues: [mkval('a')],
                        values: null,
                        hasRemote: false
                    }, ''],
                    [{
                        enforced: false,
                        multivalued: false,
                        remoteValues: [mkval('a'), mkval('b')],
                        values: null,
                        hasRemote: false
                    }, ''],
                    [{
                        enforced: true,
                        multivalued: false,
                        remoteValues: [mkval('a'), mkval('b')],
                        values: null,
                        hasRemote: false
                    }, ''],
                    [{
                        enforced: false,
                        multivalued: true,
                        remoteValues: [mkval('a'), mkval('b')],
                        values: null,
                        hasRemote: false
                    }, ''],
                    [{
                        enforced: false,
                        multivalued: false,
                        remoteValues: [mkval('a')],
                        values: null,
                        hasRemote: true
                    }, ',a'],
                    [{
                        enforced: false,
                        multivalued: false,
                        remoteValues: [mkval('a'), mkval('b')],
                        values: null,
                        hasRemote: true
                    }, ',a,b'],
                    [{
                        enforced: true,
                        multivalued: false,
                        remoteValues: [mkval('a'), mkval('b')],
                        values: null,
                        hasRemote: true
                    }, 'a,b'],
                    [{
                        enforced: false,
                        multivalued: true,
                        remoteValues: [mkval('a'), mkval('b')],
                        values: null,
                        hasRemote: true
                    }, 'a,b']

                ],
                function (val) {
                    opt.enforced(val.enforced);
                    opt.multivalued(val.multivalued);
                    opt.remoteValues(val.remoteValues);
                    opt.values(val.values);
                    opt.hasRemote(val.hasRemote);

                    var testValue = opt.selectOptions();

                    return ko.utils.arrayMap(testValue, function (val) {
                        return val.value();
                    }).join(",");
                }
            );

        },
        selectedOptionValue_changes_value_Test: function (pref) {
            "use strict";
            var self = this;
            var opt = mkopt();
            self.testMatrix(
                " selectedOptionValue({0})",
                [
                    ['', ''],
                    ['a', 'a'],
                    [mkval('a'), 'a'],
                    [mkval('a', 'Z'), 'a']

                ],
                function (val) {
                    opt.selectedOptionValue(val);

                    return opt.value();
                }
            );

        },
        loadRemote_json_data_with_values_Test: function (pref) {
            "use strict";
            var self = this;
            self.testMatrix(
                " loadRemote({0})",
                [
                    [{values:['x','y'],selectedvalue:'x'}, {value:'x',selectedOptionValue:'x',remoteValues:'x,y'}],
                    [{values:['x','y']}, {value:null,selectedOptionValue:null,remoteValues:'x,y'}],

                ],
                function (val) {
                    var opt = mkopt({value:null,selectedOptionValue:null});
                    opt.loadRemote(val);

                    return {
                        value:opt.value(),
                        selectedOptionValue:opt.selectedOptionValue(),
                        remoteValues:ko.utils.arrayMap(opt.remoteValues(),function(val){return val.value();}).join(',')
                    };
                }
            );
        },
        loadRemote_json_data_with_object_values_selected_Test: function (pref) {
            "use strict";
            var self = this;
            self.testMatrix(
                " {2}: loadRemoteValues({0})",
                [
                    [
                        {values: [{value: 'x', name: 'X'}, {value: 'y', name: 'Y'}], selectedvalue: 'x'},
                        {value: 'x', selectedOptionValue: 'x', remoteValues: 'x,y'}
                    ],
                    [
                        {
                            values: [{value: 'x', name: 'X', selected: true}, {value: 'y', name: 'Y'}],
                            selectedvalue: 'x'
                        },
                        {value: 'x', selectedOptionValue: 'x', remoteValues: 'x,y'}
                    ],
                    [
                        {
                            values: [{value: 'x', name: 'X', selected: false}, {value: 'y', name: 'Y', selected: true}],
                            selectedvalue: 'x'
                        },
                        {value: 'y', selectedOptionValue: 'y', remoteValues: 'x,y'}
                    ],
                    [
                        {
                            values: [{value: 'x', name: 'X', selected: false}, {value: 'y', name: 'Y', selected: true}]
                        },
                        {value: 'y', selectedOptionValue: 'y', remoteValues: 'x,y'}
                    ],
                    [
                        {
                            values: [{value: 'x', name: 'X', selected: true}, {value: 'y', name: 'Y', selected: false}]
                        },
                        {value: 'x', selectedOptionValue: 'x', remoteValues: 'x,y'}
                    ]
                ],
                function (val) {
                    var opt = mkopt({value: null, selectedOptionValue: null});
                    opt.loadRemoteValues(val.values, val.selectedvalue);

                    return {
                        value: opt.value(),
                        selectedOptionValue: opt.selectedOptionValue(),
                        remoteValues: ko.utils.arrayMap(opt.remoteValues(), function (val) {
                            return val.value();
                        }).join(',')
                    };
                }
            );
        },
        loadRemote_json_data_with_init_values_Test: function (pref) {
            "use strict";
            var self = this;
            self.testMatrix(
                " loadRemoteValues({0})",
                [
                    [
                        {values: [{value: 'x', name: 'X'}, {value: 'y', name: 'Y'}], selectedvalue: 'x', init: 'x'},
                        {value: 'x', selectedOptionValue: 'x', remoteValues: 'x,y', initvalue: 'x'}
                    ],
                    [
                        {values: [{value: 'x', name: 'X'}, {value: 'y', name: 'Y'}], selectedvalue: 'x', init: 'y'},
                        {value: 'y', selectedOptionValue: 'y', remoteValues: 'x,y', initvalue: 'y'}
                    ],
                    [
                        {
                            values: [{value: 'x', name: 'X'}, {value: 'y', name: 'Y', selected: true}],
                            selectedvalue: 'x',
                            init: 'y'
                        },
                        {value: 'y', selectedOptionValue: 'y', remoteValues: 'x,y', initvalue: 'y'}
                    ],
                    [
                        {
                            values: [{value: 'x', name: 'X', selected: true}, {value: 'y', name: 'Y', selected: false}],
                            selectedvalue: 'x',
                            init: 'y'
                        },
                        {value: 'y', selectedOptionValue: 'y', remoteValues: 'x,y', initvalue: 'y'}
                    ]

                ],
                function (val) {
                    var opt = mkopt({value: val.init, selectedOptionValue: null});
                    opt.loadRemoteValues(val.values, val.selectedvalue);

                    return {
                        value: opt.value(),
                        selectedOptionValue: opt.selectedOptionValue(),
                        remoteValues: ko.utils.arrayMap(opt.remoteValues(), function (val) {
                            return val.value();
                        }).join(','),
                        initvalue: opt.initvalue()
                    };
                }
            );
        },
        loadRemote_json_data_twice_with_initvalue_Test: function (pref) {
            "use strict";
            var self = this;
            self.testMatrix(
                " loadRemoteValues({0})",
                [
                    [

                        {
                            loaded: [
                                {
                                    values: [
                                        {value: 'x', name: 'X'},
                                        {value: 'y', name: 'Y'}
                                    ],
                                    selectedvalue: 'x'
                                },
                                {
                                    values: [
                                        {value: 'a', name: 'A', selected: true},
                                        {value: 'x', name: 'X'},
                                        {value: 'z', name: 'Y'}
                                    ],
                                    selectedvalue: 'a'
                                }
                            ],
                            init: 'x'
                        },

                        [
                            {value: 'x', selectedOptionValue: 'x', remoteValues: 'x,y', initvalue: 'x', useinit: false},
                            {
                                value: 'a',
                                selectedOptionValue: 'a',
                                remoteValues: 'a,x,z',
                                initvalue: 'x',
                                useinit: false
                            }
                        ]
                    ]
                ],
                function (val) {
                    var opt = mkopt({value: val.init, selectedOptionValue: null});
                    opt.loadRemoteValues(val.loaded[0].values, val.loaded[0].selectedvalue);

                    var result = [{
                        value: opt.value(),
                        selectedOptionValue: opt.selectedOptionValue(),
                        remoteValues: ko.utils.arrayMap(opt.remoteValues(), function (val) {
                            return val.value();
                        }).join(','),
                        initvalue: opt.initvalue(),
                        useinit: opt.useinit()
                    }];
                    opt.loadRemoteValues(val.loaded[1].values, val.loaded[1].selectedvalue);

                    result.push({
                        value: opt.value(),
                        selectedOptionValue: opt.selectedOptionValue(),
                        remoteValues: ko.utils.arrayMap(opt.remoteValues(), function (val) {
                            return val.value();
                        }).join(','),
                        initvalue: opt.initvalue(),
                        useinit: opt.useinit()
                    });
                    return result;
                }
            );
        },
        loadRemote_json_data_twice_with_multi_remote_selected_Test: function (pref) {
            "use strict";
            var self = this;
            self.testMatrix(
                " loadRemoteValues({0})",
                [
                    [

                        {
                            loaded: [
                                {
                                    values: [
                                        {value: 'x', name: 'X'},
                                        {value: 'y', name: 'Y'}
                                    ],
                                    selectedvalue: 'y'
                                },
                                {
                                    values: [
                                        {value: 'a', name: 'A', selected: true},
                                        {value: 'x', name: 'X', selected: true},
                                        {value: 'z', name: 'Y'}
                                    ],
                                    selectedvalue: 'y'
                                }
                            ],
                            init: ''
                        },

                        [
                            {
                                value: '',
                                selectedMultiValues: ['y'],
                                remoteValues: 'x,y',
                                initvalue: '',
                                useinit: false
                            },
                            {
                                value: '',
                                selectedMultiValues: ['a', 'x'],
                                remoteValues: 'a,x,z',
                                initvalue: '',
                                useinit: false
                            }
                        ]
                    ]
                ],
                function (val) {
                    var opt = mkopt({value: val.init, selectedOptionValue: null, multivalued: true, delimiter: ','});
                    opt.loadRemoteValues(val.loaded[0].values, val.loaded[0].selectedvalue);

                    var result = [{
                        value: opt.value(),
                        selectedMultiValues: opt.selectedMultiValues(),
                        remoteValues: ko.utils.arrayMap(opt.remoteValues(), function (val) {
                            return val.value();
                        }).join(','),
                        initvalue: opt.initvalue(),
                        useinit: opt.useinit()
                    }];
                    opt.loadRemoteValues(val.loaded[1].values, val.loaded[1].selectedvalue);

                    result.push({
                        value: opt.value(),
                        selectedMultiValues: opt.selectedMultiValues(),
                        remoteValues: ko.utils.arrayMap(opt.remoteValues(), function (val) {
                            return val.value();
                        }).join(','),
                        initvalue: opt.initvalue(),
                        useinit: opt.useinit()
                    });
                    return result;
                }
            );
        },

        loadRemote_json_data_with_multiple_selected_Test: function (pref) {
            "use strict";
            var self = this;
            self.testMatrix(
                " loadRemoteValues({0})",
                [
                    [ //init value
                        {
                            init: 'z',
                            values: [
                                {value: 'x', name: 'X', selected: true},
                                {value: 'y', name: 'Y'},
                                {value: 'z', name: 'Z'}
                            ],
                            selectedvalue: 'y'
                        },
                        {value: 'z', selectedOptionValue: 'z'}
                    ],
                    [ //no init value
                        {
                            values: [
                                {value: 'x', name: 'X', selected: true},
                                {value: 'y', name: 'Y'},
                                {value: 'z', name: 'Z'}
                            ],
                            selectedvalue: 'y'
                        },
                        {value: 'x', selectedOptionValue: 'x'}
                    ],
                    [ //no remote selected value
                        {
                            values: [
                                {value: 'x', name: 'X'},
                                {value: 'y', name: 'Y'},
                                {value: 'z', name: 'Z'}
                            ],
                            selectedvalue: 'y'
                        },
                        {value: 'y', selectedOptionValue: 'y'}
                    ]
                ],
                function (val) {
                    var opt = mkopt({value: val.init, selectedOptionValue: null});
                    opt.loadRemoteValues(val.values, val.selectedvalue);

                    return {
                        value: opt.value(),
                        selectedOptionValue: opt.selectedOptionValue()
                    };
                }
            );
        },
        loadRemote_json_data_with_error_Test: function (pref) {
            "use strict";
            var self = this;
            self.testMatrix(
                " loadRemote({0})",
                [
                    [{err:{message:"blah"},srcUrl:"blee"}, {remoteError:{message:"blah",url:"blee"},remoteValues:''}],

                ],
                function (val) {
                    var opt = mkopt({value:null,selectedOptionValue:null});
                    opt.loadRemote(val);

                    return {
                        remoteError:opt.remoteError(),
                        remoteValues:ko.utils.arrayMap(opt.remoteValues(),function(val){return val.value();}).join(',')
                    };
                }
            );

        },
        multivalued_option_has_default_values_selectedTest: function (pref) {
            "use strict";
            var self = this;
            self.testMatrix(
                " selectedMultiValues of {0}",
                [
                    [{multivalued:true,defaultMultiValues:['a','b'],selectedMultiValues:[]},
                        ['a','b']],
                    [{multivalued:true,defaultMultiValues:['a','b'],selectedMultiValues:['x','y']},
                        ['x','y']]
                ],
                function (val) {
                    var opt = mkopt(val);

                    return opt.selectedMultiValues();
                }
            );

        }
    });

});
