/*
 * Decompiled with CFR 0.152.
 */
package org.rwtodd.args;

import java.io.PrintStream;
import java.util.Collection;
import java.util.Map;
import org.rwtodd.args.ArgParserException;
import org.rwtodd.args.OneArgParam;
import org.rwtodd.args.Param;

public abstract class BasicOneArgParam<T>
implements OneArgParam {
    protected T arg;
    protected final Collection<String> paramNames;
    protected final String helpText;

    public BasicOneArgParam(Collection<String> names, T dflt, String help) {
        this.arg = dflt;
        this.paramNames = names;
        this.helpText = help;
    }

    public T getValue() {
        return this.arg;
    }

    @Override
    public void addToMap(Map<String, Param> map) {
        for (String s : this.paramNames) {
            map.put(s, this);
        }
    }

    @Override
    public void addHelp(PrintStream ps) {
        String nameLine = String.format("%s   <%s>", Param.formatNames(this.paramNames), this.arg.getClass().getSimpleName());
        Param.formatTypicalHelp(ps, nameLine, this.helpText);
    }

    protected abstract T convertArg(String var1, String var2) throws Exception;

    protected T validate(String param, T arg) throws Exception {
        return arg;
    }

    @Override
    public void process(String param, String argument) throws ArgParserException {
        try {
            this.arg = this.validate(param, this.convertArg(param, argument));
        }
        catch (ArgParserException ape) {
            throw ape;
        }
        catch (Exception e) {
            throw new ArgParserException(String.format("Argument for <%s> is not valid!", param), e);
        }
    }
}

