/*
 * Decompiled with CFR 0.152.
 */
package org.rwtodd.args;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import org.rwtodd.args.ArgParserException;
import org.rwtodd.args.BasicOneArgParam;

public class ExistingFileParam
extends BasicOneArgParam<Path> {
    public ExistingFileParam(Collection<String> names, Path dflt, String help) {
        super(names, dflt, help);
    }

    public ExistingFileParam(Collection<String> names, String help) {
        this(names, null, help);
    }

    @Override
    protected Path convertArg(String param, String argument) throws ArgParserException {
        Path p = Path.of(argument, new String[0]);
        try {
            if (!Files.isRegularFile(p, new LinkOption[0])) {
                throw new ArgParserException(String.format("Argument for <%s> is not an exisiting file!", param));
            }
        }
        catch (SecurityException se) {
            throw new ArgParserException(String.format("Argument for <%s> caused a security exception!", param), se);
        }
        return p;
    }
}

