/*
 * Decompiled with CFR 0.152.
 */
package org.rwtodd.args;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.rwtodd.args.ArgParserException;
import org.rwtodd.args.NoArgParam;
import org.rwtodd.args.OneArgParam;
import org.rwtodd.args.Param;

public class Parser {
    private final Map<String, Param> parameterMap;
    private final Param[] parameters;

    public Parser(Param ... ps) {
        this.parameters = ps;
        this.parameterMap = new HashMap<String, Param>();
        for (Param p : ps) {
            p.addToMap(this.parameterMap);
        }
    }

    public List<String> parse(String ... args) throws ArgParserException {
        ArgumentIterator iter = new ArgumentIterator(args);
        ArrayList<String> remainingArgs = new ArrayList<String>();
        while (iter.advance()) {
            if (iter.isDoubleDash()) {
                String param = iter.getCurrent().substring(2);
                int eqIdx = param.indexOf("=");
                if (eqIdx >= 0) {
                    this.runParamWithArg(param.substring(0, eqIdx), param.substring(eqIdx + 1));
                    continue;
                }
                this.runParam(param, iter);
                continue;
            }
            if (iter.isSingleDash()) {
                String params = iter.getCurrent().substring(1);
                for (int i = 0; i < params.length() - 1; ++i) {
                    this.runParamWithoutArg(params.substring(i, i + 1));
                }
                this.runParam(params.substring(params.length() - 1), iter);
                continue;
            }
            remainingArgs.add(iter.getCurrent());
        }
        return remainingArgs;
    }

    private void runParamWithArg(String param, String arg) throws ArgParserException {
        Param p = this.parameterMap.get(param);
        if (!(p instanceof OneArgParam)) {
            if (p instanceof NoArgParam) {
                NoArgParam nap = (NoArgParam)p;
                throw new ArgParserException(String.format("Parameter <%s> does not take arguments!", param));
            }
            throw new ArgParserException(String.format("Parameter <%s> not found!", param));
        }
        OneArgParam oap = (OneArgParam)p;
        oap.process(param, arg);
    }

    private void runParamWithoutArg(String param) throws ArgParserException {
        Param p = this.parameterMap.get(param);
        if (!(p instanceof NoArgParam)) {
            if (p instanceof OneArgParam) {
                OneArgParam nap = (OneArgParam)p;
                throw new ArgParserException(String.format("Parameter <%s> needs an argument!", param));
            }
            throw new ArgParserException(String.format("Parameter <%s> not found!", param));
        }
        NoArgParam nap = (NoArgParam)p;
        nap.process(param);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void runParam(String param, ArgumentIterator iter) throws ArgParserException {
        Param p = this.parameterMap.get(param);
        if (p instanceof OneArgParam) {
            OneArgParam oap = (OneArgParam)p;
            if (!iter.advance() || !iter.isNotDashed()) throw new ArgParserException(String.format("Parameter <%s> was not given an argument!", param));
            oap.process(param, iter.getCurrent());
            return;
        } else {
            if (!(p instanceof NoArgParam)) throw new ArgParserException(String.format("Parameter <%s> not found!", param));
            NoArgParam nap = (NoArgParam)p;
            nap.process(param);
        }
    }

    public void printHelpText(PrintStream ps) {
        for (Param p : this.parameters) {
            p.addHelp(ps);
        }
    }

    private static final class ArgumentIterator {
        private boolean verbatim;
        private final String[] argList;
        private int argIdx;

        ArgumentIterator(String[] args) {
            this.argList = args;
            this.argIdx = -1;
            this.verbatim = false;
        }

        boolean isVerbatim() {
            return this.verbatim;
        }

        boolean advance() {
            if (++this.argIdx < this.argList.length) {
                if (!this.verbatim && this.argList[this.argIdx].equals("--")) {
                    this.verbatim = true;
                    return this.advance();
                }
                return true;
            }
            return false;
        }

        String getCurrent() {
            return this.argList[this.argIdx];
        }

        boolean isNotDashed() {
            String current = this.argList[this.argIdx];
            return this.verbatim || !current.startsWith("-") || current.length() == 1;
        }

        boolean isDoubleDash() {
            String current = this.argList[this.argIdx];
            return !this.verbatim && current.startsWith("--");
        }

        boolean isSingleDash() {
            String current = this.argList[this.argIdx];
            return !this.verbatim && current.startsWith("-");
        }
    }
}

