/*
 * Decompiled with CFR 0.152.
 */
package org.rwtodd.args;

import java.io.PrintStream;
import java.util.Collection;
import java.util.Map;
import org.rwtodd.args.NoArgParam;
import org.rwtodd.args.OneArgParam;

public sealed interface Param
permits OneArgParam, NoArgParam {
    public void addToMap(Map<String, Param> var1);

    public void addHelp(PrintStream var1);

    public static String formatNames(Collection<String> names) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String name : names) {
            if (!first) {
                sb.append(" | ");
            }
            if (name.length() > 1) {
                sb.append('-');
            }
            sb.append('-');
            sb.append(name);
            first = false;
        }
        return sb.toString();
    }

    public static void formatTypicalHelp(PrintStream ps, String nameLine, String descline) {
        ps.println(nameLine);
        if (descline.length() <= 72) {
            ps.print("   ");
            ps.println(descline);
        } else {
            int start = 0;
            int end = 72;
            while (start < descline.length()) {
                ps.print("   ");
                ps.println(descline.substring(start, end));
                start = end;
                end = Math.min(end + 72, descline.length());
            }
        }
    }
}

