/*
 * Decompiled with CFR 0.152.
 */
package org.rwtodd.args;

import java.time.LocalDate;
import java.util.Arrays;
import java.util.Collection;
import org.rwtodd.args.ArgParserException;
import org.rwtodd.args.BasicOneArgParam;

public class DateParam
extends BasicOneArgParam<LocalDate> {
    public DateParam(Collection<String> names, LocalDate dflt, String help) {
        super(names, dflt, help);
    }

    public DateParam(Collection<String> names, String help) {
        super(names, LocalDate.now(), help);
    }

    @Override
    protected LocalDate convertArg(String param, String arg) throws Exception {
        LocalDate today = LocalDate.now();
        try {
            int[] nums = Arrays.stream(arg.split("-")).mapToInt(Integer::parseInt).toArray();
            return switch (nums.length) {
                case 3 -> LocalDate.of(nums[0], nums[1], nums[2]);
                case 2 -> LocalDate.of(today.getYear(), nums[0], nums[1]);
                case 1 -> LocalDate.of(today.getYear(), today.getMonthValue(), nums[0]);
                default -> throw new IllegalArgumentException("bad format!");
            };
        }
        catch (Exception e) {
            throw new ArgParserException(String.format("Argument for <%s> is not in yyyy-mm-dd format!", param), e);
        }
    }
}

