/*
 * Decompiled with CFR 0.152.
 */
package org.rwtodd.args;

import java.io.PrintStream;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.rwtodd.args.ArgParserException;
import org.rwtodd.args.NoArgParam;
import org.rwtodd.args.Param;

public class EnumParam<T extends Enum<T>>
implements NoArgParam {
    private final Class<T> clz;
    private final String helpStr;
    private T value;

    public EnumParam(Class<T> c, T dflt, String help) {
        this.clz = c;
        this.value = dflt;
        this.helpStr = help;
    }

    public EnumParam(Class<T> c, String help) {
        this(c, null, help);
    }

    @Override
    public void addToMap(Map<String, Param> map) {
        for (Enum econst : (Enum[])this.clz.getEnumConstants()) {
            map.put(econst.toString(), this);
        }
    }

    @Override
    public void addHelp(PrintStream ps) {
        List.of((Enum[])this.clz.getEnumConstants());
        Param.formatTypicalHelp(ps, Param.formatNames(Arrays.stream((Enum[])this.clz.getEnumConstants()).map(e -> e.toString()).toList()), this.helpStr);
    }

    @Override
    public void process(String param) throws ArgParserException {
        T x = Enum.valueOf(this.clz, param);
        if (x == null) {
            throw new ArgParserException(String.format("Param <%s> should be a defined constant, but it isn't!", param));
        }
        this.value = x;
    }

    public T getValue() {
        return this.value;
    }
}

