/*
 * Decompiled with CFR 0.152.
 */
package org.rwtodd.args;

import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import org.rwtodd.args.ArgParserException;
import org.rwtodd.args.OneArgParam;
import org.rwtodd.args.Param;

public class BoundedParam<T extends Comparable<T>>
implements OneArgParam<T> {
    private final T min;
    private final T max;
    private final BoundType boundtype;
    private final OneArgParam<T> delegate;

    public BoundedParam(OneArgParam<T> delegate, T min, T max, BoundType bt) {
        this.delegate = delegate;
        this.min = min;
        this.max = max;
        this.boundtype = bt;
    }

    public BoundedParam(OneArgParam<T> delegate, T min, T max) {
        this(delegate, min, max, BoundType.Inclusive);
    }

    @Override
    public void process(String param, String argument) throws ArgParserException {
        this.delegate.process(param, argument);
        Comparable arg = (Comparable)this.delegate.getValue();
        if (arg.compareTo(this.min) < 0 || arg.compareTo(this.max) > 0 || this.boundtype == BoundType.Exclusive && arg.compareTo(this.max) == 0) {
            throw new ArgParserException(String.format("Parameter <%s> must be between %s and %s!", param, this.min.toString(), this.max.toString()));
        }
    }

    @Override
    public T getValue() {
        return (T)((Comparable)this.delegate.getValue());
    }

    @Override
    public void addToMap(Map<String, Param> map) {
        HashMap<String, Param> tempMap = new HashMap<String, Param>();
        this.delegate.addToMap(tempMap);
        for (String k : tempMap.keySet()) {
            map.put(k, this);
        }
    }

    @Override
    public void addHelp(PrintStream ps) {
        this.delegate.addHelp(ps);
    }

    public static enum BoundType {
        Inclusive,
        Exclusive;

    }
}

