/*
 * Decompiled with CFR 0.152.
 */
package org.rwtodd.args;

import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import org.rwtodd.args.ArgParserException;
import org.rwtodd.args.OneArgParam;
import org.rwtodd.args.Param;

public class ClampedParam<T extends Comparable<T>>
implements OneArgParam<T> {
    private final T min;
    private final T max;
    private final OneArgParam<T> delegate;

    public ClampedParam(OneArgParam<T> delegate, T min, T max) {
        this.delegate = delegate;
        this.min = min;
        this.max = max;
    }

    @Override
    public void process(String param, String argument) throws ArgParserException {
        this.delegate.process(param, argument);
    }

    @Override
    public T getValue() {
        Comparable v = (Comparable)this.delegate.getValue();
        if (v.compareTo(this.min) < 0) {
            v = this.min;
        } else if (v.compareTo(this.max) > 0) {
            v = this.max;
        }
        return (T)v;
    }

    @Override
    public void addToMap(Map<String, Param> map) {
        HashMap<String, Param> tempMap = new HashMap<String, Param>();
        this.delegate.addToMap(tempMap);
        for (String k : tempMap.keySet()) {
            map.put(k, this);
        }
    }

    @Override
    public void addHelp(PrintStream ps) {
        this.delegate.addHelp(ps);
    }
}

