/*
 * Decompiled with CFR 0.152.
 */
package org.rwtodd.args;

import java.io.PrintStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.rwtodd.args.ArgParserException;
import org.rwtodd.args.OneArgParam;
import org.rwtodd.args.Param;

public class SetRestrictedParam<T>
implements OneArgParam<T> {
    private Set<T> restrictTo;
    private OneArgParam<T> delegate;

    public SetRestrictedParam(OneArgParam<T> delegate, Iterable<T> restriction) {
        this.delegate = delegate;
        this.restrictTo = new HashSet<T>();
        for (T r : restriction) {
            this.restrictTo.add(r);
        }
    }

    @Override
    public void process(String param, String argument) throws ArgParserException {
        this.delegate.process(param, argument);
        if (!this.restrictTo.contains(this.delegate.getValue())) {
            throw new ArgParserException(String.format("Argument to <%s> is not in the allowed list!", param));
        }
    }

    @Override
    public T getValue() {
        return this.delegate.getValue();
    }

    @Override
    public void addToMap(Map<String, Param> map) {
        HashMap<String, Param> tempMap = new HashMap<String, Param>();
        this.delegate.addToMap(tempMap);
        for (String k : tempMap.keySet()) {
            map.put(k, this);
        }
    }

    @Override
    public void addHelp(PrintStream ps) {
        this.delegate.addHelp(ps);
    }
}

