package org.sackfix.field

import org.sackfix.common.validated.fields.SfFieldInt

/**
  * Generated by SackFix code generator on 20170404
  */
case class AllocAccountTypeField(override val value: Int) extends SfFieldInt(798, value) {
  override def toString = appendStringBuilder().toString
  override def appendStringBuilder(b:StringBuilder = new StringBuilder()) = b.append("(798)AllocAccountType=(").append(value).append(")").append(AllocAccountTypeField.fixDescriptionByValue.getOrElse(value,""))
}

object AllocAccountTypeField {
  val TagId = 798 
  val AccountIsCarriedOnCustomerSideOfBooks=1
  val AccountIsCarriedOnNonCustomerSideOfBooks=2
  val HouseTrader=3
  val FloorTrader=4
  val AccountIsCarriedOnNonCustomerSideOfBooksAndIsCrossMargined=6
  val AccountIsHouseTraderAndIsCrossMargined=7
  val JointBackofficeAccount=8
  lazy val fixDescriptionByValue = Map(1->"ACCOUNT_IS_CARRIED_ON_CUSTOMER_SIDE_OF_BOOKS",2->"ACCOUNT_IS_CARRIED_ON_NON_CUSTOMER_SIDE_OF_BOOKS",
    3->"HOUSE_TRADER",4->"FLOOR_TRADER",6->"ACCOUNT_IS_CARRIED_ON_NON_CUSTOMER_SIDE_OF_BOOKS_AND_IS_CROSS_MARGINED",
    7->"ACCOUNT_IS_HOUSE_TRADER_AND_IS_CROSS_MARGINED",8->"JOINT_BACKOFFICE_ACCOUNT")
 
  def apply(value: String) = try {
    new AllocAccountTypeField(value.toInt)
  } catch {
    case ex: Exception => throw new IllegalArgumentException("new AllocAccountType("+value.toString+") failed with exception", ex)
  } 
  def decode(a: Option[Any]) : Option[AllocAccountTypeField] = a match {
    case Some(v) => decode(v)
    case _ =>  scala.Option.empty[AllocAccountTypeField]
  }

  def decode(a: Any) : Option[AllocAccountTypeField] = a match {
    case v: String => Some(AllocAccountTypeField(v))
    case v: Int => Some(AllocAccountTypeField(v))
    case v: AllocAccountTypeField => Some(v)
    case _ => scala.Option.empty[AllocAccountTypeField]
  } 
}
