package org.sackfix.field

import org.sackfix.common.validated.fields.SfFieldLocalMktDate
import java.time.LocalDate
import org.sackfix.common.validated.fields.SfFixDateFormats

/**
  * Generated by SackFix code generator on 20170404
  */
case class IssueDateField(override val value: LocalDate) extends SfFieldLocalMktDate(225, value) {
  override def toString = appendStringBuilder().toString
  override def appendStringBuilder(b:StringBuilder = new StringBuilder()) = b.append("(225)IssueDate=(").append(value).append(")")
}

object IssueDateField {
  val TagId = 225  
  def apply(value: String) = try {
    new IssueDateField(LocalDate.from(SfFixDateFormats.localMktDate.parse(value)))
  } catch {
    case ex: Exception => throw new IllegalArgumentException("new IssueDate("+value.toString+") failed with exception", ex)
  } 
  def decode(a: Option[Any]) : Option[IssueDateField] = a match {
    case Some(v) => decode(v)
    case _ =>  scala.Option.empty[IssueDateField]
  }

  def decode(a: Any) : Option[IssueDateField] = a match {
    case v: String => Some(IssueDateField(v))
    case v: LocalDate => Some(IssueDateField(v))
    case v: IssueDateField => Some(v)
    case _ => scala.Option.empty[IssueDateField]
  } 
}
