package org.sackfix.field

import org.sackfix.common.validated.fields.SfFieldLocalMktDate
import java.time.LocalDate
import org.sackfix.common.validated.fields.SfFixDateFormats

/**
  * Generated by SackFix code generator on 20170404
  */
case class MaturityDateField(override val value: LocalDate) extends SfFieldLocalMktDate(541, value) {
  override def toString = appendStringBuilder().toString
  override def appendStringBuilder(b:StringBuilder = new StringBuilder()) = b.append("(541)MaturityDate=(").append(value).append(")")
}

object MaturityDateField {
  val TagId = 541  
  def apply(value: String) = try {
    new MaturityDateField(LocalDate.from(SfFixDateFormats.localMktDate.parse(value)))
  } catch {
    case ex: Exception => throw new IllegalArgumentException("new MaturityDate("+value.toString+") failed with exception", ex)
  } 
  def decode(a: Option[Any]) : Option[MaturityDateField] = a match {
    case Some(v) => decode(v)
    case _ =>  scala.Option.empty[MaturityDateField]
  }

  def decode(a: Any) : Option[MaturityDateField] = a match {
    case v: String => Some(MaturityDateField(v))
    case v: LocalDate => Some(MaturityDateField(v))
    case v: MaturityDateField => Some(v)
    case _ => scala.Option.empty[MaturityDateField]
  } 
}
