package org.sackfix.field

import org.sackfix.common.validated.fields.SfFieldUtcTimeStamp
import java.time.LocalDateTime
import org.sackfix.common.validated.fields.SfFixDateFormats

/**
  * Generated by SackFix code generator on 20170404
  */
case class OrigTimeField(override val value: LocalDateTime) extends SfFieldUtcTimeStamp(42, value) {
  override def toString = appendStringBuilder().toString
  override def appendStringBuilder(b:StringBuilder = new StringBuilder()) = b.append("(42)OrigTime=(").append(value).append(")")
}

object OrigTimeField {
  val TagId = 42  
  def apply(value: String) = try {
    new OrigTimeField(LocalDateTime.from(SfFixDateFormats.utcTimeStamp.parse(value)))
  } catch {
    case ex: Exception => throw new IllegalArgumentException("new OrigTime("+value.toString+") failed with exception", ex)
  } 
  def decode(a: Option[Any]) : Option[OrigTimeField] = a match {
    case Some(v) => decode(v)
    case _ =>  scala.Option.empty[OrigTimeField]
  }

  def decode(a: Any) : Option[OrigTimeField] = a match {
    case v: String => Some(OrigTimeField(v))
    case v: LocalDateTime => Some(OrigTimeField(v))
    case v: OrigTimeField => Some(v)
    case _ => scala.Option.empty[OrigTimeField]
  } 
}
